<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class CreditsModel extends CI_Model
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	public function getAdvanceList($search, $length, $start, $order_column, $order)
	{
		if ($length != -1){
			$this->db->select('*,tbl_advance.advance_id as advance_no')
			->from('tbl_advance')
			->join('tbl_patients', 'tbl_patients.patient_id = tbl_advance.patient_id')
			->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_advance.pay_type','left');
		}else {
			$this->db->select('COUNT(*) as total')
			->from('tbl_advance')
			->join('tbl_patients', 'tbl_patients.patient_id = tbl_advance.patient_id')
			->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_advance.pay_type','left');
		}
		
		if ($length != -1)
			$this->db->limit($length, $start);

		if (!empty($search)) {
			$this->db->group_start();
			$this->db->like('tbl_patients.patient_name', $search);
			$this->db->or_like('tbl_patients.patient_id', $search);
			$this->db->or_like('tbl_advance.advance_id', $search);
			$this->db->group_end();
		}
		
		if ($length != -1)
		$this->db->order_by($order_column, $order);


		return $this->db->get()->result();
	}

	public function getRefundList($search, $length, $start, $order_column, $order)
	{
		$this->db->select('*,tbl_refund.id as refund_no')
			->from('tbl_refund')
			->join('tbl_treatment_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_refund.treatment_payment_id')
			->join('tbl_patients', 'tbl_patients.patient_id = tbl_treatment_payment.patient_id')
			->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_refund.pay_type','left');

		if ($length != -1)
			$this->db->limit($length, $start);

		if (!empty($search)) {
			$this->db->like('tbl_patients.patient_name', $search);
			$this->db->or_like('tbl_patients.patient_id', $search);
			$this->db->or_like('tbl_patient_payment.patient_payment_id', $search);
		}
		$this->db->where('is_refund', 1);
		$this->db->order_by($order_column, $order);


		return $this->db->get()->result();
	}

	

	
}
