<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


class Lab extends CI_Model
{

 
	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

    
    
	public function getParams()
	{
        return  $this->db->select('test_parameters.*,lab_units.name AS unit_name')
        ->from('test_parameters')
        ->join('lab_units', 'lab_units.id = test_parameters.unit', 'left')
        ->get()
        ->result();
	}

	public function getTests()
	{
        return  $this->db->select('lab_test.*, test_categories.name as cat_name')
        ->from('lab_test')
		->join('test_categories', 'test_categories.id = lab_test.categories', 'left')
        ->get()
        ->result();
	}

	public function get_print_config() {
        $this->db->select('config_option, value');
        $this->db->from('lab_config');
        $this->db->where('type', 'print');
        $query = $this->db->get();
        return $query->result();
    }

	public function saveTest($data) {
        $this->db->insert('lab_test', $data);
        return $this->db->insert_id();
    }

	public function save_params($data) {
        $this->db->insert('test_has_params', $data);
    }

	public function get_test_by_detail(){
     

		$searchTerm = strtoupper($_GET['name_startsWith']);

		$query = $this->db->query("SELECT * FROM lab_test 
		WHERE lab_test.id LIKE '" . $searchTerm . "%' 
		OR lab_test.name LIKE '" . $searchTerm . "%' 
		OR lab_test.short_name LIKE '%" . $searchTerm . "%' 
		ORDER BY lab_test.id ASC");

		return $query;
	
    }

	public function get_cases_list($qid,$from,$to,$type){
		$this->db->select('*');
		$this->db->from('lab_cases');
		$this->db->join('tbl_patients', 'lab_cases.patient_id = tbl_patients.patient_id', 'left');
	
		if (!empty($from)) {
			$this->db->where('created_at >=', $from);
		}
		if (!empty($to)) {
			$this->db->where('created_at <=', $to);
		}
		
		if (!empty($qid)) {
			$this->db->group_start();
			$this->db->where('tbl_patients.qatar_id =', $qid);
			$this->db->or_where('tbl_patients.patient_id =', $qid);
			$this->db->group_end();
		}
	
			$this->db->where('type =', $type);
			$this->db->order_by('lab_cases.created_at', 'DESC');
		
		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_request_list($file,$from,$to,$type){
		$this->db->select('tbl_patients.*,rf.full_name as refferedby,ch.full_name as createdby,lab_cases.*');
		$this->db->from('lab_cases');
		$this->db->join('tbl_patients', 'lab_cases.patient_id = tbl_patients.patient_id', 'left');
		$this->db->join('tbl_users rf', 'lab_cases.reffered_by = rf.user_id', 'left');
		$this->db->join('tbl_users ch', 'lab_cases.user_id = ch.user_id', 'left');
	
		if (!empty($from)) {
			$this->db->where('lab_cases.created_at >=', $from);
		}
		if (!empty($to)) {
			$this->db->where('lab_cases.created_at <=', $to);
		}
		
			
		
		if (!empty($file)) {
			$this->db->group_start();
			$this->db->where('tbl_patients.patient_id', $file);
			$this->db->or_where('tbl_patients.qatar_id', $file);
			$this->db->group_end();
		}
		$this->db->where('lab_cases.type =', $type);
		$this->db->order_by('lab_cases.created_at', 'DESC');
	
		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_cases_list_by_patient($patient_id){
		$this->db->select('lab_cases.id as case_id,lab_cases.*, lab_test.name as test_name');
		$this->db->from('lab_cases');
		
		$this->db->join('case_has_tests', 'lab_cases.id = case_has_tests.case_id', 'left');
		$this->db->join('lab_test', 'case_has_tests.test_id = lab_test.id', 'left');
		
		if (!empty($patient_id)) {
			$this->db->where('lab_cases.patient_id', $patient_id);
		}
		$query = $this->db->get();
		$results = $query->result_array();
		 // Group tests by case
		 $grouped_cases = [];
		 foreach ($results as $row) {
			 $case_id = $row['case_id'];
			 if (!isset($grouped_cases[$case_id])) {
				 $grouped_cases[$case_id] = [
					 'case_id' => $case_id,
					 'created_at' => $row['created_at'],
					 'status' => $row['status'],
					 'type' => $row['type'],
					 'tests' => []
				 ];
			 }
			 $grouped_cases[$case_id]['tests'][] = [
				 'test_name' => $row['test_name'],
				 'test_result' => $row['test_result'],
				 'test_date' => $row['test_date']
			 ];
		 }
		 return array_values($grouped_cases);
	}
	public function get_tests_by_case($case_id) {
        $this->db->select('lab_test.id, lab_test.name');
        $this->db->from('case_has_tests');
        $this->db->join('lab_test', 'case_has_tests.test_id = lab_test.id', 'left');
        $this->db->where('case_has_tests.case_id', $case_id);
        $query = $this->db->get();
        return $query->result_array();
    }
	public function delete_case_request($id){

		$this->db->where('case_id', $id);
		$this->db->delete('case_has_tests');

		$this->db->where('id', $id);
        return $this->db->delete('lab_cases');

	}

	public function get_patient_case($case_id){
		$this->db->select('*');
		$this->db->from('lab_cases');
		$this->db->join('tbl_patients', 'lab_cases.patient_id = tbl_patients.patient_id', 'left');
		$this->db->where('lab_cases.id', $case_id);
		$query = $this->db->get();
		$results = $query->row();
		return $results;
	}

	public function get_test_params_for_case($case_id) {
		$this->db->select('t.id AS test_id, t.name AS test_name, tp.name AS param_name, pv.*,lu.name as unit_name');
		$this->db->from('case_has_tests ch');
		$this->db->join('lab_test t', 'ch.test_id = t.id');
		$this->db->join('test_has_params thp', 't.id = thp.test_id');
		$this->db->join('test_parameters tp', 'thp.param_id = tp.id');
		$this->db->join('lab_units lu', 'tp.unit = lu.id');
		$this->db->join('parameters_values pv', 'tp.id = pv.param_id');
		$this->db->where('ch.case_id', $case_id);
		$query = $this->db->get();
		$results = $query->result_array();
	
		// Organize data by test_id
		$test_params = [];
		foreach ($results as $row) {
			$test_id = $row['test_id'];
			if (!isset($test_params[$test_id])) {
				$test_params[$test_id] = [
					'test_name' => $row['test_name'],
					'parameters' => []
				];
			}
			$test_params[$test_id]['parameters'][] = [
				'param_name' => $row['param_name'],
				'lower_value' => $row['lower_value'],
				'max_value' => $row['max_value'],
				'min_age' => $row['min_age'],
				'max_age' => $row['max_age'],
				'gender' => $row['gender'],
				'unit_name' => $row['unit_name'],
				'normal_value' => $row['normal_value'],
			];
		}
	
		return $test_params;
	}
	public function save_test_result_json($case_id, $test_results,$remarks) {
        // Check if the result already exists
        $this->db->where('case_id', $case_id);
        $query = $this->db->get('case_test_result');

        $data = [
            'case_id' => $case_id,
            'result' => json_encode($test_results),
			'created_at'=>date('Y-m-d H:i:s'),
			'remarks'=>$remarks,
        ];

        if ($query->num_rows() > 0) {
            // Update existing result
            $this->db->where('case_id', $case_id);
            $this->db->update('case_test_result', $data);
        } else {
            // Insert new result
            $this->db->insert('case_test_result', $data);
        }
		$this->db->where('id', $case_id);
		$this->db->update('lab_cases', ['status'=>'1']);
    }

    // Method to get test results by case_id
    public function get_test_results_by_case_id($case_id) {
        $this->db->where('case_id', $case_id);
        $query = $this->db->get('case_test_result');
        return $query->row_array();
    }

	public function get_test_params_with_results($case_id) {
		// Fetch the test parameters and normal values
		$this->db->select('t.id AS test_id, t.name AS test_name, tp.name AS param_name, pv.*,lu.name as unit_name');
		$this->db->from('case_has_tests ch');
		$this->db->join('lab_test t', 'ch.test_id = t.id');
		$this->db->join('test_has_params thp', 't.id = thp.test_id');
		$this->db->join('test_parameters tp', 'thp.param_id = tp.id');
		$this->db->join('lab_units lu', 'tp.unit = lu.id');
		$this->db->join('parameters_values pv', 'tp.id = pv.param_id');
		$this->db->where('ch.case_id', $case_id);
		$query = $this->db->get();
		$params_result = $query->result_array();
	
		// Fetch the stored JSON results
		$this->db->select('result,remarks');
		$this->db->from('case_test_result');
		$this->db->where('case_id', $case_id);
		$query = $this->db->get();
		$results_row = $query->row_array();
		$stored_results = json_decode($results_row['result'], true);
	
		// Organize the data
		$organized_data = [];
		foreach ($params_result as $row) {
			$test_id = $row['test_id'];
			$param_id = $row['param_id'];
			$param_name = $row['param_name'];
	
			if (!isset($organized_data[$test_id])) {
				$organized_data[$test_id] = [
					'test_name' => $row['test_name'],
					'parameters' => []
				];
			}
	
			$organized_data[$test_id]['parameters'][] = [
				'param_id' => $param_id,
				'param_name' => $param_name,
				'normal_value' => $row['normal_value'],
				'max_value' => $row['max_value'],
				'lower_value' => $row['lower_value'],
				'remarks' => $results_row['remarks'],
				'unit_name' => $row['unit_name'],
				'param_value' => $stored_results[$test_id][$param_name] ?? null
			];
		}
	
		return $organized_data;
	}
	
	
}
