<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class PaymentsModel extends CI_Model
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	public function getPaymentsList()
	{
		$str_quary = "";

		$str_quary .= " SELECT 
		tbl_treatment_payment.*,
		GROUP_CONCAT(CONCAT(tbl_insurance_prices.treatment_name,' / ',tbl_insurance_prices.treatment_name_ar)  SEPARATOR '<br>') AS procedure_ids,
		tbl_diagnostise.name,
		tbl_episode_payment.*,
		tbl_users.full_name,
		tbl_patients.patient_name,
		tbl_insurance_types.insurance_name
	FROM 
		tbl_treatment_payment
	LEFT JOIN 
		tbl_episode_payment ON tbl_treatment_payment.treatement_payment_id = tbl_episode_payment.treatement_payment_id
	LEFT JOIN 
	tbl_diagnostise ON tbl_diagnostise.diagnostise_id = tbl_episode_payment.diagnostise_id
	LEFT JOIN 
	tbl_patients ON tbl_patients.patient_id = tbl_treatment_payment.patient_id
	LEFT JOIN 
	tbl_users ON tbl_users.user_Id = tbl_treatment_payment.user_id
	LEFT JOIN 
	tbl_insurance_types ON tbl_insurance_types.insurance_type_id = tbl_treatment_payment.insurance_type
	LEFT JOIN 
	tbl_insurance_prices ON tbl_insurance_prices.id = tbl_episode_payment.procedure_id
	";
		$str_quary .= " GROUP BY 
		tbl_treatment_payment.treatement_payment_id  ORDER BY tbl_treatment_payment.treatement_payment_id DESC";

		$query = $this->db->query($str_quary);
		return $query->result();
		// print_r($query->result());die;
	}

	public function getReceiptsList($search, $insurance, $length, $start, $order_column, $order)
	{
		if ($length > 0) {
		$this->db->select('tbl_patient_payment.*, tbl_patient_payment.*, tbl_patients.patient_name,tbl_patients.mobile, tbl_payment_types.type_name, tbl_patient_payment.patient_payment_id as recipt_no, tbl_treatment_payment.patient_id as patient_id,tbl_treatment_payment.treatement_payment_id as treatment_no,tbl_modules.module_name,tbl_users.full_name');
		}else{
			$this->db->select('count(tbl_patients.patient_name) as count');
		}
		$this->db->from('tbl_patient_payment');
		$this->db->join('tbl_treatment_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_patient_payment.treatment_payment_id', 'left');
		$this->db->join('tbl_modules', 'tbl_treatment_payment.department_id = tbl_modules.module_id', 'left');
		$this->db->join('tbl_insurance_types', 'tbl_treatment_payment.insurance_type = tbl_insurance_types.insurance_type_id', 'left');
		$this->db->join('tbl_patients', 'tbl_patients.patient_id = tbl_treatment_payment.patient_id', 'left');
		$this->db->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_patient_payment.pay_type', 'left');

		$this->db->join('tbl_users', 'tbl_users.user_Id = tbl_patient_payment.user_id', 'left');

		
		$this->db->where('is_insurance', $insurance);

		if (!empty($search)) {
			$this->db->group_start();
			$this->db->where('patient_payment_id', $search);
			$this->db->or_where('treatment_payment_id', $search);
			$this->db->or_where('tbl_patients.patient_id', $search);
			$this->db->or_where('tbl_patients.mobile', $search);
		
			$this->db->group_end();
		}
		
		if($length >0)
		$this->db->limit($length, $start);


		if($order_column != -1)
		$this->db->order_by($order_column, $order);

		$query = $this->db->get();
		return $query->result();
	}

	public function getTreatmentList($treatement_payment_id)
	{
		$str_quary = "";

		$str_quary .= " SELECT 
		tbl_treatment_payment.*,
		GROUP_CONCAT(CONCAT(tbl_insurance_prices.treatment_name,' / ',tbl_insurance_prices.treatment_name_ar)  SEPARATOR '<br>') AS procedure_ids,
		tbl_diagnostise.name,
		tbl_episode_payment.*,
		tbl_users.full_name,
		tbl_insurance_types.insurance_name,
		discount_category.discount as category_discount_p,
		tbl_companies.discount as company_discount_p
	FROM 
		tbl_treatment_payment
	LEFT JOIN 
		tbl_episode_payment ON tbl_treatment_payment.treatement_payment_id = tbl_episode_payment.treatement_payment_id
	LEFT JOIN 
	tbl_diagnostise ON tbl_diagnostise.diagnostise_id = tbl_episode_payment.diagnostise_id
	LEFT JOIN 
	tbl_users ON tbl_users.user_Id = tbl_treatment_payment.user_id
	LEFT JOIN 
	discount_category ON discount_category.id = tbl_treatment_payment.category_discount
	LEFT JOIN 
	tbl_companies ON tbl_companies.company_id = tbl_treatment_payment.company_discount
	LEFT JOIN 
	tbl_insurance_types ON tbl_insurance_types.insurance_type_id = tbl_treatment_payment.insurance_type
	LEFT JOIN 
	tbl_insurance_prices ON tbl_insurance_prices.id = tbl_episode_payment.procedure_id";
		$str_quary .= " WHERE tbl_treatment_payment.treatement_payment_id = " . $treatement_payment_id . " ORDER BY tbl_treatment_payment.treatement_payment_id DESC";

		$query = $this->db->query($str_quary);
		return $query->row();
	}

	public function getTreatmentRecipts($treatement_payment_id)
	{
		$str_quary = "";

		$str_quary .= " SELECT *
	FROM 
	tbl_patient_payment
	LEFT JOIN 
	tbl_payment_types ON tbl_payment_types.type_id = tbl_patient_payment.pay_type";
		$str_quary .= " WHERE tbl_patient_payment.treatment_payment_id = " . $treatement_payment_id . "";

		$query = $this->db->query($str_quary);
		return $query->result();
	}

	public function getTreatmentPatient($patient_id)
	{
		$str_quary = "";

		$str_quary .= " SELECT 
		tbl_treatment_payment.*,
		tbl_users.full_name,
		tbl_insurance_types.insurance_name
	FROM 
		tbl_treatment_payment
	LEFT JOIN 
	tbl_users ON tbl_users.user_Id = tbl_treatment_payment.user_id
	LEFT JOIN 
	tbl_insurance_types ON tbl_insurance_types.insurance_type_id = tbl_treatment_payment.insurance_type
	";
		$str_quary .= " WHERE tbl_treatment_payment.patient_id = " . $patient_id . "";

		$query = $this->db->query($str_quary);
		// print_r($this->db->last_query());die;
		return $query->result();
	}
	public function getTreatment($id)
	{
		// Use query binding to prevent SQL injection
		$this->db->select('tbl_treatment_payment.*, tbl_patients.patient_name, tbl_patients.second_mobile');
		$this->db->from('tbl_treatment_payment');
		$this->db->join('tbl_patients', 'tbl_patients.patient_id = tbl_treatment_payment.patient_id', 'left');
		$this->db->where('tbl_treatment_payment.treatement_payment_id', $id);
	
		$query = $this->db->get();
		
		// Return the result
		return $query->row();
	}

	// public function getTreatmentReciptsPatient($patient_id)
	// {
	// 	$str_quary = "";

	// 	$str_quary .= " SELECT *
	// 	FROM 
	// 	tbl_patient_payment
	// 	LEFT JOIN 
	// 	tbl_payment_types ON tbl_payment_types.type_id = tbl_patient_payment.pay_type";
	// 	$str_quary .= " WHERE tbl_patient_payment.patient_id = " . $patient_id . "";
	// 	$str_quary .= " AND tbl_patient_payment.pay_type != 3";

	// 	$query = $this->db->query($str_quary);
	// 	return $query->result();
	// }
	public function getTreatmentReciptsPatient($patient_id)
{

	$str_query = "SELECT tbl_patient_payment.*,tbl_treatment_payment.discount as doctor_discount
	FROM tbl_patient_payment
	
	INNER JOIN tbl_treatment_payment ON tbl_treatment_payment.treatement_payment_id = tbl_patient_payment.treatment_payment_id
	WHERE tbl_patient_payment.patient_id = ?
	AND tbl_patient_payment.pay_type != 3";

$query = $this->db->query($str_query, array($patient_id));

return $query->result();

}

	public function getInvoiceDiscounts($patient_id)
	{
		return $this->db->select('SUM(`discount`) as `total_invoice_discount`')
			->from('tbl_treatment_payment')
			->where('patient_id', $patient_id)
			->group_by('patient_id')
			->get()
			->row()->total_invoice_discount;
	}

	public function getReceiptDiscounts($patient_id)
	{
		return $this->db->select('SUM(`discount`) as `total_receipt_discount`')
			->from('tbl_patient_payment')
			->where('patient_id', $patient_id)
			// ->where('is_insurance', )
			->where_not_in('pay_type', array(3))
			->group_by('patient_id')
			->get()
			->row()->total_receipt_discount;
	}

	public function getTotalRefunds($patient_id)
	{
		return $this->db->select('SUM(`amount`) as `total_total_refund`')
			->from('tbl_refund')
			->where('patient_id', $patient_id)
			->group_by('patient_id')
			->get()
			->row()->total_total_refund;
	}

	public function paidInvoices($patient_id)
	{
		$this->db->select('tbl_treatment_payment.treatement_payment_id');
		$this->db->select('tbl_treatment_payment.total as gross_total');
		$this->db->select('tbl_treatment_payment.treat_date');
		$this->db->select('tbl_treatment_payment.discount as doctor_discount');
		$this->db->select('COALESCE(SUM(IFNULL(tbl_patient_payment.insurance_amount,0)), 0) AS insurance_amount', FALSE);
		$this->db->select('COALESCE(SUM(IFNULL(tbl_patient_payment.co_payment,0)), 0) AS co_payment', FALSE);
		$this->db->select('
				(tbl_treatment_payment.discount + 
				COALESCE(SUM(IFNULL(tbl_patient_payment.discount, 0) 
				+ IFNULL(tbl_patient_payment.coupon_discount, 0) 
				+ IFNULL(tbl_patient_payment.company_discount, 0) 
				+ IFNULL(tbl_patient_payment.category_discount, 0) 
				+ IFNULL(tbl_patient_payment.points_discount, 0)), 0)
				) AS total_discount', FALSE);
		$this->db->select('COALESCE(SUM(IFNULL(tbl_patient_payment.total,0))) AS net_total', FALSE);
		$this->db->select('COALESCE(SUM(IFNULL(tbl_patient_payment.cash,0))) AS paid_total', FALSE);
		$this->db->from('tbl_treatment_payment');
		$this->db->join('tbl_patient_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_patient_payment.treatment_payment_id', 'left');
		$this->db->group_by('tbl_treatment_payment.treatement_payment_id');
		
		$this->db->where('tbl_treatment_payment.patient_id', $patient_id);

		$query = $this->db->get();

		return $query->result();
	}

	public function getReceipts($patient_id)
	{
		return $this->db->select('*')
			->from('tbl_patient_payment')
			->where('tbl_patient_payment.patient_id', $patient_id)
			->join('tbl_payment_types', 'tbl_patient_payment.pay_type = tbl_payment_types.type_id', 'left')
			->get()
			->result();
	}

	public function getInvoiceList($search, $length, $start, $order_column, $order)
	{
		if ($length > -1) {
			$this->db->select('tbl_treatment_payment.*, tbl_treatment_payment.treatement_payment_id AS treatment_payment_id, tbl_treatment_payment.treatement_payment_id AS invoice_id, tbl_treatment_payment.patient_id AS file_no');
			$this->db->select("GROUP_CONCAT(CONCAT(tbl_insurance_prices.treatment_name, ' / ', tbl_insurance_prices.treatment_name_ar) SEPARATOR '<br>') AS procedure_ids");
			$this->db->select('tbl_diagnostise.name');
			$this->db->select('tbl_episode_payment.*');
			$this->db->select('tbl_users.full_name');
			$this->db->select('tbl_patients.patient_name');
			$this->db->select("FORMAT((tbl_treatment_payment.total - tbl_treatment_payment.discount) - IFNULL((SELECT SUM(total) FROM tbl_patient_payment WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id), '0.00'), 2) AS due_amount", false);
			$this->db->select('tbl_insurance_types.insurance_name');
			$this->db->select('tbl_modules.module_name');
		} else {
			$this->db->select('count(*)');
		}
		$this->db->from('tbl_treatment_payment');
		$this->db->join('tbl_episode_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_episode_payment.treatement_payment_id', 'left');
		$this->db->join('tbl_diagnostise', 'tbl_diagnostise.diagnostise_id = tbl_episode_payment.diagnostise_id', 'left');
		$this->db->join('tbl_patients', 'tbl_patients.patient_id = tbl_treatment_payment.patient_id', 'left');
		$this->db->join('tbl_users', 'tbl_users.user_Id = tbl_treatment_payment.user_id', 'left');
		$this->db->join('tbl_modules', 'tbl_modules.department_id = tbl_treatment_payment.department_id', 'left');
		$this->db->join('tbl_insurance_types', 'tbl_insurance_types.insurance_type_id = tbl_treatment_payment.insurance_type', 'left');
		$this->db->join('tbl_insurance_prices', 'tbl_insurance_prices.id = tbl_episode_payment.procedure_id', 'left');

		if (!empty($search)) {
			$this->db->like('tbl_treatment_payment.treatement_payment_id', $search);
			$this->db->or_like('tbl_patients.patient_id', $search);
			$this->db->or_like('tbl_patients.patient_name', $search);
			$this->db->or_like('tbl_modules.module_name', $search);
			$this->db->or_like('tbl_insurance_types.insurance_name', $search);
			$this->db->or_like('tbl_treatment_payment.treat_date', $search);
			$this->db->or_like('tbl_users.full_name', $search);
		}

		$this->db->group_by('tbl_treatment_payment.treatement_payment_id');

		if ($length > 0)
			$this->db->limit($length, $start);

		$query = $this->db->get();
		return $query->result();
	}
public function getInvoiceListDT($search, $length, $start, $order_column, $order,$status, $p_mobile, $p_file)
	{
	    
		$this->db->select('
    tp.treatement_payment_id AS treatment_payment_id,
    tp.treatement_payment_id AS invoice_id,
    tp.patient_id AS file_no,
    FORMAT((tp.discount + IFNULL(pp.total_discount, 0)), 2) AS all_discount,
    tp.treat_date,
    tp.treat_time,
    tp.total,
    u.full_name,
    p.patient_name,
    p.patient_id,
    p.mobile,
	pp.total_paid_amount,
	FORMAT((tp.total - (tp.discount + IFNULL(pp.total_discount, 0))) - IFNULL(pp.total_paid_amount, 0), 2) AS due_amount,
    it.insurance_name,
    m.module_name,
	tp.created_by,
	uc.full_name as created_by_name
', false);


$this->db->from('tbl_treatment_payment tp');

// Joins
$this->db->join('tbl_patients p', 'p.patient_id = tp.patient_id', 'left');
$this->db->join('tbl_users u', 'u.user_Id = tp.user_id', 'left');
$this->db->join('tbl_users uc', 'uc.user_Id = tp.created_by', 'left');
$this->db->join('tbl_modules m', 'm.department_id = tp.department_id', 'left');
$this->db->join('tbl_insurance_types it', 'it.insurance_type_id = tp.insurance_type', 'left');
if(!empty($p_mobile)){
	$this->db->where('p.mobile', $p_mobile);
}
if(!empty($p_file)){
	$this->db->where('p.patient_id', $p_file);
}
// Subquery for discount and total amount
$this->db->join('(
    SELECT 
        treatment_payment_id,
        SUM(discount + IFNULL(company_discount, 0) + IFNULL(category_discount, 0) + IFNULL(coupon_discount, 0) +IFNULL(points_discount, 0)) AS total_discount,
        SUM(cash) AS total_paid_amount
    FROM tbl_patient_payment 
    GROUP BY treatment_payment_id
) pp', 'pp.treatment_payment_id = tp.treatement_payment_id', 'left');
if (!empty($search)) {
	$this->db->where('tp.treatement_payment_id', $search);
	$this->db->or_where('p.mobile', $search);
	$this->db->or_where('p.patient_id', $search);
	// $this->db->or_like('p.patient_id', $search);
	// $this->db->or_like('p.patient_name', $search);
	// $this->db->or_like('m.module_name', $search);
	// $this->db->or_like('it.insurance_name', $search);

}


if ($length > 0)
	$this->db->limit($length, $start);


$this->db->order_by($order_column,$order);
if (!empty($status)) {
	if($status==1){
		$this->db->having('due_amount >', 0);
	}elseif($status==2){
		$this->db->having('due_amount =', 0);
	}
	
}
// Execute the query
$query = $this->db->get();
return $query->result();	
	}
// 	public function getInvoiceListDT($search, $length, $start, $order_column, $order,$status)
// 	{
// 		if ($length > -1) {
// 			$this->db->select('tbl_treatment_payment.treatement_payment_id AS treatment_payment_id, tbl_treatment_payment.treatement_payment_id AS invoice_id, tbl_treatment_payment.patient_id AS file_no,tbl_treatment_payment.created_by ');
// 			$this->db->select("FORMAT(
// 				(tbl_treatment_payment.discount) 
// 				+ IFNULL((SELECT SUM(discount) FROM tbl_patient_payment WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id), '0.00')
// 				+ IFNULL((SELECT SUM(company_discount) FROM tbl_patient_payment WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id), '0.00') 
// 				+ IFNULL((SELECT SUM(category_discount) FROM tbl_patient_payment WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id), '0.00') 
// 				+ IFNULL((SELECT SUM(coupon_discount) FROM tbl_patient_payment WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id), '0.00') 
// 				+ IFNULL((SELECT SUM(points_discount) FROM tbl_patient_payment WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id), '0.00'), 2) 
// 				AS all_discount", false);
// 			$this->db->select("IFNULL((SELECT SUM(cash) FROM tbl_patient_payment WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id), '0.00') AS total_paid_amount", false);
// 			$this->db->select('tbl_treatment_payment.treat_date');
// 			$this->db->select('tbl_treatment_payment.treat_time');
// 			$this->db->select('tbl_treatment_payment.total');
// 			$this->db->select('tbl_users.full_name');
// 			$this->db->select('cb.full_name as created_by_name');
// 			$this->db->select('tbl_patients.patient_name');
// 			$this->db->select('tbl_patients.patient_id');
// 			$this->db->select("
//     FORMAT(
//         (
//             tbl_treatment_payment.total - tbl_treatment_payment.discount 
//             - IFNULL(
//                 (SELECT SUM(category_discount)
//                  FROM tbl_patient_payment 
//                  WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id
//                 ), 
//                 '0.00'
//             )
//             - IFNULL(
//                 (SELECT SUM(company_discount)
//                  FROM tbl_patient_payment 
//                  WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id
//                 ), 
//                 '0.00'
//             )
// 			- IFNULL(
//                 (SELECT SUM(coupon_discount)
//                  FROM tbl_patient_payment 
//                  WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id
//                 ), 
//                 '0.00'
//             )
// 			- IFNULL(
//                 (SELECT SUM(points_discount)
//                  FROM tbl_patient_payment 
//                  WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id
//                 ), 
//                 '0.00'
//             )
// 			- IFNULL(
//                 (SELECT SUM(discount)
//                  FROM tbl_patient_payment 
//                  WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id
//                 ), 
//                 '0.00'
//             )
//             - IFNULL(
//                 (SELECT SUM(cash) 
//                  FROM tbl_patient_payment 
//                  WHERE tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id
//                 ), 
//                 '0.00'
//             )
//         ), 2
//     ) AS due_amount", false);
// 			$this->db->select('tbl_insurance_types.insurance_name');
// 			$this->db->select('tbl_modules.module_name');
// 			$this->db->order_by($order_column, $order);
// 		} else {
// 			$this->db->select('count(*)');
// 		}
// 		$this->db->from('tbl_treatment_payment');
// 		$this->db->join('tbl_patients', 'tbl_patients.patient_id = tbl_treatment_payment.patient_id', 'left');
// 		$this->db->join('tbl_users', 'tbl_users.user_Id = tbl_treatment_payment.user_id', 'left');
// 		$this->db->join('tbl_users as cb', 'cb.user_Id = tbl_treatment_payment.created_by', 'left');
// 		$this->db->join('tbl_modules', 'tbl_modules.department_id = tbl_treatment_payment.department_id', 'left');
// 		$this->db->join('tbl_insurance_types', 'tbl_insurance_types.insurance_type_id = tbl_treatment_payment.insurance_type', 'left');

// 		if (!empty($search)) {
// 			$this->db->like('tbl_treatment_payment.treatement_payment_id', $search);
// 			$this->db->or_like('tbl_patients.patient_id', $search);
// 			$this->db->or_like('tbl_patients.patient_name', $search);
// 			$this->db->or_like('tbl_modules.module_name', $search);
// 			$this->db->or_like('tbl_insurance_types.insurance_name', $search);
// 			$this->db->or_like('tbl_treatment_payment.treat_date', $search);
// 			$this->db->or_like('tbl_users.full_name', $search);
// 		}
// 		if (!empty($status)) {
// 			if($status==1){
// 				$this->db->having('due_amount >', 0);
// 			}elseif($status==2){
// 				$this->db->having('due_amount =', 0);
// 			}
			
// 		}

// 		$this->db->group_by('tbl_treatment_payment.treatement_payment_id');
// 		// $this->db->order_by('tbl_treatment_payment.treatement_payment_id','desc');
		

// 		if ($length > 0)
// 			$this->db->limit($length, $start);

// 		$query = $this->db->get();
// 		return $query->result();
// 	}

	public function getInvoiceCount()
{
    return $this->db->from('tbl_treatment_payment')->count_all_results();
}

public function getReceiptsCount()
{
    return $this->db->from('tbl_patient_payment')->count_all_results();
}


	public function getTotalAdvance($patient_id)
	{
		$advance = $this->CommonModel->get_patient_advance($patient_id);
		$payed = $this->CommonModel->get_payed_by_advance($patient_id);
		return ($advance - $payed);
	}

	public function getAdvanceReceipts($patient_id)
	{
		return $this->db->select('*')
			->from('tbl_advance')
			->where('tbl_advance.patient_id', $patient_id)
			->join('tbl_payment_types', 'tbl_advance.pay_type = tbl_payment_types.type_id', 'left')
			->get()
			->result();
	}

	public function deleteUsedCoupon($coupon_id, $patient_id){
		$this->db->where('user_id',$patient_id);
		$this->db->where('coupon_id',$coupon_id);
		$this->db->delete('user_coupons');
	}

	public function getLoyaltyTransactions($patient_id,$search,$status){
		$this->db->select('*')
			->from('loyalty_transactions')
			->where('user_id',$patient_id);

			if(!empty($status)){
				$this->db->where('transaction_type',$status);
			}
			$query = $this->db->get();
			return $query->result();
	}
}
