<?php

use
    DataTables\Editor,
    DataTables\Editor\Field,
    DataTables\Editor\Format,
    DataTables\Editor\Join,
    DataTables\Editor\Upload,
    DataTables\Editor\Validate;
    
class DrugsModel extends CI_Model 
{
    private $editorDb = null;
    
    //constructor which loads the CodeIgniter database class (not required)
    public function __construct()	{
        $this->load->database();
    }    
    
    public function init($editorDb)
    {
        $this->editorDb = $editorDb;
    }
    
    public function getDrugs($post)
    {
		// Build our Editor instance and process the data coming from _POST
		// Use the Editor database class
		Editor::inst( $this->editorDb, 'sh_drugs' )
		->fields(
		    Field::inst( 'sh_drugs.drug_name' )->validator( 'Validate::unique' ),
            Field::inst( 'sh_drugs.drugs_category' ),
            Field::inst( 'sh_drugs.drugs_location' ),
            Field::inst( 'sh_drugs.drugs_brand' ),
		    Field::inst( 'sh_drugs.drugs_code' )->validator( 'Validate::unique' ),
            Field::inst( 'sh_drugs.total_quantity' ),
		    Field::inst( 'sh_drugs.quantity' ),
		    Field::inst( 'sh_drugs.price' ),
            Field::inst( 'sh_drugs.on_hand' ),
            Field::inst( 'sh_drugs.drug_loose' ),
		    Field::inst( 'sh_drugs.loose_active' ),
            Field::inst( 'sh_drugs.expiry' ),
            Field::inst( 'sh_drugs.deleted' ),
            Field::inst( 'sh_category.category_name' ),
            Field::inst( 'sh_status.status_name' ),
            Field::inst( 'sh_locations.location_name' ),
            Field::inst( 'sh_brand.brand_name' ),
            Field::inst( 'sh_drugs.drug_id' )

		)
        ->leftJoin( 'sh_category',   'sh_category.category_id',   '=', 'sh_drugs.drugs_category' )
        ->leftJoin( 'sh_status',   'sh_status.status_id',   '=', 'sh_drugs.deleted' )
        ->leftJoin( 'sh_locations',   'sh_locations.location_id',   '=', 'sh_drugs.drugs_location' )
        ->leftJoin( 'sh_brand',   'sh_brand.brand_id',   '=', 'sh_drugs.drugs_brand' )
        ->pkey('sh_drugs.drug_id')
		->process( $post )
		->json();    
    }

    public function getSuppliers($post)
    {
        Editor::inst( $this->editorDb, 'sh_supplier' )
        ->fields(
            Field::inst( 'sh_supplier.supplier_name' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'sh_supplier.email' )->validator( 'Validate::email', array(
                                                'required' => true
                                            ) ),
            Field::inst( 'sh_supplier.mobile' ),
            Field::inst( 'sh_supplier.phone' ),
            Field::inst( 'sh_supplier.fax' ),
            Field::inst( 'sh_supplier.deleted' ),
            Field::inst( 'sh_status.status_name' )
        )
        ->leftJoin( 'sh_status',   'sh_status.status_id',   '=', 'sh_supplier.deleted' )
        ->pkey('sh_supplier.supplier_id')
        ->process( $post )
        ->json();    
    }

    public function getToken($post)
    {
        Editor::inst( $this->editorDb, 'appointment_category' )
        ->fields(
            Field::inst( 'app_cat_code' )->validator( 'Validate::unique' ),
            Field::inst( 'app_cat_name' )
        )
        ->pkey('app_cat_id')
        ->process( $post )
        ->json();    
    }

    public function getLaser($post)
    {
        Editor::inst( $this->editorDb, 'laser_type' )
        ->fields(
            Field::inst( 'laser_name' ),
            Field::inst( 'laser_id' )
        )
        ->pkey('laser_id')
        ->process( $post )
        ->json();    
    }

    public function getCategory($post)
    {
        Editor::inst( $this->editorDb, 'sh_category' )
        ->fields(
            Field::inst( 'category_id' ),
            Field::inst( 'category_name' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'category_desc' )->validator( 'Validate::notEmpty' )
        )
        ->pkey('category_id')
        ->process( $post )
        ->json();    
    }

    public function getLocation($post)
    {
        Editor::inst( $this->editorDb, 'sh_locations' )
        ->fields(
            Field::inst( 'location_id' ),
            Field::inst( 'location_name' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'location_desc' )->validator( 'Validate::notEmpty' )
        )
        ->pkey('location_id')
        ->process( $post )
        ->json();    
    }

    public function getBrand($post)
    {
        Editor::inst( $this->editorDb, 'sh_brand' )
        ->fields(
            Field::inst( 'brand_id' ),
            Field::inst( 'brand_name' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'brand_desc' )->validator( 'Validate::notEmpty' )
        )
        ->pkey('brand_id')
        ->process( $post )
        ->json();    
    }
    
    //An additional method just to see if we can still use the Codeigniter database class (not required)
    // public function getStaffMember($id)
    // {
    //     if($id != false) 
    //     {
    //         //Use the CodeIgniter database class
    //         $query = $this->db->get_where('users', array('id' => $id));
    //         return $query->row_array();
    //     }
    //     return false;
    // }
}