<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inquiry extends CI_Model {

	var $table = 'sh_inquiry';
	var $column_order = array('inquiry_id','inquiry_date','supplier_name','mobile',null); //set column field database for datatable orderable
	var $column_search = array('sh_inquiry.inquiry_id','inquiry_date','supplier_name','mobile'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order = array('inquiry_id' => 'desc'); // default order 

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	private function _get_datatables_query()
	{
		
		$this->db->from($this->table);
		$this->db->join('sh_supplier', 'sh_inquiry.supplier_id = sh_supplier.supplier_id', 'left');
		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{				
				$this->db->or_like($item, $_POST['search']['value']);
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	function get_datatables()
	{
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function count_filtered()
	{
		$this->_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->from($this->table);
		return $this->db->count_all_results();
	}

	public function get_by_id($id)
	{
		$this->db->from($this->table);
		$this->db->where('sh_inquiry.inquiry_id',$id);
		$this->db->join('sh_supplier', 'sh_inquiry.supplier_id = sh_supplier.supplier_id', 'left');
		$query = $this->db->get();

		return $query->row();
	}

	public function get_by_id_view($id)
	{
		$this->db->select("sh_inquiry_items.item_id,sh_inquiry_items.quantity,sh_drugs.drug_name");
		$this->db->from("sh_inquiry_items");
		$this->db->where('inquiry_id',$id);
		$this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_inquiry_items.item_id', 'left');
		$query = $this->db->get();

		return $query->result_array();
	}

	public function save($data)
	{
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}

	public function update($where, $data)
	{
		$this->db->update($this->table, $data, $where);
		return $this->db->affected_rows();
	}

	public function delete_by_id($id)
	{
		$this->db->where('sh_inquiry.inquiry_id', $id);
		$this->db->delete($this->table);
	}


}
