<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Pos extends CI_Model {

    public function get_all() {
        $result = $this->db->get('sh_supplier');
        return $result->result();
    }
    
    public function get_bill($bill) {
        $query="SELECT "
                . "`sell_bill_id` as bill_id, `sell_date` as bill_date, `amount` as bill_amount, `paid_amount` as payment, `tbl_patients`.`patient_id` as patient_id, `patient_name` as patient "
                . "FROM `sh_sell_bill` "
                . "left join `sh_sell_bill_credit` "
                . "on `sh_sell_bill_credit`.`bill_id`=`sell_bill_id` "
                . "left join `sh_sell_bill_paid` "
                . "on `sh_sell_bill_paid`.`bill_id`=`sell_bill_id` "
                . "left join `tbl_patients` "
                . "on `tbl_patients`.`patient_id`=`sh_sell_bill_credit`.`patient_id` "
                . "WHERE `sell_bill_id`=$bill";
        $result = $this->db->query($query);
        return $result->result_array();
    }
    
    public function get_bill_items($bill) {
        $query="SELECT "
                . "`batch`, `qty`-`returned` as `qty`, `sell_price` as price, `item_id`, `drug_name` as item_name "
                . "FROM `sh_sell_bill_items` "
                . "left join `sh_drugs` "
                . "on `drug_id`=`item_id` "
                . "WHERE `sell_bill_id`=$bill";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function add_data($table,$data) {
        $this->db->insert($table, $data);
        return $this->db->insert_id();
    }

    public function search($param) {
        $this->db->like('supplier_name', $param);
        $this->db->or_like('email', $param);
        $this->db->or_like('mobile', $param);
        $this->db->or_like('phone', $param);
        $this->db->or_like('fax', $param);
        $result = $this->db->get('sh_supplier');
        return $result->result();
    }

    public function search_json($param) {
        $query = "SELECT `supplier_id`, `supplier_name` "
                . "FROM `sh_supplier` "
                . "where `supplier_name` like '%$param%' and `deleted`=0 "
                . "group by `supplier_id`";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function count_active() {
        $this->db->where('deleted', 0);
        $this->db->from('sh_supplier');
        return $this->db->count_all_results();
    }

    public function delete($id, $where) {
        $value=($where==0)?1:0;
        $data=array('deleted'=>$value);
        $this->db->where('supplier_id', $id);
        $this->db->update('sh_supplier', $data);
        return $this->db->affected_rows();
    }

    public function update($id, $data) {
        $this->db->where('supplier_id', $id);
        $this->db->update('sh_supplier', $data);
        return $this->db->affected_rows();
    }

    public function add_bill_payment($data) {
        $this->db->insert('sh_bill_paid', $data);
        return $this->db->affected_rows();
    }

public function get_reciept($bill_id)
    {
        $query = $this->db->query("SELECT sh_drugs.drug_name, sh_sell_bill_items.qty, sh_sell_bill_items.sell_price, sh_sell_bill_items.discount, sh_sell_bill.amount, sh_sell_bill.sell_date, sh_sell_bill.type, sh_sell_bill_paid.paid_amount, employee.employee_name, sh_sell_bill.sell_bill_id
                                    FROM sh_sell_bill_items 
                                    LEFT JOIN sh_drugs 
                                    ON sh_sell_bill_items.item_id = sh_drugs.drug_id 
                                    LEFT JOIN sh_sell_bill 
                                    ON sh_sell_bill_items.sell_bill_id = sh_sell_bill.sell_bill_id
                                    LEFT JOIN sh_sell_bill_paid 
                                    ON sh_sell_bill_paid.bill_id = sh_sell_bill.sell_bill_id
                                    LEFT JOIN users
                                    ON users.user_id = sh_sell_bill.user_id
                                    LEFT JOIN employee 
                                    ON employee.employee_id = users.employee_id  
                                    WHERE sh_sell_bill_items.sell_bill_id = '$bill_id'");

        if($query->num_rows() > 0)
            {
                return $query->result_array(); 
            }else{
                return FALSE;
            }
    }

}
