<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Supplier extends CI_Model {
   
    
    public function get_all() {
        $result = $this->db->get('sh_supplier');
        return $result->result();
    }

    public function add($data) {
        $this->db->insert('sh_supplier', $data);
        return $this->db->affected_rows();
    }

    public function search($param) {
        $this->db->like('supplier_name', $param);
        $this->db->or_like('email', $param);
        $this->db->or_like('mobile', $param);
        $this->db->or_like('phone', $param);
        $this->db->or_like('fax', $param);
        $result = $this->db->get('sh_supplier');
        return $result->result();
    }

    public function search_json($param) {
        $query = "SELECT `supplier_id`, `supplier_name` "
                . "FROM `sh_supplier` "
                . "where `supplier_name` like '%$param%' and `deleted`=0 "
                . "group by `supplier_id`";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function count_active() {
        $this->db->where('deleted', 0);
        $this->db->from('sh_supplier');
        return $this->db->count_all_results();
    }

    public function delete($id, $where) {
        $value = ($where == 0) ? 1 : 0;
        $data = array('deleted' => $value);
        $this->db->where('supplier_id', $id);
        $this->db->update('sh_supplier', $data);
        return $this->db->affected_rows();
    }

    public function update($id, $data) {
        $this->db->where('supplier_id', $id);
        $this->db->update('sh_supplier', $data);
        return $this->db->affected_rows();
    }

    public function add_bill($data) {
        $this->db->insert('sh_bill', $data);
        return $this->db->insert_id();
    }

    public function supplier_account($supplier) {
        $query = "SELECT sum(`amount`) as amount, sum(`paid_amount`) as paid "
                . "FROM `sh_bill` "
                . "left join `sh_bill_paid` "
                . "on `sh_bill_paid`.`bill_id`=`sh_bill`.`bill_id` "
                . "WHERE `supplier_id`=$supplier";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function get_bill($bill) {
        $query = "SELECT `sh_bill`.`bill_id`, `supplier_name`, `sh_bill`.`supplier_id`, `receive_date`, `amount`, `paid_amount` "
                . "FROM `sh_bill` "
                . "left join `sh_supplier` "
                . "on `sh_supplier`.`supplier_id`=`sh_bill`.`supplier_id` "
                . "left join `sh_receive_bill` "
                . "on `sh_receive_bill`.`bill_id`=`sh_bill`.`bill_id` "
                . "left join `sh_bill_paid` "
                . "on `sh_bill_paid`.`bill_id`=`sh_bill`.`bill_id` "
                . "WHERE `sh_bill`.`bill_id`=$bill";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function insert_record($table, $data) {
        $this->db->insert($table, $data);
        return $this->db->insert_id();
    }

   public function get_inquiry()
    {

        $query = $this->db->query("SELECT * FROM sh_inquiry
            LEFT JOIN sh_supplier ON sh_inquiry.supplier_id = sh_supplier.supplier_id");
            
            if($query->num_rows() > 0)
            {
                return $query->result_array();
                
            } else{
                return FALSE;
            }
    }

    public function get_gross($supplier) {
        $query = "SELECT sum(amount) as amount FROM sh_supplier
        LEFT JOIN sh_bill ON sh_bill.supplier_id = sh_supplier.supplier_id
        WHERE sh_supplier.supplier_id = '$supplier'
        GROUP BY sh_supplier.supplier_id";

        $result = $this->db->query($query);
        return $result->row();
    }

    public function get_statement($supplier) {
        $query = "SELECT sh_supplier.supplier_id,supplier_name,mobile,sum(amount) as amount,sum(discount) as discount FROM sh_supplier
        LEFT JOIN sh_bill ON sh_bill.supplier_id = sh_supplier.supplier_id
        -- LEFT JOIN sh_bill_paid ON sh_bill_paid.bill_id = sh_bill.bill_id
        WHERE sh_supplier.supplier_id = '$supplier'
        GROUP BY sh_supplier.supplier_id";

        $result = $this->db->query($query);
        return $result->row();
    }

    public function paid_list($supplier) {
        $query = "SELECT * FROM sh_bill_paid
        LEFT JOIN sh_bill ON sh_bill_paid.bill_id = sh_bill.bill_id
        LEFT JOIN sh_bill_payment ON sh_bill_payment.payment_id = sh_bill_paid.payment_id
        WHERE supplier_id = '$supplier'";

        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function returned_list($supplier) {
        $query = "SELECT * FROM sh_return_stock
        LEFT JOIN sh_bill ON sh_return_stock.bill_id = sh_bill.bill_id
        WHERE sh_bill.supplier_id = '$supplier'";

        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function get_email($id)
    {

        $query = $this->db->query("SELECT * FROM sh_inquiry
            LEFT JOIN sh_supplier ON sh_inquiry.supplier_id = sh_supplier.supplier_id
            where inquiry_id = $id");
            
            if($query->num_rows() > 0)
            {
                return $query->row();
                
            } else{
                return FALSE;
            }
    }
    function get_datatables()
	{
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}
    private function _get_datatables_query()
	{
         $table = 'sh_supplier';
         $column_order = array('supplier_id','supplier_name','mobile',null); //set column field database for datatable orderable
         $column_search = array('supplier_id','supplier_name','mobile'); //set column field database for datatable searchable just firstname , lastname , address are searchable
         $order = array('supplier_id' => 'desc'); // default order 

		$this->db->from($table);
		// $this->db->join('sh_supplier', 'sh_bill.supplier_id = sh_supplier.supplier_id', 'left');
		$i = 0;
	
		foreach ($column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{				
				$this->db->or_like($item, $_POST['search']['value']);
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($order))
		{
			
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}
    function count_filtered()
	{
		$this->_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
        $table = 'sh_supplier';
		$this->db->from($table);
		return $this->db->count_all_results();
	}

}
