<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class QlmModel extends CI_Model
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	function qlmPriceList($insurnaceId, $treatmentCategory)
	{
		return $this->db->select('*')
			->from('tbl_insurance_prices')
			->where('insurance_type_id', $insurnaceId)
			->where('treatment_category', $treatmentCategory)
			->get()
			->result();
	}

	public function getDiagnosis($term)
	{
		$term = $this->db->escape_like_str($term);
		$this->db->select('diagnostise_id, name');
		$this->db->from('tbl_diagnostise');
		$this->db->like('name', $term);
		$this->db->limit(20);
		return $this->db->get()->result_array();
	}

	public function getLastExam($id)
	{
		$this->db->select('*');
		$this->db->from('tbl_examination');
		$this->db->where('patient_id', $id);
		$this->db->order_by('exam_id', 'DESC');
		$this->db->limit(1);
		$query = $this->db->get();

		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}

	public function getDoctorData($id)
	{
		return $this->db->select('tbl_employees.*')
		->from('tbl_users')
		->join('tbl_employees', 'tbl_users.user_Id=tbl_employees.user_id')
		->where('tbl_users.user_Id', $id)
		->get()
		->row();

	}

}
