<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class ReceiptModel extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function get_active_template()
    {
        return $this->db->select('*')
        ->from('tbl_invoice_templates')
        ->where('invoice_type', 2)
        ->where('is_default', 1)
        ->where('is_active', 1)
        ->get()
        ->row()->template;
    }

    public function get_receipt_header_details($patient_payment_id)
    {
        return $this->db->select('tbl_patient_payment.*, tbl_receptionist.full_name as receptionist, tbl_patients.patient_name, tbl_doctor.full_name as doctor, tbl_treatment_payment.total as total_payment,tbl_treatment_payment.discount as invoice_discount, tbl_patient_payment.total as paid_total, tbl_patient_payment.discount as cashier_discount, tbl_patient_payment.co_payment,tbl_patient_payment.insurance_amount,tbl_insurance_types.insurance_name,tbl_payment_types.type_name,
        tbl_doctor_types.doctor_type')
        ->from('tbl_patient_payment')
        ->where('patient_payment_id', $patient_payment_id)
        ->join('tbl_users as tbl_receptionist', 'tbl_receptionist.user_id = tbl_patient_payment.user_id')
        ->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_patient_payment.pay_type','left')
        ->join('tbl_patients', 'tbl_patients.patient_id = tbl_patient_payment.patient_id','left')
        ->join('tbl_treatment_payment', 'tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id','left')
        ->join('tbl_users as tbl_doctor', 'tbl_treatment_payment.user_id = tbl_doctor.user_id','left')
        ->join('tbl_employees', 'tbl_employees.user_id = tbl_doctor.user_id','left')
        ->join('tbl_doctor_types', 'tbl_doctor_types.doctor_types_id = tbl_employees.doctor_type','left')
        ->join('tbl_insurance_types', 'tbl_insurance_types.insurance_type_id = tbl_treatment_payment.insurance_type','left')
        ->get()
        ->row();
    }

    public function get_invoice_data_for_receipt($treatment_payment_id)
    {
        return $this->db->select('*')
        ->from('tbl_treatment_payment')
        ->join('tbl_patients', 'tbl_treatment_payment.patient_id = tbl_patients.patient_id','left')
        ->where('treatement_payment_id', $treatment_payment_id)
        ->get()
        ->result();
    }

    public function get_receipt_summary($treatment_payment_id)
    {
        return $this->db->select('*')
        ->from('tbl_patient_payment')
        ->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_patient_payment.pay_type','left')
        ->where('treatment_payment_id', $treatment_payment_id)
        ->get()
        ->result();
    }

    public function get_episode_payments($treatment_payment_id)
    {
        return $this->db->select('*')
        ->from('tbl_episode_payment')
        ->join('tbl_insurance_prices', 'tbl_episode_payment.procedure_id = tbl_insurance_prices.id','left')
        ->where('treatement_payment_id', $treatment_payment_id)
        ->get()
        ->result();
    }
    
     public function get_previous_advance($patient_id,$advance_id)
	{
		$advance = $this->get_patient_advance($patient_id,$advance_id);
		$payed = $this->get_payed_by_advance($patient_id);
		return ($advance - $payed);
	}

    public function get_patient_advance($patient_id,$advance_id)
	{
		return $this->db->select('sum(amount) as total_advance')
			->from('tbl_advance')
			->join('tbl_patients', 'tbl_patients.patient_id = tbl_advance.patient_id')
			->where('tbl_patients.patient_id', $patient_id)
            ->where('tbl_advance.advance_id !=', $advance_id)
			->group_by('tbl_patients.patient_id')
			->get()
			->row()->total_advance;
	}

	public function get_payed_by_advance($patient_id)
	{
		return $this->db->select('IFNULL((sum(total)-sum(discount)),0) as total_applied_advances')
			->from('tbl_patient_payment')
			->join('tbl_patients', 'tbl_patients.patient_id = tbl_patient_payment.patient_id')
			->where('tbl_patients.patient_id', $patient_id)
			->where('tbl_patient_payment.pay_type', 5)
			->group_by('tbl_patients.patient_id')
			->get()
			->row()->total_applied_advances;
	}


    public function get_receipt_advance_details($patient_id)
	{
		$this->db->select('*,tbl_advance.advance_id as advance_no')
			->from('tbl_advance')
			->join('tbl_patients', 'tbl_patients.patient_id = tbl_advance.patient_id')
			->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_advance.pay_type','left');

			$this->db->where('tbl_patients.patient_id', $patient_id);

		return $this->db->get()->row();
	}

    public function get_receipt_advance($advance_id)
	{
		$this->db->select('*,tbl_advance.advance_id as advance_no')
			->from('tbl_advance')
			->join('tbl_patients', 'tbl_patients.patient_id = tbl_advance.patient_id')
			->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_advance.pay_type','left')
			->join('tbl_users', 'tbl_advance.user_id = tbl_users.user_id','left');

			$this->db->where('tbl_advance.advance_id', $advance_id);

		return $this->db->get()->row();
	}

    public function get_receipt_refund($refund_id){
        $this->db->select('*,tbl_refund.total as refund_amount')
        ->from('tbl_refund')
        ->join('tbl_patients', 'tbl_patients.patient_id = tbl_refund.patient_id')
        ->join('tbl_treatment_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_refund.treatment_payment_id','left')
        ->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_refund.pay_type','left')
        ->join('tbl_users', 'tbl_refund.user_id = tbl_users.user_Id','left');

        $this->db->where('tbl_refund.id', $refund_id);

        return $this->db->get()->row();
    }

    public function getRefundInvoice($nameStartsWith)
    {

        $subquery = $this->db->select('sum(cash)+sum(card)+sum(insurance_amount)')->from('tbl_patient_payment')->where('tbl_patient_payment.treatment_payment_id=tbl_treatment_payment.treatement_payment_id', NULL, FALSE)->get_compiled_select();

        $subquery_adv = $this->db->select('sum(amount)')->from('tbl_refund')->where('tbl_refund.treatment_payment_id=tbl_treatment_payment.treatement_payment_id', NULL, FALSE)->get_compiled_select();

        $this->db->select("*,IFNULL(({$subquery}),0) - IFNULL(({$subquery_adv}),0) as total_pay", FALSE);
        $this->db->select(",IFNULL(({$subquery}),0) as paid_total", FALSE);
        
        $this->db->from('tbl_treatment_payment');
        $this->db->join('tbl_patients', 'tbl_patients.patient_id = tbl_treatment_payment.patient_id');
        $this->db->where('tbl_treatment_payment.treatement_payment_id', strtoupper($nameStartsWith));

        $this->db->order_by('tbl_patients.patient_id', 'ASC');
       

        return $this->db->get()->row();

    }
     public function paid_amount($id)
	{
		$query = $this->db->query("SELECT *	FROM tbl_patient_payment WHERE patient_payment_id = '$id'");
			if($query->num_rows() > 0)
			{
				return $query->result_array();
			}else{
				return FALSE;
			}
	}
  
    public function employee_name($id)
	{
		$query = $this->db->query("SELECT *  from tbl_users WHERE user_Id = '$id'");
			if($query->num_rows() > 0)
			{
				return $query->row()->full_name;
			}else{
				return FALSE;
			}
	}

    // public function reciept_treatment($t_pid)
	// {

	// 	$query = $this->db->query("SELECT episode_type FROM tbl_episode_payment WHERE treatement_payment_id = '$t_pid' GROUP BY episode_type");
			
	// 		if($query->num_rows() > 0)
	// 		{
	// 			if ($query->row()->episode_type == 0) {
	// 				$query = $this->db->query("SELECT *FROM tbl_episode_payment LEFT JOIN procedure_list ON episode_payment.procedure_id = procedure_list.procedure_id WHERE treatement_payment_id = '$t_pid'");
	// 				return $query->result_array();
	// 			}else{

	// 				$query = $this->db->query("SELECT *FROM episode_payment LEFT JOIN p_treatment_price ON p_treatment_price.p_treatment_id = episode_payment.procedure_id LEFT JOIN diagnostise ON episode_payment.diagnostise_id = diagnostise.diagnostise_id WHERE treatement_payment_id = '$t_pid'");
	// 				//$query = $this->db->query("SELECT *FROM episode_payment LEFT JOIN procedure_list ON episode_payment.procedure_id = procedure_list.procedure_id WHERE treatement_payment_id = '$t_pid'");
					
	// 				return $query->result_array();
	// 			}
				
	// 		} else{
	// 			return FALSE;
	// 		}
	// }

    public function reciept_treatment_date_time($t_pid)
	{
		$query = $this->db->query("SELECT *FROM tbl_treatment_payment LEFT JOIN tbl_treatment_log ON tbl_treatment_payment.log_id = tbl_treatment_log.log_id WHERE tbl_treatment_payment.treatement_payment_id = '$t_pid'");
		if($query->num_rows() > 0)
			{
				return $query->result_array(); 
			}else{
				return FALSE;
			}
	}
    public function patient_info($p_id)
	{
		$query = $this->db->query("SELECT *FROM tbl_patients  WHERE tbl_patients.patient_id = '$p_id' ORDER BY patient_id DESC LIMIT 1");
		if($query->num_rows() > 0)
			{
				return $query->result_array();
			}else{
				return FALSE;
			}
	}

    public function get_payment($patient_payment_id){
        
        return $this->db->select('*')
        ->from('tbl_patient_payment')
        ->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_patient_payment.pay_type','left')
        ->where('patient_payment_id', $patient_payment_id)
        ->get()
        ->row();
    }




}

?>