<?php

class ReportsModel extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }


    /**
     * Doctor Reports Queries start
     */

    public function all_doctors()
    {
        return  $this->db->select('tbl_users.*')
            ->from('tbl_employees')
            ->join('tbl_users', 'tbl_employees.user_id = tbl_users.user_id', 'left')
            ->where('employee_type', 1)
            ->where('tbl_users.deleted', 0)
            ->get()
            ->result();
    }

    public function payment_types()
    {
        return $this->db->select('tbl_payment_types.*')
            ->from('tbl_payment_types')
            ->get()
            ->result();
    }

    public function refund_types()
    {
        return $this->db->select('tbl_refund_types.*')
            ->from('tbl_refund_types')
            ->get()
            ->result();
    }

    public function all_insurance_types()
    {
        return $this->db->select('tbl_insurance_types.*')
            ->from('tbl_insurance_types')
            ->get()
            ->result();
    }

    public function get_doctor_list($doctor = null, $payment_type = null, $date_from = null, $date_to = null, $length, $start)
    {

        $this->db->select('tbl_users.full_name, tbl_treatment_payment.*, tbl_patients.patient_name, IFNULL(tbl_payment_types.type_name,"N/A") as type_name,IFNULL(tbl_patient_payment.cash, 0) as amount,IFNULL(tbl_patient_payment.discount, 0) as cdiscount,IFNULL(tbl_patient_payment.company_discount, 0) as company_discount,IFNULL(tbl_patient_payment.category_discount, 0) as category_discount,IFNULL(tbl_patient_payment.points_discount, 0) as discount_cashier');
        $this->db->from('tbl_employees');
        $this->db->join('tbl_users', 'tbl_employees.user_id = tbl_users.user_Id', 'left');
        $this->db->join('tbl_treatment_payment', 'tbl_employees.user_id = tbl_treatment_payment.user_id', 'inner');
        $this->db->join('tbl_patients', 'tbl_treatment_payment.patient_id = tbl_patients.patient_id', 'left');

        $this->db->join('tbl_patient_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_patient_payment.treatment_payment_id', 'left');
        $this->db->join('tbl_payment_types', 'tbl_patient_payment.pay_type = tbl_payment_types.type_id', 'left');

        if ($length > 0) {
            $this->db->limit($length, $start);
        }

        if ((int)$doctor) {
            $this->db->group_start();
            $this->db->where('tbl_users.user_Id', (int)$doctor);
            $this->db->group_end();
        }

        if ((int)$payment_type) {
            $this->db->where('tbl_patient_payment.pay_type', $payment_type);
        }

        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("tbl_treatment_payment.treat_date BETWEEN '{$date_from}' AND '{$date_to}'");
        }

        $this->db->where('tbl_treatment_payment.deleted', 0);
        $this->db->where('tbl_users.deleted', 0);

        $this->db->order_by('treat_date', 'DESC');
        return $this->db->get()->result();
    }


    public function get_total_doctors()
    {
        $this->db->where('employee_type', 1);
        return $this->db->count_all('tbl_employees');
    }

    /**
     * Doctor Report Queries end
     */

    /**
     * Appoinment Report Queries start
     */

    public function get_all_booking_status()
    {
        return $this->db->select('*')->from('booking_status')->get()->result();
    }

    public function get_appoinment_list($status = null, $date_from = null, $date_to = null, $length, $start)
    {

        // $this->db->select('tbl_appointment.appointment_date,tbl_appointment.appointment_time, tbl_appointment_patient_info.app_patient_id, tbl_appointment_patient_info.app_patient_name,tbl_appointment_patient_info.app_patient_contact, tbl_users.full_name as doctor, tbl_users.full_name as user');
        // $this->db->from('tbl_appointment');
        // $this->db->join('tbl_appointment_patient_info', 'tbl_appointment.app_info_id = tbl_appointment_patient_info.app_patient_id', 'left');
        // $this->db->join('tbl_users', 'tbl_appointment.doctor_id = tbl_users.user_Id', 'left');
        // $this->db->join('tbl_users', 'tbl_appointment.user_id = tbl_users.user_Id', 'left');

        $this->db->select('tbl_appointment.appointment_date, tbl_appointment.appointment_time,tbl_appointment.appointment_etime, tbl_appointment_patient_info.app_patient_id,
         TIMEDIFF(tbl_appointment.appointment_etime, tbl_appointment.appointment_time) as appointment_duration, tbl_appointment_patient_info.app_patient_name, tbl_appointment_patient_info.app_patient_contact,tbl_appointment_patient_info.now_waiting,booking_status.status_name, doctor.full_name as doctor_name, user.full_name as user_name');
        $this->db->from('tbl_appointment');
        $this->db->join('tbl_appointment_patient_info', 'tbl_appointment.app_info_id = tbl_appointment_patient_info.app_patient_id', 'left');
        $this->db->join('tbl_users as doctor', 'tbl_appointment.doctor_id = doctor.user_Id', 'left');
        $this->db->join('booking_status as booking_status', 'tbl_appointment_patient_info.now_waiting = booking_status.status_id', 'left');
        $this->db->join('tbl_users as user', 'tbl_appointment.user_id = user.user_Id', 'left');

        // if ($length > 0) {
        //     $this->db->limit($length, $start);
        // }

        if ((int)$status) {
            $this->db->group_start();
            $this->db->where('tbl_appointment_patient_info.now_waiting', (int)$status);
            $this->db->group_end();
        }

        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("tbl_appointment.appointment_date BETWEEN '{$date_from}' AND '{$date_to}'");
        }

        $this->db->where('tbl_appointment.deleted', 0);

        return $this->db->get()->result();
    }
    public function get_appoinment_list_count($status = null, $date_from = null, $date_to = null)
    {

        // $this->db->select('tbl_appointment.appointment_date,tbl_appointment.appointment_time, tbl_appointment_patient_info.app_patient_id, tbl_appointment_patient_info.app_patient_name,tbl_appointment_patient_info.app_patient_contact, tbl_users.full_name as doctor, tbl_users.full_name as user');
        // $this->db->from('tbl_appointment');
        // $this->db->join('tbl_appointment_patient_info', 'tbl_appointment.app_info_id = tbl_appointment_patient_info.app_patient_id', 'left');
        // $this->db->join('tbl_users', 'tbl_appointment.doctor_id = tbl_users.user_Id', 'left');
        // $this->db->join('tbl_users', 'tbl_appointment.user_id = tbl_users.user_Id', 'left');

        $this->db->select('tbl_appointment.appointment_date, tbl_appointment.appointment_time,tbl_appointment.appointment_etime, tbl_appointment_patient_info.app_patient_id,
         TIMEDIFF(tbl_appointment.appointment_etime, tbl_appointment.appointment_time) as appointment_duration, tbl_appointment_patient_info.app_patient_name, tbl_appointment_patient_info.app_patient_contact,tbl_appointment_patient_info.now_waiting,booking_status.status_name, doctor.full_name as doctor_name, user.full_name as user_name');
        $this->db->from('tbl_appointment');
        $this->db->join('tbl_appointment_patient_info', 'tbl_appointment.app_info_id = tbl_appointment_patient_info.app_patient_id', 'left');
        $this->db->join('tbl_users as doctor', 'tbl_appointment.doctor_id = doctor.user_Id', 'left');
        $this->db->join('booking_status as booking_status', 'tbl_appointment_patient_info.now_waiting = booking_status.status_id', 'left');
        $this->db->join('tbl_users as user', 'tbl_appointment.user_id = user.user_Id', 'left');

       

        if ((int)$status) {
            $this->db->group_start();
            $this->db->where('tbl_appointment_patient_info.now_waiting', (int)$status);
            $this->db->group_end();
        }

        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("tbl_appointment.appointment_date BETWEEN '{$date_from}' AND '{$date_to}'");
        }

        $this->db->where('tbl_appointment.deleted', 0);

        return $this->db->get()->result();
    }
    

    public function get_insurance_list($insurace_type = null, $payment_type = null, $date_from = null, $date_to = null, $length, $start)
    {

        $subquery = $this->db->select('sum(cash)+sum(card)+sum(insurance_amount)')->from('tbl_patient_payment')->where('tbl_patient_payment.treatment_payment_id=tbl_treatment_payment.treatement_payment_id', NULL, FALSE)->get_compiled_select();

        $this->db->select("*,({$subquery}) as total_pay", FALSE);
        $this->db->from('tbl_patient_payment');
        $this->db->join('tbl_treatment_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_patient_payment.treatment_payment_id', 'left');
        $this->db->join('tbl_insurance_types', 'tbl_insurance_types.insurance_type_id = tbl_treatment_payment.insurance_type', 'left');
        $this->db->join('tbl_patients', 'tbl_patients.patient_id = tbl_treatment_payment.patient_id', 'left');
        $this->db->join('tbl_users', 'tbl_treatment_payment.user_id = tbl_users.user_Id', 'left');
        $this->db->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_patient_payment.pay_type', 'left');
        $this->db->join('(SELECT treatement_payment_id, GROUP_CONCAT(treatment_name SEPARATOR "<br>") AS procedure_ids FROM tbl_episode_payment LEFT JOIN tbl_insurance_prices ON tbl_episode_payment.procedure_id = tbl_insurance_prices.id GROUP BY treatement_payment_id) AS tbl_episode_payment', 'tbl_patient_payment.treatment_payment_id = tbl_episode_payment.treatement_payment_id', 'left');

        if ($length > 0) {
            $this->db->limit($length, $start);
        }

        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("tbl_treatment_payment.treat_date BETWEEN '{$date_from}' AND '{$date_to}'");
        }

        if (!empty($payment_type)) {
            $this->db->where('tbl_patient_payment.pay_type', $payment_type);
        }

        if ($insurace_type > 0) {
            $this->db->where("tbl_treatment_payment.insurance_type = '{$insurace_type}'");
        }

        $this->db->where('tbl_treatment_payment.deleted', 0);

        return $this->db->get()->result();
    }

    public function get_sales_list($insurace_type = null, $payment_type = null, $date_from = null, $date_to = null, $length, $start)
    {

        // $subquery = $this->db->select('sum(cash)+sum(insurance_amount)')->from('tbl_patient_payment')->where('tbl_patient_payment.treatment_payment_id=tbl_treatment_payment.treatement_payment_id', NULL, FALSE)->get_compiled_select();
        // $subquery_type = $this->db->select('GROUP_CONCAT(tbl_payment_types.type_name SEPARATOR " & ") AS payment_types');
        //     ->from('tbl_patient_payment')
        //     ->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_patient_payment.pay_type', 'left');
        //     ->where('tbl_patient_payment.patient_payment_id=tbl_patient_payment.patient_payment_id', NULL, FALSE)
        //     ->group_by('tbl_treatment_payment.treatement_payment_id')
        //     ->get_compiled_select();

        // $this->db->select("*,({$subquery}) as total_pay", FALSE);
        $this->db->select("tbl_treatment_payment.discount,
        tbl_patient_payment.discount,  
            tbl_treatment_payment.discount, 
            tbl_patient_payment.company_discount,
            tbl_patient_payment.category_discount,
            tbl_patient_payment.points_discount,
            tbl_treatment_payment.treatement_payment_id,
            tbl_treatment_payment.patient_id,
             tbl_patients.patient_name,
             tbl_patient_payment.pay_type,
             tbl_episode_payment.procedure_ids,
              tbl_treatment_payment.treat_date
            ", FALSE);
        $this->db->select("GROUP_CONCAT(tbl_payment_types.type_name SEPARATOR ' & ') AS payment_type", FALSE);
        $this->db->select("IFNULL(GROUP_CONCAT(tbl_patient_payment.patient_payment_id SEPARATOR ' , '),'N/A') AS patient_payment_ids", FALSE);
        $this->db->select("IFNULL(tbl_patient_payment.patient_payment_id,'N/A') as patient_payment_id", FALSE);
        $this->db->select("IFNULL(((tbl_treatment_payment.total)),0) as invoice_amount", FALSE);
        $this->db->select("
        IFNULL((
            SUM(IFNULL(tbl_patient_payment.discount, 0)) + 
            (IFNULL(tbl_treatment_payment.discount, 0)) + 
            SUM(IFNULL(tbl_patient_payment.company_discount, 0)) + 
            SUM(IFNULL(tbl_patient_payment.category_discount, 0)) + 
            SUM(IFNULL(tbl_patient_payment.points_discount, 0))
        ), 0) as all_discount", FALSE);
        $this->db->select("IFNULL((SUM(tbl_patient_payment.cash) + SUM(tbl_patient_payment.insurance_amount)),0) as paid_amount", FALSE);
        $this->db->from('tbl_treatment_payment');
        $this->db->join('tbl_patient_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_patient_payment.treatment_payment_id', 'left');
        $this->db->join('tbl_insurance_types', 'tbl_insurance_types.insurance_type_id = tbl_treatment_payment.insurance_type', 'left');
        // $this->db->join('tbl_insurance_types', 'tbl_insurance_types.insurance_type_id = tbl_treatment_payment.insurance_type', 'left');
        $this->db->join('tbl_patients', 'tbl_patients.patient_id = tbl_treatment_payment.patient_id', 'left');
        $this->db->join('tbl_users', 'tbl_treatment_payment.user_id = tbl_users.user_Id', 'left');
        $this->db->join('tbl_payment_types', 'tbl_payment_types.type_id = tbl_patient_payment.pay_type', 'left');
        $this->db->join('(SELECT treatement_payment_id, GROUP_CONCAT(treatment_name SEPARATOR "<br>") AS procedure_ids FROM tbl_episode_payment LEFT JOIN tbl_insurance_prices ON tbl_episode_payment.procedure_id = tbl_insurance_prices.id GROUP BY treatement_payment_id) AS tbl_episode_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_episode_payment.treatement_payment_id', 'left');

        // if ($length > 0) {
        //     $this->db->limit($length, $start);
        // }

        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("tbl_treatment_payment.treat_date BETWEEN '{$date_from}' AND '{$date_to}'");
        }

        if ($payment_type > -1) {
            $this->db->where('tbl_patient_payment.pay_type', $payment_type);
        }

        if ($insurace_type > 0) {
            $this->db->where("tbl_treatment_payment.insurance_type = '{$insurace_type}'");
        }

        $this->db->where('tbl_treatment_payment.deleted', 0);
        $this->db->group_by('tbl_treatment_payment.treatement_payment_id');

        return $this->db->get()->result();
    }

    public function get_refund_list($receptionist = null, $date = null, $length, $start)
    {

        $this->db->select('re.*, re.id as recipt_no, p.patient_name, pt.type_name, tp.patient_id as patient_id, tp.treatement_payment_id as treatment_no, m.module_name, us.full_name, it.insurance_name,tbl_episode_payment_alias.procedure_ids');
        $this->db->select(',(select full_name from tbl_users where tbl_users.user_Id = re.user_id) as cashier', false);
        $this->db->from('tbl_treatment_payment tp');
        $this->db->join('tbl_patient_payment pp', 'tp.treatement_payment_id = pp.treatment_payment_id', 'left');
        $this->db->join('tbl_refund re', 're.treatment_payment_id = tp.treatement_payment_id');
        $this->db->join('tbl_modules m', 'tp.department_id = m.module_id', 'left');
        $this->db->join('tbl_insurance_types it', 'tp.insurance_type = it.insurance_type_id', 'left');
        $this->db->join('tbl_patients p', 'p.patient_id = tp.patient_id', 'left');
        $this->db->join('tbl_payment_types pt', 'pt.type_id = re.pay_type', 'left');
        $this->db->join('tbl_users us', 'us.user_Id = tp.user_Id', 'left');
        $this->db->join('(SELECT treatement_payment_id, GROUP_CONCAT(treatment_name SEPARATOR "<br>") AS procedure_ids FROM tbl_episode_payment LEFT JOIN tbl_insurance_prices ON tbl_episode_payment.procedure_id = tbl_insurance_prices.id GROUP BY treatement_payment_id) AS tbl_episode_payment_alias', 'tp.treatement_payment_id = tbl_episode_payment_alias.treatement_payment_id', 'left');



        // $this->db->order_by($order_column, $order);
        // return $this->db->get()->result();


        // if ($length > 0) {
        //     $this->db->limit($length, $start);
        // }

        if (!empty($date)) {
            $this->db->where("pp.pay_date = '{$date}'");
        }

        if (!empty($receptionist)) {
            $this->db->where("pp.user_Id = " . $receptionist);
        }

        $this->db->group_by('re.id');
        // $this->db->where("tbl_treatment_payment.insurance_type = 0");
        return $this->db->get()->result();
    }

    public function get_refund_list_report($receptionist = null, $date = null, $length, $start, $end)
    {

        $this->db->select('re.*, re.id as recipt_no, p.patient_name, pt.type_name, tp.patient_id as patient_id, tp.treatement_payment_id as treatment_no, m.module_name, us.full_name, it.insurance_name,tbl_episode_payment_alias.procedure_ids,tp.treat_date');
        $this->db->select(',(select full_name from tbl_users where tbl_users.user_Id = re.user_id) as cashier', false);
        $this->db->from('tbl_treatment_payment tp');
        $this->db->join('tbl_refund re', 're.treatment_payment_id = tp.treatement_payment_id');
        $this->db->join('tbl_modules m', 'tp.department_id = m.module_id', 'left');
        $this->db->join('tbl_insurance_types it', 'tp.insurance_type = it.insurance_type_id', 'left');
        $this->db->join('tbl_patients p', 'p.patient_id = tp.patient_id', 'left');
        $this->db->join('tbl_payment_types pt', 'pt.type_id = re.pay_type', 'left');
        $this->db->join('tbl_users us', 'us.user_Id = tp.user_Id', 'left');
        $this->db->join('(SELECT treatement_payment_id, GROUP_CONCAT(treatment_name SEPARATOR "<br>") AS procedure_ids FROM tbl_episode_payment LEFT JOIN tbl_insurance_prices ON tbl_episode_payment.procedure_id = tbl_insurance_prices.id GROUP BY treatement_payment_id) AS tbl_episode_payment_alias', 'tp.treatement_payment_id = tbl_episode_payment_alias.treatement_payment_id', 'left');



        // $this->db->order_by($order_column, $order);
        // return $this->db->get()->result();


        // if ($length > 0) {
        //     $this->db->limit($length, $start);
        // }

        if (!empty($start) && !empty($end)) {
            $this->db->where("re.pay_date BETWEEN '{$start}' AND '{$end}'");
        }

        if (!empty($receptionist)) {
            $this->db->where("re.user_Id = " . $receptionist);
        }

        // $this->db->where("tbl_treatment_payment.insurance_type = 0");
        return $this->db->get()->result();
    }

    public function get_total_appoinments()
    {
        $this->db->where('deleted', 0);
        return $this->db->count_all('tbl_appointment');
    }
    /**
     * Appoinment Report Queries end
     */


    /**
     * Daily Collection Report Queries start
     */
   public function get_daily_collection_list($receptionist = null, $date = null, $date_to = null, $length = 0, $start = 0, $doctor = null, $payment_type = null)
{
    $this->db->select('
        pp.*, 
        pp.patient_payment_id AS recipt_no,
        pp.discount AS cdiscount,
        pp.treatment_payment_id,
        p.patient_name,
        pt.type_name,
        tp.discount,
        tp.total AS gross,
        tp.patient_id AS patient_id,
        tp.treatement_payment_id AS treatment_no,
        m.module_name,
        us.full_name,
        it.insurance_name,
        tbl_episode_payment_alias.procedure_ids
    ');

    // Cashier name query
    $this->db->select('(SELECT full_name FROM tbl_users WHERE tbl_users.user_Id = pp.user_id) AS cashier', false);

    // Individual record calculations for discount and cash
    $this->db->select("
        IFNULL(pp.discount, 0) + 
        IFNULL(tp.discount, 0) + 
        IFNULL(pp.company_discount, 0) + 
        IFNULL(pp.category_discount, 0) + 
        IFNULL(pp.points_discount, 0) AS all_discount", false);

    $this->db->select("IFNULL(pp.cash, 0) AS total_paid", false);

    // Join statements
    $this->db->from('tbl_patient_payment pp');
    $this->db->join('tbl_treatment_payment tp', 'tp.treatement_payment_id = pp.treatment_payment_id', 'left');
    $this->db->join('tbl_modules m', 'tp.department_id = m.module_id', 'left');
    $this->db->join('tbl_insurance_types it', 'tp.insurance_type = it.insurance_type_id', 'left');
    $this->db->join('tbl_patients p', 'p.patient_id = tp.patient_id', 'left');
    $this->db->join('tbl_payment_types pt', 'pt.type_id = pp.pay_type', 'left');
    $this->db->join('tbl_users us', 'us.user_Id = tp.user_Id', 'left');
    $this->db->join('(SELECT treatement_payment_id, GROUP_CONCAT(treatment_name SEPARATOR "<br>") AS procedure_ids FROM tbl_episode_payment LEFT JOIN tbl_insurance_prices ON tbl_episode_payment.procedure_id = tbl_insurance_prices.id GROUP BY treatement_payment_id) AS tbl_episode_payment_alias', 'pp.treatment_payment_id = tbl_episode_payment_alias.treatement_payment_id', 'left');

    // Date range filter
    if(check_right('daily_collection_range',$this)){
        if (!empty($date && $date_to)) {
            $this->db->where("pp.pay_date BETWEEN '{$date}' AND '{$date_to}'");
        }
    }else{
        if (!empty($date)) {
            $this->db->where("pp.pay_date='{$date}'");
        }
    }
    // Receptionist filter
    if (!empty($receptionist)) {
        $this->db->where("pp.user_Id", $receptionist);
    }
    
    if (!empty($doctor)) {
        $this->db->where("tp.user_id", $doctor);
    }
    
    if (!empty($payment_type)) {
        $this->db->where("pt.type_id", $payment_type);
    }

    // Pagination
    // if ($length > 0) {
    //     $this->db->limit($length, $start);
    // }

    // Execute and return result
    return $this->db->get()->result();
}


    public function get_sales_persons()
    {
                return $this->db->select('tbl_users.full_name, tbl_users.user_Id')
            ->from('tbl_patient_payment')
            ->join('tbl_users', 'tbl_patient_payment.user_id = tbl_users.user_id')
            ->group_by('tbl_patient_payment.user_id')
            ->get()
            ->result();
    }

    /**
     * Daily Collection Report Queries end
     */


    /**
     * Treatment Wise Report Queries start
     */

    public function get_insurance_price_list($insurance_id, $department_id)
    {
            $this->db->select('*');
            $this->db->from('tbl_insurance_prices');
            $this->db->where('insurance_type_id', (int)$insurance_id);
            if($department_id>0){
            $this->db->where('treatment_category', (int)$department_id);
            }
            $query= $this->db->get();
       return    $query->result();
    }

    public function get_treatment_wise_report($insurance_id, $prodecure, $payment_type, $date_from, $date_to, $length, $start, $order_column, $order, $department_id)
    {
        $this->db->select('tbl_treatment_payment.treatement_payment_id, tbl_patients.patient_name,tbl_episode_payment.quantity,tbl_episode_payment.orig_price,tbl_episode_payment.discount_qr,tbl_episode_payment.fees, tbl_treatment_payment.treat_date,GROUP_CONCAT(tbl_insurance_prices.treatment_name) as treatment_names, 
        GROUP_CONCAT(tbl_insurance_prices.treatment_id) as insurance_price_ids, 
        GROUP_CONCAT(tbl_insurance_prices.treatment_name_ar) as treatment_names_ar, tbl_treatment_payment.total, tbl_users.user_name as doctor, tbl_modules.module_name as department_name')
            ->from('tbl_treatment_payment')
            ->join('tbl_episode_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_episode_payment.treatement_payment_id', 'left')
            ->join('tbl_patients', 'tbl_treatment_payment.patient_id = tbl_patients.patient_id', 'left')
            ->join('tbl_insurance_prices', 'tbl_episode_payment.procedure_id = tbl_insurance_prices.id', 'left')
           
            ->join('tbl_users', 'tbl_treatment_payment.user_id = tbl_users.user_Id', 'left')
            ->join('tbl_modules', 'tbl_treatment_payment.department_id = tbl_modules.department_id');

        if ($insurance_id > 0) {
           
            $this->db->where('tbl_treatment_payment.insurance_type', $insurance_id);
        }

        if (!empty($prodecure)) {
            $this->db->where('tbl_episode_payment.procedure_id', $prodecure);
        }

        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("tbl_treatment_payment.treat_date BETWEEN '$date_from' AND '$date_to'");
        }

        // if ($length > 0) {
        //     $this->db->limit($length, $start);
        // }

        if (!empty($department_id)) {
            $this->db->where('tbl_treatment_payment.department_id', $department_id);
        }
        // ->group_by('tbl_episode_payment.procedure_id')
        // ->group_by('tbl_patient_payment.pay_type');

        $this->db->group_by('tbl_treatment_payment.treatement_payment_id');
         
        $this->db->order_by($order_column, $order);

        //echo $this->db->get_compiled_select();exit;

        return $this->db->get()->result();
    }

 public function count_total_treatment_wise_records($insurance_id, $prodecure, $payment_type, $date_from, $date_to, $department_id)
    {
        $this->db->select('COUNT(DISTINCT tbl_treatment_payment.treatement_payment_id) AS total_records')
            ->from('tbl_treatment_payment')
            ->join('tbl_episode_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_episode_payment.treatement_payment_id', 'left')
            ->join('tbl_patients', 'tbl_treatment_payment.patient_id = tbl_patients.patient_id', 'left')
            ->join('tbl_insurance_prices', 'tbl_episode_payment.procedure_id = tbl_insurance_prices.id', 'left')
         
            
            ->join('tbl_users', 'tbl_treatment_payment.user_id = tbl_users.user_Id', 'left');

        if (!empty($insurance_id)) {
            $this->db->where('tbl_treatment_payment.insurance_type', $insurance_id);
        }

        if (!empty($prodecure)) {
            $this->db->where('tbl_episode_payment.procedure_id', $prodecure);
        }

       

        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("tbl_treatment_payment.treat_date BETWEEN '$date_from' AND '$date_to'");
        }

        // $this->db->group_by('tbl_treatment_payment.insurance_type')
        //     ->group_by('tbl_episode_payment.procedure_id');

        if (!empty($department_id)) {
            $this->db->where('tbl_treatment_payment.department_id', $department_id);
        }

        return $this->db->get()->row()->total_records ?? 0;
    }

    public function get_departments()
    {
        return $this->db->select('*')->from('tbl_modules')->where('department_id > 0')->get()->result();
    }

    /**
     * Treatment Wise Report Queries end
     */

    public function get_feedback_list($from, $to, $patient_id, $doctor_id)
    {

        $this->db->select('*');
        $this->db->from('tbl_patient_feedback');
        $this->db->join('tbl_patients', 'tbl_patient_feedback.patient_id = tbl_patients.patient_id', 'left');
        if (!empty($patient_id)) {
            $this->db->where('tbl_patient_feedback.curr_date >=', $from);
        }
        if (!empty($to)) {
            $this->db->where('tbl_patient_feedback.curr_date <=', $to);
        }
        if (!empty($patient_id)) {
            $this->db->where('tbl_patients.patient_id', $patient_id);
        }
        if (!empty($doctor_id)) {
            $this->db->where('tbl_patient_feedback.assign', $doctor_id);
        }
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    /**
     * SMS Report
     */

    public function getNotificationList($from, $to, $status, $type, $length, $start)
    {
        if(empty($from ) || empty($to) || empty($status) || empty($type)) {
            return false;
        }

        $this->db
        ->select('*')
        ->from('tbl_notifications')
        ->where("DATE(created_at) BETWEEN '$from' AND '$to'")
        ->where('status', $status)
        ->where('type', $type);

        if ($length > 0) {
            $this->db->limit($length, $start);
        }

        $this->db->order_by('id DESC');

        return $this->db->get()->result();
        // echo $this->db->last_query();
        // exit;
    }

    public function getTotalNotification($type, $status)
    {
        return $this->db->select('COUNT(id) as count')
        ->from('tbl_notifications')
        ->where('type', $type)
        ->where('status', $status)
        ->get()->row();
    }
    

    public function get_p_expiring_report($from,$to,$opt,$drug)
	{
       
		if($opt == -1){
            $this->db->select('*');
            $this->db->from('sh_receive_bill_items');
            $this->db->join('sh_bill', 'sh_bill.bill_id = sh_receive_bill_items.bill_id', 'left');
            $this->db->join('sh_supplier', 'sh_supplier.supplier_id = sh_bill.supplier_id', 'left');
            $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_receive_bill_items.item_id', 'left');
           
            if (!empty($from)) {
                $this->db->where('x_date >=', $from);
            }
            if (!empty($to)) {
                $this->db->where('x_date <=', $to);
            }
            if (!empty($drug) && $drug != -1) {
                $this->db->where('sh_receive_bill_items.item_id =', $drug);
            }
            $this->db->order_by('bill_items_id', 'DESC');
        
            $query = $this->db->get();
            return $query->result();
		}else{
		
				$this->db->select('*');
                $this->db->from('sh_receive_bill_items');
                $this->db->join('sh_bill', 'sh_bill.bill_id = sh_receive_bill_items.bill_id', 'left');
                $this->db->join('sh_supplier', 'sh_supplier.supplier_id = sh_bill.supplier_id', 'left');
                $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_receive_bill_items.item_id', 'left');
               
                if (!empty($from)) {
                    $this->db->where('x_date >=', $from);
                }
                if (!empty($to)) {
                    $this->db->where('x_date <=', $to);
                }
                if (!empty($to)) {
                    $this->db->where('sh_bill.supplier_id =', $opt);
                }
                
            
                $this->db->order_by('bill_items_id', 'DESC');
            
                $query = $this->db->get();
                return $query->result();

		}
	}

    public function get_items_list($id,$from,$to)
	{
      
		if($id == -1){

            $this->db->select('sh_receive_bill_items.*, sh_bill.*, sh_drugs.*, sh_receive_bill_items.quantity as receive_quantity');
            $this->db->from('sh_receive_bill_items');
            $this->db->join('sh_bill', 'sh_bill.bill_id = sh_receive_bill_items.bill_id', 'left');
            $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_receive_bill_items.item_id', 'left');
            
        
            if (!empty($from)) {
                $this->db->where('bill_date >=', $from);
            }
            if (!empty($to)) {
                $this->db->where('bill_date <=', $to);
            }
        
            $query = $this->db->get();
            return $query->result();

		}else{

            $this->db->select('sh_receive_bill_items.*, sh_bill.*, sh_drugs.*, sh_receive_bill_items.quantity as receive_quantity');
                $this->db->from('sh_receive_bill_items');
                $this->db->join('sh_bill', 'sh_bill.bill_id = sh_receive_bill_items.bill_id', 'left');
                $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_receive_bill_items.item_id', 'left');
            
                if (!empty($from)) {
                    $this->db->where('bill_date >=', $from);
                }
                if (!empty($to)) {
                    $this->db->where('bill_date <=', $to);
                }

                if (!empty($id)) {
                    $this->db->where('item_id =', $id);
                }
               

                $query = $this->db->get();
                return $query->result();
    

              

		}
		
	}
    public function get_transaction_list($request,$from,$to)
	{
		if($request == 2){
		
            $this->db->select('*');
            $this->db->from('sh_sell_bill');
            $this->db->join('tbl_users', 'tbl_users.user_id = sh_sell_bill.user_id', 'left');
            $this->db->join('tbl_employees', 'tbl_employees.user_id = tbl_users.user_id', 'left');

            if (!empty($from)) {
                $this->db->where('sell_date >=', $from);
            }
            if (!empty($to)) {
                $this->db->where('sell_date <=', $to);
            }

            $this->db->order_by('sell_bill_id', 'DESC');

            $query = $this->db->get();
            return $query->result();




		}else{
            
            $this->db->select('*');
            $this->db->from('sh_sell_bill');
            $this->db->join('tbl_users', 'tbl_users.user_id = sh_sell_bill.user_id', 'left');
            $this->db->join('tbl_employees', 'tbl_employees.user_id = tbl_users.user_id', 'left');

            if (!empty($from)) {
                $this->db->where('sell_date >=', $from);
            }
            if (!empty($to)) {
                $this->db->where('sell_date <=', $to);
            }
            if (!empty($request)) {
                $this->db->where('type =', $request);
            }

            $this->db->order_by('sell_bill_id', 'DESC');

            $query = $this->db->get();
            return $query->result();
		}
	}

    public function get_view_reports($id,$from,$to,$drug,$cashier)
	{
		// if($id == -1){
            $this->db->select('*, sh_sell_bill_items.sell_price as sell_prices, (sh_sell_bill_items.qty * sh_sell_bill_items.sell_price) as total');
            $this->db->from('sh_sell_bill_items');
            $this->db->join('sh_sell_bill', 'sh_sell_bill.sell_bill_id = sh_sell_bill_items.sell_bill_id', 'left');
            $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_sell_bill_items.item_id', 'left');
            $this->db->join('sh_receive_bill_items', 'sh_receive_bill_items.bill_items_id = sh_sell_bill_items.r_bill', 'left');
            $this->db->join('sh_bill', 'sh_bill.bill_id = sh_receive_bill_items.bill_id', 'left');
            $this->db->join('sh_supplier', 'sh_supplier.supplier_id = sh_bill.supplier_id', 'left');
        
            if (!empty($from)) {
                $this->db->where('sell_date >=', $from);
            }
            if (!empty($to)) {
                $this->db->where('sell_date <=', $to);
            }
            if (!empty($drug) && $drug !=-1) {
                $this->db->where('sh_sell_bill_items.item_id =', $drug);
            }
            if (!empty($cashier && $cashier !=-1)) {
                $this->db->where('sh_sell_bill.user_id =', $cashier);
            }
            if (!empty($id) && $id !=-1) {
                $this->db->where('sh_bill.supplier_id =', $id);
            }
            $this->db->order_by('sh_sell_bill.sell_bill_id', 'DESC');
            $query = $this->db->get();
            return $query->result();

		// }else{

        //     $this->db->select('*, sh_sell_bill_items.sell_price as sell_prices, (sh_sell_bill_items.qty * sh_sell_bill_items.sell_price) as total');
        //     $this->db->from('sh_sell_bill_items');
        //     $this->db->join('sh_sell_bill', 'sh_sell_bill.sell_bill_id = sh_sell_bill_items.sell_bill_id', 'left');
        //     $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_sell_bill_items.item_id', 'left');
        //     $this->db->join('sh_receive_bill_items', 'sh_receive_bill_items.bill_items_id = sh_sell_bill_items.r_bill', 'left');
        //     $this->db->join('sh_bill', 'sh_bill.bill_id = sh_receive_bill_items.bill_id', 'left');
        //     $this->db->join('sh_supplier', 'sh_supplier.supplier_id = sh_bill.supplier_id', 'left');
        
        //     if (!empty($from)) {
        //         $this->db->where('sell_date >=', $from);
        //     }
        //     if (!empty($to)) {
        //         $this->db->where('sell_date <=', $to);
        //     }
           
        
        //     $this->db->order_by('sh_sell_bill.sell_bill_id', 'DESC');
        //     $query = $this->db->get();
        //     return $query->result();

		// }
		
	}
    public function get_drugs_sale($id,$from,$to)
	{
		if($id == -1){

            $this->db->select('*');
            $this->db->from('sh_sell_bill_items');
            $this->db->join('sh_sell_bill', 'sh_sell_bill.sell_bill_id = sh_sell_bill_items.sell_bill_id', 'left');
            $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_sell_bill_items.item_id', 'left');
        
            if (!empty($from)) {
                $this->db->where('sell_date >=', $from);
            }
            if (!empty($to)) {
                $this->db->where('sell_date <=', $to);
            }
        
            $query = $this->db->get();
            return $query->result_array();


		}else{

            $this->db->select('*');
            $this->db->from('sh_sell_bill_items');
            $this->db->join('sh_sell_bill', 'sh_sell_bill.sell_bill_id = sh_sell_bill_items.sell_bill_id', 'left');
            $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_sell_bill_items.item_id', 'left');
        
            if (!empty($from)) {
                $this->db->where('sell_date >=', $from);
            }
            if (!empty($to)) {
                $this->db->where('sell_date <=', $to);
            }
            if (!empty($id)) {
                $this->db->where('item_id =', $id);
            }
        
            $query = $this->db->get();
            return $query->result();

		}
		
	}

    public function get_view_profit_reports($id,$drug,$from,$to)
	{
	
        $this->db->select('*, sh_sell_bill_items.sell_price as sell_prices, sh_sell_bill.amount as amount');
        $this->db->from('sh_sell_bill_items');
        $this->db->join('sh_sell_bill', 'sh_sell_bill.sell_bill_id = sh_sell_bill_items.sell_bill_id', 'left');
        $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_sell_bill_items.item_id', 'left');
        $this->db->join('sh_receive_bill_items', 'sh_receive_bill_items.bill_items_id = sh_sell_bill_items.r_bill', 'left');
        $this->db->join('sh_bill', 'sh_bill.bill_id = sh_receive_bill_items.bill_id', 'left');
        $this->db->join('sh_supplier', 'sh_supplier.supplier_id = sh_bill.supplier_id', 'left');
 
        $this->db->order_by('sh_sell_bill.sell_bill_id', 'DESC');
        

        if (!empty($from)) {
            $this->db->where('sell_date >=', $from);
        }
        if (!empty($to)) {
            $this->db->where('sell_date <=', $to);
        }
        if (!empty($id) && $id != -1) {
            $this->db->where('sh_bill.supplier_id =', $id);
        }
        if (!empty($drug) && $drug != -1) {
            $this->db->where('sh_sell_bill_items.item_id =', $drug);
        }

        $query = $this->db->get();

        return $query->result_array();	
		
		
	}
    public function get_p_refund_report($from,$to,$timeFrom,$timeTo)
	{
		    $this->db->select('*');
            $this->db->from('sh_return_sale');
            $this->db->join('sh_return_sale_items', 'sh_return_sale_items.return_sale_id = sh_return_sale.return_sale_id', 'left');
            // $this->db->join('sh_supplier', 'sh_supplier.supplier_id = sh_bill.supplier_id', 'left');
            $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_return_sale_items.item_id', 'left');

            if (!empty($from)) {
                $this->db->where('return_date >=', $from);
            }
            if (!empty($to)) {
                $this->db->where('return_date <=', $to);
            }
            $query = $this->db->get();

        return $query->result_array();	
	}

    public function get_purchase_refund_report($from,$to)
	{
        $this->db->select('sh_return_stock.*, sh_return_stock_items.quantity, sh_return_stock_items.cost, sh_drugs.*, (sh_return_stock_items.quantity * sh_return_stock_items.cost) as total_cost');
        $this->db->from('sh_return_stock');
        $this->db->join('sh_return_stock_items', 'sh_return_stock_items.return_stock_id = sh_return_stock.return_stock_id', 'left');
        $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_return_stock_items.item_id', 'left');
        
			
			if (!empty($from)) {
                $this->db->where('return_date >=', $from);
            }
            if (!empty($to)) {
                $this->db->where('return_date <=', $to);
            }
            $query = $this->db->get();

        return $query->result_array();	
	}

    public function get_row_data($table, $filed_name, $filed_value)
	{

		$query = $this->db->query("SELECT * FROM $table WHERE $filed_name ='$filed_value'");
			
			if($query->num_rows() > 0)
			{
				return $query->row();				
			} else {
				return FALSE;
			}
	}


    public function get_items()
	{
		$query = $this->db->query("SELECT * FROM sh_drugs");
			
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			}else{
				return FALSE;
			}
	}

    public function get_payment_types()
	{
		$query = $this->db->query("SELECT * FROM tbl_payment_types");
			
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			}else{
				return FALSE;
			}
	}



   
    public function refund_pharma_cashier($from, $to)
	{
	
			$query = $this->db->query("SELECT * FROM sh_return_sale LEFT JOIN sh_return_sale_items ON sh_return_sale.return_sale_id = sh_return_sale_items.return_sale_id WHERE sh_return_sale.return_date BETWEEN '$from' AND '$to'");
	
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			} else {
				return FALSE;
			}
	}

    public function refund_pharma_cashier_wise($from, $to, $cashier, $request)
	{
		if($cashier == ""){
			if($request == 2){
				$query = $this->db->query("SELECT * FROM sh_return_sale LEFT JOIN sh_return_sale_items ON sh_return_sale.return_sale_id = sh_return_sale_items.return_sale_id LEFT JOIN sh_sell_bill ON sh_sell_bill.sell_bill_id = sh_return_sale.sell_bill_id WHERE sh_return_sale.return_date BETWEEN '$from' AND '$to'");
				
				if($query->num_rows() > 0)
				{
					return $query->result_array();
					
				}else{
					return FALSE;
				}
			}else{
				$query = $this->db->query("SELECT * FROM sh_return_sale LEFT JOIN sh_return_sale_items ON sh_return_sale.return_sale_id = sh_return_sale_items.return_sale_id LEFT JOIN sh_sell_bill ON sh_sell_bill.sell_bill_id = sh_return_sale.sell_bill_id WHERE  sh_sell_bill.in_or_out = '$request' AND sh_return_sale.return_date BETWEEN '$from' AND '$to'");
				
				if($query->num_rows() > 0)
				{
					return $query->result_array();
					
				}else{
					return FALSE;
				}
			}

		}else{

			if($request == 2){
				$query = $this->db->query("SELECT * FROM sh_return_sale LEFT JOIN sh_return_sale_items ON sh_return_sale.return_sale_id = sh_return_sale_items.return_sale_id LEFT JOIN sh_sell_bill ON sh_sell_bill.sell_bill_id = sh_return_sale.sell_bill_id WHERE sh_return_sale.user_id = '$cashier' AND sh_return_sale.return_date BETWEEN '$from' AND '$to'");
				
				if($query->num_rows() > 0)
				{
					return $query->result_array();
					
				}else{
					return FALSE;
				}
			}else{
				$query = $this->db->query("SELECT * FROM sh_return_sale LEFT JOIN sh_return_sale_items ON sh_return_sale.return_sale_id = sh_return_sale_items.return_sale_id LEFT JOIN sh_sell_bill ON sh_sell_bill.sell_bill_id = sh_return_sale.sell_bill_id WHERE sh_return_sale.user_id = '$cashier' AND sh_sell_bill.in_or_out = '$request' AND sh_return_sale.return_date BETWEEN '$from' AND '$to'");
				
				if($query->num_rows() > 0)
				{
					return $query->result_array();
					
				}else{
					return FALSE;
				}
			}

		}
	}

    public function get_payment_list($cashier, $request, $from, $to, $timeFrom, $timeTo)
    {
        // Start building the query
        $this->db->select('*');
        $this->db->from('sh_sell_bill');
        $this->db->join('tbl_users', 'tbl_users.user_id = sh_sell_bill.user_id', 'left');
        $this->db->join('tbl_employees', 'tbl_employees.user_id = tbl_users.user_id', 'left');
    
        // Add conditions based on the parameters
        if (!empty($from)) {
            $this->db->where('sell_date >=', $from);
        
        }
        if(!empty($to)){
            $this->db->where('sell_date <=', $to);
        }
        if (!empty($timeFrom) && !empty($timeTo)) {
            $this->db->where('sell_time >=', $timeFrom);
            $this->db->where('sell_time <=', $timeTo);
        }
        if (!empty($cashier)) {
            $this->db->where('sh_sell_bill.user_id =',$cashier);
        }
        if (!empty($request) && $request != 2) {
            // Execute the query and get the results
            $this->db->where('in_or_out =',$request);
           
          
            
        }
        $this->db->order_by('sell_bill_id', 'DESC');
        $query = $this->db->get();
        return $query->result_array();	
    }

	

	
    public function get_logs_list($status = null, $date_from = null, $date_to = null, $length, $start, $type, $action, $user_id,$order_column,$order)
    {
        $this->db->select('*,  DATE_FORMAT(tbl_logs.created_date, "%m/%d/%Y %H:%i") as created_date');
        $this->db->from('tbl_logs');
        $this->db->join('tbl_users as user', 'tbl_logs.user_id = user.user_Id', 'left');
        if ($length > 0) {
            $this->db->limit($length, $start);
        }
        if ($action!='All') {
            $this->db->where('tbl_logs.action', $action);
        }
        
        if ($user_id!='All') {
        $this->db->where('tbl_logs.user_id', $user_id);
        }
        
        if ($type!='All') {
        $this->db->where('tbl_logs.type', $type);
        }
        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("date(tbl_logs.created_date) BETWEEN '{$date_from}' AND '{$date_to}'");
        }
        $this->db->order_by('created_date', 'DESC');
        
        return $this->db->get()->result();
    }

    public function get_log($id)
    {
        $this->db->select('*');
        $this->db->from('tbl_logs');
        $this->db->join('tbl_users as user', 'tbl_logs.user_id = user.user_Id', 'left');
        $this->db->where('log_id',$id);
        
        return $this->db->get()->row();
    }

	
public function get_doctorIncome($doctor = null, $payment_type = null, $date_from = null, $date_to = null)
    {
        // Query for total cash by doctor
        $this->db->select('tbl_users.full_name, tbl_users.user_Id, SUM(tbl_patient_payment.cash) AS total_cash');
        $this->db->from('tbl_employees');
        $this->db->join('tbl_users', 'tbl_employees.user_id = tbl_users.user_Id', 'left');
        $this->db->join('tbl_treatment_payment', 'tbl_employees.user_id = tbl_treatment_payment.user_id', 'inner');
        $this->db->join('tbl_patient_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_patient_payment.treatment_payment_id', 'left');
        $this->db->join('tbl_payment_types', 'tbl_patient_payment.pay_type = tbl_payment_types.type_id', 'left');
    
        // Filter by doctor if specified
        if ((int)$doctor) {
            $this->db->where('tbl_users.user_Id', (int)$doctor);
        }
    
        // Filter by payment type if specified
        if ((int)$payment_type) {
            $this->db->where('tbl_patient_payment.pay_type', $payment_type);
        }
    
        // Filter by date range if specified
        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("tbl_patient_payment.pay_date BETWEEN '{$date_from}' AND '{$date_to}'");
        }

        $this->db->group_by('tbl_users.user_Id');
        $this->db->order_by('tbl_users.full_name', 'ASC');
    
        $result = $this->db->get()->result();
    
        // Query for total cash per payment method
        $this->db->select('tbl_payment_types.type_name, SUM(tbl_patient_payment.cash) AS total_cash');
        $this->db->from('tbl_patient_payment');
        $this->db->join('tbl_payment_types', 'tbl_patient_payment.pay_type = tbl_payment_types.type_id', 'left');
         $this->db->join('tbl_treatment_payment', 'tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id', 'inner');
        // Apply the same date filters as above
        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("tbl_patient_payment.pay_date BETWEEN '{$date_from}' AND '{$date_to}'");
        }
    if ((int)$doctor) {
            $this->db->where('tbl_treatment_payment.user_id', (int)$doctor);
        }
    

    
        // Group by payment type to get total cash per payment method
        $this->db->group_by('tbl_payment_types.type_name');
        $payment_method_totals = $this->db->get()->result();
    
        return [
            'doctor_totals' => $result,
            'payment_method_totals' => $payment_method_totals,
        ];
    }
    public function receptionistSale($doctor = null, $payment_type = null, $date_from = null, $date_to = null) {
        $this->db->select('rc.user_Id, rc.full_name, tbl_payment_types.type_name, SUM(tbl_patient_payment.cash) AS total_cash');
        $this->db->from('tbl_patient_payment');
        $this->db->join('tbl_payment_types', 'tbl_patient_payment.pay_type = tbl_payment_types.type_id', 'left');
        $this->db->join('tbl_treatment_payment', 'tbl_patient_payment.treatment_payment_id = tbl_treatment_payment.treatement_payment_id', 'inner');
        $this->db->join('tbl_users rc', 'tbl_patient_payment.user_id = rc.user_Id', 'inner'); // Join with receptionist/collector user_id
    
        // Apply date range filter if specified
        if (!empty($date_from) && !empty($date_to)) {
            $this->db->where("tbl_patient_payment.pay_date BETWEEN '{$date_from}' AND '{$date_to}'");
        }
    
        // Filter by doctor if specified (the doctor responsible for the treatment, not the collector)
        if ((int)$doctor) {
            $this->db->where('tbl_treatment_payment.user_id', (int)$doctor);
        }
    
        // Filter by payment type if specified
        if ((int)$payment_type) {
            $this->db->where('tbl_patient_payment.pay_type', $payment_type);
        }
    
        // Group by collector user_id and payment type
        $this->db->group_by(['rc.user_Id', 'tbl_payment_types.type_id']);
        $this->db->order_by('rc.full_name', 'ASC');
    
        $payment_method_totals = $this->db->get()->result();
        return $payment_method_totals;
    }
}