<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class UserModel extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function saveUser($data)
    {
        $this->db->insert('tbl_users', $data);
        $UserId = $this->db->insert_id();;

        return $UserId;
    }

    public function get_user_right($loginId)
    {
        $query = $this->db->select('*')
            ->from('tbl_user_group_rights')
            ->join('tbl_users', 'tbl_user_group_rights.create_user_Id = tbl_users.user_Id')
            ->join('tbl_user_rights', 'tbl_user_group_rights.user_right_id = tbl_user_rights.user_right_Id')
            ->get();
        return $query;
    }

    public function get_user($length=null,$start=null,$designation=null,$search=null)
    {
        $this->db->select('*,tbl_designations.designation')
            ->from('tbl_users')
            ->join('tbl_user_groups', 'tbl_user_groups.user_group_Id = tbl_users.user_group_Id','left')
            ->join('tbl_designations', 'tbl_designations.designation_id = tbl_users.designation_id','left')
            ->where('tbl_users.user_Id!=',77);
          

            if($length >0)
            $this->db->limit($length, $start);
            if(!empty($designation))
            $this->db->where('tbl_users.designation_id', $designation);
             if(!empty($search))
            $this->db->like('tbl_users.user_name', $search);

            $query = $this->db->get();
		return $query->result();
    
    }
    public function get_total_user($length,$start,$designation,$search=null)
    {
        $this->db->select('COUNT(tbl_users.user_Id) as total_users')
        ->from('tbl_users')
        ->join('tbl_user_groups', 'tbl_user_groups.user_group_Id = tbl_users.user_group_Id', 'left')
        ->join('tbl_designations', 'tbl_designations.designation_id = tbl_users.designation_id', 'left')
        ->where('tbl_users.user_Id !=', 77); // Exclude user with user_Id 77
        if(!empty($designation))
        $this->db->where('tbl_users.designation_id', $designation);
        if(!empty($search))
        $this->db->like('tbl_users.user_name', $search);
    // Execute the query
    $query = $this->db->get();

    // Return the count result
    return $query->row()->total_users;
    
    }

    //get user update detail
    public function get_user_details($user_id)
    {
        $query = $this->db->select('*')
            ->from('tbl_users')
            ->join('tbl_user_groups', 'tbl_user_groups.user_group_Id = tbl_users.user_group_Id')
            ->where('tbl_users.user_Id', $user_id)
            ->get();
            
        return $query->result_array();
    }

    public function user_group_id()
    {
        $query = $this->db->select('*')
            ->from('tbl_user_groups')
            ->where('tbl_user_groups.user_group_Id!=', 81)
            ->get();
        return $query;
    }

    public function updateUser($UserId, $data)
    {
        //        $query = $this->db->where('user_Id', $UserId)
        //                ->update('tbl_users', $data);
        //        return $query;

        //$this->db->set('teacher_id', $data["teacher_id"]);
        $this->db->set('full_name', $data["full_name"]);
        $this->db->set('user_name', $data["user_name"]);
        $this->db->set('email', $data["email"]);
        $this->db->set('phone_no', $data["phone_no"]);
        $this->db->set('user_description', $data["user_description"]);
        $this->db->set('image', $data["image"]);
        $this->db->set('user_group_Id', $data["user_group_Id"]);
        $this->db->set('district_id', $data["district_id"]);
        $this->db->set('designation_id', $data["designation_id"]);
        $this->db->set('create_user_Id', $data["create_user_Id"]);
        $this->db->set('create_datetime', $data["create_datetime"]);
        $this->db->set('is_inactive', $data["is_inactive"]);

        $this->db->where('user_Id', $UserId);
        $this->db->update('tbl_users');
    }

    public function changePassword($UserId, $data)
    {


        $this->db->set('password', $data["password"]);
        $this->db->set('create_datetime', $data["create_datetime"]);

        $this->db->where('user_Id', $UserId);
        $this->db->update('tbl_users');
    }

    public function checkUserName($username)
    {
        $this->db->select('username');
        $this->db->from('tbl_users');
        $this->db->where('username', $username);
        $this->db->limit(1);

        $query = $this->db->get();

        if ($query->num_rows() == 1) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function checkEmail($Email)
    {
        $this->db->select('email');
        $this->db->from('tbl_users');
        $this->db->where('email', $Email);
        //        $this->db->where('UserName', $username);
        //        $this->db->where('Password', $Password);
        $this->db->limit(1);

        $query = $this->db->get();

        if ($query->num_rows() == 1) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function password_check($Password)
    {
        $this->db->select('password');
        $this->db->from('tbl_users');
        $this->db->where('password', $Password);
        $this->db->limit(1);

        $query = $this->db->get();

        if ($query->num_rows() == 1) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function profile($loginId)
    {
        $query = $this->db->select('*')
            ->from('tbl_users')
            ->where('tbl_users.user_Id', $loginId)
            ->get()->result();
        return $query;
    }
}
