<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Conset Form View </title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <!--image crop-->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


  <?php require_once(APPPATH . "views/admin/header.php"); ?>

  <style type="text/css">
    .ui-autocomplete {
      max-height: 100px;
      overflow-y: auto;
      /* prevent horizontal scrollbar */
      overflow-x: hidden;
      z-index: 5000;
    }

    /*      body{
        font-family:monospace;
        text-align:center;
      }*/
    #btnSaveSign {
      color: #fff;
      background: #f99a0b;
      padding: 5px;
      border: none;
      border-radius: 5px;
      font-size: 20px;
      margin-top: 10px;
    }

    input[type="text"] {
      cursor: not-allowed;
      width: 255px;
    }

    ;

    input {
      cursor: not-allowed;
    }

    ;



    #signArea,
    #dsignArea,
    #wsignArea {
      width: 304px;
    }

    .sign-container {
      width: 60%;
      margin: auto;
    }

    .sign-preview {
      width: 150px;
      height: 50px;
      border: solid 1px #CFCFCF;
      margin: 10px 5px;
    }

    .tag-ingo {
      font-family: cursive;
      font-size: 12px;
      text-align: left;
      font-style: oblique;
    }

    .loading-spinner {
      width: 30px;
      height: 30px;
      border: 5px solid #48bcff;
      border-radius: 50%;
      border-top-color: #0001;
      display: inline-block;
      animation: loadingspinner .7s linear infinite;
    }


    input.single-line {
      border-bottom: 1px solid #000 !important;
      border: 0;
      border-radius: 0;
      box-shadow: none;
    }

    input.single-line:focus {
      box-shadow: none !important;
      outline: none;
    }


    @media print {
      body .panel {
        margin: 0px !important;
      }

      body h2 {
        margin-bottom: 30px !important;
      }

      @page {
        margin: 0cm;
        size: auto;
      }

      html,
      body {
        margin-left: -10mm;
        margin-right: -10mm;
        padding: 0cm;
      }
    }

    @keyframes loadingspinner {
      0% {
        transform: rotate(0deg)
      }

      100% {
        transform: rotate(360deg)
      }
    }
  </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header no-print">
      <h1>
        Conset Form
        <small>Read carefully before signing.</small>
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <section class="content pt-0 mt-0">
      <div class="row">
        <div class="col-md-12">
          <div class="box box-info mb-2">
            <div class="box-body">
              <div class="container-fluid" role="main">
                <div class="panel pl-5 pr-5 pt-2 pb-2">
                  <div class="panel-body">
                    <?php print_header($this); ?>
                    <form role="form" action="<?= base_url('index.php/admin/ConsentForm/ConsentFormController/insert_to_consents'); ?>" method="post" enctype="multipart/form-data" id="patient_consent_form">

                      <?php echo $content; ?>
                      <input type="hidden" name="patient_id" id="patient_id">
                      <input type="hidden" name="doctor_id" id="doctor_id">
                      <input type="hidden" name="consent_type" id="consent_type" value="<?php echo $consent_type; ?>">
                      <input type="hidden" name="consent_lang" id="consent_lang" value="<?php echo $consent_lang; ?>">
                      <a type="button" href="<?= base_url('index.php/admin/ConsentForm/ConsentFormController/index?lang=' . $consent_lang . '&id=' . $consent_type . ''); ?>" class="btn btn-default btn-primary no-print" id="back">Back</a>
                      <button type="button" class="btn btn-default btn-success no-print" id="print" onclick="window.print()">Print</button>
                    </form>
                  </div>
                </div>
              </div>

              <div class="modal  hidden-print" id="modal-loading" data-backdrop="static">
                <div class="modal-dialog modal-sm">
                  <div class="modal-content">
                    <div class="modal-body text-center">
                      <div class="loading-spinner mb-2"></div>
                      <div>Loading</div>
                    </div>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    </section>


    </form>

  </div>

  <!-- ./wrapper -->


  <?php require_once(APPPATH . "views/admin/footer.php"); ?>

</body>

</html>

<script>
  $(".patient_idx").autocomplete({
    source: function(request, response) {
      $.ajax({
        url: "<?php $this->load->helper('url');
              echo site_url('patient/get_patients'); ?>",
        dataType: "json",
        data: {
          name_startsWith: request.term,
          type: 'patient_id'
        },
        success: function(data) {
          response($.map(data, function(item) {
            var pat_name = item.split(' - ');
            return {
              label: item,
              value: pat_name[1]
            }
          }));
        }
      });
    },
    select: function(event, ui) {
      var patient_id = ui.item.label.split(' - ');

      $('#patient_id').val(patient_id[0]);
    },
    autoFocus: false,
    minLength: 1
  });

  $(".doctor_idx").autocomplete({
    source: function(request, response) {
      $.ajax({
        url: "<?php $this->load->helper('url');
              echo site_url('patient/get_patients_doctor'); ?>",
        dataType: "json",
        data: {
          name_startsWith: request.term,
          type: 'patient_id'
        },
        success: function(data) {

          response($.map(data, function(item) {

            var pat_name = item.split(' | ');

            return {
              label: item,
              value: pat_name[1]
            }
          }));
        }
      });
    },
    select: function(event, ui) {
      var patient_id = ui.item.label.split(' - ');

      $('#doctor_id').val(patient_id[0]);
      //$('input[name=doctor_name]').val(patient_id[1]);
    },
    autoFocus: false,
    minLength: 1
  });

  $(document).ready(function() {
    $('.signArea').signaturePad({
      drawOnly: true,
      drawBezierCurves: true,
      lineTop: 90
    });

    $(".reset_signature").click(function(e) {
      $(this).parent().signaturePad().clearCanvas();
      $(this).parent().find('.img_val').val('')
    });

    $('input[type=text]').attr('readonly', true);

    $("#save").click(function(e) {
      //$(this).attr('disabled', true);
      // $('#modal-loading').modal('show');
      var sign_pads = $('.sign-pad');
      var pads_count = 0;
      for (let x = 0; x < sign_pads.length; x++) {
        html2canvas([sign_pads[x]], {
          onrendered: function(canvas) {
            var canvas_img_data = canvas.toDataURL('image/png');
            var img_data = canvas_img_data.replace(/^data:image\/(png|jpg);base64,/, "");
            $(sign_pads[x]).parent().parent().find('.img_val').val(img_data);
          }
        });
        pads_count++;
      }

      setTimeout(() => {
        if (pads_count == sign_pads.length) {
          $('#patient_consent_form').submit();
        }
      }, 3000);

    });

  });

  $('#check_concern').click(function() {

    if ($("input[name=concern_patient_id]").val()) {
      if ($.isNumeric($("input[name=concern_patient_id]").val())) {
        $.ajax({
          type: "POST",
          url: "<?php $this->load->helper('url');
                echo site_url('patient/search_concern_form'); ?>",
          data: {
            search_data: $("input[name=concern_patient_id]").val(),
            type: 2
          },
          cache: false,
          success: function(result) {
            $("#search_error3").hide();
            $("#search_error2").hide();
            $("#search_error1").hide();
            $("#search_error4").hide();

            $("#search_patient").html(result);

          }
        });

      } else {
        var result = '<span class="text-danger">Please enter file number only</span';
        $("#search_error3").hide();
        $("#search_error2").hide();
        $("#search_error4").hide();
        $("#search_error1").show();
        $("#search_error1").html(result);
      }
    } else if ($("input[name=mobile_num]").val()) {
      if ($.isNumeric($("input[name=mobile_num]").val()) && $("input[name=mobile_num]").val().length >= 7) {
        $.ajax({
          type: "POST",
          url: "<?php $this->load->helper('url');
                echo site_url('patient/search_concern_form'); ?>",
          data: {
            search_data: $("input[name=mobile_num]").val(),
            type: 2
          },
          cache: false,
          success: function(result) {
            $("#search_error3").hide();
            $("#search_error2").hide();
            $("#search_error1").hide();
            $("#search_error4").hide();

            $("#search_patient").html(result);
          }
        });
      } else {
        var result = '<span class="text-danger">Please enter mobile number and it should be 8 or 7 digital number</span';
        $("#search_error3").hide();
        $("#search_error1").hide();
        $("#search_error4").hide();
        $("#search_error2").show();
        $("#search_error2").html(result);
      }
    } else if ($("input[name=q_id]").val()) {
      if ($.isNumeric($("input[name=q_id]").val()) && $("input[name=q_id]").val().length == 11) {
        $.ajax({
          type: "POST",
          url: "<?php $this->load->helper('url');
                echo site_url('patient/search_concern_form'); ?>",
          data: {
            search_data: $("input[name=q_id]").val(),
            type: 2
          },
          cache: false,
          success: function(result) {
            $("#search_error3").hide();
            $("#search_error2").hide();
            $("#search_error1").hide();
            $("#search_error4").hide();

            $("#search_patient").html(result);
          }
        });
      } else {
        var result = '<span class="text-danger">Please enter qatar id and it should be 11 digital number</span';
        $("#search_error1").hide();
        $("#search_error2").hide();
        $("#search_error4").hide();
        $("#search_error3").show();
        $("#search_error3").html(result);
      }
    } else if ($("input[name=patient_name_search]").val()) {
      $.ajax({
        type: "POST",
        url: "<?php $this->load->helper('url');
              echo site_url('patient/search_concern_form_byname'); ?>",
        data: {
          search_data: $("input[name=patient_name_search]").val(),
          type: 2
        },
        cache: false,
        success: function(result) {
          $("#search_error3").hide();
          $("#search_error2").hide();
          $("#search_error1").hide();
          $("#search_error4").hide();
          $("#search_patient").html(result);
        }
      });
    } else {
      var result1 = '<span class="text-danger">Please enter file number only</span>';
      var result2 = '<span class="text-danger">Please enter mobile number only</span>';
      var result3 = '<span class="text-danger">Please enter qatar id only</span>';
      var result4 = '<span class="text-danger">Please enter patient name only</span>';
      $("#search_error1").show();
      $("#search_error2").show();
      $("#search_error3").show();
      $("#search_error4").show();
      $("#search_error1").html(result1);
      $("#search_error2").html(result2);
      $("#search_error3").html(result3);
      $("#search_error4").html(result4);
    }

  });
</script>