<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo $title; ?></title>
  <link rel="icon" href="<?php echo IMG . '/favicon.ico'; ?>">
  <!-- Bootstrap -->
  <link href="<?php echo CSS . '/bootstrap.css'; ?>" rel="stylesheet">
  <!-- Table Data-->
  <link href="<?php echo LIB . '/dataTables/dataTables.bootstrap.css'; ?>" rel="stylesheet">
  <!-- Custom -->
  <link href="<?php echo CSS . '/custom.css'; ?>" rel="stylesheet">
  <link href="<?php echo CAL . '/css/jquery-ui.css'; ?>" rel="stylesheet">
  <link href="<?php echo CSS . '/jquery-ui.min.css'; ?>" rel="stylesheet">
  <!-- datepicker -->
  <link href="<?php echo CAL . '/css/jquery.datepick.css'; ?>" rel="stylesheet">
  <!--Print Landscape-->
  <link href="<?php echo CSS . '/print/print-landscape.css'; ?>" rel="stylesheet" media="print">

  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css">
  <style>
  .ui-autocomplete {
        max-height: 200px;
        max-width: 400px;
        overflow-y: auto;
        /* prevent horizontal scrollbar */
        overflow-x: hidden;
  }
      /* IE 6 doesn't support max-height
       * we use height instead, but this forces the menu to always be this tall
       */
      * html .ui-autocomplete {
        height: 200px!important;
      }
    .overflow {
      overflow: scroll;
    }

    #summary_table td,
    th {
      text-align: center;
    }

    #summary_table th {
      background-color: #5d4e4a;
      color: white;
    }

    #summary_table {
      box-shadow: 0px 0px 3px 0px rgb(131 112 24 / 88%);
    }
    .panel-default{
      overflow: scroll!important;
    }
  </style>
</head>

<body>
  <!-- Fixed navbar -->
  <?php include('nav_bar.php'); ?>

  <div class="container theme-showcase" role="main">
    <div class="jumbotron" style="background-color:#9CD0E8;">
      <!-- login plate -->
      <?php include('login_plate.php') ?>

      <h4 class="page-header ui-page-header hidden-print"><?php echo $page_header; ?></h4>

      <div id="print_header">
        <?php include(dirname(__FILE__) . '/blocks/print_header.php');
        ?> </div>
      <!-- content -->
      <div class="row hidden-print">
        <div class="col-md-12">
          <div class="panel panel-info">
            <div class="panel-heading">
              <h3 class="panel-title">Filter Feedback Report</h3>
            </div>
            <form action="<?php $this->load->helper('url');
                          echo site_url('reports/feedback_report'); ?>" method="post" autocomplete="off">
              <div class="panel-body">
                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label for="patient_id">Select Patient</label>
                      <input type="text" class="form-control" value="<?php echo $patient; ?>" name="patient_id" id="patient_id" placeholder="Select Patient...">
                    </div>
                    <!-- <div class="form-group">
                      <label for="patient_id">Select Doctor/Machine</label>
                      <input type="text" class="form-control" value="<?php echo $doctor; ?>" name="doctor_id" id="doctor_id" placeholder="Select Doctor/Machine...">
                    </div> -->
                    <div class="form-group">
                      <label for="from">From</label>
                      <input type="text" value="<?php if (isset($from)) {
                                                  echo $from;
                                                } ?>" class="form-control" name="from" id="from">
                    </div>
                    <div class="form-group">
                      <label for="to">To</label>
                      <input type="text" value="<?php if (isset($to)) {
                                                  echo $to;
                                                } ?>" class="form-control" name="to" id="to">
                    </div>
                    <button type="submit" class="btn btn-default btn-primary hidden-print">Show Report</button>
                    <button type="reset" class="btn btn-default btn-warning hidden-print" id="clear">Clear</button>
                  </div>
                  <div class="col-md-1"></div>
                  <?php if ($feedback_summary != FALSE) {
                    $previous = [0, 0, 0, 0, 0];
                    $treatment = [0, 0, 0, 0, 0];
                    $session = [0, 0, 0, 0, 0];
                    $laser = [0, 0, 0, 0, 0];
                    $nurse = [0, 0, 0, 0, 0];
                    $waiting = [0, 0, 0, 0, 0];
                    $reception = [0, 0, 0, 0, 0];
                    $appointment = [0, 0, 0, 0, 0];

                    foreach ($feedback_summary as $key => $val) {
                      foreach ($val as $key => $value) {
                        $key == 'previous' && $value!=0 ? $previous[$value - 1] += 1 : '';
                        $key == 'treatment' && $value!=0 ? $treatment[$value - 1] += 1 : '';
                        $key == 'session' && $value!=0 ?  $session[$value - 1] += 1 : '';
                        $key == 'laser' && $value!=0 ? $laser[$value - 1] += 1 : '';
                        $key == 'nurse' && $value!=0 ? $nurse[$value - 1] += 1 : '';
                        $key == 'waiting' && $value!=0 ? $waiting[$value - 1] += 1 : '';
                        $key == 'reception' && $value!=0 ? $reception[$value - 1] += 1 : '';
                        $key == 'appointment' && $value!=0 ? $appointment[$value - 1] += 1 : '';
                      };
                    }

                  ?>
                    <div class="col-md-8">
                      <table class="table" id="summary_table">
                        <thead>
                          <th width="40%"></th>
                          <th width="10%">Excellent</th>
                          <th width="10%">Good</th>
                          <th width="10%">Satisfied</th>
                          <th width="10%">Poor</th>
                          <th width="10%">Bad</th>
                        </thead>
                        <tbody>
                          <tr>
                            <td><b>Satisfaction with the booking appointment?</b></td>
                            <td><b><?= $appointment[0] ?></b></td>
                            <td><b><?= $appointment[1] ?></b></td>
                            <td><b><?= $appointment[2] ?></b></td>
                            <td><b><?= $appointment[3] ?></b></td>
                            <td><b><?= $appointment[4] ?></b></td>
                          </tr>
                           <tr>
                            <td><b>How satisfied are you with the reception? </b></td>
                            <td><b><?= $reception[0] ?></b></td>
                            <td><b><?= $reception[1] ?></b></td>
                            <td><b><?= $reception[2] ?></b></td>
                            <td><b><?= $reception[3] ?></b></td>
                            <td><b><?= $reception[4] ?></b></td>
                          </tr>
                          <tr>
                            <td><b>How satisfied are you with the waiting period?</b></td>
                            <td><b><?= $waiting[0] ?></b></td>
                            <td><b><?= $waiting[1] ?></b></td>
                            <td><b><?= $waiting[2] ?></b></td>
                            <td><b><?= $waiting[3] ?></b></td>
                            <td><b><?= $waiting[4] ?></b></td>
                          </tr>
                          <tr>
                            <td><b>How satisfied are you with the nurse’s reception? </b></td>
                            <td><b><?= $nurse[0] ?></b></td>
                            <td><b><?= $nurse[1] ?></b></td>
                            <td><b><?= $nurse[2] ?></b></td>
                            <td><b><?= $nurse[3] ?></b></td>
                            <td><b><?= $nurse[4] ?></b></td>
                          </tr> 
                          <tr>
                            <td><b>How satisfied are you with the laser room?</b></td>
                            <td><b><?= $laser[0] ?></b></td>
                            <td><b><?= $laser[1] ?></b></td>
                            <td><b><?= $laser[2] ?></b></td>
                            <td><b><?= $laser[3] ?></b></td>
                            <td><b><?= $laser[4] ?></b></td>
                          </tr> 
                          <tr>
                            <td><b>How satisfied are you with the duration of the session?</b></td>
                            <td><b><?= $session[0] ?></b></td>
                            <td><b><?= $session[1] ?></b></td>
                            <td><b><?= $session[2] ?></b></td>
                            <td><b><?= $session[3] ?></b></td>
                            <td><b><?= $session[4] ?></b></td>
                          </tr> 
                          <tr>
                            <td><b>How was the nurse’s treatment and accuracy? </b></td>
                            <td><b><?= $treatment[0] ?></b></td>
                            <td><b><?= $treatment[1] ?></b></td>
                            <td><b><?= $treatment[2] ?></b></td>
                            <td><b><?= $treatment[3] ?></b></td>
                            <td><b><?= $treatment[4] ?></b></td>
                          </tr> 
                          <tr>
                            <td><b>If this is not your first session, how satisfied with the result of the previous session?</b></td>
                            <td><b><?= $previous[0] ?></b></td>
                            <td><b><?= $previous[1] ?></b></td>
                            <td><b><?= $previous[2] ?></b></td>
                            <td><b><?= $previous[3] ?></b></td>
                            <td><b><?= $previous[4] ?></b></td>
                          </tr> 
                        </tbody>
                      </table>
                    </div>
                  <?php  } ?>

                  <div class="col-md-1"></div>
                </div>


              </div>
          </div>
          </form>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <div class="panel panel-info">
          <div class="panel panel-default">
            <table class="table" id="feedback_table">
              <thead>
                <tr>
                  <th>No.</th>
                  <th width="10%">Date</th>
                  <th width="10%">Patient</th>
                  <th width="5%"><abbr title="Satisfaction with the booking appointment?" class="initialism">Appointment</abbr></th>
                  <th width="5%"><abbr title="How satisfied are you with the reception?" class="initialism">Reception</abbr></th>
                  <th width="5%"><abbr title="How satisfied are you with the waiting period?" class="initialism">Waiting</abbr></th>
                  <th width="5%"><abbr title="How satisfied are you with the nurse’s reception?" class="initialism">Nurse’s Reception</abbr></th>
                  <th width="5%"><abbr title="How satisfied are you with the laser room?" class="initialism">Laser</abbr></th>
                  <th width="5%"><abbr title="How satisfied are you with the duration of the session?" class="initialism">Session</abbr></th>
                  <th width="5%"><abbr title="How was the nurse’s treatment and accuracy?" class="initialism">Treatment</abbr></th>
                  <th width="5%"><abbr title="If this is not your first session, how satisfied with the result of the previous session.?" class="initialism">Last Session</abbr></th>
                  <!-- <th width="30%">Other Comments</th> -->
                </tr>
              </thead>
              <tbody>
                <?php
                if ($feedback_report != FALSE) {

                  $i=0;foreach ($feedback_report as $value) {$i++;
                ?>
                    <tr>
                      <td class="text-center"><?php echo $i; ?></td>
                      <td class="text-center"><?php echo date("Y-m-d h.i A", strtotime($value['curr_date'] . ' ' . $value['curr_time'])); ?></td>
                      <td class="text-center"><?php echo $value['patient_name']; ?></td>
                      <!-- <td class="text-center"><?php echo $value['assign']; ?></td> -->
                      <td class="text-center"><?php echo $this->rating_name($value['appointment']); ?></td>
                      <td class="text-center"><?php echo $this->rating_name($value['reception']); ?></td>
                      <td class="text-center"><?php echo $this->rating_name($value['waiting']); ?></td>
                      <td class="text-center"><?php echo $this->rating_name($value['nurse']); ?></td>
                      <td class="text-center"><?php echo $this->rating_name($value['laser']); ?></td>
                      <td class="text-center"><?php echo $this->rating_name($value['session']); ?></td>
                      <td class="text-center"><?php echo $this->rating_name($value['treatment']); ?></td>
                      <td class="text-center"><?php echo $this->rating_name($value['previous']); ?></td>
                      <!-- <td style="text-align:left"><?php echo $value['comment']; ?></td> -->
                    </tr>

                  <?php



                  }
                  ?>
              </tbody>
            </table>
          <?php
                } else {
          ?>
            </tbody>
            </table>
            <div class="row">
              <div class="col-md-6 col-md-offset-5">
                <br>
                No records found
              </div>
            </div>
          <?php
                }
          ?>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
  <!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>-->
  <script src="<?php echo JS . '/jquery-2.1.1.min.js'; ?>"></script>
  <!-- Include all compiled plugins (below), or include individual files as needed -->
  <script src="<?php echo JS . '/bootstrap.min.js'; ?>"></script>
  <!-- Data Table -->
  <script src="<?php echo JS . '/jquery-ui.min.js'; ?>"></script>
  <script src="<?php echo (LIB . '/dataTables/jquery.dataTables.js'); ?>"></script>
  <!-- <script src="<?php echo (LIB . '/dataTables/dataTables.bootstrap.js'); ?>"></script> -->
  <!-- Date Picker -->
  <script src="<?php echo CAL . '/js/jquery.plugin.js'; ?>"></script>
  <script src="<?php echo CAL . '/js/jquery.datepick.js'; ?>"></script>

  <script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
  <script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
  <script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
  <script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
  <script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
  <script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>
  <script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>
  <script>
    $(document).ready(function() {
      var print_header = $('#print_header').html();
      /* Data table*/
      $('#feedback_table').DataTable({
        dom: 'Bfrtip',
        pageLength: 20,
        buttons: [{
            extend: 'print',
            autoPrint: true,
            title: '',
            exportOptions: {
              columns: [0, 1, 2, 3, 4, 5]
            },
            customize: function(win) {
              $(win.document.body)
                .css('font-size', '10pt')
                .prepend(print_header + '<h4 class="visible-print-block col-md-12 text-center"><u>Feedback Report</u></h4>');

              $(win.document.body).find('table')
                .addClass('compact')
                .css('font-size', 'inherit');
            }
          },
          {
            extend: 'excel',
            exportOptions: {
              columns: [0, 1, 2, 3, 4, 5]
            }
          }
        ],
        order: [
          [0, 'desc']
        ]
      });

      $("#sale_csv").click(function() {
        $('#submit_sales').submit();
      });

      $("#clear").click(function() {
        $('input').val('');
      });

    });

    $("#patient_id").autocomplete({
        source: function(request, response) {
          $.ajax({
            url: "<?php $this->load->helper('url');
                  echo site_url('patient/get_patients_doc'); ?>",
            dataType: "json",
            data: {
              name_startsWith: request.term,
              type: 'patient_id'
            },
            success: function(data) {
              response($.map(data, function(item) {
                return {
                  label: item,
                  value: item
                }
              }));
            }
          });
        },
        autoFocus: false,
        minLength: 2
      });

      
    $("#doctor_id").autocomplete({
        source: function(request, response) {
          $.ajax({
            url: "<?php $this->load->helper('url');
                  echo site_url('patient/get_doctor_machines'); ?>",
            dataType: "json",
            data: {
              name_startsWith: request.term,
              type: 'patient_id'
            },
            success: function(data) {
              response($.map(data, function(item) {
                return {
                  label: item,
                  value: item
                }
              }));
            }
          });
        },
        autoFocus: false,
        minLength: 1
      });
  </script>
  <script>
    $('#from').datepick({
      dateFormat: 'yyyy-mm-dd',
      showTrigger: '#calImg',
      minDate: new Date(2014, 1 - 1, 1),
      maxDate: new Date(2030, 12 - 1, 31),
      yearRange: '2014:2050'
    });
    $('#to').datepick({
      dateFormat: 'yyyy-mm-dd',
      showTrigger: '#calImg',
      minDate: new Date(2014, 1 - 1, 1),
      maxDate: new Date(2030, 12 - 1, 31),
      yearRange: '2014:2050'
    });
  </script>
</body>

</html>