<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo $title; ?></title>
  <link rel="icon" href="<?php echo IMG . '/favicon.ico'; ?>">
  <!-- Bootstrap -->
  <link href="<?php echo CSS . '/bootstrap.css'; ?>" rel="stylesheet">
  <!-- Table Data-->
  <!-- <link href="<?php echo LIB . '/dataTables/dataTables.bootstrap.css'; ?>" rel="stylesheet"> -->
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css">
  <!-- datepicker -->
  <link href="<?php echo CAL . '/css/jquery.datepick.css'; ?>" rel="stylesheet">
  <!-- Custom -->
  <link href="<?php echo CSS . '/custom.css'; ?>" rel="stylesheet">

  <style>
    @media print {
      .show-on-print {
        visibility: visible;
      }
      
    }

    .datepick-popup {
      z-index: 5000;
    }

    .form-group>.select2-container {
      width: 100% !important;
    }

    .modal-open .datepicker {
      z-index: 9999 !important
    }

    /* The Modal (background) */
    /* Modal Content/Box */
    .modal-lg {
      background-color: #fefefe;
      margin: 15% auto;
      /* 15% from the top and centered */
      border: 1px solid #888;
      width: 150%;
      /* Could be more or less, depending on screen size */
    }

    .select2-container {
      width: 100% !important;
      padding: 0;
    }

    .report_tabs {
      padding: 20px;
    }

    #myModal .modal-dialog {
      -webkit-transform: translate(0, -50%);
      -o-transform: translate(0, -50%);
      transform: translate(0, -50%);
      top: 50%;
      margin: 0 auto;
    }

    .btn-overview {
      background-image: url("<?= IMG . '/buttons/items/items.png' ?>");
      display: inline-block;
      height: 130px;
      width: 150px;
      padding-top: 80px;
      color: #fff;
      font-size: 18px;
    }

    .btn-overview:hover {
      text-decoration: none;
      color: #fff;
    }

    .btn-location {
      background-image: url("<?= IMG . '/buttons/items/locations.png' ?>");
      display: inline-block;
      height: 130px;
      width: 150px;
      padding-top: 80px;
      color: #fff;
      font-size: 18px;
    }

    .btn-location:hover {
      text-decoration: none;
      color: #fff;
    }

    .btn-categories {
      background-image: url("<?= IMG . '/buttons/items/categories.png' ?>");
      display: inline-block;
      height: 130px;
      width: 150px;
      padding-top: 80px;
      color: #fff;
      font-size: 18px;
    }

    .btn-categories:hover {
      text-decoration: none;
      color: #fff;
    }

    .btn-suppliers {
      background-image: url("<?= IMG . '/buttons/suppliers/suppliers.png' ?>");
      display: inline-block;
      height: 130px;
      width: 150px;
      padding-top: 80px;
      color: #fff;
      font-size: 18px;
    }

    .btn-suppliers:hover {
      text-decoration: none;
      color: #fff;
    }

    .btn-transfers {
      background-image: url("<?= IMG . '/buttons/items/transfer.png' ?>");
      display: inline-block;
      height: 130px;
      width: 150px;
      padding-top: 80px;
      color: #fff;
      font-size: 18px;
    }

    .btn-transfers:hover {
      text-decoration: none;
      color: #fff;
    }

    .btn-invoices {
      background-image: url("<?= IMG . '/buttons/items/transfer.png' ?>");
      display: inline-block;
      height: 130px;
      width: 150px;
      padding-top: 80px;
      color: #fff;
      font-size: 18px;
    }

    .btn-departments{
      background-image: url("<?= IMG . '/buttons/suppliers/inquiryitems.png' ?>");
      display: inline-block;
      height: 130px;
      width: 150px;
      padding-top: 80px;
      color: #fff;
      font-size: 18px;

    }

    .btn-reports {
      background-image: url("<?= IMG . '/buttons/items/reports.png' ?>");
      display: inline-block;
      height: 130px;
      width: 150px;
      padding-top: 80px;
      color: #fff;
      font-size: 18px;
    }

    .btn-invoices:hover {
      text-decoration: none;
      color: #fff;
    }

    .report-content {
      margin-top: 30px;
    }

    .add-btn {
      margin-top: 24px;
    }

    .quantity {
      width: 55px;
    }
  </style>
</head>

<body>
  <!-- Fixed navbar -->
  <?php include('nav_bar.php'); ?>

  <div class="container theme-showcase" role="main">
    <div class="jumbotron" style="background-color:#9CD0E8;">
      <!-- login plate -->
      <?php include('login_plate.php') ?>

      <h4 class="page-header ui-page-header"><?php echo $page_header; ?></h4>
      
      <div id="print_header">
      <?php include(dirname(__FILE__) .'/blocks/print_header_receipt.php');
      ?> </div>

      <!-- user GUI/content -->
      <?php //include('patient_tab.php') 
      ?>


      <div class="panel panel-default">
        <div class="panel-body">
          <ul class="nav nav-tabs hide" role="tablist">
            <li class="tab-sel"><a href="#ph_overview" role="tab" data-toggle="tab" class="tab-overview">Overview</a></li>
            <li class="active tab-sel"><a href="#ph_items" role="tab" data-toggle="tab">Items</a></li>
            <li class="tab-sel"><a href="#ph_item_categories" role="tab" data-toggle="tab">Categories</a></li>
            <li class="tab-sel"><a href="#ph_item_suppliers" role="tab" data-toggle="tab">Suppliers</a></li>
            <li class="tab-sel"><a href="#ph_item_locations" role="tab" data-toggle="tab" class="tab-location">Location</a></li>
            <li class="tab-sel"><a href="#ph_requests" role="tab" data-toggle="tab">Doctor Requests</a></li>
            <li class="tab-sel"><a href="#ph_item_invoices" role="tab" data-toggle="tab">Invoices</a></li>
          </ul>

          <!-- Tab panes -->
          <div class="tab-content">
            <div class="tab-pane dashboard-tabs" id="ph_overview">
              </br></br>
              <?php include('pharmacy_overview.php') ?>
            </div>
            <div class="tab-pane dashboard-tabs active" id="ph_items">
              </br></br>
              <?php include('pharmacy_items.php') ?>
            </div>
            <div class="tab-pane dashboard-tabs" id="ph_item_categories">
              </br></br>
              <?php include('pharmacy_item_categories.php') ?>
            </div>
            <div class="tab-pane dashboard-tabs" id="ph_item_departments">
              </br></br>
              <?php include('pharmacy_item_departments.php') ?>
            </div>
            <div class="tab-pane dashboard-tabs" id="ph_item_suppliers">
              </br></br>
              <?php include('pharmacy_item_suppliers.php') ?>
            </div>
            <div class="tab-pane dashboard-tabs" id="ph_item_locations">
              </br></br>
              <?php include('pharmacy_locations.php') ?>
            </div>
            <div class="tab-pane dashboard-tabs" id="ph_requests">
              </br></br>
              <?php include('pharmacy_requests.php') ?>
            </div>
            <div class="tab-pane dashboard-tabs" id="ph_item_invoices">
              </br></br>
              <?php include('pharmacy_item_invoices.php') ?>
            </div>
            <div class="tab-pane dashboard-tabs" id="ph_item_reports">
              </br></br>
              <?php include('pharmacy_item_reports.php') ?>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>-->
    <script type="text/javascript" src="<?php echo LIB . '/js/jquery.min.js'; ?>"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="<?php echo JS . '/bootstrap.min.js'; ?>"></script>
    <!-- Data Table -->
    <script src="<?php echo (LIB . '/dataTables/jquery.dataTables.js'); ?>"></script>
    <!-- <script src="<?php echo (LIB . '/dataTables/dataTables.bootstrap.js'); ?>"></script> -->
    <script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>
    <script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="<?php echo CAL . '/js/jquery.plugin.js'; ?>"></script>
    <script src="<?php echo CAL . '/js/jquery.datepick.js'; ?>"></script>

    </body>
    <script>
      var col = [];
      var mod = '';
      var ent = false;
      var print_header = $('#print_header').html();

      function delMod(id, c) {
        $.ajax({
          url: "<?php $this->load->helper('url');
                echo site_url('ajax/delete_phar_inventory'); ?>",
          type: "POST",
          dataType: "json",
          data: {
            id: id,
            mod: c
          },
          success: function(data) {
            location.reload();
          }
        });
      }

      function store(type, ex, arr) {
        col = arr;
        ent = ex;
        mod = type;
        assign();
        if (type == 'item') {
          getItemInfo(arr[0], ex);
        }
      }

      function assign() {
        //console.log('##############################################################');
        //console.log(mod);
        //console.log(col);
        //console.log(col[0]);
        //console.log('##############################################################');

        switch (mod) {
          case 'item':
            $('#item_code').val(col[0]);
            $('#item_name').val(col[1]);
            $('#item_type option[value="' + col[2] + '"]').prop("selected", true);
            $('#ph_item_unit option[value="' + col[3] + '"]').prop("selected", true);

            $('#barcode').val(col[4]);
            $('#new').val(ent);
            $('#item_code').attr('readonly', ent);
            $('#new').text(ent);
            $('#itemLabel').text('Edit Item');
            break;

          case 'category':
            $('#ph_category_id').val(col[0]);
            $('#category_name').val(col[1]);
            $('#new_category').val(ent);
            $('#categoryLabel').text('Edit Category');
            break;

          case 'supplier':
            $('#ph_supplier_id').val(col[0]);
            $('#supplier_name').val(col[1]);
            $('#new_supplier').val(ent);
            $('#contact_person').val(col[2]);
            $('#number').val(col[3]);
            $('#address').val(col[4]);
            $('#email').val(col[5]);
            $('#payment_type option[value="' + col[6] + '"]').prop("selected", true);
            $('#supplierLabel').text('Edit Supplier');
            break;

          case 'departments':
            $('#ph_department_id').val(col[0]);
            $('#department_name').val(col[1]);
            $('#departmentLabel').text('Edit Department')
            break;
        }
        return col;
      }

      function getItemInfo(id, ex) {
        $.ajax({
          url: "<?php $this->load->helper('url');
                echo site_url('ajax/get_phar_item_info'); ?>",
          type: "POST",
          dataType: "json",
          data: {
            item_id: id
          },
          beforeSend: function() {},
          success: function(data) {
            // console.log('#########################################################');
            // console.log(data);
            // console.log('#########################################################');
            $('#new').val(ex);
            $('#item_code').val(data[0].item_id);
            $('#barcode').val(data[0].barcode);
            $('#item_name').val(data[0].item_name);
            $('#item_type').val(data[0].item_type);
            $('#item_unit').val(data[0].item_unit);
            $('#description').val(data[0].description);
            $('#price').val(data[0].price);

            $('#item_code').attr('readonly', ent);
          }
        });
      }

      function escape(s) {
        console.log('aaa');
        return ('' + s)
          .replace(/\\/g, '\\\\')
          .replace(/\t/g, '\\t')
          .replace(/\n/g, '\\n')
          .replace(/\u00A0/g, '\\u00A0')
          .replace(/&/g, '\\x26')
          .replace(/'/g, '\\x27')
          .replace(/"/g, '\\x22')
          .replace(/</g, '\\x3C')
          .replace(/>/g, '\\x3E');
      }

      function getItemListAjax(url, target) {
        $.ajax({
          // url : "<?php $this->load->helper('url');
                    echo site_url('ajax/get_phar_items_list'); ?>",
          url: url,
          type: "POST",
          dataType: "json",
          data: {},
          beforeSend: function() {
            // $('#tbl-items tbody').html('<tr><td colspan=4><h5 class="text-center"><img src="<?php echo base_url(); ?>images/ajax-loader_dark.gif"> Loading list...</h5></td></tr>');
            // $('#tbl-overview-expire-soon tbody').html('<tr><td colspan=4><h5 class="text-center"><img src="<?php echo base_url(); ?>images/ajax-loader_dark.gif"> Loading list...</h5></td></tr>');
          },
          success: function(data) {
            row = '';
            var report = '';
            if (target == 'tbl-requests') {
              var report = 'Requests'
              // console.log(target+'----------------------------');
              for (let i = 0; i < data.length; ++i) {
                row += '<tr>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].request_id + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].date + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].emp_name + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].department_name + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].user_name + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center"><button class="btn btn-primary btn-primary btn-xs btn-edit-item" data-toggle="modal" data-target="#requestModal_Edit" onclick="request_update(\'' + data[i].date + '\',\'' + data[i].employee_id + '\',\'' + data[i].request_id + '\',\'' + data[i].department + '\')">Editt</button>&nbsp;<button class="btn btn-primary btn-danger btn-xs btn-delete" onClick="delMod(\'' + data[i].request_id + '\',\'request\')">Delete</button></td>';
                row += '</tr>';
              }
            } else if (target == 'tbl-invoices') {
              var report = 'Billings'
              //console.log(target + 'TEST----------------------------');
              inv_url = '<?= site_url("pharmacy/invoice/") ?>';
              for (let i = 0; i < data.length; ++i) {
                if (data[i].payment_method == 1) {
                  pm = 'Credit';
                } else if (data[i].payment_method == 2) {
                  pm = 'Cash';
                } else {
                  pm = 'Cheque';
                }

                row += '<tr>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].inventory_invoice_id + '</td>';
                // row += '<td style="vertical-align: middle;" class="text-center">'+data[i].ref_no+'</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + pm + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].date + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].supplier_name + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center"><a href="' + inv_url + '/' + data[i].inventory_invoice_id + '" class="btn btn-primary btn-primary btn-xs">Edit</a>&nbsp;<button class="btn btn-primary btn-danger btn-xs btn-delete" onClick="delMod(\'' + data[i].inventory_invoice_id + '\',\'invoice\')">Delete</button></td>';
                row += '</tr>';

                // $.ajax({
                //   url : "<?php $this->load->helper('url');
                            echo site_url('ajax/get_phar_invoice_item_list'); ?>",
                //   // url : url,
                //   type: "POST",
                //   dataType: "json",
                //   data: {
                //     inv_id: data[i].inventory_invoice_id
                //   },
                //   beforeSend: function() {
                //   },
                //   success: function(data) {
                //     // console.log(data);
                //   }
                // })
              }
            } else if (target == 'tbl-categories') {
              var report = 'Categories'
              // console.log(target+'----------------------------');
              inv_url = '<?= site_url("pharmacy/invoice/") ?>';
              for (let i = 0; i < data.length; ++i) {
                if (data[i].payment_method == 1) {
                  pm = 'Credit';
                } else if (data[i].payment_method == 2) {
                  pm = 'Cash';
                } else {
                  pm = 'Cheque';
                }

                row += '<tr>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].inventory_invoice_id + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + pm + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].date + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].supplier_name + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center"><a href="' + inv_url + '/' + data[i].inventory_invoice_id + '" class="btn btn-primary btn-primary btn-xs">Edit</a>&nbsp;<button class="btn btn-primary btn-danger btn-xs btn-delete" onClick="delMod(\'' + data[i].inventory_invoice_id + '\',\'invoice\')">Delete</button></td>';
                row += '</tr>';

                $.ajax({
                  url: "<?php $this->load->helper('url');
                        echo site_url('ajax/get_phar_invoice_item_list'); ?>",
                  // url : url,
                  type: "POST",
                  dataType: "json",
                  data: {
                    inv_id: data[i].inventory_invoice_id
                  },
                  beforeSend: function() {},
                  success: function(data) {
                    // console.log(data);
                  }
                })
              }
            } else {
              var report = 'Items'
              for (let i = 0; i < data.length; ++i) {
                // console.log('*************************');
                // console.log(data[i]);
                // console.log('*************************');
                row += '<tr>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].item_id + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + (typeof(data[i].barcode) !== 'undefined' ? data[i].barcode : 'n/a') + '</td>';
                row += '<td style="vertical-align: middle;" class="text-center">' + data[i].item_name + '</td>';
                if(data[i].qty <= 10) {
                    row += '<td style="vertical-align: middle;background-color:red;color:#fff;font-weight:bold;" class="text-center">'+data[i].qty+'</td>';
                }else {
                    row += '<td style="vertical-align: middle;background-color:green;color:#fff;font-weight:bold;" class="text-center">'+data[i].qty+'</td>';
                }
                if (target == 'tbl-items')
                  row += '<td style="vertical-align: middle;" class="text-center">' + data[i].type_name + '</td>';
                else
                  row += '<td style="vertical-align: middle;" class="text-center">' + data[i].expiry_date + '</td>';
                // if(target == 'tbl-items')
                // row += '<td style="vertical-align: middle;" class="text-center">'+data[i].expiry_date+'</td>';
                row += '<td style="vertical-align: middle;" class="text-center"><button class="btn btn-primary btn-primary btn-xs btn-edit-item" data-toggle="modal" data-target="#itemModal" onclick="store(\'item\',true,[\'' + (data[i].item_id).replace(/["']/g, "") + '\',\'' + (data[i].item_name).replace(/["']/g, "") + '\',\'' + data[i].item_type + '\',\'' + data[i].unit + '\'])">Edit</button>&nbsp;<button class="btn btn-primary btn-danger btn-xs btn-delete" onClick="delMod(\'' + data[i].item_id + '\',\'item\')">Delete</button></td>';
                row += '</tr>';
              }
            }

            // if(target == 'tbl-items') {
            //   $('#tbl-items tbody').html(row);
            //   $('#tbl-items').dataTable(); 
            // }
            $('#' + target + ' tbody').html(row);
            // $('#'+target).dataTable(); 
            $('#' + target).DataTable({
              dom: 'Bfrtip',
              buttons: [{
                  extend: 'print',
                  autoPrint: true,
                  title:'',
                  exportOptions: {
                    columns: ':not(:last-child)'
                  },
                  customize: function ( win ) {
                        $(win.document.body)
                            .css( 'font-size', '10pt' )
                            .prepend(print_header + '<h4 class="visible-print-block col-md-12 text-center"><u>Inventory : '+report+'</u></h4>');

                        $(win.document.body).find( 'table' )
                            .addClass( 'compact' )
                            .css( 'font-size', 'inherit' );
                  }
                },
                {
                  extend: 'excel',
                  exportOptions: {
                    columns: ':not(:last-child)'
                  }
                }
              ],
              order: [[0, 'desc']]
            });
          }
        });
      }

      $(document).ready(function() {
        var url = window.location.href;
        var activeTab = url.substring(url.indexOf("#") + 1);
        var activeindex = url.split("#");
        if(activeindex.length >1){
          $(".dashboard-tabs").removeClass("active in");
          $("#" + activeTab).addClass("active in");
          $('a[href="#'+ activeTab +'"]').tab('show');
        }

        $('.date').datepick({
          dateFormat: 'yyyy-mm-dd',
          showTrigger: '#calImg',
          maxDate: new Date(2030, 12 - 1, 31),
          yearRange: '2014:2050'
        });
        $.fn.dataTable.ext.errMode = 'none';

        $('.btn-overview').on('click', function() {
          $('.tab-overview').trigger('click');
        })

        $('.btn-location').on('click', function() {
          $('.tab-location').trigger('click');
        })

        $('.add_btn').on('click', function() {
          var type = $(this).attr('data-control');
          switch (type) {
          case 'item':
            $('#item_code').val('');
            $('#item_name').val('');
            $('#item_type').prop("selected", true);
            $('#ph_item_unit').prop("selected", true);
            $('#price').val('');

            $('#barcode').val('');
            $('#description').val('');
            $('#new').val(false);
            $('#item_code').attr('readonly', false);
            $('#new').text(false);
            $('#itemLabel').text('Add Item');
            break;
          case 'category':
            $('#ph_category_id').val('');
            $('#category_name').val('');
            $('#new_category').val(false);
            $('#categoryLabel').text('Add Category');
            break;

          case 'supplier':
            $('#ph_supplier_id').val('');
            $('#supplier_name').val('');
            $('#contact_person').val('');
            $('#number').val('');
            $('#address').val('');
            $('#email').val('');
            $('#new_supplier').val(false);
            $('#supplierLabel').text('Add Supplier');
            break;

          case 'department':
            $('#ph_department_id').val(0);
            $('#department_name').val('');
            $('#departmentLabel').text('Add Department')
            break;  
          }

        })

        $('.select2-container').css("width", "100%");
        $('#item_id').select2({
          placeholder: 'Select Drug...',
          allowClear: true,
          ajax: {
            url: '<?php $this->load->helper('url');
                  echo site_url('ajax/get_items_json'); ?>',
            dataType: 'json',
            width: '100%',
            data: function(params) {
              var queryParameters = {
                term: params.term,
                not_all: false
              }
              return queryParameters;
            },
            processResults: function(data) {
              return {
                results: data
              };
            },
            cache: true
          }
        });

        $('#item_id_add').select2({
          placeholder: 'Select Drug...',
          allowClear: true,
          ajax: {
            url: '<?php $this->load->helper('url');
                  echo site_url('ajax/get_items_stock_json'); ?>',
            dataType: 'json',
            width: '100%',
            data: function(params) {
              var queryParameters = {
                term: params.term,
                not_all: $('#request_items_add').val()
              }
              return queryParameters;
            },
            processResults: function(data) {
              return {
                results: data
              };
            },
            cache: true
          }
        });

        $('#item_id_edit').select2({
          placeholder: 'Select Drug...',
          allowClear: true,
          ajax: {
            url: '<?php $this->load->helper('url');
                  echo site_url('ajax/get_items_stock_json'); ?>',
            dataType: 'json',
            width: '100%',
            data: function(params) {
              var queryParameters = {
                term: params.term,
                not_all: $('#request_items_edit').val()
              }
              return queryParameters;
            },
            processResults: function(data) {
              return {
                results: data
              };
            },
            cache: true
          }
        });



        $('.item_id').select2({
          placeholder: 'Select Drug...',
          allowClear: true,
          ajax: {
            url: '<?php $this->load->helper('url');
                  echo site_url('ajax/get_items_json_reports'); ?>',
            dataType: 'json',
            width: '100%',
            data: function(params) {
              var queryParameters = {
                term: params.term,
                not_all: false
              }
              return queryParameters;
            },
            processResults: function(data) {
              console.log(data);
              return {
                results: data
              };
            },
            cache: true
          }
        });

        // getItemListAjax("<?php $this->load->helper('url');
                            echo site_url('ajax/get_phar_not_expired_items_list'); ?>",'tbl-overview-not-expired');
        getItemListAjax("<?php $this->load->helper('url');
                          echo site_url('ajax/get_phar_items_list'); ?>", 'tbl-items');
        getItemListAjax("<?php $this->load->helper('url');
                          echo site_url('ajax/get_phar_expired_soon_list'); ?>", 'tbl-overview-expire-soon');
        getItemListAjax("<?php $this->load->helper('url');
                          echo site_url('ajax/get_phar_expired_items_list'); ?>", 'tbl-overview-expired');
        getItemListAjax("<?php $this->load->helper('url');
                          echo site_url('ajax/get_phar_no_expiry_items_list'); ?>", 'tbl-overview-no-expire');
        getItemListAjax("<?php $this->load->helper('url');
                          echo site_url('ajax/get_doctor_requests_list'); ?>", 'tbl-requests');
        getItemListAjax("<?php $this->load->helper('url');
                          echo site_url('ajax/get_phar_invoice_list'); ?>", 'tbl-invoices');


        $('.btn-item-submit').on('click', function() {
          // alert('asdasd');
        })

        // console.log("<?php $this->load->helper('url');
                        echo site_url('ajax/get_phar_invoice_list'); ?>");
        // $.ajax({
        //   url: "<?php $this->load->helper('url');
        //         echo site_url('ajax/get_phar_invoice_list'); ?>",
        //   type: "POST",
        //   dataType: "json",
        //   data: {},
        //   beforeSend: function() {
        //     // $('#treatment_prices tbody').html('<tr><td colspan=4><h5 class="text-center"><img src="<?php echo base_url(); ?>images/ajax-loader_dark.gif"> Refreshing treatment list...</h5></td></tr>');
        //   },
        //   success: function(data) {
        //     row = '';
        //     pm = '';

        //     for (let i = 0; i < data.length; ++i) {
        //       // console.log('###################');
        //       // console.log(data[i]);
        //       pm = '';
        //       inv_url = '<?= site_url("pharmacy/invoice/") ?>';

        //       if (data[i].payment_method == 1) {
        //         pm = 'Credit';
        //       } else if (data[i].payment_method == 2) {
        //         pm = 'Cash';
        //       } else {
        //         pm = 'Cheque';
        //       }
        //       // console.log('pasok');
        //       // console.log(data[i].inventory_invoice_id);

        //       row += '<tr>';
        //       row += '<td style="vertical-align: middle;" class="text-center">' + data[i].inventory_invoice_id + '</td>';
        //       row += '<td style="vertical-align: middle;" class="text-center">' + pm + '</td>';
        //       row += '<td style="vertical-align: middle;" class="text-center">' + data[i].date + '</td>';
        //       row += '<td style="vertical-align: middle;" class="text-center">' + data[i].supplier_name + '</td>';
        //       row += '<td style="vertical-align: middle;" class="text-center"><a href="' + inv_url + '/' + data[i].inventory_invoice_id + '" class="btn btn-primary btn-primary btn-xs">Edit</a>&nbsp;<button class="btn btn-primary btn-danger btn-xs btn-delete" onClick="delMod(\'' + data[i].inventory_invoice_id + '\',\'invoice\')">Delete</button></td>';
        //       row += '</tr>';
        //     }

        //     $('#tbl-invoices tbody').html(row);
        //     $('#tbl-invoices').dataTable();
        //     initialize_print('#tbl-invoices','Invoices');
        //   }
        // });

        $.ajax({
          url: "<?php $this->load->helper('url');
                echo site_url('ajax/get_phar_category_list'); ?>",
          type: "POST",
          dataType: "json",
          data: {},
          beforeSend: function() {
            // $('#treatment_prices tbody').html('<tr><td colspan=4><h5 class="text-center"><img src="<?php echo base_url(); ?>images/ajax-loader_dark.gif"> Refreshing treatment list...</h5></td></tr>');
          },
          success: function(data) {
            row = '';

            for (let i = 0; i < data.length; ++i) {
              row += '<tr>';
              row += '<td style="vertical-align: middle;" class="text-center">' + data[i].item_type + '</td>';
              row += '<td style="vertical-align: middle;" class="text-center">' + data[i].type_name + '</td>';
              row += '<td style="vertical-align: middle;" class="text-center"><button class="btn btn-primary btn-primary btn-xs" data-toggle="modal" data-target="#categoryModal" onclick="store(\'category\',true,[\'' + data[i].item_type + '\',\'' + data[i].type_name + '\'])">Edit</button>&nbsp;<button class="btn btn-primary btn-danger btn-xs btn-delete" onClick="delMod(\'' + data[i].item_type + '\',\'category\')">Delete</button></td>';
              row += '</tr>';
            }

            $('#tbl-categories tbody').html(row);
            //$('#tbl-categories').dataTable();
            initialize_print('#tbl-categories','Categories');
          }
        });

        $.ajax({
          url: "<?php $this->load->helper('url');
                echo site_url('ajax/get_phar_department_list'); ?>",
          type: "POST",
          dataType: "json",
          data: {},
          beforeSend: function() {
            // $('#treatment_prices tbody').html('<tr><td colspan=4><h5 class="text-center"><img src="<?php echo base_url(); ?>images/ajax-loader_dark.gif"> Refreshing treatment list...</h5></td></tr>');
          },
          success: function(data) {
            row = '';

            for (let i = 0; i < data.length; ++i) {
              row += '<tr>';
              row += '<td style="vertical-align: middle;" class="text-center">' + data[i].id + '</td>';
              row += '<td style="vertical-align: middle;" class="text-center">' + data[i].department_name + '</td>';
              row += '<td style="vertical-align: middle;" class="text-center"><button class="btn btn-primary btn-primary btn-xs" data-toggle="modal" data-target="#departmentModal" onclick="store(\'departments\',true,[\'' + data[i].id + '\',\'' + data[i].department_name + '\'])">Edit</button>&nbsp;<button class="btn btn-primary btn-danger btn-xs btn-delete" onClick="delMod(\'' + data[i].id + '\',\'department\')">Delete</button></td>';
              row += '</tr>';
            }

            $('#tbl-departments tbody').html(row);
            //$('#tbl-departments').dataTable();
            initialize_print('#tbl-departments','Departments');
          }
        });

        $.ajax({
          url: "<?php $this->load->helper('url');
                echo site_url('ajax/get_phar_supplier_list'); ?>",
          type: "POST",
          dataType: "json",
          data: {},
          beforeSend: function() {
            // $('#treatment_prices tbody').html('<tr><td colspan=4><h5 class="text-center"><img src="<?php echo base_url(); ?>images/ajax-loader_dark.gif"> Refreshing treatment list...</h5></td></tr>');
          },
          success: function(data) {
            row = '';

            for (let i = 0; i < data.length; ++i) {
              row += '<tr>';
              row += '<td style="vertical-align: middle;" class="text-center">' + data[i].supplier_id + '</td>';
              row += '<td style="vertical-align: middle;" class="text-center">' + data[i].supplier_name + '</td>';
              row += '<td style="vertical-align: middle;" class="text-center">' + data[i].number + '</td>';
              row += '<td style="vertical-align: middle;" class="text-center"><button class="btn btn-primary btn-primary btn-xs" data-toggle="modal" data-target="#supplierModal" onclick="store(\'supplier\',true,[\'' + data[i].supplier_id + '\',\'' + data[i].supplier_name + '\',\'' + data[i].contact_person + '\',\'' + data[i].number + '\',\'' + data[i].address + '\',\'' + data[i].email + '\',\'' + data[i].payment_type + '\'])">Edit</button>&nbsp;<button class="btn btn-primary btn-danger btn-xs btn-delete" onClick="delMod(\'' + data[i].supplier_id + '\',\'supplier\')">Delete</button></td>';
              row += '</tr>';
            }

            $('#tbl-suppliers tbody').html(row);
            //$('#tbl-suppliers').dataTable();
            initialize_print('#tbl-suppliers','Suppliers');
          }
        });

        $('.select-overview').on('change', function() {
          opt = $(this).val();
          url = '';

          if (opt == 1) {
            $('.overview-not-expired').hide();
            $('.overview-expire-soon').show();
            $('.overview-expired').hide();
            $('.overview-no-expire').hide();
          } else if (opt == 2) {
            $('.overview-not-expired').hide();
            $('.overview-expire-soon').hide();
            $('.overview-expired').show();
            $('.overview-no-expire').hide();
          } else if (opt == 3) {
            $('.overview-not-expired').hide();
            $('.overview-expire-soon').hide();
            $('.overview-expired').hide();
            $('.overview-no-expire').show();
          } else if (opt == 4) {
            $('.overview-not-expired').show();
            $('.overview-expire-soon').hide();
            $('.overview-expired').hide();
            $('.overview-no-expire').hide();
          } else {
            alert('No selected.');
          }
        }).trigger('change')


        // $('.tab-sel').on('click', function() {
        //   id = $(this).children().attr('href');
        //   sel = id.replace('#ph_', '');
        //   mod = sel;

        //   $.ajax({
        //     url : "<?php $this->load->helper('url');
                      echo site_url('ajax/get_phar_items_list'); ?>",
        //     type: "POST",
        //     dataType: "json",
        //     data: {
        //     },
        //     beforeSend: function() {
        //       // $('#treatment_prices tbody').html('<tr><td colspan=4><h5 class="text-center"><img src="<?php echo base_url(); ?>images/ajax-loader_dark.gif"> Refreshing treatment list...</h5></td></tr>');
        //     },
        //     success: function(data) {
        //       row = '';


        //       switch(sel) {
        //         case 'overview': 
        //         break;
        //         case 'items':

        //         break;
        //         case 'item_categories': 
        //         break;
        //         case 'locations': 
        //         break;
        //         case 'requests': 
        //         break;
        //         case 'reports': 
        //         break;

        //       }



        //     }
        //   });

        // }).trigger('click')


        // /* Add row of table*/
        // var cnt = 2;
        //  $("#anc_add").click(function(){
        //     $('#tbl1 tr').last().after('\
        //       <tr>\
        //         <td>\
        //           <select class="form-control" name="insurance" id="insurance">\
        //                 <!--<option>Select Patient Type...</option>-->\
        //                 <option value="0">920 - Panodal Clusaiya</option>\
        //                 <option value="0">920 - Panodal Clusaiya</option>\
        //                 <option value="0">920 - Panodal Clusaiya</option>\
        //                 <option value="0">920 - Panodal Clusaiya</option>\
        //           </select>\
        //         </td>\
        //         <td>\
        //           <input type="text" class="form-control" name="patient_name'+cnt+'" id="patient_name'+cnt+'">\
        //         </td>\
        //         <td>20.00</td>\
        //       </tr>');
        //     cnt++;
        //  });

        // $("#anc_rem").click(function(){
        //   if($('#tbl1 tr').size()>1){
        //    $('#tbl1 tr:last-child').remove();
        //    }else{
        //    alert('One row should be present in table');
        //    }
        //  })


        $('.genrate_report').on('click', function() {
          var type = $(this).attr('data-control');
          var item_id = $('#item_id_' + type).val() == null ? 0 : $('#item_id_' + type).val();
          var from_date = $('#from_date_' + type).val();
          var to_date = $('#to_date_' + type).val();
          var options = {
            supplier_id: $('#supplier_id_report').val(),
            doctor_id: $('#doctor_id_report').val(),
            department: $('#department_report').val(),
            item_id: item_id,
            from_date: from_date,
            to_date: to_date,
          };

          if(from_date != '' && to_date == ''){
            alert('Please select a to date')
            return
          } else if (from_date == '' && to_date != ''){
            alert('Please select a from date')
            return
          }

          $.ajax({
            url: "<?php $this->load->helper('url');
                  echo site_url('pharmacy/get_report_'); ?>" + type,
            type: "POST",
            dataType: "html",
            data: options,
            beforeSend: function() {
              $('#content-' + type).html('<div class="col-md-12 text-center">Loading...</div>');
            },
            success: function(data) {
              $('#content-' + type).html(data);
            }
          })
        })

        $('.print_report').on('click', function() {
          var type = $(this).attr('data-control');
          var printContents = $('#report-content-' + type).html();
          var originalContents =  $('body').html();
          $('#report-content-' + type).find( 'table' ).addClass( 'compact' ).css( 'font-size', 'small' );
          $('body').html(printContents);
          setTimeout(function() {
          window.print();
          //document.body.innerHTML=originalContents;
          window.location.reload();
          }, 500);
        })

        $('.submit_request').on('click', function() {
          var type = $(this).attr('data-control')
          var elements = $('.calculate_'+type);

          var submit = true;
          for (var i = 0; i < elements.length; i++) {
              var data =  $(elements[i]).attr('data-control')
                  text = data.split('_'),
                  item_id = text[0],
                  qty = parseInt($(elements[i]).val());
                  stock = parseInt(text[2]);

              if(stock < qty){
                $('#'+ item_id+ "_" + type).html('More than stock qty!')
                submit = false;
              }
              if(0 >= qty){
                $('#'+ item_id+ "_" + type).html('Less than stock qty!')
                submit = false;
              }
          }

          if(submit){
            document.getElementById(type+"_form").submit();
          } else {
            return;
          }
            
        })
        

        $('.add-btn').on('click', function(transfer_items) {
          var  type = $(this).attr('data-control'),
                data = $('#item_id_'+type).select2('data'),
                added_invoice_item_id = data[0].id,
                text = data[0].text.split('||'),
                invoice_id = text[0],
                code = text[1],
                item_barcode = text[2],
                name = text[3],
                stock = text[4].trim();
                price = text[5],

          $("#issue_tbody_"+type).append("<tr>" +
            "<td>" +
            "<button type=\"button\" class=\"btn btn-sm btn-danger delete_row\" data-control='" + added_invoice_item_id + "_" + type + "'><span class=\"glyphicon glyphicon-minus-sign\"></span></button>" +
            "</td>" +
            "<td>" + invoice_id + "</td>"+
            "<td>" + code + "</td>"+
            "<td>" + item_barcode + "</td>"
            // + "<td>" + batch + "</td>"
            +
            "<td>" + name + "</td>" +
            "<td>" +
            "<input type=\"hidden\" name='invoice_item_id[]' value=" + added_invoice_item_id + " class=\"quantity\">" +
            "<input type=\"hidden\" name='items[]' value=" + code + " class=\"quantity\">" +
            "<input type=\"text\" name='quantity[]' data-control='" + added_invoice_item_id + "_"+type+"_"+stock+"' value=\"1\" class='quantity calculate_"+type+"'>" +
            "<h6 class='text-danger' id='" + added_invoice_item_id + "_" + type + "'><h6>" +
            "</td>" +
            "<td>" + price + "</td>"+
            "</tr>");

            var selected_items = $('#request_items_'+type).val();
            $('#request_items_'+type).val(selected_items +','+ added_invoice_item_id);
            $("#item_id_"+type).empty().trigger('change');
        });

      });

      $(document).on('click','.delete_row', function() {
        $(this).parent().parent().remove();
        var data = $(this).attr('data-control'),
            text = data.split('_')
            invoice_item_id = text[0]
            type = text[1]
            selected_items = $('#request_items_'+type).val(),
        $('#request_items_'+type).val(selected_items.replace(','+invoice_item_id, ''))
      });

      var tableToExcel = (function() {
        var uri = 'data:application/vnd.ms-excel;base64,',
          template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--><meta http-equiv="content-type" content="text/plain; charset=UTF-8"/></head><body><table>{table}</table></body></html>',
          base64 = function(s) {
            return window.btoa(unescape(encodeURIComponent(s)))
          },
          format = function(s, c) {
            return s.replace(/{(\w+)}/g, function(m, p) {
              return c[p];
            })
          }
        return function(table, name) {
          if (!table.nodeType) table = document.getElementById(table)
          var ctx = {
            worksheet: name || 'Worksheet',
            table: table.innerHTML
          }
          window.location.href = uri + base64(format(template, ctx))
        }
      })()

      function request_update(date, employee_id, request_id,department) {
        $.ajax({
            url: "<?php $this->load->helper('url'); echo site_url('ajax/get_doctor_requests_items'); ?>",
            type: "POST",
            dataType: "json",
            data:{ request_id:request_id } ,
            beforeSend: function() {
              $('#issue_tbody_edit').html('<div class="col-md-12 text-center">Loading...</div>');
            },
            success: function(data) {
              $('#issue_tbody_edit').empty();
              $('#request_items_edit').val(0);
              
            for (let i = 0; i < data.length; ++i) {
                $("#issue_tbody_edit").append("<tr>" +
                    "<td>" +
                    "<button type=\"button\" class=\"btn btn-sm btn-danger delete_row\" data-control='" + data[i].invoice_item_id + "_edit'><span class=\"glyphicon glyphicon-minus-sign\"></span></button>" +
                    "</td>" +
                    "<td>" + data[i].invoice_item_id + "</td>"+
                    "<td>" + data[i].item_id + "</td>" +
                    "<td>" + data[i].barcode + "</td>"
                    // + "<td>" + batch + "</td>"
                    +
                    "<td>" + data[i].item_name + "</td>" +
                    "<td>" +
                    "<input type=\"hidden\" name='invoice_item_id[]' value=" + data[i].invoice_item_id + " class=\"quantity\">" +
                    "<input type=\"hidden\" name='items[]' value=" + data[i].item_id + ">" +
                    "<input type=\"text\" name='quantity[]' value=" + data[i].quantity + " data-control=" + data[i].item_id + "_edit_"+(parseInt(data[i].stock_qty)+parseInt(data[i].quantity))+" class='quantity calculate_edit'>" +
                    "<h6 class='text-danger' id='" + data[i].item_id + "_edit'><h6>" +
                    "</td>" +
                    "<td>" + Number(data[i].item_price).toFixed(2) + "</td>" +
                    "</tr>");
                var selected_items = $('#request_items_edit').val();
                $('#request_items_edit').val(selected_items +','+ data[i].invoice_item_id);
              }
              
            }
          });

        $('#date_edit').val(date);
        $('#doctor_id_edit').val(employee_id);
        $('#request_id_edit').val(request_id);
        $('#request_id_edit').val(request_id);
        $('#department option[value="' + department + '"]').prop("selected", true);
      }

      function initialize_print(target , report){
        $(target).DataTable({
              dom: 'Bfrtip',
              buttons: [{
                  extend: 'print',
                  autoPrint: true,
                  title:'',
                  exportOptions: {
                    columns: ':not(:last-child)'
                  },
                  customize: function ( win ) {
                        $(win.document.body)
                            .css( 'font-size', '10pt' )
                            .prepend(print_header + '<h4 class="visible-print-block col-md-12 text-center"><u>Inventory : '+report+'</u></h4>');

                        $(win.document.body).find( 'table' )
                            .addClass( 'compact' )
                            .css( 'font-size', 'inherit' );
                  }
                },
                {
                  extend: 'excel',
                  exportOptions: {
                    columns: ':not(:last-child)'
                  }
                }
              ],
              order: [[0, 'desc']]
            });
      }
    </script>

</html>