<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
  <?php require_once(APPPATH . "views/admin/header.php"); ?>


  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css">

  <style>
    .select2-container .select2-selection--single {
      height: 55px;
    }

    .form-group>.select2-container {
      width: 100% !important;
    }

    .modal-open .datepicker {
      z-index: 9999 !important
    }

    /*table {
        table-layout: fixed;
    word-wrap: break-word;
      }*/
    @media print {
      @page {
        size: landscape;
        margin: 5mm 0mm;
      }

      th:last-child,
      td:last-child {
        /*  border :none;
          background-color: #ffffff;*/
        display: none;
      }

      button {
        display: none !important;
      }

      input,
      select,
      textarea {
        border: none !important;
        box-shadow: none !important;
        outline: none !important;
        -moz-appearance: none;
        -webkit-appearance: none;
      }

      input[type="file"],
      .tbl-items {
        display: none !important;
        position: relative;
        clear: both;
      }

      .panel-default {
        border: 0 !important;
      }

      #requestModal,
      #requestModal * {
        visibility: visible;
      }

      #requestModal {
        position: absolute;
        left: 0;
        top: 0;
      }
    }

    .cursor-poiner {
      cursor: pointer;
      text-decoration: underline;
    }
  </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->
  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->


  <div class="modal fade" id="stockModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header bg-primary">
          <h5 class="modal-title" id="exampleModalLabel">Modify Stock
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
          </h5>
          </button>
        </div>
        <div class="modal-body">
          <div class="form-group qty">
            <label for="qty">Quantity</label><br>
            <input type="text" class="form-control" name="qty" id="qty">
          </div>
          <div class="form-group expiry_date">
            <label for="expiry_date">Expiry Date</label><br>
            <input type="text" class="form-control" name="expiry_date" id="expiry_date">
          </div>
          <div class="form-group qty">
            <label for="qty">Location</label><br>
            <input type="text" class="form-control" name="location" id="location">
          </div>
          <div class="form-group hide">
            <textarea id="items_col"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-default btn-primary">Save</button>
        </div>

      </div>
    </div>
  </div>

  <div class="content-wrapper">

    <section class="content-header">
      <h1>
        <strong>Billing</strong>
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <section class="content">

      <div class="row">
        <div class="col-md-12">
          <div class="box box-solid">
            <div class="box-body">
              <div class="row">
                <div class="col-md-1">
                  <a href="<?php echo base_url('index.php/admin/Inventory/InventoryController/index') ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left"></i> Go back </a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="box box-info">
            <div class="box-header with-border">
              <h3 class="box-title font-weight-bold">New Order</h3>
            </div>

            <div class="box-body">
              <div class="panel-group" id="accordion">
                <div class="d-block mb-3">
                  <div class="panel panel-default">
                    <div class="panel-body">
                      <h4 class="page-header ui-page-header"><?= $page_header; ?></h4>

                      <form role="form" id="main" action="<?= base_url('index.php/admin/Inventory/InventoryController/manage_invoice'); ?>" method="post" enctype="multipart/form-data" class="form-horizontal">
                        <div class="panel panel-default">
                          <div class="panel-body">
                            <div class="row">

                              <div class="col-md-2"><label>Ref. Invoice No</label><input type="text" class="form-control" name="invoice_no" value="<?= $header[0]['ref_no'] ?>"><input type="hidden" class="form-control" name="invoice_id" value="<?= $header[0]['inventory_invoice_id'] ?>"></div>

                              <div class="col-md-2"><label>Payment Method</label>
                                <select class="form-control" name="payment_method">
                                  <option value="1" <?= ($header[0]['payment_method'] == 1) ? "selected" : "" ?>>Credit</option>
                                  <option value="2" <?= ($header[0]['payment_method'] == 2) ? "selected" : "" ?>>Cash</option>
                                  <option value="3" <?= ($header[0]['payment_method'] == 3) ? "selected" : "" ?>>Cheque</option>
                                </select>
                              </div>

                              <div class="col-md-2">
                                <label for="lab_test">Date</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                <input type="date" class="form-control" name="date" id="date_invoice" autocomplete="false" value="<?= $header[0]['date'] ?>">
                              </div>

                              <div class="col-md-6"><label>Supplier</label>

                                <select class="form-control" name="supplier_id">
                                  <?php foreach ($suppliers as $supp) : ?>
                                    <option value="<?= $supp['supplier_id'] ?>" <?= ($header[0]['supplier_id'] == $supp['supplier_id']) ? "selected" : "" ?>><?= $supp['supplier_id'] ?> - <?= $supp['supplier_name'] ?></option>
                                  <?php endforeach; ?>
                                </select>

                              </div>
                            </div>
                            <div class="row form-group tbl-items">

                              <div class="col-md-4">
                                <label>Item</label>
                                <select class="form-control" id="item_id" name="item_id" class="item_id">
                                </select><br>
                              </div>

                              <div class="col-md-2">
                                <label>Qty</label>
                                <input type="text" class="form-control" id="item_qty" name="item_qty" class="item_qty">
                                <span class="hide">
                                  <textarea id="items_arr"></textarea>
                                  <textarea id="qty_arr"></textarea>
                                  <textarea id="unit_arr"></textarea>
                                  <textarea id="expiry_arr"></textarea>
                                  <textarea id="location_arr"></textarea>
                                </span>
                              </div>

                              <div class="col-md-2">
                                <label for="item_location">Unit</label><br>
                                <select class="form-control" name="item_unit" id="item_unit" disabled>
                                  <?php foreach ($units as $unit) : ?>
                                    <option value="<?= $unit['unit_id'] ?>"><?= $unit['name'] ?></option>
                                  <?php endforeach; ?>
                                </select>
                              </div>

                              <div class="col-md-2">
                                <label for="item_expire">Expiry Date</label><br>
                                <input type="date" class="form-control" name="item_expire" id="item_expire" autocomplete="false">
                              </div>

                              <div class="col-md-2">
                                <label for="item_location">Location</label><br>
                                <!-- <input type="text" class="form-control" name="item_location" id="item_location" autocomplete="false"> -->
                                <select name="item_location" id="item_location" require class="form-control">
                                    <?php foreach($locations as $location): ?>
                                      <option value="<?= $location['location'] ?>"><?= $location['location'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                              </div>

                            </div>

                            <div class="row form-group">
                              <div class="col-md-2 pull-left">
                                <label>&nbsp;</label>
                                <button type="button" class="btn-sm btn btn-dark" id="add_item"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add Item</button>
                              </div>
                            </div>

                            <div class="row">
                              <hr>
                              <div class="col-md-12">
                                <div class="panel panel-primary">
                                  <div class="panel-heading">
                                    <h4>Item List</h4>
                                  </div>

                                  <table class="table table-hover display table-striped" id="tbl-invoice-items">
                                    <thead>
                                      <tr>
                                        <th>Code</th>
                                        <!-- <th>Barcode</th> -->
                                        <th>Item Name</th>
                                        <th>Qty</th>
                                        <th>Bonus</th>
                                        <th>Unit</th>
                                        <th>Price</th>
                                        <th>Expiry Date</th>
                                        <th>Location</th>
                                        <th>Actions</th>
                                      </tr>
                                    </thead>
                                    <tbody>
                                      <?php if (!empty($items)) : ?>
                                        <?php foreach ($items as $item) : ?>
                                          <tr>
                                            <td>
                                              <input type="hidden" name="invoice_item_id[]" value="<?= $item['item_inventory_invoice_item_id'] ?>">
                                              <input type="text" name="item[]" value="<?= $item['item_id'] ?>" readonly="readonly" style="width:100px;" readonly="readonly" class="form-control">
                                            </td>
                                            <td><b><?= $item['item_name'] ?></b><br><small><?= $item['barcode'] ?></small></td>
                                            <td><input type="text" name="qty[]" value="<?= $item['quantity'] ?>" style="width:50px;" class="form-control"></td>
                                            <td><input type="text" name="bonus[]" value="<?= $item['bonus'] ?>" style="width:50px;" class="form-control"></td>
                                            <td><input type="hidden" name="item_list_unit[]" value="<?= $item['unit_id'] ?>" style="width:50px;"><?= $item['name'] ?></td>
                                            <td><input type="text" name="price[]" value="<?= $item['price'] ?>" style="width:100px;" class="form-control"></td>
                                            <td><input type="text" name="item_expire[]" value="<?= $item['expiry_date'] ?>" style="width:100px; class=" form-control""></td>
                                            <td><input type="text" name="item_location[]" value="<?= $item['location'] ?>" class="form-control"></td>
                                            <td class="text-center">
                                              <button class="btn btn-light btn-del-item"><i class="fa fa-trash" aria-hidden="true"></i></button>
                                            </td>
                                          </tr>
                                        <?php endforeach; ?>
                                      <?php endif; ?>
                                    </tbody>
                                  </table>

                                </div>
                              </div>
                            </div>

                            <div class="row hidden-print">
                              <div class="col-md-3">
                                <label class="cursor-poiner" for="scanned_invoice">Scanned Documents (invoice) <br> </label><small>(*jpg, *png, *pdf)</small>
                                <input type="file" id="scanned_invoice" name="scanned_invoice">
                                <?php if ($header[0]['scanned_invoice'] != $header[0]['inventory_invoice_id'] . '-inv.' && $header[0]['scanned_invoice'] != '') : ?>
                                  <br><a class="" target="_blank" href="<?= base_url(''.UPLOAD_PATH.'inventory/' . $header[0]['scanned_invoice']); ?>"><b>View Invoice</b></a>
                                <?php endif; ?>
                              </div>
                            </div>

                            <br>

                            <div class="row hidden-print">
                              <div class="col-md-3">
                                <label class="cursor-poiner" for="scanned_payment">Scanned Documents (payment)</label><small>(*jpg, *png, *pdf)</small>
                                <input type="file" id="scanned_payment" name="scanned_payment">
                                <?php if ($header[0]['scanned_payment'] != $header[0]['inventory_invoice_id'] . '-pay.' && $header[0]['scanned_payment'] != '') : ?>
                                  <br><a class="" target="_blank" href="<?= base_url(''.UPLOAD_PATH.'inventory/' . $header[0]['scanned_payment']); ?>"><b>View Payment</b></a>
                                <?php endif; ?>
                              </div>
                            </div>


                            <div class="row hidden-print">
                              <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
                                <button type="button" class="btn btn-light btn-sm" onclick="window.print();"><i class="fa fa-print" aria-hidden="true"></i> Print</button>
                              </div>
                            </div>

                          </div>
                        </div>
                      </form>


                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
  <?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>

</html>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
  <?php if (!$header[0]['inventory_invoice_id']) : ?>
    $('#date_invoice').val(new Date().toISOString().slice(0, 10));
  <?php endif; ?>

  // $('#tbl-invoice-items tbody').empty();
  $('#item_id').select2({
    placeholder: 'Select Drug...',
    ajax: {
      url: '<?= base_url('index.php/admin/Inventory/InventoryController/get_items_json'); ?>',
      dataType: 'json',
      width: '100%',
      data: function(params) {
        var queryParameters = {
          term: params.term,
          not_all: false
        }
        return queryParameters;
      },
      processResults: function(data) {
        return {
          results: data
        };
      },
      cache: true
    }
  });

  $('#item_id').on("change", function(e) {
    var data = $('#item_id').select2('data');
    var text = data[0].text.split(' || ');
    $('#item_unit').val(text[4]);
  });

  row = '';
  itemsArr = [];
  itemArr = [];
  itemQty = [];
  itemUnit = [];
  itemExpiry = [];
  itemLocation = [];

  $('#add_item').on('click', function() {
    item = $('#item_id').val();
    qty = $('#item_qty').val();
    unit = $('#item_unit').val();
    unit_name = $('#item_unit').find(":selected").text();
    expire = $('#item_expire').val();
    ilocation = $('#item_location').val();

    $.ajax({
      url: "<?= base_url('index.php/admin/Inventory/InventoryController/get_phar_item_info'); ?>",
      type: "POST",
      dataType: "json",
      data: {
        item_id: item
      },
      beforeSend: function() {
        if ($('input[name="invoice_id"]').val()) {
          $('#tbl-invoice-items tbody').empty();
        }
      },
      success: function(data) {
        if (itemsArr.indexOf(item) == true) {

        } else {
          itemArr.push(item);
          itemQty.push(qty);
          itemUnit.push(unit);
          itemExpiry.push(expire);
          itemLocation.push(ilocation);
          row = '';

          row += '<tr id="item-' + data[0].item_id + '">';
          row += '<td><input type="hidden" name="invoice_item_id[]"><input type="text" name="item[]" value="' + data[0].item_id + '" style="width:100px;" readonly="readonly" class="form-control"></td>';
          row += '<td><b>' + data[0].item_name + '</b><br><small>' + data[0].barcode + '</small></td>';
          row += '<td><input type="text" name="qty[]" value="' + qty + '" style="width:50px;" class="form-control"></td>';
          row += '<td><input type="text" name="bonus[]" value="0" style="width:50px;" class="form-control"></td>';
          row += '<td><input type="hidden" name="item_list_unit[]" value="' + unit + '" style="width:50px;">' + unit_name + '</td>';
          row += '<td><input type="text" name="price[]" value="' + data[0].price + '" style="width:100px;" class="form-control"></td>';
          row += '<td><input type="text" name="item_expire[]" value="' + expire + '" style="width:100px;" class="form-control"></td>';
          row += '<td><input type="text" name="item_location[]" value="' + ilocation + '" class="form-control"></td>';
          row += '<td style="vertical-align: middle;" class="text-center"><button type="button" class="btn btn-light btn-sm btn-del-item" data-id="' + data[0].item_id + '"><i class="fa fa-trash" aria-hidden="true"></i> Delete</button></td>';
          row += '</tr>';

          $('#tbl-invoice-items tbody').append(row).contents();
        }

        $('#items_arr').val(itemArr.toString());
        $('#qty_arr').val(itemQty.toString());
        $('#unit_arr').val(itemUnit.toString());
        $('#expiry_arr').val(itemExpiry.toString());
        $('#location_arr').val(itemLocation.toString());

        $('.btn-del-item').on('click', function() {
          id = $(this).data('id');

          $('#item-' + id).remove();
          row = $('#tbl-invoice-items tbody').html();
        })
      }
    })
  })
</script>