<?php

$template = str_replace('{{_COMPANY_NAME_}}', $company->company_name, $template);
$template = str_replace('{{_ADDRESS_}}', $company->address, $template);
$template = str_replace('{{_PHONE_NO_}}', $company->phone_no, $template);
$template = str_replace('{{_MOBILE_NO_}}', $company->mobile_no, $template);
$template = str_replace('{{_EMAIL_}}', $company->email, $template);
$template = str_replace('{{_FAX_}}', $company->fax, $template);
$template = str_replace('{{_LOGO_}}', base_url($company->logo), $template);
$template = str_replace('{{_WEB_}}', $company->web, $template);

$content = '';
require_once 'LabInvoiceDetails.php';
$template = str_replace('{{_INVOICE_CONTENT_}}', $content, $template);
?>
<!DOCTYPE html>
<html lang="en" class="no-bg">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="<?php echo base_url('Images/hmate.ico') ?>" />
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
    <title>Invoice Template</title>

    <style>
        html {
            background-color: whitesmoke;
        }

        body {
            width: 100%;
            font-family: Arial, sans-serif;
            overflow-x: hidden
        }

        main {
            max-width: 800px;
            background-color: white;
            box-shadow: -1px 2px 20px darkgray;
            margin: 0 auto;
        }

        .c-data {
            height: 0px !important;
        }

        .c-header {
            background: #09abd959;
            padding-top: 10px;
            padding-bottom: 10px;
            border-bottom: 2px solid #09abd9a6;
            color: #404040;
        }

        h1 {
            width: 100%;
            text-align: center;
            font-size: 1.8em;
        }

        .zd0 {
            display: block;
            overflow: hidden;
            padding: 10px;
        }

        .ztbl0 {
            width: 100%;
           
        }

        .ztbl0 thead {
            font-size: 0.9em;
        }

        .ztbl0 thead th {
            padding: 10px;
            background-color: #000000;
            color: white;
        }

        .ztbl0 tr:nth-child(even) {
          
        }

        .ztbl0 td {
            padding: 10px;
            font-size: 0.9em;
        }

        .ztd0 {
            text-align: right;
        }

        .ztd1 {
            border-top: 3px solid #7d7b7b;
        }

        .ztd2 {
            border-bottom: 3px solid #7d7b7b;
        }

        @keyframes blink {

            0%,
            100% {
                opacity: 0.6;
            }

            50% {
                opacity: 1;
            }
        }

        .btn0 {
            padding: 15px;
           
            bottom: 30px;
            right: 30px;
            font-weight: 500;
            border-radius: 5px;
            font-size: 17px;
            border: none;
            background: #656792;
            color: white;
            transition-duration: 0.2s;
            cursor: pointer;
         
            /* Use 'infinite' to keep the animation running */
        }

        .btn0:hover {
            opacity: 1;
            animation: none;
            /* Stop the animation on hover */
        }


        @media print {

            .no-print,
            .no-print * {
                display: none !important;
            }

            .no-bg {
                background-color: white;
            }

            body {
    visibility: hidden !important;
  }
  
            main{
                max-width: 100% !important;
                width: 100%;
                visibility: visible !important;
                position: absolute;
                left: 0;
                top: 0;
                box-shadow: none;
            }
        }
    </style>

</head>

<body>

    <main>
        <div  id="invoice">
        <?= $template; ?>
        </div>
        <button class="btn0 no-print" onclick="window.print()">
            <i class="fa fa-print" aria-hidden="true"></i>
            Print
        </button>
        <button class="btn0 no-print"  id="whatsappBtn">
            <i class="fa fa-whatsapp" aria-hidden="true"></i>
            Send Whatsapp
        </button>
    </main>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script>
       document.getElementById('whatsappBtn').addEventListener('click', () => {
            const { jsPDF } = window.jspdf;

            html2canvas(document.getElementById('invoice')).then(canvas => {
                const imgData = canvas.toDataURL('image/png');
                const pdf = new jsPDF();
                pdf.addImage(imgData, 'PNG', 10, 10);
                const pdfBlob = pdf.output('blob');

                // Create a FormData object to upload the PDF to the server
                const formData = new FormData();
                const uniqueFileName = `invoice_${Date.now()}.pdf`;
                formData.append('file', pdfBlob, uniqueFileName);

                // Send the PDF to the server using AJAX
                fetch('<?php echo base_url('admin/Invoice/InvoiceController/upload')  ?>', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const pdfUrl = data.url;

                        // Create the WhatsApp link
                        const customerPhone = '77393781'; // Replace with the actual phone number
                        const message = `Please find your invoice here: ${pdfUrl}`;
                        const whatsappLink = `https://wa.me/${customerPhone}?text=${encodeURIComponent(message)}`;

                        // Open the WhatsApp link
                        window.open(whatsappLink, '_blank');
                    } else {
                        console.error('Error uploading PDF:', data.error);
                    }
                })
                .catch(error => {
                    console.error('Error uploading PDF:', error);
                });
            }).catch(error => {
                console.error('Error generating PDF:', error);
            });
        });
</script>
</html>