<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Lab Result</title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <!--image crop-->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>
  <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/select.dataTables.min.css'); ?>" rel="stylesheet">
  <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/editor.dataTables.min.css'); ?>" rel="stylesheet">


  <?php require_once(APPPATH . "views/admin/header.php"); ?>
  <style>
    .small-box {
			text-decoration: none;
			color: #444444;
      transition-timing-function: ease-in-out;
      cursor: pointer;
		}

    .small-box:hover {
			text-decoration: none;
			color: #084a6ad9;
		}
    
    .small-box {
      box-shadow: 0 1px 11px 0px rgba(0, 0, 0, 0.1) !important;
    }

    .inner{
      height: 120px;
    }

    .dashboard_icon{
      color: black;
      font-size: 60px;
    }
    
    .phrma_dash_num{
      font-weight: 900;
    }
  </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <strong>Lab Result</strong>
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

   
      <section class="content">
        <!--buttons-->


        <!--//buttons-->

        <!--table-->
        <div class="box box-info">
            <div class="box-body">
                <table class="table">
                    <tr>
                        <td><strong>Patient Name : </strong><?php echo $patient->patient_name ?></td>
                        <td><strong>QID : </strong><?php echo $patient->qatar_id ?></td>
                        <td><strong>DOB : </strong><?php echo $patient->dob ?></td>
                    </tr>
                    <tr>
                        <td><strong>Nationality : </strong><?php echo $patient->nationality ?></td>
                        <td><strong>Gender : </strong><?php echo $patient->sex ?></td>
                     
                    </tr>
                </table>
            </div>
        </div>

        <div class="box box-info">

          <div class="box-body">
           
          <table class="table table-border">
            <thead>
                <tr>
                    <th>Test Name</th>
                    <th>Enter Value</th>
                    <th>Normal Value</th>
                </tr>
            </thead>
            <tbody>
                <form id="result_form">
            <?php foreach ($test_params as $test_id => $test_data): ?>
                <input type="hidden" name="case_id" value="<?php echo $case_id; ?>">

                <h5 class="p-3"><?php echo $test_data['test_name']; ?></h5>
                <?php foreach ($test_data['parameters'] as $param): ?>
                    <tr>

                  
                    <td> <?php echo $param['param_name']; ?></td>
                    <td>
                        <input
                            type="text"
                            id="param_<?php echo $test_id; ?>_<?php echo $param['param_name']; ?>"
                            name="test_results[<?php echo $test_id; ?>][<?php echo $param['param_name']; ?>]"
                            value="<?php echo htmlspecialchars($param['param_value']); ?>"
                        /></td>
                        <td>
                            <?php  if($param['max_value'] && $param['lower_value'] > 0){ echo $param['lower_value'].'&nbsp;- &nbsp;'.$param['max_value'].$param['unit_name'] ; } else{echo $param['normal_value'] ?? 'NA';}
                             ?>

                             
                        </td>
                        </tr>
                    
                <?php endforeach; ?>
            <?php endforeach; ?>
            </tbody>
        </table>
        <hr>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="">Remarks (if Any)</label>
                    <textarea name="remarks" id="" class="form-control" cols="15" rows="5"></textarea>
                </div>
            </div>
            <div class="col-md-12 d-flex justify-content-end">
            <button class="btn btn-dark save_result mr-1" data-info="no_print" type="button"><i class="fa fa-save"></i>Save Result</button>
            <a class="btn btn-success " href="<?php echo base_url('admin/Lab/LabController/print_results/'.$case_id) ?>" data-info="print" type="button"><i class="fa fa-print"></i> Print</a>
            </div>
            </form>
        </div>
        </div>
        </div>
        <!--//table-->
        


      </section>




  </div>

  <!-- ./wrapper -->


  <?php require_once(APPPATH . "views/admin/footer.php"); ?>
	<script src="<?php echo base_url('js/Services/Pharmacy/pos.js') ?>" type="text/javascript"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/dataTables.select.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/dataTables.editor.min.js'); ?>"></script>


</body>
<script>
  $(document).on('click', '[data-control=medical_click]', function(e) {

    var selected_id = e.target.id;
    var form = $('#formSubmit').val();
    var url_ = $('#form').val();

    $('#selected_id').val(selected_id);

    var URL = url_ + 'Controller/medical_book/' + selected_id;

    window.location.href = URL;

  });

  
 


</script>
<script>
        $(document).ready(function() {
            $('.save_result').click(function() {
                $btnInfo = $(this).data('info');

                var formData = $('#result_form').serialize();

                $.ajax({
                    type: 'POST',
                    url: '<?php echo site_url('admin/Lab/LabController/save_results'); ?>',
                    data: formData,
                    success: function(response) {
                       successNotification('Result Added Successfully');
                       if($btnInfo == 'print'){
                        var caseId = $('input[name="case_id"]').val();
                window.open('<?php echo site_url('admin/Lab/LabController/print_results/'); ?>' + caseId, '_blank');
                       }
                    },
                    error: function(xhr, status, error) {
                        alert('An error occurred while saving results: ' + error);
                    }
                });
            });
        });
    </script>

</html>