<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Patient</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <?php require_once(APPPATH . "views/admin/header.php"); ?>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->

    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                &nbsp;Edit Dental Treatment
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <section class="content">

            <div class="row mb-2 no-print">
                <div class="col-md-12">
                    <div class="box margin-bottom-5px" style="border: none;">
                        <div class="box-body">
                            <div class="d-flex justify-content-start">
                                <a href="<?php echo base_url('index.php/admin/Patients/PatientsController/medical_book/') . encrypt_and_url_encode($patient_id, $this) ?>" class="btn btn-dark btn-sm">
                                    <i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php print_header($this); ?>

            <div class="row">
                <div class="col-md-12">
                    <div class="box margin-bottom-5px" style="border: none;">
                        <div class="box-body">

                            <div class="d-flex justify-content-start">
                                <form role="form" action="<?php echo site_url('admin/Modules/Dental/DentalController/update'); ?>" method="post" enctype="multipart/form-data">
                                    <div class="row no-print">
                                        <div class="col-md-12 col-12">
                                            <input type="hidden" name="attendance" value="1">
                                            <div class="form-group">
                                                <label for="cheif_compalin">Chief Complaint<span class="text-red" aria-hidden="true">*</span></label>
                                                <span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                                <textarea required class="form-control" name="cheif_compalin" id="cheif_compalin" rows="3"><?= $dental->cheif_compalin ?></textarea>
                                            </div>
                                            <div class="form-group mt-2">
                                                <label for="clinical_finding">Clinical Examination and finding<span class="text-red" aria-hidden="true">*</span></label>
                                                <textarea class="form-control" name="clinical_finding" id="clinical_finding" rows="3"><?= $dental->cheif_compalin ?></textarea>
                                            </div>
                                            <div class="form-group mt-2 no-print">
                                                <label for="diagnosis_auto">Enter Diagnosis<span class="text-red" aria-hidden="true">*</span></label>
                                                <span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                               <input  class="multi_diagnosis_free form-control" data-department="1" placeholder="Enter Diagnosis" name="multi_diagnosis_free">
                                            </div>
                                            <div class="form-group mt-2 no-print">
                                                <label for="diagnosis_auto">Select Procedure<span class="text-red" aria-hidden="true">*</span></label>
                                                <span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                                <select id="procedure" class="procedure" data-department="1" placeholder="Select a procedure..." name="procedure"></select>
                                            </div>

                                            <?php
                                            date_default_timezone_set('Asia/Kuwait');
                                            $date_string = '%Y-%m-%d';
                                            $curr_date = mdate($date_string);
                                            ?>
                                            <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php echo $curr_date; ?>>
                                            <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
                                            <input type="hidden" class="form-control" name="treatement_payment_id" id="treatement_payment_id" value="<?php echo $invoice->treatement_payment_id; ?>">
                                            <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="treatment_time" class="diag-time" value="<?php echo date('H:s'); ?>">
                                                <div class="form-group">
                                                    <label for="payment_type">Mark Tooth<span class="text-danger">*</span></label>
                                                    <select id="color_type" name="color_type" required>
                                                        <?php
                                                        $query = $this->db->query("SELECT * FROM tbl_tooth_treat");
                                                        $tooth_treat = $query->result_array();
                                                        ?>
                                                    </select>
                                                    <label><small><?php echo form_error("payment_type"); ?></small></label>
                                                </div>
                                        </div>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-md-12 col-12">
                                            <div class="d-flex flex-wrap" id="selected_colors">

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-md-12">
                                            <div style="width: 100%; overflow:hidden">
                                                <?php $this->load->view('admin/Chart/tooth_svg') ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row no-print">
                                        <div class="col-md-10">
                                            <button type="button" class="btn btn-dark btn-sm" id="addRow"><i class="fa fa-plus-circle"></i> Add</button>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="panel panel-primary">
                                                <div class="panel-heading">
                                                    <h5>Treatment List</h5>
                                                </div>
                                                <table class="table table-hover display table-striped w-100" id="treatemnts">
                                                    <thead>
                                                        <tr>
                                                            <th>No</th>
                                                            <th>Primary Diagnosis</th>
                                                            <th>Treatments</th>
                                                            <th>Material Type</th>
                                                            <th>Composit</th>
                                                            <th class="teethno">Tooth No</th>
                                                            <th>Discount(QR)</th>
                                                            <th>Discount(%)</th>
                                                            <th>Fees</th>
                                                            <th class="text-center">Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $i = 0;
                                                        $arr = [];
                                                        foreach ($episodes as $key => $value) {
                                                            $i++;

                                                            $arr = array_merge($arr, explode(";", $value['full_tooth']));
                                                        ?>
                                                            <tr class="odd">
                                                                <td class="sorting_1"><?= $i ?></td>
                                                                <td>
                                                                    <?= $value['aditional_diagnostise_name'] ?>
                                                                    <input type="hidden" name="treatment_diagnosis[]" value="<?= $value['aditional_diagnostise_name'] ?>">
                                                                    <input type="hidden" name="treatment_diagnosis_id[]" value="<?= $value['diagnostise_id'] ?>">
                                                                </td>
                                                                <td>
                                                                    <?= $value['treatment_name'] ?>
                                                                    <input type="hidden" name="treat_procedure[]" value="<?= $value['procedure_id'] ?>">
                                                                    <input type="hidden" value="" name="treat_extra[]">
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="form-control" size="7" name="treat_type[]" value="<?= $value['treat_type'] ?>" class="treat_type">
                                                                </td>
                                                                <td>
                                                                    <input type="checkbox" name="composit[]" value="composit" <?= !empty($value['composit']) ? 'checked' : ''; ?> />
                                                                </td>
                                                                <td>
                                                                    <?= $value['teeth_number'] ?>
                                                                    <input type="hidden" name="treat_teeth[]" value="<?= $value['teeth_number'] ?>">
                                                                    <input type="hidden" name="full_teeth[]" value="<?= $value['full_tooth'] ?>">
                                                                </td>
                                                                <td>
                                                                    <input type="hidden" class="orgi" name="orig_price[]" value="<?= $value['orig_price'] ?>">
                                                                    <input type="text" size="7" name="discount[]" value="<?= $value['discount_qr'] ?>" class="discount form-control">
                                                                </td>
                                                                <td>
                                                                    <input type="text" size="7" name="discount_per[]" value="<?= $value['discount_per'] ?>" class="discount_per form-control">
                                                                </td>
                                                                <td>
                                                                    <input type="text" size="7" value="<?= $value['fees'] ?>" name="treat_fees[]" class="teeth_price form-control">
                                                                </td>
                                                                <td class="sorting_1 text-center">
                                                                    <button type="button" class="btn btn-light deleteRow">
                                                                        <i class="fa fa-trash"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        <?php }
                                                        $tooths = '';
                                                        $last_val = "";
                                                        $ctr = 0;
                                                        $full = [];
                                                        $array = [];
                                                        $tempss = [];
                                                        foreach ($arr as $value2) {
                                                            if ($value2 != '0' && $value2 != '') {
                                                                $temp = explode("|", $value2);
                                                                array_push($tempss, $temp);
                                                            }
                                                        }


                                                        foreach ($tempss as $value3) {
                                                            $tooths .= $value3[0] . " | " . $value3[1] . " | " . $value3[2] . "||";
                                                        }

                                                        ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                        <?php if($is_refferal==1){
                           
                           require_once(APPPATH . "views/admin/Modules/refferal.php");
                            
                            } ?>
                                            <div class="form-group">
                                                <label for="lab_test">Post Operative instructions</label>
                                                <textarea class="form-control" name="lab_test" id="lab_test" rows="3"><?= $dental->lab_test ?></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="condition">Treatmen Type</label><br>
                                                <div class="followup_div">

                                                    <label class="radio-inline">
                                                        <input type="radio" required name="followup" id="followup_0" value="0" <?php echo $invoice->followup == 0 ? 'checked' : '' ?> class="jq_followup"> New
                                                        Treatment
                                                    </label>
                                                    <label class="radio-inline">
                                                        <input type="radio" required name="followup" id="followup_1" value="1" <?php echo $invoice->followup == 1 ? 'checked' : '' ?> class="jq_followup"> FOC
                                                    </label>
                                                    <?php if($is_package==1){
                                                    
                                                    require_once(APPPATH . "views/admin/Modules/packages.php");
                                                        
                                                        } ?>
                                                </div>
                                            </div>
                                            <input name="insurance_current_id" id="insurance_current_id" type="hidden" value="123"> <!-- Replace with actual value -->
                                            <button type="submit" class="btn btn-light btn-sm" id="private_submit"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
                                            <button type="reset" class="btn btn-light btn-sm" id="clear"><i class="fa fa-times-circle"></i> Clear</button>
                                            <button type="button" onclick="window.print()" class="btn btn-light btn-sm" id="clear"><i class="fa fa-print"></i> Print</button>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label for="note">Radiological Request</label>
                                                <textarea class="form-control" name="radiological" id="radiological" rows="2"><?= $dental->radiological ?></textarea>
                                            </div>

                                            <div class="form-group">
                                                <label for="note">Note</label>
                                                <textarea class="form-control" name="note" id="note" rows="3"><?= $dental->note ?></textarea>
                                            </div>

                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>
    </div>
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>


<script>
    var default_tooth_color = '#ffffffff'
    var selected_tooths = {};
    var counter = <?= count($episodes) + 1; ?>;
    var multiDiagnosisSelect;
    var initTomSelecs;

    const tooth_sections = ['O', 'B', 'M', 'D', 'L', 'I', 'F', 'P', 'ROOT', 'SURFACE', 'SURFACE2'];

    function select_tooth(element) {

        let [treatment_color, treatment_name, full_tooth] = Cookies.get('dcolor').split('|');
        let tooth_id = element.id;
        let tooth_num = tooth_id.split('-')[0];
        full_tooth = parseInt(full_tooth);

        if (full_tooth) {
            for (const tooth_section of tooth_sections) {

                const tooth_section_id = `${tooth_num}-${tooth_section}`;
                const tooth_section_element = document.getElementById(tooth_section_id)

                if (!tooth_section_element) continue;

                tooth_section_element.querySelectorAll('path').forEach(path => path.style.fill = treatment_color);
                selected_tooths[tooth_section_id] = tooth_section_id + "|" + treatment_color + "|" + treatment_name;
            }
        } else {
            element.querySelectorAll('path').forEach(path => path.style.fill = treatment_color);
            selected_tooths[tooth_id] = tooth_id + "|" + treatment_color + "|" + treatment_name;
        }

        console.clear();
        console.log(selected_tooths, Object.keys(selected_tooths).length);
        draw_list();
    }

    function unselect_tooth(element) {
        let paths = element.querySelectorAll('path');
        paths.forEach(path => {
            path.style.fill = default_tooth_color;
        });

        delete selected_tooths[element.id];

        console.clear();
        console.log(selected_tooths, Object.keys(selected_tooths).length);
        draw_list();
    }

    function add_treatment() {
        console.log('Function triggered success..')
        let split_procedure = document.querySelector('select[name=procedure]').value.split(' | ');
        let split_diagnosis = document.querySelector('input[name=multi_diagnosis_free]').value;

        let finalvalue = '';
        let stooth = '';
        let fulltooth = '';

        console.clear();
        console.log(selected_tooths)

        for (let tooth in selected_tooths) {
            console.log(selected_tooths[tooth]);

            stooth = selected_tooths[tooth].split('|');
            finalvalue += stooth[0] + ';';
            fulltooth += selected_tooths[tooth] + ';';
            // Remove tooth hilight color
            let paths = document.getElementById(tooth).querySelectorAll('path');
            paths.forEach(path => {
                path.style.fill = default_tooth_color;
            });
        }

        if (split_diagnosis[1] == undefined) {
            errorNotification('Diagnosis Required!');
            return;
        }

        if (split_procedure[1] == undefined) {
            errorNotification('Procedure Required!');
            return;
        }

        let diagnosis = `${split_diagnosis}<input type="hidden" name="treatment_diagnosis[]" value="${split_diagnosis}"><input type="hidden" name="treatment_diagnosis_id[]" value="${split_diagnosis}">`;

        let fprice = Object.keys(selected_tooths).length * split_procedure[3];

        dataTable.row.add([
            counter,
            diagnosis,
            split_procedure[2] + '<input type="hidden" name="treat_procedure[]" value="' + split_procedure[0] + '"><input type="hidden" value="" name="treat_extra[]">',
            '<input type="text" size="7" name="treat_type[]" value="" class="treat_type form-control">',
            '<input type="checkbox" name="composit[]" value="composit" />',
            finalvalue + '<input type="hidden" name="treat_teeth[]" value="' + finalvalue + '"><input type="hidden" name="full_teeth[]" value="' + fulltooth + '">',
            '<input type="hidden" class="orgi" name="orig_price[]" value="' + fprice + '"><input type="text" size="7" name="discount[]" value="0" class="form-control discount">',
            '<input type="text" size="7" name="discount_per[]" value="0" class="form-control discount_per">',
            '<input type="text" size="7" value="' + fprice + '" name="treat_fees[]" class="form-control teeth_price">',
            '<td class="sorting_1 text-center"><div class="text-center"><button type="button" class="btn btn-light deleteRow"><i class="fa fa-trash"></i></button></div></td>',
        ]).draw(false);

        counter++;
        multiDiagnosisSelect.clear();
        initTomSelecs.clear();

        // Clear selected tooth object
        for (let t in selected_tooths) delete selected_tooths[t];
    }

    function color_selected_tooths() {
        const sample = '<?php echo $tooths; ?>';

        const arr = sample.split('||');


        for (const value of arr) {
            
            if (value == '0' || value == '') continue;
            let valsplit = value.split(' | ');

            let [tooth_section, color] = value.split(' | ');

            document.getElementById(tooth_section).querySelectorAll('path').forEach(path => path.style.fill = color);
            selected_tooths[valsplit[0]] = valsplit[0] + "|" + valsplit[1] + "|" + valsplit[2];
        }
        draw_list();
    }

    document.addEventListener("DOMContentLoaded", function() {

        const tooth_parts = document.getElementsByClassName('tooth-part');
        const context_menu_one = document.getElementsByClassName('context-menu-one');
        const add_row_btn = document.getElementById('addRow');

        Array.from(tooth_parts).forEach(e => {
            let label = e.getAttribute('inkscape:label').split('-');
            e.id = `${label[0]}-${label[2]}`;
        });

        Array.from(context_menu_one).forEach(e => {

            e.addEventListener('dblclick', function(e) {
                select_tooth(this);
            });

            e.addEventListener('click', function(e) {
                unselect_tooth(this);
            });

        });

        add_row_btn.addEventListener('click', add_treatment);
        color_selected_tooths();
    });
</script>

<script>
    $(document).ready(function() {
        var procedureElements = document.querySelectorAll('.procedure');

        var procedureCount = procedureElements.length;

        for (var i = 0; i < procedureCount; i++) {
            var currentElement = procedureElements[i];
            var departmentId = currentElement.getAttribute('data-department');
            initTomSelectProcedres(currentElement, departmentId);
        }

        var diagnosisElements = document.querySelectorAll('.multi_diagnosis');
        var diagnosisCount = diagnosisElements.length;

        for (var i = 0; i < diagnosisCount; i++) {
            var currentElement = diagnosisElements[i];
            var departmentId = currentElement.getAttribute('data-department');
            initTomSelectDiagnosis(currentElement, departmentId);
        }

    });

    var dataTable = $('#treatemnts').DataTable({
        "bFilter": false,
        "paging": false,
        "info": false
    });

    function initTomSelectProcedres(selector, departmentId) {
        initTomSelecs = new TomSelect(selector, {
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            load: function(query, callback) {
                var apiUrl = "<?php echo site_url('admin/CommenController/get_procedures?p=');
                                echo $patient_id . '&' ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

                fetch(apiUrl)
                    .then(response => response.json())
                    .then(data => {
                        callback(data);
                    })
                    .catch(() => {
                        callback();
                    });
            },
            render: {
                option: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                },
                item: function(item, escape) {
                    return '<div>' +
                        '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                }
            },
        });

        initTomSelecs.settings.minLength = 2;
    }

    function initTomSelectDiagnosis(selector, departmentId) {
        multiDiagnosisSelect = new TomSelect(selector, {
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            load: function(query, callback) {
                var apiUrl = "<?php echo site_url('admin/CommenController/get_diagnosis?'); ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

                fetch(apiUrl)
                    .then(response => response.json())
                    .then(data => {
                        callback(data);
                    })
                    .catch(() => {
                        callback();
                    });
            },
            render: {
                option: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                },
                item: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                }
            },
        });

        multiDiagnosisSelect.settings.minLength = 2;
    }

    /**
     *  OLD DENTAL CHART CODE
     * 	2024-04-14
     *  [ADD NEW TREATMENT ROW]
     */

    // var sample = '<?php //echo $tooths; 
                        ?>';
    // var arr = sample.split('||');

    // $.each(arr, function(index, value) {
    //     if (value != '0' && value != '') {
    //         var temp = value.split(' | ');
    //         if (temp[0] == 'All') {
    //             temp[0] = 's\\&p';
    //         }
    //         console.log(temp[0]);
    //         $('#' + temp[0]).children("path").attr("fill", temp[1]);
    //         $('#' + temp[0]).children("input").attr("value", temp[0] + "|" + temp[1] + "|" + temp[2]);
    //     }
    // });

    //var counter = 1;

    // $('#addRow').on('click', function() {
    //     var split_procedure = $('select[name=procedure]').val().split(' - ');
    //     var split_diagnosis = $('select[name=multi_diagnosis]').val().split(' - ');

    //     var finalvalue = '';
    //     var stooth = '';
    //     var vstooth = '';
    //     var fulltooth = '';
    //     var vtooth = '';
    //     $('input[name=tpart]').each(function() {
    //         var vstooth = $(this).attr("value");
    //         if (vstooth != 0) {
    //             stooth = vstooth.split('|');
    //             finalvalue += stooth[0] + ';';
    //         }

    //         fulltooth += vstooth + ';';
    //     });

    //     if(split_diagnosis[1] == undefined ){
    //         errorNotification('Diagnosis Required!')
    //         return
    //     }

    //     if(split_procedure[1] == undefined ){
    //         errorNotification('Procedure Required!')
    //         return
    //     }

    //     var diagnosis = split_diagnosis[1] + '<input type="hidden" name="treatment_diagnosis[]" value="' + split_diagnosis[1] + '"><input type="hidden" name="treatment_diagnosis_id[]" value="' + split_diagnosis[0] + '">';

    //     var tcount = finalvalue.split(';');
    //     var filteredtcount = tcount.filter(function(value) {
    //         return value !== '';
    //     });

    //     var num_of_teeth = tcount.length;
    //     var fprice = 1 * split_procedure[2];

    //     dataTable.row.add([
    //         '<td class="sorting_1"><button type="button" class="btn btn-sm btn-danger deleteRow"><i class="fa fa-trash"></i></button></td>',
    //         counter,
    //         diagnosis,
    //         split_procedure[1] + '<input type="hidden" name="treat_procedure[]" value="' + split_procedure[0] + '"><input type="hidden" value="" name="treat_extra[]">',
    //         finalvalue + '<input type="hidden" name="treat_teeth[]" value="' + finalvalue + '"><input type="hidden" name="full_teeth[]" value="' + fulltooth + '">',
    //         '<input type="hidden" class="orgi" name="orig_price[]" value="' + fprice + '"><input type="text" size="7" name="discount[]" value="0" class="discount">',
    //         '<input type="text" size="7" name="discount_per[]" value="0" class="discount_per">',
    //         '<input type="text" size="7" value="' + fprice + '" name="treat_fees[]" class="teeth_price">'
    //     ]).draw();

    //     counter++;
    //     $('input[name=quick_diagnosis]').val('');
    //     $('input[name=quick_procedure]').val('');
    //     $('input[name=quick_tooth]').val('');
    // });

    // $(".context-menu-one").dblclick(function() {
    //     var cookie_color = Cookies.get('dcolor');
    //     var treat_color = cookie_color.split('|');
    //     var tooth_part = $(this).attr('id');
    //     var tooth_num = tooth_part.split('-');

    //     if (treat_color[2] != 1) {
    //         $(this).children("path").attr("fill", treat_color[0]);
    //         $(this).children("input").attr("value", tooth_part + "|" + treat_color[0] + "|" + treat_color[1]);
    //     } else {
    //         $('#' + tooth_num[0] + '-O').find('path').attr("fill", treat_color[0]);
    //         $('#' + tooth_num[0] + '-O').find('input').attr("value", tooth_num[0] + "-O|" + treat_color[0] + "|" + treat_color[1]);

    //         $('#' + tooth_num[0] + '-B').find('path').attr("fill", treat_color[0]);
    //         $('#' + tooth_num[0] + '-B').find('input').attr("value", tooth_num[0] + "-B|" + treat_color[0] + "|" + treat_color[1]);

    //         $('#' + tooth_num[0] + '-M').find('path').attr("fill", treat_color[0]);
    //         $('#' + tooth_num[0] + '-M').find('input').attr("value", tooth_num[0] + "-M|" + treat_color[0] + "|" + treat_color[1]);

    //         $('#' + tooth_num[0] + '-D').find('path').attr("fill", treat_color[0]);
    //         $('#' + tooth_num[0] + '-D').find('input').attr("value", tooth_num[0] + "-D|" + treat_color[0] + "|" + treat_color[1]);

    //         $('#' + tooth_num[0] + '-L').find('path').attr("fill", treat_color[0]);
    //         $('#' + tooth_num[0] + '-L').find('input').attr("value", tooth_num[0] + "-L|" + treat_color[0] + "|" + treat_color[1]);

    //         $('#' + tooth_num[0] + '-I').find('path').attr("fill", treat_color[0]);
    //         $('#' + tooth_num[0] + '-I').find('input').attr("value", tooth_num[0] + "-I|" + treat_color[0] + "|" + treat_color[1]);

    //         $('#' + tooth_num[0] + '-F').find('path').attr("fill", treat_color[0]);
    //         $('#' + tooth_num[0] + '-F').find('input').attr("value", tooth_num[0] + "-F|" + treat_color[0] + "|" + treat_color[1]);

    //         $('#' + tooth_num[0] + '-P').find('path').attr("fill", treat_color[0]);
    //         $('#' + tooth_num[0] + '-P').find('input').attr("value", tooth_num[0] + "-P|" + treat_color[0] + "|" + treat_color[1]);
    //     }
    // });

    // $('.context-menu-one').on('click', function(e) {
    //     //alert('hidden');
    //     var clear = $(this).children("linearGradient").attr("id");
    //     $(this).children("path").attr("fill", "url(#" + clear + ")");
    //     $(this).children("input").attr("value", "0");
    //     console.log('clicked', this);
    // })

    // $('.ui-color-box-large').on('click', function() {

    //     if (navigator.cookieEnabled == true) {
    //         var data_color = $(this).attr("data-color");

    //         Cookies.set('dcolor', data_color);
    //         var cookie_color = Cookies.get('dcolor');

    //         //alert('Selected');


    //     } else {
    //         alert('Not work Cookies, please enable cookie');
    //     }

    //     //alert('hi');
    // });

    $("#color_type").on('change', function(params) {
		var  color= $(params.currentTarget.tomselect.activeOption.childNodes[0]).attr('data-color')

		if (navigator.cookieEnabled == true) {
			var data_color = color;

			Cookies.set('dcolor', data_color);
			var cookie_color = Cookies.get('dcolor');

		} else {
			alert('Not work Cookies, please enable cookie');
		}
	});


    $('body').on('keyup', '.discount', function() {
        this_td = $(this).closest('td'),
            orig_price = $(this).prev('input').val(),
            dis_per_td = this_td.next('td');
        discount_per = $(dis_per_td).find('input').val(),
            fees_td = dis_per_td.next('td');
        fees = $(fees_td).find('input').val(),
            discount = Number($(this).val()).toFixed(2);

        dis_per_td.find('input').val(Number((discount * 100 / orig_price))); //discount_per
        fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
    });

    $('body').on('keyup', '.discount_per', function() {
        this_td = $(this).closest('td'),
            dis_td = this_td.prev('td'),
            orig_price = $(dis_td).find('input').val(),
            discount = $(dis_td).find('input').next().val(),
            fees_td = this_td.next('td');
        fees = $(fees_td).find('input').val(),
            discount_per = Number($(this).val()).toFixed(2);

        dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
        fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
    });

    $('body').on('keyup', '.teeth_price', function() {
        this_td = $(this).closest('td'),
            dis_per_td = this_td.prev('td');
        discount_per = $(dis_per_td).find('input').val(),
            dis_td = dis_per_td.prev('td'),
            orig_price = $(dis_td).find('input').val(),
            discount = $(dis_td).find('input').next().val(),
            fees = Number($(this).val()).toFixed(2);

        dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
        dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
        // dis_td.find('.orgi').val(fees);
    });

    $('body').on("click", ".deleteRow", function(e) {
        dataTable.row($(this).parents('tr')).remove().draw();
        return false;
    });

    color_select = new TomSelect('#color_type', {
        valueField: 'id',
        searchField: 'title',
        options: [
            <?php foreach ($tooth_treat as $ol) {
                echo '{
						id: "' . $ol['treat_id'] . '",
						title: "' . $ol['treatname'] . '",
						color: "' . $ol['color'] . '",
						select: "' . $ol['full_select'] . '"
					},';
            }; ?>
        ],
        render: {
            option: function(data, escape) {
                return '<div>' +
                    '<div class="ui-color-box-large" style="background-color: ' + escape(data.color) + '" data-color="' + escape(data.color) + '|' + escape(data.title) + '|' + escape(data.select) + '"></div>' +
                    '<span class="title">' + escape(data.id) + '</span>' +
                    '<span class="url">' + escape(data.title) + '</span>' +
                    '</div>';
            },
            item: function(data, escape) {
                return '<div title="' + escape(data.id) + '">' +
                    '<div class="ui-color-box-large" style="background-color: ' + escape(data.color) + '" data-color="' + escape(data.color) + '|' + escape(data.title) + '|' + escape(data.treat_id) + '"></div>' + escape(data.title) + '</div>';
            }
        }
    });

    function draw_list() {
        var main_content = '';
        var uniqueTitles = {};

        for (let drw_tooth in selected_tooths) {
            var title = selected_tooths[drw_tooth].split('|');
            
            var combination = title[1] + '|' + title[2];
            if (!uniqueTitles[combination]) {
                main_content += '<div class="col-md-3 col-3 d-flex">' +
                    '<div class="ui-color-box-large" style="background-color: ' + title[1] + '" ></div>' + title[2] +
                    '</div>';

                uniqueTitles[combination] = true;
            }
        }

        $('#selected_colors').html(main_content);

    }
</script>

</html>