<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Patient</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <?php require_once(APPPATH . "views/admin/header.php"); ?>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->

    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                &nbsp;Edit OB-GYN Treatment
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <section class="content">

        <div class="row mb-2">
				<div class="col-md-12">
					<div class="box margin-bottom-5px" style="border: none;">
						<div class="box-body">
							<div class="d-flex justify-content-start">
								<a href="<?php echo base_url('index.php/admin/Patients/PatientsController/medical_book/') . encrypt_and_url_encode($patient_id, $this) ?>" class="btn btn-dark btn-sm">
									<i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>

            <?php print_header($this); ?>
            <form role="form" action="<?= base_url('index.php/admin/Modules/OBGYN/OBGYNController/update'); ?>" method="post" enctype="multipart/form-data" id="ent_submit">
                <?php
                date_default_timezone_set('Asia/Kuwait');
                $date_string = '%Y-%m-%d';
                $curr_date = mdate($date_string);
                ?>
                <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php echo $curr_date; ?>>
                <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
                <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="treatment_time" class="diag-time" value="<?php echo date('H:s'); ?>">
                <input type="hidden" class="form-control" name="treatement_payment_id" id="treatement_payment_id" class="diag-time" value="<?php echo $treatment_payment_id; ?>">

                <?php
                date_default_timezone_set('Asia/Kuwait');
                $date_string = '%Y-%m-%d';
                $curr_date = mdate($date_string);

                $query = $this->db->query("SELECT * FROM tbl_nurse_triage WHERE treatment_id = '$treatment_payment_id' AND treatment_id = '$treatment_payment_id' ORDER BY triage_id DESC LIMIT 1");
                $details = $query->row();

                if ($details) {

                    $weight = $details->weight;
                    $height = $details->height;
                    $bmi = $details->bmi;
                    $bp = $details->bp;
                    $temperature = $details->temperature;
                    $pulse = $details->pulse;
                    $rr = $details->rr;
                } else {

                    $weight = "";
                    $height = "";
                    $bmi = "";
                    $bp = "";
                    $temperature = "";
                    $pulse = "";
                    $rr = "";
                }
                ?>


                <div class="box  box-info">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-12">
                                <form role="form" id="gyne_form" action="<?= base_url('index.php/admin/Modules/OBGYN/OBGYNController/update'); ?>" method="post" enctype="multipart/form-data">
                                    <input name="insurance_current_id" id="insurance_current_id" type="hidden" value="<?php echo $insurance_id; ?>">
                                    <section class="gyane-record">
                                        <div class="form-group <?php echo (form_error('date') == '') ? '' : ' has-error'; ?>">
                                            <label for="app_date">Treatment Date</label>
                                            <input type="text" class="form-control select_date" name="treatment_date_gyne" id="treatment_date_gyne" value="<?php echo date('Y-m-d'); ?>">
                                            <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="c" class="diag-time" value="<?php echo date('H:s'); ?>">
                                            <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">


                                            <?php echo form_error('date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Present Complaints</label>
                                                <textarea class="form-control comments-1" cols="6" rows="5" value="" name="present_complaints" id="present_complaints"><?= $present_complaints ?? ''; ?></textarea>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="row mt-2">
                                            <div class="col-md-12">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label>Menstrual History :</label>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="d-flex flex-row justify-content-end">
                                                            <label class="mr-2">L.M.P. :</label>
                                                            <input type="text" style="max-width: 300px;" class="form-control lmp-date para-text" name="lmp" id="lmp" value="<?= $lmp ?? ''; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mt-2">
                                                    <div class="col-md-12">
                                                        <textarea class="form-control comments-1" cols="6" rows="5" name="menstrual" id="menstrual"><?= $menstrual ?? ''; ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Menarche</label>
                                                <input type="text" placeholder="" class="form-control" value="<?= $menarche ?? ''; ?>" name="menarche" id="menarche">
                                            </div>
                                        </div>

                                        <hr>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Obstetric history</label>
                                                <textarea class="form-control comments-1" cols="6" rows="5" name="obstetric" id="obstetric"><?= $obstetric ?? ''; ?></textarea>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Urinary symptoms: </label>
                                                <textarea class="form-control comments-1" cols="6" rows="5" name="urinary_symptoms" id="urinary_symptoms"><?= $urinary_symptoms ?? ''; ?></textarea>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Alimentary symtoms :</label>
                                                <input type="text" placeholder="" class="form-control" value="<?= $alimentary_symtoms ?? ''; ?>" name="alimentary_symtoms" id="alimentary_symtoms">
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Contraception methods</label>
                                                <textarea class="form-control comments-1" cols="6" rows="5" name="contraception_methods" id="contraception_methods"><?= $contraception_methods ?? ''; ?></textarea>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Marital history</label>

                                                <textarea class="form-control comments-1" cols="6" rows="5" name="marital_history" id="marital_history"><?= $marital_history ?? ''; ?></textarea>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Previous medical and surgical history</label>
                                                <textarea class="form-control comments-1" cols="6" rows="5" name="pre_medi" id="pre_medi"><?= $pre_medi ?? ''; ?></textarea>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Family History</label>
                                                <textarea placeholder="" class="form-control comments-1" cols="6" rows="5" value="" name="complaints" id="complaints"><?= $complaints ?? ''; ?></textarea>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Allergies</label>
                                                <textarea placeholder="" class="form-control comments-1" cols="6" rows="5" value="" name="allergies" id="allergies"><?= $allergies ?? ''; ?></textarea>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Drugs</label>
                                                <textarea placeholder="" class="form-control comments-1" cols="6" rows="5" value="" name="drugs" id="drugs"><?= $drugs ?? ''; ?></textarea>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <h3><b>Physical Examination</b></h3>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">

                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <label>General</label>
                                                        <input type="text" placeholder="" class="form-control" value="<?= $general_pe ?? ''; ?>" name="general_pe" id="general_pe">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label>BP</label>
                                                        <input type="text" placeholder="" class="form-control" value="<?= $bp_pe ?? ''; ?>" name="bp_pe" id="bp_pe">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label>Height</label>
                                                        <input type="text" placeholder="" class="form-control" value="<?= $height_pe ?? ''; ?>" name="height_pe" id="height_pe">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label>Weight</label>
                                                        <input type="text" placeholder="" class="form-control" value="<?= $weight_pe ?? ''; ?>" name="weight_pe" id="weight_pe">
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <label>Breast</label>
                                                        <textarea placeholder="" class="form-control" cols="6" rows="5" value="" name="breast_pe" id="breast_pe"><?= $breast_pe ?? ''; ?></textarea>
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="col-md-6">
                                                <label>Investigation</label>
                                                <textarea placeholder="" class="form-control" cols="6" rows="8" value="" name="investigation" id="investigation"><?= $investigation ?? ''; ?></textarea>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <h3><b>Vaginal Exam</b></h3><br>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <label>Vulva</label>
                                                <input type="text" placeholder="" class="form-control" value="<?= $vulva ?? ''; ?>" name="vulva" id="vulva"><br>
                                                <label>Introitus</label>
                                                <input type="text" placeholder="" class="form-control" value="<?= $introitus ?? ''; ?>" name="introitus" id="introitus"><br>
                                                <label>Vagina</label>
                                                <input type="text" placeholder="" class="form-control" value="<?= $vagina ?? ''; ?>" name="vagina" id="vagina"><br>
                                                <label>Cervix</label>
                                                <input type="text" placeholder="" class="form-control" value="<?= $cervix ?? ''; ?>" name="cervix" id="cervix"><br>
                                                <label>Uterus</label>
                                                <input type="text" placeholder="" class="form-control" value="<?= $uterus ?? ''; ?>" name="uterus" id="uterus"><br>
                                                <label>Appendage R.</label>
                                                <input type="text" placeholder="" class="form-control" value="<?= $apendage_r ?? ''; ?>" name="apendage_r" id="apendage_r"><br>
                                                <label>Appendage L.</label>
                                                <input type="text" placeholder="" class="form-control" value="<?= $apendage_l ?? ''; ?>" name="apendage_l" id="apendage_l"><br>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-offset-4 col-md-3">
                                                        <label>Smear taken</label>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="new-rb">Yes
                                                            <input type="radio" <?= isset($smeartaken) && $smeartaken == 1 ? 'checked' : ''; ?> name="smeartaken" id="inlineRadio1" value="1" class="radio_heart_disease">
                                                            <span class="checkmark-rd"></span>
                                                        </label>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="new-rb">No
                                                            <input type="radio" <?= isset($smeartaken) && $smeartaken == 2 ? 'checked' : ''; ?> name="smeartaken" id="inlineRadio1" value="2" class="radio_heart_disease">
                                                            <span class="checkmark-rd"></span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-offset-4 col-md-3">
                                                        <label>Swab taken</label>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="new-rb">Yes
                                                            <input type="radio" <?= isset($swabtaken) && $swabtaken == 1 ? 'checked' : ''; ?> name="swabtaken" id="inlineRadio1" value="1" class="radio_heart_disease">
                                                            <span class="checkmark-rd"></span>
                                                        </label>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="new-rb">No
                                                            <input type="radio" <?= isset($swabtaken) && $swabtaken == 2 ? 'checked' : ''; ?> name="swabtaken" id="inlineRadio1" value="2" class="radio_heart_disease">
                                                            <span class="checkmark-rd"></span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-offset-4 col-md-3">
                                                        <label>Coli visible</label>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="new-rb">Yes
                                                            <input type="radio" <?= isset($colivisible) && $colivisible == 1 ? 'checked' : ''; ?> name="colivisible" id="inlineRadio1" value="1" class="radio_heart_disease">
                                                            <span class="checkmark-rd"></span>
                                                        </label>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="new-rb">No
                                                            <input type="radio" <?= isset($colivisible) && $colivisible == 2 ? 'checked' : ''; ?> name="colivisible" id="inlineRadio1" value="2" class="radio_heart_disease">
                                                            <span class="checkmark-rd"></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <label>Provisional diagnosis</label>

                                                <textarea placeholder="" class="form-control" cols="6" rows="8" value="" name="provisional_diagnosis" id="provisional_diagnosis"><?= isset($provisional_diagnosis) ? $provisional_diagnosis : ''; ?></textarea>
                                            </div>
                                            <div class="col-md-6">
                                                <label>Made by</label>

                                                <textarea placeholder="" class="form-control" cols="6" rows="8" value="" name="made_by" id="made_by"><?= isset($made_by) ? $made_by : ''; ?></textarea>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Investigation and Management</label>
                                                <textarea placeholder="" class="form-control" cols="6" rows="8" value="" name="investigation_pe" id="investigation_pe"><?= isset($investigation_pe) ? $investigation_pe : ''; ?></textarea>
                                            </div>
                                        </div>
                                    </section>

                                    <div class="row mt-2">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="drugs">Select Diagnosis</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                                <input type="text" class="multi_diagnosis" name="diagnosis_gynes" id="diagnosis_gynes">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mt-2">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="name">Select Procedure</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                                <select class="procedure" data-department="6" name="gyne_diags" id="gyne_diags">
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-dark btn-sm" id="addRow_gynes"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
                                            <!-- <button type="button" class="btn btn-default btn-danger" id="deleteRow_gynes">Remove</button> -->
                                        </div>
                                    </div>

                                    <div class="row mt-2">
                                        <div class="col-md-12">
                                            <div class="panel panel-primary">
                                                <label class="panel-heading">
                                                    <h5>Treatment List</h5>
                                                </label>
                                                <table class="table table-hover table-bordered display table-striped w-100" id="treatemnts_gynes">
                                                    <thead>
                                                        <tr>
                                                            <th>No</th>
                                                            <th>Diagnosis</th>
                                                            <th>Treatment</th>
                                                            <th>Discount(QR)</th>
                                                            <th>Discount(%)</th>
                                                            <th>Fees</th>
                                                            <th class="text-center">Actions</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $i = 0; foreach ($episodes as $row) { $i++; ?>
    <tr>
        <td class="sorting_1"><?= $i ?></td>
        <td><?php echo $row['aditional_diagnostise_name']; ?><input type="hidden" name="gyne_diagnosis_name[]" value="<?php echo $row['aditional_diagnostise_name']; ?>"><input type="hidden" name="gyne_diagnosis_id[]" value="<?php echo $row['diagnostise_id']; ?>"></td>
        <td><?php echo $row['treatment_name']; ?><input type="hidden" name="gyne_treatment_name[]" value="<?php echo $row['treatment_name']; ?>"><input type="hidden" name="gyne_treatment_id[]" value="<?php echo $row['procedure_id']; ?>"></td>
        <td><input type="hidden" class="orgi " name="orig_price[]" value="<?php echo $row['fees']; ?>"><input type="text" size="7" name="discount[]" class="form-control discount_gyne" value="<?php echo $row['discount_qr']; ?>" ></td>
        <td><input type="text" class="form-control discount_per_gyne" size="7" name="discount_per[]" value="<?php echo $row['discount_per']; ?>" ></td>
        <td><input type="text" class="form-control" name="fees_gyne[]" size="7" value="<?php echo ($row['fees'] - $row['discount_qr']); ?>"></td>
        <td><button type="button" class="btn btn-dark btn-xs deleteRow_gynes"><i class='fa fa-trash'></i></button></td>
    </tr>
<?php } ?>
</tbody>
                                                    
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="d-flex flex-row justify-content-end">
                                                <button type="submit" class="btn btn-dark btn-sm" id="gyne_submit"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
                                                <button type="button" onclick="window.print()" class="btn btn-light" id="clear"><i class="fa fa-print"></i>Print</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>

                    </div>
                </div>


        </section>
    </div>
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>
    <script src="<?php echo base_url('js/Modules/gyne.js') ?>" type="text/javascript"></script>

</body>
<script>
    var counter = <?= count($episodes) + 1; ?>;
    $(document).ready(function() {
        var procedureElements = document.querySelectorAll('.procedure');

        var procedureCount = procedureElements.length;

        for (var i = 0; i < procedureCount; i++) {
            var currentElement = procedureElements[i];
            var departmentId = currentElement.getAttribute('data-department');
            initTomSelectProcedres(currentElement, departmentId);
        }

        var diagnosisElements = document.querySelectorAll('.multi_diagnosis');
        var diagnosisCount = diagnosisElements.length;

        for (var i = 0; i < diagnosisCount; i++) {
            var currentElement = diagnosisElements[i];
            var departmentId = currentElement.getAttribute('data-department');
            initTomSelectDiagnosis(currentElement, departmentId);
        }

    });

    $('.drugs').on("focus", function() {
        $(this).autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_drugs'); ?>",
                    dataType: "json",
                    data: {
                        name_startsWith: request.term,
                        type: 'drug'
                    },
                    success: function(data) {
                        response($.map(data, function(item) {
                            return {
                                label: item,
                                value: item
                            }
                        }));
                    }
                });
            },
            autoFocus: false,
            minLength: 2
        });
    });

    function initTomSelectProcedres(selector, departmentId) {
        var initTomSelecs = new TomSelect(selector, {
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            load: function(query, callback) {
                var apiUrl = "<?php echo site_url('admin/CommenController/get_procedures?p=');
                                echo encrypt_and_url_encode($patient_id, $this) . '&' ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

                fetch(apiUrl)
                    .then(response => response.json())
                    .then(data => {
                        callback(data);
                    })
                    .catch(() => {
                        callback();
                    });
            },
            render: {
                option: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                },
                item: function(item, escape) {
                    return '<div>' +
                        '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                }
            },
        });

        initTomSelecs.settings.minLength = 2;
    }

    function initTomSelectDiagnosis(selector, departmentId) {
        var multiDiagnosisSelect = new TomSelect(selector, {
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            load: function(query, callback) {
                var apiUrl = "<?php echo site_url('admin/CommenController/get_diagnosis?'); ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

                fetch(apiUrl)
                    .then(response => response.json())
                    .then(data => {
                        callback(data);
                    })
                    .catch(() => {
                        callback();
                    });
            },
            render: {
                option: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                },
                item: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                }
            },
        });

        multiDiagnosisSelect.settings.minLength = 2;
    }

</script>

</html>