<h4 class="page-header ui-page-header">Prescription</h4>

<div class="panel-body">
    <?php
    $query = $this->db->query("SELECT * FROM tbl_patients WHERE patient_id = '$patient_id'");
    $result = $query->row();
    ?>
    <form role="form"  id="prescription-form" action="<?= base_url('index.php/admin/Modules/Prescription/PrescriptionController/insert_prescription'); ?>" method="post" enctype="multipart/form-data">

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="patient_id">Select Patient</label>
                    <input type="text" class="form-control" name="p_id" id="p_id" disabled value="<?= $result->patient_id . ' - ' . $result->patient_name; ?>">
                    <input type="hidden" name="patient_id" value="<?= $result->patient_id . ' - ' . $result->patient_name; ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="patient_id">Select Diagnosis</label>
                    <input type="text" class="multi_diagnosis_prescription form-control" name="diagnosis_auto" id="diagnosis_auto">
                </div>
            </div>
        </div>

        <div class="row mt-2">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="drugs">Select Drugs</label>
                    <input type="text" class="form-control drugs-prescription" name="drugs" id="">
                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <label for="drugs">Doses</label>
                    <!-- <input type="text" class="form-control ent_doses_auto" name="drug_qty" id="drug_qty"> -->
                    <input type="text" class="form-control" name="drug_qty" id="drug_qty">
                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <label for="meal">Frequency</label></br>
                    <!-- <input type="text" class="form-control ent_frequency_auto" name="drug_meal" id="drug_meal"> -->
                    <input type="text" class="form-control" name="drug_meal" id="drug_meal">
                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <label for="drugs">Duration(Days)</label>
                    <div class="input-group">
                        <!-- <input type="text" class="form-control ent_duration_auto" name="drug_note" id="drug_note"> -->
                        <input type="text" class="form-control" name="drug_duration" id="drug_duration">
                        
                    </div>
                </div>
            </div>
             <div class="col-md-3">
                <div class="form-group">
                        <label for="meal">Note</label>
                        <div class="input-group">
                        <!-- <input type="text" class="form-control ent_duration_auto" name="drug_note" id="drug_note"> -->
                        <input type="text" class="form-control" name="drug_note" id="drug_note">
                        <span class="input-group-addon">
                             <button type="button" class="btn btn-light  ml-1" id="add_prescription_item"><i class="fa fa-plus-circle" aria-hidden="true"></i></button>
                             <button type="button" class="btn btn-light clear_field" id="clear_field"><i class="fa fa-trash" aria-hidden="true"></i></button>
                        </span>
                    </div>
                    <!-- <input type="text" class="form-control ent_frequency_auto" name="drug_meal" id="drug_meal"> -->
                    
            </div></div>
            <!--<div class="col-md-2">-->
            <!--    <div class="form-group"></br>-->
            <!--        <span class="input-group-addon">-->
            <!--                <button type="button" class="btn btn-light  ml-1" id="add_prescription_item"><i class="fa fa-plus-circle" aria-hidden="true"></i></button>-->
            <!--                <button type="button" class="btn btn-light clear_field" id="clear_field"><i class="fa fa-trash" aria-hidden="true"></i></button>-->
            <!--            </span>-->
            <!--    </div>-->
            <!--</div>-->
        </div>

        <div class="input_fields_wrap">

        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="d-flex flex-row justify-content-end">
                    <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
                    <button type="button" class="btn btn-light btn-sm ml-1" id="prescription-clear"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
                </div>
            </div>
        </div>

    </form>

    <hr>

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <h5>Prescription List</h5>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <?php

                        $this->db->select('*');
                        $this->db->from('tbl_prescription_main');
                        $this->db->where('tbl_prescription_main.patient_id', $patient_id);
                        $this->db->where('deleted_at is NULL');
                        $this->db->order_by('tbl_prescription_main.prescription_main_id', 'DESC');
                        $this->db->limit(3);
                        $query = $this->db->get();

                        $prescription = $query->num_rows() > 0 ? $query->result_array() : FALSE;


                        if ($prescription != FALSE) :
                            $i = 1;
                            foreach ($prescription as $value) :
                                $id = $value['prescription_main_id'];
                                $patient_id = $value['patient_id'];
                        ?>
                                <div>
                                    <strong class="text-danger"><?= "Prescription " . $i . " - " . date("d/m/Y", strtotime($value['enter_date'])); ?></strong>
                                    <a class="btn btn-light btn-sm ml-1" href="<?= base_url('index.php/admin/Modules/Prescription/PrescriptionController/print_patient_prescription/' . encrypt_and_url_encode($id, $this) . "/" . encrypt_and_url_encode($patient_id, $this)); ?>"><i class="fa fa-eye" aria-hidden="true"></i> View </a>
                                </div>

                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <th width="20%">Drug Name</th>
                                        <th width="20%">Doses</th>
                                        <th width="20%">Frequency</th>
                                        <th width="20%">Duration(Days)</th>
                                        <th width="20%">Notes</th>
                                        <th width="8%" class="text-center">Actions</th>
                                    </thead>
                                    <tbody>

                                        <?php
                                        $query = $this->db
                                            ->select('tbl_prescription.drug_name,tbl_prescription.drug_duration, tbl_prescription.prescription, tbl_prescription.drug_qty, tbl_prescription.drug_note, tbl_prescription.after_before')
                                            ->from('tbl_prescription')
                                            ->join('tbl_drugs_list', 'tbl_prescription.drug_id = tbl_drugs_list.drug_id', 'left')
                                            ->where('tbl_prescription.prescription_main_id', $id)
                                            ->get();

                                        $prescription_data = $query->result_array();

                                        foreach ($prescription_data as $value) : ?>
                                            <tr>
                                                <td><?php echo $value['drug_name']; ?></td>
                                                <td><?php echo $value['drug_qty']; ?></td>
                                                <td><?php echo $value['after_before']; ?></td>
                                                <td><?php echo $value['drug_duration']; ?></td>
                                                <td><?php echo $value['drug_note']; ?></td>

                                                <td>
                                                    <div class="d-flex flex-row">
                                                        <a class="btn btn-light btn-sm ml-1" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Modules/Prescription/PrescriptionController/prescription_delete/' . encrypt_and_url_encode($id, $this) . '/' . encrypt_and_url_encode($patient_id, $this)); ?>')" href="#" role="button"><i class="fa fa-trash" aria-hidden="true"></i> Delete
                                                        </a>
                                                    </div>

                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            <?php
                                $i++;
                            endforeach;
                            ?>
                        <?php else : ?>
                            <p>No Records</p>
                        <?php endif; ?>
                    </div>
                </div>


            </div>

        </div>
    </div>

</div>


<script>
    $(document).ready(function() {
        $('.ent_duration_auto').on("focus", function() {
            $(this).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "<?= base_url('index.php/admin/Modules/Prescription/PrescriptionController/get_auto_complete'); ?>",
                        dataType: "json",
                        data: {
                            name_startsWith: request.term,
                            category_id: 8,
                            type: 'diagnosis'
                        },
                        success: function(data) {
                            response($.map(data, function(item) {
                                return {
                                    label: item,
                                    value: item
                                }
                            }));
                        }
                    });
                },
                autoFocus: false,
                minLength: 1
            });
        });

        $('.ent_frequency_auto').on("focus", function() {
            $(this).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "<?= base_url('index.php/admin/Modules/Prescription/PrescriptionController/get_auto_complete'); ?>",
                        dataType: "json",
                        data: {
                            name_startsWith: request.term,
                            category_id: 7,
                            type: 'diagnosis'
                        },
                        success: function(data) {
                            response($.map(data, function(item) {
                                return {
                                    label: item,
                                    value: item
                                }
                            }));
                        }
                    });
                },
                autoFocus: false,
                minLength: 1
            });
        });

        $('.ent_doses_auto').on("focus", function() {
            $(this).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "<?= base_url('index.php/admin/Modules/Prescription/PrescriptionController/get_auto_complete'); ?>",
                        dataType: "json",
                        data: {
                            name_startsWith: request.term,
                            category_id: 6,
                            type: 'diagnosis'
                        },
                        success: function(data) {
                            response($.map(data, function(item) {
                                return {
                                    label: item,
                                    value: item
                                }
                            }));
                        }
                    });
                },
                autoFocus: false,
                minLength: 1
            });
        });

        function split(val) {
            return val.split(/,\s*/);
        }

        function extractLast(term) {
            return split(term).pop();
        }

        $(".multi_diagnosis_prescription")
            // don't navigate away from the field on tab when selecting an item
            .on("keydown", function(event) {
                if (event.keyCode === $.ui.keyCode.TAB &&
                    $(this).autocomplete("instance").menu.active) {
                    alert('a');
                    event.preventDefault();
                }
            })
            .autocomplete({
                minLength: 1,
                source: function(request, response) {
                    // delegate back to autocomplete, but extract the last term
                    $.getJSON("<?= base_url('index.php/admin/Modules/Prescription/PrescriptionController/get_diagnosis_multi'); ?>", {
                        term: extractLast(request.term)
                    }, response);
                },
                focus: function() {
                    // prevent value inserted on focus
                    return false;
                },
                select: function(event, ui) {
                    var terms = split(this.value);
                    // remove the current input
                    terms.pop();
                    // add the selected item
                    terms.push(ui.item.value);
                    // add placeholder to get the comma-and-space at the end
                    terms.push("");
                    this.value = terms.join(", ");
                    return false;
                }
            });

            var selectedDrugItem =false;
        $('.drugs-prescription').on("focus", function() {
            $(this).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "<?= base_url('index.php/admin/Modules/Prescription/PrescriptionController/get_drugs'); ?>",
                        dataType: "json",
                        data: {
                            name_startsWith: request.term,
                            type: 'drug'
                        },
                        success: function(data) {
                            response($.map(data, function(item) {
                                return {
                                    label: item,
                                    value: item
                                }
                            }));
                        }
                    });
                },
                autoFocus: false,
                minLength: 2,
                select: function(event, ui) {
                    selectedDrugItem = true; // Set the flag to true when an item is selected
            $(this).val(ui.item.value);
        },
        change: function(event, ui) {
            if (!selectedDrugItem) { // If no item was selected, clear the input
                $(this).val('');
                alert("Please select a drug from the list.");
            }
            selectedDrugItem = false; // Reset the flag after change
        }
            });
        });

        var max_fields = 10; //maximum input boxes allowed
        var wrapper = $(".input_fields_wrap"); //Fields wrapper
        var add_button_pres = $("#add_prescription_item"); //Add button ID

        var x = 1; //initlal text box count
        $(add_button_pres).on('click', function(e) { //on add input button click
           
            var drug = $('input[name=drugs]').val().split(' - ');;
            var drug_qty = $('input[name=drug_qty]').val();
            var meal = $('input[name=drug_meal]').val();
            var drug_note = $('input[name=drug_note]').val();
            var drug_duration = $('input[name=drug_duration]').val();


      

            if ($('input[name=drugs]').val().indexOf('-') == -1) {
                var diagnosis = '<input type="text" class="form-control drugs" name="drug[]" value="' + drug[1] + '" id="drugs" disabled>' + '<input type="hidden" class="form-control drugs" name="drug_name[]" value="' + drug[1] + '"><input type="hidden" class="form-control drugs" name="drug_id[]" value=""><input type="hidden" class="form-control drugs" name="bill_items_id[]" value="" id="drugs">';
            } else {
                var diagnosis = '<input type="text" class="form-control drugs" name="drug[]" value="' + drug[1] + '" id="drugs" disabled>' + '<input type="hidden" name="drug_name[]" value="' + drug[1] + '"><input type="hidden" name="drug_id[]" value="' + drug[0] + '"><input type="hidden" class="form-control drugs" name="bill_items_id[]" value="' + drug[2] + '" id="drugs">';
            }
            if ($('input[name=drugs]').val().length === 0) {
                    alert("Please select drugs");
                    return false;
            }

            var treat = '<div class="xys row">\
                <div class="col-md-3">\
                  <div class="form-group">' +
                diagnosis +
                '</div>\
                </div>\
                <div class="col-md-2">\
                  <div class="form-group">\
                     <input type="text" class="form-control" name="drugs_qty[]" value="' + drug_qty + '" id="drug_qty" disabled>\
                     <input type="hidden" class="form-control" name="drugs_qty[]" value="' + drug_qty + '" id="drug_qty" >\
                  </div>\
                </div>\
                <div class="col-md-2">\
                  <div class="form-group">\
                    <input type="text" class="form-control" name="meals[]" value="' + meal + '" id="meal" disabled>\
                    <input type="hidden" class="form-control" name="meals[]" value="' + meal + '" id="meal">\
                  </div>\
                </div>\
                <div class="col-md-2">\
                  <div class="form-group">\
                    <input type="text" class="form-control" name="drug_duration[]" value="' + drug_duration + '" id="meal" disabled>\
                    <input type="hidden" class="form-control" name="drug_duration[]" value="' + drug_duration + '" id="meal">\
                  </div>\
                </div>\
                <div class="col-md-3">\
                    <div class="input-group">\
                      <input type="text" class="form-control" name="drug_notes[]" value="' + drug_note + '" id="drug_note" disabled>\
                      <input type="hidden" class="form-control" name="drug_notes[]" value="' + drug_note + '" id="drug_note">\
                      <span class="input-group-addon ml-1">\
                      <button type="button" class="btn btn-light remove_field" id="remove_drug"><i class="fa fa-trash" aria-hidden="true"></i></button>\
                      </span>\
                  </div>\
                </div>\
            </div>';

            $(wrapper).append(treat); //add input box

            var drug = $('input[name=drugs]').val('');
            var drug_qty = $('input[name=drug_qty]').val('');
            var drug_note = $('input[name=drug_note]').val('');
            var drug_note = $('input[name=drug_meal]').val('');
            var drug_duration = $('input[name=drug_duration]').val('');

            return false;

        });

        $(wrapper).on("click", ".remove_field", function(e) {
            $(this).parent().parent().parent().parent().remove();
            return false;
        });

        $('.clear_field').on('click', function(e) {
            var drug = $('input[name=drugs]').val('');
            var drug_qty = $('input[name=drug_qty]').val('');
            var drug_note = $('input[name=drug_note]').val('');
            var drug_note = $('input[name=drug_meal]').val('');
            return false;
        });

        $("#patient_id").autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: "<?= base_url('patient/get_patients'); ?>",
                    dataType: "json",
                    data: {
                        name_startsWith: request.term,
                        type: 'patient_id'
                    },
                    success: function(data) {
                        response($.map(data, function(item) {
                            return {
                                label: item,
                                value: item
                            }
                        }));
                    }
                });
            },
            autoFocus: false,
            minLength: 3
        });

        $('#prescription-form').submit(function(event) {
            event.preventDefault();
            if ($('input[name="drug[]"]').val() === undefined) {
                alert("You cannot save please click the + button");
                return false;
            }else{
              
        Swal.fire({
			title: "Are you sure?",
			text: "You won't be able to edit this!",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Yes, create it!"
		}).then((result) => {
            if (result.isConfirmed) {
                event.target.submit();
            }
		});
            }
        });

    });

    /* OCR Auto fill*/
    $("#auto_fill").change(function() {
        if (this.checked) {
            $('#patient_name').val($("input[name=patient_name_hidden]").val());
            $('#qatar_id').val($("input[name=qatar_id_hidden]").val());
            $('#dob').val($("input[name=dob_hidden]").val());
        }
    });

    $('#prescription-clear').on('click', function(){
        $('.input_fields_wrap').html('');
        console.log('worked');
    });

    function warn_before_save(event){
        event.preventDefault();
        Swal.fire({
			title: "Are you sure?",
			text: "You won't be able to edit this!",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Yes, create it!"
		}).then((result) => {
            if (result.isConfirmed) {
                event.target.submit();
            }
		});
    }
</script>