<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<title>Patient</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

	<!--image crop-->
	<link href="<?php echo base_url('plugins/croppie/croppie.css') ?>" rel="stylesheet" type="text/css" />
	<link href="<?php echo base_url('css/fileupload.css') ?>" rel="stylesheet" type="text/css" />
	<script src="<?php echo base_url('plugins/croppie/croppie.js') ?>" type="text/javascript"></script>
	<!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" /> -->
	<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script> -->
	<script src="<?php echo base_url('js/Marker2.js') ?>"></script>
	<link rel="stylesheet" href="<?= base_url('css/jquery-ui.css') ?>">
	<?php require_once(APPPATH . "views/admin/header.php"); ?>
	
	<style media="print">
		body * {
			display: none;
		}

		.modalImage {
			display: block !important;
		}
	</style>
	<style>
		.sigWrapper.current {
    border-color: #ededed;
    box-shadow: 0px 0px 2px 0px #d0caca;
    border-radius: 10px;
}
		.logo_patient {
			font-size: 45px;
			margin: 0;
			padding: 0;
			border: 1px solid #cdcdcd;
			width: 63px;
			text-align: center;
		}

		.blob {
			/* border-radius: 50%; */
			box-shadow: 0 0 0 0 rgba(255, 0, 0, 1);
			transform: scale(1);
			animation: pulse 2s infinite;
			cursor: pointer;
		}

		.blob-triage {
			cursor: pointer;
		}

		@keyframes pulse {
			0% {
				transform: scale(0.95);
				box-shadow: 0 0 0 0 rgba(255, 0, 0, 0.7);
			}

			70% {
				transform: scale(1);
				box-shadow: 0 0 0 10px rgba(0, 0, 0, 0);
			}

			100% {
				transform: scale(0.95);
				box-shadow: 0 0 0 0 rgba(0, 0, 0, 0);
			}
		}

		.floating-window {
			position: fixed;
			top: 100px;
			right: 100px;
			z-index: 9999999999;
			background-color: rgba(255, 255, 255, 1);
			height: 300px;
			width: 400px;
			border-radius: 5px;
			box-shadow: 1px 1px 4px -2px black;
			display: none;
			overflow: hidden;
		}

		.cursor-pointer {
			cursor: pointer;
		}

		.floating-window-header {
			font-size: 1.2em;
			background: #084a6a;
		}

		.floating-window-file {
			position: fixed;
			top: 30px;
			right: 62px;
			z-index: 9999999999;
			background-color: rgba(255, 255, 255, 1);
			height: 93%;
			width: 93%;
			border-radius: 5px;
			box-shadow: 1px 1px 4px -2px black;
			display: none;
			overflow: hidden;
		}

		.floating-window-file-header {
			font-size: 1.2em;
			background: #084a6a;
		}

		.floating-window-triage {
			position: fixed;
			top: 100px;
			right: 80px;
			z-index: 9999999999;
			background-color: rgba(255, 255, 255, 1);
			border-radius: 5px;
			box-shadow: 1px 1px 4px -2px black;
			display: none;
			overflow: hidden;
			width: 250px
		}

		.floating-window-triage-header {
			font-size: 1.2em;
			background: #084a6a;
		}

		#show-alert {
			display: none;
		}


		.tab-wrapper ul {
			padding-inline-start: 0px;
		}

		.tab-menu li {
			position: relative;
			background-color: #fff;
			color: #bcbcbc;
			display: inline-block;
			padding: 15px 30px;
			opacity: 0.8;
			cursor: pointer;
			z-index: 0;
		}

		.tab-menu li:hover {
			color: #464646;
		}

		.tab-menu li.active {
			color: #464646;
			opacity: 1;
		}

		.tab-menu li.active:hover {
			color: #464646;
		}

		.tab-content>div {
			background-color: #fff;
			box-sizing: border-box;
			width: 100%;
		}

		.line {
			position: absolute;
			width: 0;
			height: 4px;
			background-color: #084a6a;
			top: 0;
			left: 0;
		}

		.hideForm {
			display: none;
		}
	</style>
	
<script>
    let sourceImage, targetRoot,targetFace,targetFaceFiller,targetBody, maState,faceState,fillerState,bodyState;

// save references to the original image and its parent div (positioning root)
function setSourceImage(source) {
  sourceImage = source;
  targetRoot = source.parentElement;
}
    let sourceImageFace,sourceImageBody,sourceImageFiller;

// save references to the original image and its parent div (positioning root)
function setSourceImageFace(source) {
    sourceImageFace = source;
	targetFace = source.parentElement;
}
function setSourceImageFaceFiller(source) {
    sourceImageFiller = source;
	targetFaceFiller = source.parentElement;
}
function setSourceImageBody(source) {
    sourceImageBody = source;
	targetBody = source.parentElement;
}
</script>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->

	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->


	<div class="floating-window-file">
		<div class="d-flex flex-column">
			<div class="d-flex flex-row justify-content-between p-2 floating-window-file-header">
				<strong class="text-white">Patient Document</strong> <strong><small class="text-white"></small></strong> <i class="fa fa-times-circle text-danger floating-window-file-close cursor-pointer" aria-hidden="true"></i>
			</div>
			<div style="height:1000px" id="file-content">
			</div>
		</div>
	</div>

	<div class="floating-window">
		<div class="d-flex flex-column">
			<div class="d-flex flex-row justify-content-between p-2 floating-window-header">
				<strong class="text-white">Patient History</strong> <strong><small class="text-white">Last Update: <?= $save_date; ?></small></strong> <i class="fa fa-times-circle text-danger floating-window-close cursor-pointer" aria-hidden="true"></i>
			</div>
			<div style="height: 100%;">
				<ol style="overflow-y: auto; max-height: 300px;padding-bottom: 50px; margin-top:5px; margin-left:-18px" class="pt-1" id="history-list">
				</ol>
			</div>
		</div>
	</div>

	<div class="floating-window-triage">
		
		<?php if (isset($triage[0])) { ?>
			<div class="d-flex flex-column">
				<div class="d-flex flex-row justify-content-between p-2 floating-window-triage-header">
					<strong class="text-white">Last Measurements</strong><br>
					</small><i class="fa fa-times-circle text-danger floating-window-triage-close cursor-pointer" aria-hidden="true"></i>
				</div>
				<div style="height: 100%;">
					<div class="box-body">
						<div class="row pl-3">
							<div class="col-12">
								<table>

									<tr>
										<td>
											<i class="fa fa-heartbeat mr-3 text-success" aria-hidden="true"></i>
										</td>
										<td>
											<strong class="mr-3"><?= $triage[0]['bp'] ?></strong>
										</td>
										<td>
										
											<span class="text-muted">b.p.m</span>
										</td>
									</tr>
									<tr>
										<td>
											<i class="fa fa-thermometer-empty text-danger" aria-hidden="true"></i>
										</td>
										<td>
											<strong class="mr-3"><?= $triage[0]['temperature'] ?></strong>
										</td>
										<td>
											<span class="text-muted">C</span>
										</td>
									</tr>
									<tr>
										<td>
											<i class="fa fa-heart text-danger" aria-hidden="true"></i>
										</td>
										<td>
											<strong class="mr-3"><?= $triage[0]['pulse'] ?></strong>
										</td>
										<td>
											<span class="text-muted">mmHg</span>
										</td>
									</tr>
									<tr>
										<td>
											<i class="fa fa-balance-scale text-primary" aria-hidden="true"></i>
										</td>
										<td>
											<strong class="mr-3"><?= $triage[0]['weight'] ?></strong>
										</td>
										<td>
											<span class="text-muted">kg</span>
										</td>
									</tr>
									<tr>
										<td>
											<i class="fa fa-arrows-v" aria-hidden="true"></i>
										</td>
										<td>
											<strong class="mr-3"><?= $triage[0]['height'] ?></strong>
										</td>
										<td>
											<span class="text-muted">cm</span>
										</td>
									</tr>

								</table>
							</div>
						</div>
						<small class="text-muted">Updated at: <?= $triage[0]['createdate']; ?></small>
					</div>
				</div>
			</div>
		<?php } ?>
	</div>







	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->

		<section class="content-header">
			<h1>
				&nbsp;Patient Medical Book
				<?php $discount_limit= $discount_range->max_value ?? ''; ?>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>

			<?php 
			$available_points=get_loyalty_points($patient_id,$this) ?? 0;
			?>
		<!-- Main content -->
		<section class="content print-remove-top-space">
			<div class="row mb-2">
				<div class="col-md-12">
					<div class="box margin-bottom-5px" style="border: none;">
						<div class="box-body">
							<div class="d-flex justify-content-between">
								<a href="<?= base_url('index.php/admin/Patients/PatientsController') ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back</a>
								<a data-control="" title="Visit Form" id="" href="<?= base_url('index.php/admin/Patients/PatientsController/print_details/'.encrypt_and_url_encode($patient_id,$this)); ?>"  class="btn btn-light float-right btn-sm" style="margin-right: 5px;">
        <i id="" class="fa fa-print"></i> Print Patient File
		</a>						<?php if($available_points > 0){ ?>
								<h5 class="d-block mb-0">
										<strong>
											Loyalty Points: <label class="text-success"><?php echo $available_points ?></label>
										</strong>
									</h5>
									<?php } ?>
							</div>
						</div>
					</div>
				</div><!-- /.box-body -->
			</div>

			<div class="row">
				<div class="col-md-12">
					<?php print_header($this); ?>
				</div>
			</div>

			<!--buttons-->

			<div class="row">
				<div class="col-12">
					<div class="box box-solid">
						<div class="box-body">
							<div class="row"> <!-- Form Buttons   -->
								<div class="col-md-2 d-flex" style="justify-content: center;">
									<?php if ($sex == 'Female') {
										if ($profile_img != 0 || $profile_img != "") {
										    	$image_path_old = FCPATH . UPLOAD_PATH . 'patients/profile/' . $patient_id . '-F.jpg';
										     if (file_exists($image_path_old)) { 
                                                $image_path_old = base_url(UPLOAD_PATH . 'patients/profile/' . $patient_id . '-F.jpg');
									?>
									
											<img class="form-control popup-image cursor-pointer" style=" object-fit:contain; max-height:183px" src="<?php echo $image_path_old;  ?>">
											<?php }else{ ?>
												<img class="form-control popup-image cursor-pointer" style=" object-fit:contain; max-height:183px" src="<?php echo base_url('' . UPLOAD_PATH . 'patients/profile/' . $profile_img);  ?>">
											<?php }  ?>
											<!-- <i class="ri-user-line logo_patient"></i> -->
										<?php  } else { ?>
											<img class="form-control" style=" object-fit:contain" src="<?php echo base_url('\Images\example_id.jpg'); ?>">
										<?php }
									} else {
										if ($profile_img != 0 || $profile_img != "") {
										$image_path_old = FCPATH . UPLOAD_PATH . 'patients/profile/' . $patient_id . '-F.jpg';
									    
										     if (file_exists($image_path_old)) { 
										         $image_path_old = base_url(UPLOAD_PATH . 'patients/profile/' . $patient_id . '-F.jpg');
										        
										?>
											<img class="form-control popup-image cursor-pointer" style=" object-fit:contain; max-height:183px" src="<?php echo $image_path_old;  ?>">
										<?php }else{ ?>
											<img class="img-fluid rounded popup-image cursor-pointer" style=" object-fit:contain" src="<?php echo base_url('' . UPLOAD_PATH . 'patients/profile/' . $profile_img);  ?>">
									    <?php } ?>

											
											<!-- <i class="ri-user-line logo_patient"></i> -->
										<?php  } else { ?>
											<img class="img-fluid" style=" object-fit:contain" src="<?php echo base_url('\Images\example_id.jpg'); ?>">
									<?php }
									} ?>
								</div>
								<div class="col-md-2">
									<ul class="list-group">
										<li class="list-group-item custom-list"><strong>
												<i class="fa" aria-hidden="true"></i>File NO:</strong> <span><?= $patient_id; ?></span><br>
										</li>
										<li class="list-group-item custom-list"><strong>
												<i class="fa" aria-hidden="true"></i>Name:</strong> <span><?= $patient_name; ?></span><br>
										</li>
										<?php if(check_right('hide_mobile',$this)) { ?>
										<?php } else { ?>
                                        <li class="list-group-item custom-list"><strong>
												<i class="fa" aria-hidden="true"></i>Mobile:</strong> <span><?= $mobile; ?></span><br>
										</li>
                                        <?php } ?>
										<li class="list-group-item custom-list"><strong>
												<i class="fa" aria-hidden="true"></i>QID:</strong> <span><?= $qatar_id; ?></span><br>
										</li>
										
										<li class="list-group-item custom-list"><strong>
												<i class="fa" aria-hidden="true"></i>Gender:</strong> <span><?= $sex; ?></span><br>
										</li>
										<li class="list-group-item custom-list"><strong>
												<i class="fa" aria-hidden="true"></i>Age:</strong> <span><?= $dob; ?> (<?= (new DateTime())->diff(new DateTime($dob))->y; ?> y)</span><br>
										</li>
									</ul>


								</div>

									<?php if(check_right('General Triage',$this)){ ?>
								<div class="col-md-2">
									<ul class="list-group">
										<li class="list-group-item custom-list">
											<i class="fa fa-heartbeat mr-3 text-success f-16" aria-hidden="true"></i>Heart Beat : <strong class=""><?= $triage[0]['bp'] ?? '---' ?></strong><sup class="text-muted">b.p.m</sup><br>
										</li>
										<li class="list-group-item custom-list">
											<i class="fa fa-thermometer-empty mr-3 text-danger f-16" aria-hidden="true"></i>Temprature :<strong class=""><?= $triage[0]['temperature'] ?? '---' ?></strong> <sup class="text-muted">C</sup><br>
										</li>
										<li class="list-group-item custom-list">
											<i class="fa fa-heart  mr-3 text-danger f-16" aria-hidden="true"></i>Pulse :<strong class=""><?= $triage[0]['pulse'] ?? '---' ?></strong> <sup class="text-muted">mmHg</sup><br>
										</li>
										<li class="list-group-item custom-list">
											<i class="fa fa-balance-scale mr-3 text-primary f-16" aria-hidden="true"></i></i>Weight : <strong class=""><?= $triage[0]['weight'] ?? '---' ?></strong> <sup class="text-muted">kg</sup><br>
										</li>
										<li class="list-group-item custom-list">
											<i class="fa fa-arrows-v mr-3 f-16" aria-hidden="true"></i> Height : <strong class=""><?= $triage[0]['height'] ?? '---' ?></strong> <sup class="text-muted">cm</sup><br>
										</li>
									</ul>
								</div>
								<?php } ?>
								<div class="col-md-2">
								<div id="placeHolder" style="width:150px; height:150px">
								<canvas id="qr-canvas"></canvas>
							</div>
								</div>
								<div class="col-md-4">
									<div class="row">
										<div class="col-md-4">
											<div class="col-md-12 bg-light small-box text-dark text-center rounded p-1">
												<p>Insurance Type</p>
												<span><?= $insurance_name; ?></span>
											</div>

										</div>
										<div class="col-md-4 ">
											<div class="col-md-12 bg-light small-box text-dark text-center rounded p-1">
												<p>Open Balance</p>
												<span><?= $total_advance; ?></span>
											</div>
										</div>
										<div class="col-md-4 ">
											<div class="col-md-12 bg-light small-box text-dark text-center rounded p-1">
												<p>Due Balance</p>
												<span><?= $total; ?></span>
											</div>
										</div>
									</div>
									<div class="row">
									<div class="col-md-12">
									<?php if($insurance_name =='QLM'){?>
									<strong>QLM Eligibility:</strong>
									<?php } ?>
									<div class="row mt-1 cursor-pointer">

										<div class="col-md-12">
											<?php
											//if ($value['insurance_type_id'] == 8)

											if ($ic['messageType'] == 'S') :
												$exp_date = str_replace('/', '-', $ic['validTo']);
											?>
												<div>
													<?php if (strtotime($exp_date) > strtotime(date('Y-m-d'))) : ?>
														<li class="list-group-item custom-list text-wrap" onclick="showQlmDetails()">
															<b><u><?= $ic['empPlan'] ?> Plan</u></b> - Valid Until: <?= $ic['validTo'] ?> | <i class="glyphicon glyphicon-chevron-down"></i>
														</li>
													<?php else : ?>
														<button class="btn btn-success btn-sm text-wrap" onclick="showQlmDetails()">
															<b><u>EXPIRED</u></b> - Valid Until: <?= $exp_date ?> | <i class="glyphicon glyphicon-chevron-down"></i>
														</button>
													<?php endif; ?>

													<div id="qlm_details" style="background-color: #ffffffff;padding: 10px;border-radius: 10px;margin-top: 5px;box-shadow: 3px 3px 10px -4px;display:none;position:absolute;z-index:999;">
														<li style="list-style: none;">
															<span style="margin-top: 20px;">
																<center>
																	<label class="" style="margin-top:10px;font-size: 14px; font-weight: bold;">Registered Name: <?= $ic['memberName'] ?></label>
																	<br><small><?= $ic['employer'] ?></small><br>
																</center>
															</span>

															<table class="table table-bordered">
																<tr>
																	<td class="bg-light">Plan</td>
																	<td colspan=3><?= $ic['empPlan'] ?></td>
																	<td class="bg-light">Validity</td>
																	<td><?= $exp_date ?></td>
																</tr>
																<tr>
																	<td class="bg-light">QID</td>
																	<td><?= ($qatar_id != 0 ? $qatar_id : 'n/a') ?></td>
																	<td class="bg-light">MID</td>
																	<td><?= ($ic['memberId'] ? $ic['memberId'] : 'n/a') ?></td>
																	<td class="bg-light">DOB</td>
																	<td><?= ($ic['dob'] ? $ic['dob'] : 'n/a') ?></td>
																</tr>
																<tr>
																	<td class="bg-light">Benefits</td>
																	<td colspan=6>
																		<?php if ($ic['basicOPDed'] != 'NIL' && $ic['basicOPDed'] != 'N/A' && $ic['basicOPDed'] != '0 %') { ?>
																			<span class="label label-default">Basic Benefit OP Deductible : <?= $ic['basicOPDed'] ?></span>
																		<?php } ?>
																		<?php if ($ic['basicIPDed'] != 'NIL' && $ic['basicIPDed'] != 'N/A' && $ic['basicIPDed'] != '0 %') { ?>
																			<span class="label label-default">Basic Benefit IP Deductible : <?= $ic['basicIPDed'] ?></span>
																		<?php } ?>
																		<?php if ($ic['matOPDed'] != 'NIL' && $ic['matOPDed'] != 'N/A' && $ic['matOPDed'] != '0 %') { ?>
																			<span class="label label-default">Maternity Benefit OP Deductible : <?= $ic['matOPDed'] ?></span>
																		<?php } ?>
																		<?php if ($ic['matIPDed'] != 'NIL' && $ic['matIPDed'] != 'N/A' && $ic['matIPDed'] != '0 %') { ?>
																			<span class="label label-default">Maternity Benefit IP Deductible : <?= $ic['matIPDed'] ?></span>
																		<?php } ?>
																		<?php if ($ic['dentalOPDed'] != 'NIL' && $ic['dentalOPDed'] != 'N/A' && $ic['dentalOPDed'] != '0 %') { ?>
																			<span class="label label-default">Dental Benefit OP Deductible : <?= $ic['dentalOPDed'] ?></span>
																		<?php } ?>
																		<?php if ($ic['dentalIPDed'] != 'NIL' && $ic['dentalIPDed'] != 'N/A' && $ic['dentalIPDed'] != '0 %') { ?>
																			<span class="label label-default">Dental Benefit IP Deductible : <?= $ic['dentalIPDed'] ?></span>
																		<?php } ?>
																		<?php if ($ic['opticalOPDed'] != 'NIL' && $ic['opticalOPDed'] != 'N/A' && $ic['opticalOPDed'] != '0 %') { ?>
																			<span class="label label-default">Optical Benefit OP Deductible : <?= $ic['opticalOPDed'] ?></span>
																		<?php } ?>
																		<?php if ($ic['opticalIPDed'] != 'NIL' && $ic['opticalIPDed'] != 'N/A' && $ic['opticalIPDed'] != '0 %') { ?>
																			<span class="label label-default">Optical Benefit IP Deductible : <?= $ic['opticalIPDed'] ?></span>
																		<?php } ?>
																		<?php if ($ic['basicOPCopay'] != 'NIL' && $ic['basicOPCopay'] != 'N/A' && $ic['basicOPCopay'] != '0 %') { ?>
																			<span class="label label-default">Basic Benefit OP Copay : <?= $ic['basicOPCopay'] ?></span>
																		<?php } ?>
																		<?php if ($ic['matOPCopay'] != 'NIL' && $ic['matOPCopay'] != 'N/A' && $ic['matOPCopay'] != '0 %') { ?>
																			<span class="label label-default">Maternity Benefit OP Copay : <?= $ic['matOPCopay'] ?></span>
																		<?php } ?>
																		<?php if ($ic['matIPCopay'] != 'NIL' && $ic['matIPCopay'] != 'N/A' && $ic['matIPCopay'] != '0 %') { ?>
																			<span class="label label-default">Maternity Benefit IP Copay : <?= $ic['matIPCopay'] ?></span>
																		<?php } ?>
																		<?php if ($ic['dentalOPCopay'] != 'NIL' && $ic['dentalOPCopay'] != 'N/A' && $ic['dentalOPCopay'] != '0 %') { ?>
																			<span class="label label-default">Dental Benefit OP CopayY : <?= $ic['dentalOPCopay'] ?></span>
																		<?php } ?>
																		<?php if ($ic['dentalIPCopay'] != 'NIL' && $ic['dentalIPCopay'] != 'N/A' && $ic['dentalIPCopay'] != '0 %') { ?>
																			<span class="label label-default">Dental Benefit IP Copay : <?= $ic['dentalIPCopay'] ?></span>
																		<?php } ?>
																		<?php if ($ic['opticalOPCopay'] != 'NIL' && $ic['opticalOPCopay'] != 'N/A' && $ic['opticalOPCopay'] != '0 %') { ?>
																			<span class="label label-default">Optical Benefit OP Copay : <?= $ic['opticalOPCopay'] ?></span>
																		<?php } ?>
																		<?php if ($ic['opticalIPCopay'] != 'NIL' && $ic['opticalIPCopay'] != 'N/A' && $ic['opticalIPCopay'] != '0 %') { ?>
																			<span class="label label-default">Optical Benefit IP Copay : <?= $ic['opticalIPCopay'] ?></span>
																		<?php } ?>
																		<?php if ($ic['opCoins'] != 'NIL' && $ic['opCoins'] != 'N/A' && $ic['opCoins'] != '0 %') { ?>
																			<span class="label label-default">OP Coinsurance : <?= $ic['opCoins'] ?></span>
																		<?php } ?>
																		<?php if ($ic['ipCoins'] != 'NIL' && $ic['ipCoins'] != 'N/A' && $ic['ipCoins'] != '0 %') { ?>
																			<span class="label label-default">IP Coinsurance : <?= $ic['ipCoins'] ?></span>
																		<?php } ?>
																		<?php if ($ic['opDed'] != 'NIL' && $ic['opDed'] != 'N/A' && $ic['opDed'] != '0 %') { ?>
																			<span class="label label-default">OP Deductible : <?= $ic['opDed'] ?></span>
																		<?php } ?>
																		<?php if ($ic['ipDed'] != 'NIL' && $ic['ipDed'] != 'N/A' && $ic['ipDed'] != '0 %') { ?>
																			<span class="label label-default">IP Deductible : <?= $ic['ipDed'] ?></span>
																		<?php } ?>
																		<?php if ($ic['consultCopayYn'] != 'NIL' && $ic['consultCopayYn'] != 'N/A' && $ic['consultCopayYn'] != '0 %') { ?>
																			<span class="label label-default">Copay for the Member : <?= $ic['consultCopayYn'] ?></span>
																		<?php } ?>
																</tr>
																<tr class="hidden-print">
																	<td class="bg-light">
																		Claim Form<br>
																		<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#app_poppup">Generate</button>
																	</td>
																	<td colspan=6>
																		<?php
																		$dir = '' . UPLOAD_PATH . 'qlm/';
																		if (is_dir($dir)) :
																			$ignored = array('.', '..', '.svn', '.htaccess');
																			$num = 0;
																			foreach (scandir($dir) as $file) :
																				if (in_array($file, $ignored)) continue;
																				$arr = explode('~', $file);
																				if ($arr[0] == $value['qatar_id'] || $arr[0] == $value['patient_id']) :
																					$num++;
																		?>
																					<a href="<?= base_url('' . UPLOAD_PATH . 'qlm/' . $file) ?>" class="btn btn-dark btn-xs" download><?= $file ?></a>&nbsp;';
																		<?php
																				endif;
																			endforeach;
																		endif;
																		?>
																	</td>
																</tr>

															</table>
														</li>
													</div>
												</div>
											<?php endif; ?>
										</div>
									</div>
								</div>
									</div>


								</div>


							</div>

							<!-- <div class="row">
								<div class="col-md-12">
									<div class="d-flex flex-row justify-content-end">
										<span class="badge badge-warning blob-triage">Triage <i class="fa fa-exclamation-circle" aria-hidden="true"></i></span>
									</div>
								</div>
							</div> -->

							<div class="row" id="show-alert">
								<div class="col-md-12">
									<div class="d-flex flex-row justify-content-end">
										<span class="badge badge-danger blob">Alert <i class="fa fa-exclamation-circle" aria-hidden="true"></i></span>
									</div>
								</div>
							</div>

						</div>
					</div>
				</div>
			</div>
			<!--//buttons-->



			<div class="row">
				<div class="col-12 col-md-12">
					<div class="row">
						<div class="col-12 col-md-12">
							<div class="box box-info" style="margin-bottom: 5px;">
								<div class="box-body">

									<?php
									$success = $this->session->flashdata('success');
									if ($success) { ?>
										<!-- <div class="row mb-2">
											<div class="col-md-12">
												<div class="callout <?php echo $this->config->item('msg_success'); ?> error-msg">
													<div>
														<span><i class="icon fa fa-check"></i><?= $success; ?></span>
													</div>
												</div>
											</div>
										</div> -->
									<?php } ?>

									


								<ul class="nav nav-pills mb-3 no-print" id="pills-tab" role="tablist">
								<?php foreach ($modules as $key => $module) {
									if ($module['is_module'] == 0 && check_right($module['module_name'],$this)) { ?>
										<li class="nav-item">
											<a class="nav-link" id="<?= $module['module_name'] ?>_tab" data-toggle="pill" href="#pill-module<?= $key; ?>" 
											role="tab" aria-controls="pills-module-tab" aria-selected="false" data-key="<?= $key ?>" 
											data-view-path="<?= $module['module_view_path'] ?>">
												<?= $module['module_name'] ?>
											</a>
										</li>
								<?php } } ?>
							</ul>
							<div class="col-md-12 justify-content-center  align-items-center module_loader" style="display: none;" >
											<div class="spinner spinner-border spinner-border-sm text-primary mx-auto" ></div>
											</div>
							<div class="tab-content" id="pills-tabContent">
							
								<?php foreach ($modules as $key => $module) {
									if ($module['is_module'] == 0) { ?>
										<div class="tab-pane fade" id="pill-module<?= $key; ?>" role="tabpanel" aria-labelledby="pills-home-tab">
											<!-- Content will be loaded here via AJAX -->
											
											
										</div>
								<?php } } ?>
							</div>


								</div>
							</div>
						</div>
					</div>

		</section>
		<input type="hidden" id="_id" name="_id" value="<?php echo $_id; ?>">

	</div>

	<!-- ./wrapper -->

	<?php require(APPPATH . "views/admin/partials/image-modal.php"); ?>
	<?php require_once(APPPATH . "views/admin/footer-simple.php"); ?>


</body>

</html>



<script>
	$(document).ready(function () {
		
		$(document).ready(function() {
			
        let selectedTab = localStorage.getItem('selectedTabIndex0') != null ? localStorage.getItem('selectedTabIndex0') : 0;
        $(`#pills-tab li a:eq(${selectedTab})`).tab('show');
      
    });
	$('#pills-tab').on('click', 'li', function() {
        var tabIndex = $(this).index();
        localStorage.setItem('selectedTabIndex0', tabIndex);
    });


		var currentRequest = null;
    $('a[data-toggle="pill"]').on('shown.bs.tab', function (e) {
		
      console.log(e.target);
        var target = $(e.target).attr("href"); // activated tab
        var viewPath = $(e.target).data('view-path');
        var key = $(e.target).data('key');
		var discount_limit = "<?php echo get_discount_limt($this); ?>";
		var patient_id= "<?php echo $patient_id; ?>";
		$('.module_loader').show();
		if (currentRequest) {
        currentRequest.abort();
    	}
        // Check if content is already loaded
        // if ($(target).is(':empty')) {
			currentRequest =     $.ajax({
                url: '<?= base_url("admin/Patients/PatientsController/load_module_view"); ?>', // Replace with your controller and method to load view
                type: 'POST',
                data: {view_path: viewPath, key: key,discount_limit:discount_limit,patient_id:patient_id},
                success: function (response) {
                    $(target).html(response); // Load the response into the tab content
					$('.module_loader').hide();
                },
                error: function () {
                    $(target).html("Error loading content.");
					$('.module_loader').hide();
                }
            });
        // }
    });
});

	

    var data="<?php  $qatar_id ?>";
	genreateQrCode(data);

	function genreateQrCode(data){

    
var typeNumber = 5;
var errorCorrectionLevel = 'H';
var qr = qrcode(typeNumber, errorCorrectionLevel);
qr.addData(data);
qr.make();

var qrImageTag = qr.createImgTag(4,4);

var qrImageSrc = qrImageTag.match(/src="([^"]*)"/)[1]; // Extract the src attribute value
var qrImage = new Image();
var canvas = document.getElementById('qr-canvas');
var ctx = canvas.getContext('2d');
var logoUrl = '<?php echo base_url('/Images/qrlogo.svg') ?> ';
console.log(logoUrl);
qrImage.onload = function() {
	// Set canvas dimensions to match QR code image
	canvas.width = qrImage.width;
	canvas.height = qrImage.height;
	
	// Draw QR code image on canvas
	ctx.drawImage(qrImage, 0, 0);

	// Draw logo image on canvas
	var logoImg = new Image();
	logoImg.onload = function() {
		var logoSize = qrImage.width / 3; // Logo size relative to QR code
		var logoX = (qrImage.width - logoSize) / 2;
		var logoY = (qrImage.height - logoSize) / 2;
		
		ctx.drawImage(logoImg, logoX, logoY, logoSize, logoSize);
	};
	logoImg.src = logoUrl;
};

qrImage.src = qrImageSrc; // Use the extracted src attribute value
}


	if (navigator.cookieEnabled == false) {
		alert('Not work Cookies, please enable cookie');
	}

	var color_select = undefined;
	var color_select_plan = undefined;
	var department_select = null;
	var site_url = '<?php echo base_url(); ?>';

	var selected_module = localStorage.getItem("selected_module");
	var selected_module_tab = localStorage.getItem("selected_module_tab");
	var selected_module_tab_qlm = localStorage.getItem("selected_module_tab_qlm");


	var dataTableLabRequest = $('#lab_request_list').DataTable({
		'ajax': {
			'url': '<?= site_url('admin/Lab/LabController/get_all_cases_by_patient'); ?>',
			'type': 'POST',
			'data': function(d) {
				d.patient_id = '<?php echo $patient_id; ?>',
					d.module_id = $('#modules_dropdown').val();
			}
		},
		'columns': [{
				'data': 'case_id',
				'title': 'No'
			},

			{
				'data': 'created_at',
				'title': 'Created At'
			},
			{
				"data": "tests",
				'title': 'Tests',
				"render": function(data, type, row) {
					let testsHtml = '<span>';
					data.forEach(test => {
						testsHtml += `<span class="badge badge-light d-table  mb-2" style="font-size:14px">${test.test_name}</span>`;
					});
					testsHtml += '</span>';
					return testsHtml;
				}
			},

			{
				"data": "status",
				'title': 'Status',
				"render": function(data, type, row) {
					if (row.type == 1) {
						return '<span class="badge badge-light">Request Not Accepted</span>';
					} else if (row.type == 0) {
						if (row.status == 0) {
							return '<span class="badge badge-light">Pending Result</span>';
						} else {
							return '<a href="<?= base_url('index.php/admin/Lab/LabController/view_result_doc'); ?>/' + row.case_id + '" class="btn btn-light btn-sm"><i class="fa fa-eye"> </i> View Result</a>';
						}
					}
					return '';
				}
			},


			{
				'data': null,
				'title': 'Actions',
				'className': 'text-center',
				'render': function(data, type, row) {
					const moduleName = $("#modules_dropdown option:selected").text().replace(/[^a-z0-9]/gi, '');
					var disabled = '';
					if (row.type != 1) {
						disabled = 'disabled'
					}
					return `<div class="text-center">
									<button 
										type="button" 
										class="btn btn-sm btn-light ${disabled}" ${disabled} data-id="${row.case_id}"  id="editLabRequestBtn" >
										<i class="fa fa-pencil fa-1"></i>
									</button>
									<button 
										class="btn btn-sm btn-light m-1 ${disabled}" ${disabled} 
										onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Lab/LabController/deleteRequest/'); ?>${row.case_id}')">
										<i class="fa fa-trash fa-1"></i>
									</button>`;
				}
			}
		],
		'serverSide': true,
		'pageLength': 10,
		'lengthMenu': [10, 25, 50, 100],
		'pagingType': 'full_numbers'
	});

	

	

	if (navigator.cookieEnabled == false) {
		alert('Not work Cookies, please enable cookie');
	}
 
	



	$('.floating-window-close').on('click', function() {
		$('.floating-window').css({
			'display': 'none'
		});
	});

	$('.floating-window-file-close').on('click', function() {
		$('.floating-window-file').css({
			'display': 'none'
		});
	});

	$('.floating-window-triage-close').on('click', function() {
		$('.floating-window-triage').css({
			'display': 'none'
		});
	});

	$('.blob').on('click', function() {
		$('.floating-window').css({
			'display': 'block'
		});
	});

	$('.blob-triage').on('click', function() {
		$('.floating-window-triage').css({
			'display': 'block'
		});
	});

	function handleFileSelect() {
		const fileInput = document.getElementById('patientDocument');
		const file = fileInput.files[0];

		if (file) {
			const reader = new FileReader();

			reader.onload = function(e) {
				const contents = e.target.result;
				const fileName = file.name;
				$('#document_name').val(fileName);
			};

			reader.readAsText(file);
		}
	}

	function textFileSelect(element) {
		const file = element.files[0];
		
		if (file) {
			const reader = new FileReader();

			reader.onload = function(e) {
				const contents = e.target.result;
				const fileName = file.name;
				// $(element).parent().parent().parent().find('.file_reader').val(fileName);
				console.log(fileName);
			};

		}
	}

	function showQlmDetails() {
		if ($('#qlm_details').css('display') == 'block') {
			$('#qlm_details').css({
				'display': 'none'
			});
		} else {
			$('#qlm_details').css({
				'display': 'block'
			});
		}
	}

	var item_price = 0;
	var selectedTests = [];
	var user_group_id = "<?php echo $this->session->userdata('group_id'); ?>";

	function init_test_select(id) {
		testSelect = new TomSelect(id, {
			valueField: 'id',
			labelField: 'name',
			searchField: ['name', 'short_name'],
			plugins: ['remove_button'],
			closeAfterSelect: true,
			// Set the "load" property to define the function to fetch data dynamically
			load: function(query, callback) {
				var apiUrl = "<?php echo site_url('admin/Lab/LabController/get_test?'); ?>name_startsWith=" + encodeURIComponent(query);

				fetch(apiUrl)
					.then(response => response.json())
					.then(data => {
						callback(data);
					})
					.catch(() => {
						callback();
					});
			},
			render: {
				option: function(item, escape) {
					return '<div>' +
						'<span class="btn btn-sm">' + escape(item.name) + '-' + escape(item.short_name) + '-' + escape(item.price) + 'Qar</span>' +
						'</div>';
				},
				item: function(item, escape) {
					return '<div>' +
						'<span class="btn  btn-sm">' + escape(item.name) + '-' + escape(item.price) + 'Qar</span>' +
						'</div>';
				}
			},
			onItemAdd: function(value, item) {

				// Find the selected patient data by id
				if (user_group_id == 80) {
					var selectedTest = this.options[value] || {
						id: value,
						name: value
					};
					selectedTest.price = parseFloat(selectedTest.price || 0);
					selectedTests.push(selectedTest);
					var total = calculatePayment(selectedTests);
					if (selectedTests.length <= 0) {
						$(".payment-section").hide(250);
					} else {
						$(".payment-section").show(250);
					}

					$('#total').text(total)
					$('#total_first').val(total)
					$('#amount_received').val(total)
					this.blur();
				}


			},
			onItemRemove: function(value, item) {
				if (user_group_id == 80) {
					var selectedTest = this.options[value] || {
						id: value,
						name: value
					};
					selectedTest.price = parseFloat(selectedTest.price || 0);
					selectedTests = selectedTests.filter(item => item.name !== selectedTest.name);

					var total = calculatePayment(selectedTests);
					$('#total').text(total)
					$('#total_first').val(total)
					$('#amount_received').val(total)

					if (selectedTests.length <= 0) {
						$(".payment-section").hide(250);
					} else {
						$(".payment-section").show(250);
					}
					this.blur();
				}
			},

		});


	}


	document.addEventListener("DOMContentLoaded", function() {
		if (document.querySelector('.test_select')) {
			init_test_select('.test_select');
			testSelect.settings.minLength = 1;
		}
		// if (document.querySelector('.color_select')) {
			
		// }

	});


	$('#LabRequestForm').submit(function(event) {
		event.preventDefault();

		var total_price = $("#total").text();
		$('#total_final').val(total_price);
		var formData = $(this).serialize();
		var url = '';
		if (user_group_id == 80) {
			url = "<?php echo base_url("admin/Lab/LabController/saveCase") ?>";
		} else {
			url = "<?php echo base_url("admin/Lab/LabController/saveRequest") ?>";
		}
		console.log(formData);
		$.ajax({
			url: url,
			type: 'POST',
			data: formData,
			success: function(response) {
				// Handle the response from the server
				if (response.status == 'success') {

					successNotification(response.msg);
					$('#LabRequestForm')[0].reset();
					dataTableLabRequest.ajax.reload();
					testSelect.clear();
					console.log(response.id);
					// var invoiceUrl = "<?php echo site_url('admin/Invoice/InvoiceController/labInvoice/'); ?>" + response.id +"/"+response.case_id;
					// window.open(invoiceUrl, '_blank');

				}
				// Optionally, reset the form or provide feedback to the user


			},
			error: function(xhr, status, error) {
				// Handle any errors
				console.error(error);
			}
		});
	});


	function calculatePayment(items, discountRate = 0) {
		console.log(items);
		var total = 0;
		items.forEach(item => {
			var price = parseFloat(item.price);
			if (!isNaN(price)) {
				total += price;
			}
		});

		if (discountRate > 0 && discountRate <= 100) {
			var discount = total * (discountRate / 100);
			total -= discount;
		}

		return total.toFixed(2);
	}


	$(document).on('click', '#editLabRequestBtn', function() {
		var case_id = $(this).data('id');



		$('#case_id_input').val(case_id);

		$.ajax({
			url: '<?= base_url('admin/Lab/LabController/get_tests_by_case/') ?>' + case_id,
			type: 'GET',
			dataType: 'json',
			success: function(data) {
				var testSelect = new TomSelect('.model_test_select', {
					plugins: ['remove_button'],
					options: data,
					valueField: 'id',
					labelField: 'name',
					searchField: 'name',
					create: false,
					render: {
						option: function(item, escape) {
							return '<div>' + escape(item.name) + '</div>';
						}
					}
				});

				// Preselect the tests in Tom Select
				var selectedTests = data.map(function(test) {
					return test.id;
				});
				testSelect.setValue(selectedTests);

				// Open the modal
				$('#editLabRequest').modal('show');
			},
			error: function(jqXHR, textStatus, errorThrown) {
				console.log(textStatus, errorThrown);
			}
		});
	})
	$(document).on('change', '.btn-file :file', function() {
		var input = $(this)[0].files;
		var fileNames = [];
		for (var i = 0; i < input.length; i++) {
			fileNames.push(input[i].name);
		}
		$(this).parents('.input-group').find(':text').val(fileNames.join(', '));
	});

	$(document).ready(function() {
		$('.btn-file :file').on('fileselect', function(event, label) {
			var input = $(this).parents('.input-group').find(':text'),
				log = label;

			if (input.length) {
				input.val(log);
			} else {
				if (log) alert(log);
			}
		});
	});

</script>

