<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title> Patients List </title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <!--image crop-->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


    <?php require_once(APPPATH . "views/admin/header.php"); ?>

    <style>
        .ztbl0 {
            width: 100%;
            background: #a9e2f273;
        }

        .ztbl0 thead {
            font-size: 0.9em;
        }

        .ztbl0 thead th {
            padding: 10px;
            background-color: #5a7881;
            color: white;
        }

        .ztbl0 tr:nth-child(even) {
            background-color: #D6EEEE;
        }

        .ztbl0 td {
            padding: 10px;
            font-size: 0.9em;
        }
        #print-card{
margin-top: -60px!important;
		}
    </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper no-bg-print">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Patient Statement
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <form id="submitForm" name="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Patients/PatientsController/search') ?>" method="post">
        
            <section class="content">
                <!--buttons-->
                <div class="row no-print">
                    <div class="col-12">
                        <div class="box box-solid" style="margin-bottom: 5px;">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-4 text-left">
                                        <a href="<?php echo base_url('index.php/admin/Patients/PatientsController') ?>" class="btn btn-sm btn-dark no-print">
                                        <i class="fa fa-chevron-circle-left"></i> Go back </a>
                                    </div>
                                    <div class="col-md-6 text-right"></div>
                                    <div class="col-md-2 text-right">
                                        <button type="button" class="btn btn-sm btn-dark" onclick="window.print();"><i class="fa fa-print" aria-hidden="true"></i> Print</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="box box-info border-top-none-print">
                    <div class="box-body">

                        <div class="row on-print hide">

												<div class="col-md-12" style="display: flex;flex-wrap: wrap;flex-direction: row;justify-content: space-between;">
													<?php echo print_header($this); ?>
												</div>
												<div class="col-md-12 text-center" style="margin-bottom: 45px;">
													<h4><u>Patient Statement</u></h4>
												</div>
						</div>

                        <div class="row mt-2">
                            <div class="col-sm-12 col-md-6">
                                <h4 class="text-center">Patient Details</h4>
                                <table class="table table-bordered table-striped">
                                    <tbody>
                                        <tr>
                                            <th>Print Date</th>
                                            <td class="text-center">:</td>
                                            <td><?= date('Y-m-d'); ?></td>
                                        </tr>
                                        <tr>
                                            <th>File No</th>
                                            <td class="text-center">:</td>
                                            <td><?= $patient->patient_id; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Patient Name</th>
                                            <td class="text-center">:</td>
                                            <td><?= $patient->patient_name; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Phone</th>
                                            <td class="text-center">:</td>
                                            <td><?= $patient->mobile; ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <?php
    // Remove commas and convert to float
    $gross_total_numeric = floatval(str_replace(',', '', $gross_total));
    $paid_total_numeric = floatval(str_replace(',', '', $paid_total));
    $total_discount_num = floatval(str_replace(',', '', $total_discount));

    $net_total= $gross_total_numeric - $total_discount_num;
    $difference = $net_total - $paid_total_numeric;
    ?>
                            <div class="col-sm-12 col-md-6">
                                <h4 class="text-center">Payments Summary</h4>
                                <table class="table table-bordered table-striped">
                                    <tbody>
                                    <tr>
                                            <th>Total Gross Amount</th>
                                            <td class="text-center">:</td>
                                            <td class="text-right"><?= $gross_total; ?> QR</td>
                                        </tr>
                                        <tr>
                                            <th>Total Discount</th>
                                            <td class="text-center">:</td>
                                            <td class="text-right"><?= $total_discount ?> QR</td>
                                        </tr>
                                     
                                        <tr>
                                            <th>Total Net Amount</th>
                                            <td class="text-center">:</td>
                                            <td class="text-right"><?= $net_total ?> QR</td>
                                        </tr>
                                        <tr>
                                            <th>Paid Amount</th>
                                            <td class="text-center">:</td>
                                            <td class="text-right"><?= $paid_total; ?> QR</td>
                                        </tr>
                                        <tr>
                                            <th>Due Balance Amount</th>
                                            <td class="text-center">:</td>
                                            <td class="text-right"><?php if($difference < 0){ echo '0';}else{echo $difference;} ?> QR</td>
                                        </tr>
                                        <tr>
                                            <th>Open Balance Amount</th>
                                            <td class="text-center">:</td>
                                            <td class="text-right"><?= $total_advance; ?> QR</td>
                                        </tr>
                                        
                                        
                                        <tr>
                                            <th>Total Refund</th>
                                            <td class="text-center">:</td>
                                            <td class="text-right"><?= $total_refunds; ?> QR</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                        </div>

                    </div>
                </div>

                <div class="box box-info border-black-print">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <h4 class="text-center">Invoices</h4>
                                <table class="table table-bordered table-striped text-center">
                                    <thead>
                                        <tr >
                                            <th>#</th>
                                            <th>Invoice No.</th>
                                            <th>Treatment Date</th>
                                            <th>Insurance Payment</th>
                                            <th>Co-Payment</th>
                                            <th>Gross Amount</th>
                                            <th>Discount</th>
                                          
                                            <th>Net Amount</th>
                                            <th>Paid Total</th>
                                            <th>Balance</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach($paid_invoices as $key => $invoice): ?>
                                        <tr>
                                            <th><?= $key+1; ?></sth>
                                            <td >INV <?= $invoice->treatement_payment_id; ?></td>
                                            <td ><?= $invoice->treat_date; ?></td>
                                            <td ><?= $invoice->insurance_amount; ?> QR</td>
                                            <td><?= $invoice->co_payment; ?> QR</td>
                                            <td><?= $invoice->gross_total; ?> QR</td>
                                            <td><?= $invoice->total_discount; ?> QR</td>
                                            
                                            <td><?= 
                                            number_format(
                                                $invoice->gross_total - $invoice->total_discount,2) ; ?> QR</td>
                                            </td>
                                            <td><?= $invoice->paid_total; ?> QR</td>
                                               <td> 
                                                <?= 
                                             number_format( $invoice->gross_total -$invoice->total_discount -$invoice->paid_total, 2);?> QR</td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="box box-info border-black-print">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <h4 class="text-center">Paid List of Treatement</h4>
                                <table class="table table-bordered table-striped text-center">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Receipt No.</th>
                                            <th>Invoice No.</th>
                                            <th>Paid Date</th>
                                            <th>Discount</th>
                                            <th>Paid</th>
                                            <th>Payment Method</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach($receipts as $key => $receipt): ?>
                                        <tr>
                                            <th><?= $key+1; ?></th>
                                            <td>RCP <?= $receipt->patient_payment_id; ?></td>
                                            <td>INV <?= $receipt->treatment_payment_id; ?></td>
                                            <td><?= $receipt->pay_date; ?></td>
                                            <td><?= $receipt->discount + $receipt->category_discount + $receipt->company_discount + $receipt->points_discount + $receipt->coupon_discount; ?></td>
                                            <td><?= $receipt->cash  ?> QR</td>
                                            <td><?= empty($receipt->type_name) ? 'Insurance' : $receipt->type_name; ?></td>

                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="box box-info border-black-print">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <h4 class="text-center">Open Balance</h4>
                                <table class="table table-bordered table-striped text-center">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Advance No.</th>
                                            <th>Paid Date</th>
                                            <th>Payment Method</th>
                                            <th>Payment Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach($advances as $key => $advance): ?>
                                        <tr>
                                            <th><?= $key+1; ?></th>
                                            <td>ADV <?= $advance->advance_id; ?></td>
                                            <td><?= $advance->pay_date; ?></td>
                                            <td><?= $advance->type_name; ?></td>
                                            <td><?= $advance->amount; ?> QR</td>

                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </section>


        </form>

    </div>

    <!-- ./wrapper -->


    <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>
<script>

</script>

</html>