<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.1/css/all.min.css" integrity="sha256-2XFplPlrFClt0bIdPgpz8H7ojnk10H69xRqd9+uTShA=" crossorigin="anonymous" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
<link href="https://fonts.googleapis.com/css2?family=Noto+Naskh+Arabic:wght@400..700&display=swap" rel="stylesheet">



<style>
    
    .spinner{
        font-size: 10px;
    width: 17px;
    height: 17px;
    }
    .custom-card{
        border:1px solid rgb(0 0 0 / 18%);
        padding: 10px;
        height: auto;
        display: flex;
      
    }
   .arabic{
        font-family: "Noto Naskh Arabic", serif;
    }
    td{
        text-transform: uppercase;
    }
    .btn-light{
        border-color: #c3c3c3 !important;
    }
    table{
            width: 100% !important;
        }

        .w-25{
            width: 25%;
        }
        
    @media print {
        @page {
    size: 2in 1in; /* Set the size of the sticker */
    margin: 0; /* Remove default margins */
  }
.container{
    max-width: 100%;
    
}
table{
    width: 100% !important;
}

        .container {
    width: 100%; /* Ensure the container uses the full width of the page */
    height: 100%; /* Ensure the container uses the full height of the page */
  }

  .row {
    display: flex;
    flex-direction: row; /* Stack items vertically */
    height: 100%;
  }

  .col-md-4 {
    width: 50%;
  }
  .col-md-6 {
    width: 45%;
  }

  #sticker {
    width: 100%;
    height: 100%;
  }
    }
    
</style>
</head>
<body>

<div class="container" id="sticker" >
<div class="row border p-2">
    <div class="col-md-4 col-4">
    <table>
         <tr>
            <td colspan="2"> <img class="" src="<?= base_url('admin/Invoice/InvoiceController/generate_barcode/'.$patient_id) ?>" alt="Barcode for Invoice #"></td>
         </tr>
        <tr>
            <td class="fw-bold w-25">File No &nbsp;:</td>
            <td class="fw-bold"><?php echo $patient_id ?></td>
        </tr>
        <tr>
        <td class="fw-bold w-25">Name &nbsp;:</td>
            <td class="fw-bold"><?php echo $patient_name ?></td>
        </tr>
        <td class="fw-bold w-25">Natio.. &nbsp;:</td>
            <td class="fw-bold"><?php echo $country_name ?></td>
        </tr>
       
        <td class="fw-bold w-25">Age &nbsp;:</td>
            <td class="fw-bold" id="age"></td>

           
           
        </tr>
        <td class="fw-bold">Gender &nbsp;:</td>
            <td class="fw-bold"><?php echo $sex ?></td>
        </tr>
      </table>
    </div>
    <div class="col-md-4  mt-4">
   
        <div id="placeHolder" ></div>
        <canvas id="qr-canvas"></canvas>
       
    </div>
      
    </div>
</div>
<div class="container">
    <div class="row">
        
    <div class="d-print-none mt-4">
                            <div class="float-end">
                                <a onclick="window.print()" class="btn btn-light me-1"><i class="fa fa-print me-1"></i>Print</a>
                                <a href="#" class="btn btn-light " id="btn-whatsapp"><i class="fab fa-whatsapp me-1" ></i> Whatsapp <i class="spinner spinner-border whatsapp-loader" id="whatsapp-loader" style="display:none"></i></a>
                                <a href="javascript:void(0)" class="btn btn-light btn-download " id="btn-download"><i class="fa fa-download me-1"></i> Download <i class="spinner spinner-border pdf-loader" id="pdf-loader" style="display:none"></i></a>
                            </div>
                        </div>
    </div>
</div>

<script src="<?php echo base_url('js/qrcode.js')  ?>"></script>
<script src="<?php echo base_url('js/pdf/jspdf.debug.js')  ?> "></script>
<script src="<?php echo base_url('js/pdf/html2canvas.min.js')  ?>"></script>
<script src="<?php echo base_url('js/pdf/html2pdf.min.js')  ?> "></script>
<script>
    var data="<?php echo $invoice->patient_name  . $invoice->patient_id ?>";
    var data="<?php echo $patient_name  .'-'. $qatar_id ?>";
	genreateQrCode(data);

	function genreateQrCode(data){

    
var typeNumber = 5;
var errorCorrectionLevel = 'H';
var qr = qrcode(typeNumber, errorCorrectionLevel);
qr.addData(data);
qr.make();

var qrImageTag = qr.createImgTag(3,3);

var qrImageSrc = qrImageTag.match(/src="([^"]*)"/)[1]; // Extract the src attribute value
var qrImage = new Image();
var canvas = document.getElementById('qr-canvas');
var ctx = canvas.getContext('2d');
var logoUrl = '<?php echo base_url('/images/qrlogo.svg') ?> ';
console.log(logoUrl);
qrImage.onload = function() {
	// Set canvas dimensions to match QR code image
	canvas.width = qrImage.width;
	canvas.height = qrImage.height;
	
	// Draw QR code image on canvas
	ctx.drawImage(qrImage, 0, 0);

	// Draw logo image on canvas
	var logoImg = new Image();
	logoImg.onload = function() {
		var logoSize = qrImage.width / 3; // Logo size relative to QR code
		var logoX = (qrImage.width - logoSize) / 2;
		var logoY = (qrImage.height - logoSize) / 2;
		
		ctx.drawImage(logoImg, logoX, logoY, logoSize, logoSize);
	};
	logoImg.src = logoUrl;
};

qrImage.src = qrImageSrc; // Use the extracted src attribute value
}
</script>
<script>

    const options = {
      margin: 0.5,
      filename: 'invoice.pdf',
      image: { 
        type: 'jpeg', 
        quality: 500
      },
      html2canvas: { 
        scale: 1 
      },
      jsPDF: { 
        unit: 'in', 
        format: 'letter', 
        orientation: 'landscape' 
      }
    }
    
    document.getElementById('btn-download').addEventListener('click', function(e) {
        document.getElementById('pdf-loader').style.display="inline-block";  
      e.preventDefault();
      const element = document.getElementById('invoice');
      html2pdf().from(element).set(options).save().then(function(){
        document.getElementById('pdf-loader').style.display="none";
      });
     
    });


    function printDiv(divName) {
     var printContents = document.getElementById(divName).innerHTML;
     var originalContents = document.body.innerHTML;

     document.body.innerHTML = printContents;

     window.print();

     document.body.innerHTML = originalContents;
}
    </script>

<script>
    var dob = "<?php echo $dob ?>";
    document.getElementById('age').innerHTML=calculateAge(dob) + ' Years';
   
     function calculateAge(dob) {
                var dob = new Date(dob);
                var diffMs = Date.now() - dob.getTime();
                var ageDt = new Date(diffMs); 
                return Math.abs(ageDt.getUTCFullYear() - 1970);
    }
    var base_url ="<?php echo base_url() ?>";
        const options2 = {
            margin: 0.5,
            filename: 'invoice.pdf',
            image: { type: 'jpeg', quality: 0.98 },
            html2canvas: { scale: 1 },
            jsPDF: { unit: 'in', format: 'letter', orientation: 'portrait' }
        };

        document.getElementById('btn-whatsapp').addEventListener('click', function(e) {
            e.preventDefault();
            document.getElementById('whatsapp-loader').style.display="inline-block";
            const element = document.getElementById('invoice');
            html2pdf().from(element).set(options2).outputPdf('blob').then(function(blob) {
                const formData = new FormData();
                formData.append('file', blob, 'invoice.pdf');
                fetch(base_url+'admin/Invoice/InvoiceController/send_whatsapp_pdf', {
                    method: 'POST',
                    body: formData
                }).then(response => response.json()).then(data => {
                    alert(data.message);
                    document.getElementById('whatsapp-loader').style.display="none";
                }).catch(error => {
                    console.error('Error:', error);
                    document.getElementById('whatsapp-loader').style.display="none";
                });
            });
        });
    </script>
</body>
</html>

