<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<title>Patient File</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

	<!--image crop-->
	<link href="<?php echo base_url('plugins/croppie/croppie.css') ?>" rel="stylesheet" type="text/css" />
	<script src="<?php echo base_url('plugins/croppie/croppie.js') ?>" type="text/javascript"></script>
	<!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" /> -->
	<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script> -->

	<?php require_once(APPPATH . "views/admin/header.php"); ?>

	<style>

		.uploadIcon {
			font-size: 5em !important;
			color: #084a6a;
		}

		@keyframes blink {
			0% {
				opacity: 0.5;
			}

			50% {
				opacity: 1;
			}

			100% {
				opacity: 0.5;
			}
		}
		
		#print-card{
            margin-top: -60px!important;
		}

		.uploadLable {
			cursor: pointer;
			padding: 10px;
			cursor: pointer;
			animation: blink 1s infinite;
		}

		.statics {
			font-size: 25px;
			font-weight: 400;
		}

		@media print {
			.no-print {
				display: none;
			}

			.on-print {
				display: block !important;
			}


		}
	</style>

</head>


<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Patient document upload modal -->
	<div class="modal fade no-print" id="uploadPatientDocumentModal" tabindex="-1" role="dialog" aria-labelledby="uploadPatientDocumentModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="uploadPatientDocumentModalLabel">Upload New Document</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<form id="fileUploadForm" class="text-center" enctype="multipart/form-data" action="<?php echo base_url('index.php/admin/Patients/PatientsController/uploadPatientDocuments') ?>" method="POST">
						<input type="hidden" name="patientId" value="<?= encrypt_and_url_encode($patient_id, $this) ?>">
						<i class="fa fa-cloud-upload uploadIcon" aria-hidden="true"></i>
						<div class="form-group">
							<label for="patientDocument" class="uploadLable">Choose a file</label>
							<?php if (form_error("patientDocument")) : ?>
								<br><label><small class="text-danger"><?= form_error("patientDocument"); ?></small></label>
								<script>
									$(document).ready(function() {
										$("#uploadPatientDocumentModal").modal("show");
									});
								</script>
							<?php endif; ?>
							<input type="file" class="form-control" name="patientDocument" id="patientDocument" accept=".pdf, .doc, .docx">
							<div class="form-group <?php echo form_error("documentName") ? "has-error" : "" ?>">
								<label for="document_name">Document Name</label>
								<input type="text" class="form-control" name="documentName" id="document_name" <?= $document_name; ?>>
								<label><small class="text-danger"><?= form_error("documentName"); ?></small></label>
							</div>
						</div>
					</form>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-light btn-sm" onclick="$('#fileUploadForm').submit()"><i class="fa fa-check-circle" aria-hidden="true"></i> Upload</button>
					<button type="button" class="btn btn-light btn-sm" data-dismiss="modal"><i class="fa fa-times-circle" aria-hidden="true"></i> Close</button>
				</div>
			</div>
		</div>
	</div>

	<!-- Site wrapper -->

	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header no-print">
			<h1>
				Patient File<small style="color: #084a6a;" class="font-weight-bold"><?= $patient_name; ?> | since <?= $registerd_date; ?></small>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>

		<!-- Main content -->
		<section class="content">
			<div class="row">
		<div class="col-md-12 on-print hide" style="display: flex;flex-wrap: wrap;flex-direction: row;justify-content: space-between;">
						<?php echo print_header($this); ?>
					</div>
					<div class="col-md-12 on-print hide text-center" style="margin-bottom: 45px;">
													<h4><u>Patient File</u></h4>
												</div></div>

			<div class="row no-print">
				<div class="col-12">
					<div class="box box-solid">
						<div class="box-body">
							<div class="row">
								<div class="col-12">
									<div class="d-flex w-100 justify-content-between ">
										<button href="<?php echo base_url('index.php/admin/Patients/PatientsController') ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go back</button>

										<?php
										$success = $this->session->flashdata('success');
										if ($success) { ?>
											<div class="col-md-9">
												<div class="callout <?php echo $this->config->item('msg_success'); ?> error-msg">
													<div>
														<span><i class="icon fa fa-check"></i><?= $success; ?></span>
													</div>
												</div>
											</div>
										<?php } ?>

										<button class="btn btn-dark btn-sm" onclick="window.print()">
											<i class="ri-printer-line" aria-hidden="true"></i> Print
										</button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			

			<div class="row">
					
				<div class="col-6 col-md-6">
					<div class="row">
						<div class="col-12 col-md-12" id="print">
							<div class="box box-info" style="margin-bottom: 5px;">
								<div class="box-body">
									<div class="row">
										<div class="col-12">
											<h4>Patient Details</h4>
											<hr>
										</div>
									</div>
									<div class="row p-3">
										<div class="ml-1 mb-3" style="justify-content: center;">
											<?php if ($sex == 'Female') {
												if ($profile_img != 0 || $profile_img != "") {
											?>
													<img class="form-control popup-image cursor-pointer" style=" object-fit:contain; max-height:300px" src="<?php echo base_url('' . UPLOAD_PATH . 'patients/profile/' . $profile_img);  ?>">
													<!-- <i class="ri-user-line logo_patient"></i> -->
												<?php } else { ?>
													<img class="form-control" style=" object-fit:contain" src="<?php echo base_url('\Images\example_id.jpg'); ?>">
												<?php }
											} else {
												if ($profile_img != 0 || $profile_img != "") { ?>

													<img class="img-fluid rounded popup-image cursor-pointer" style=" object-fit:contain; max-height:300px" src="<?php echo base_url('' . UPLOAD_PATH . 'patients/profile/' . $profile_img);  ?>">
													<!-- <i class="ri-user-line logo_patient"></i> -->
												<?php  } else { ?>
													<img class="img-fluid" style=" object-fit:contain" src="<?php echo base_url('\Images\example_id.jpg'); ?>">
											<?php }
											} ?>
										</div>
										<table class="table">
											<tbody>
											    <tr>
													<td width="40%"><small><i class="ri-asterisk" aria-hidden="true"></i></small> <strong>Patient ID</strong></td>
													<td width="60%">:&nbsp;&nbsp;<?= htmlspecialchars($patient_id); ?></td>
												</tr>
												<tr>
													<td width="40%"><small><i class="ri-user-line" aria-hidden="true"></i></small> <strong>Name</strong></td>
													<td width="60%">:&nbsp;&nbsp;<?= htmlspecialchars($patient_name); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-user-add-line" aria-hidden="true"></i></small> <strong>Registration Date</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($registerd_date); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-id-card-line" aria-hidden="true"></i></small> <strong>Qatar ID</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($qatar_id); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-passport-line" aria-hidden="true"></i></small> <strong>Passport/Alternative Number</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($passport_number); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-shield-user-line" aria-hidden="true"></i></small> <strong>Guardian's ID</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($guardian_id); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-pushpin-2-line" aria-hidden="true"></i></small> <strong>Country of Residence</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($country_name); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-cake-line" aria-hidden="true"></i></small> <strong>Date of Birth</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($dob); ?> (Age: <?= (new DateTime())->diff(new DateTime($dob))->y; ?>)</td>
												</tr>
												<tr>
													<td><small><i class="ri-earth-line" aria-hidden="true"></i></small> <strong>Nationality</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($nationality); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-cellphone-line" aria-hidden="true"></i></small> <strong>Mobile Number</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($mobile); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-smartphone-line" aria-hidden="true"></i></small> <strong>Second Mobile Number</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($second_mobile); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-phone-line" aria-hidden="true"></i></small> <strong>Emergency Contact Number</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($emergency_mobile); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-at-line" aria-hidden="true"></i></small> <strong>Email</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($email); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-map-2-line" aria-hidden="true"></i></small> <strong>Zone</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($zone); ?></td>
												</tr>
												<tr>
													<td><small><i class="fa fa-road" aria-hidden="true"></i></small> <strong>Street</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($street); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-building-line" aria-hidden="true"></i></small> <strong>Building</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($building); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-shield-line" aria-hidden="true"></i></small> <strong>Insurance Type</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($insurance_name); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-folders-line" aria-hidden="true"></i></small> <strong>Category</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($category); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-men-line" aria-hidden="true"></i></small> <i class="ri-women-line" aria-hidden="true"></i> <strong>Gender</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($sex); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-heart-line" aria-hidden="true"></i></small> <strong>Marital Status</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($marital); ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-spam-3-line" aria-hidden="true"></i></small> <strong>Black List</strong></td>
													<td>:&nbsp;&nbsp;<?= (int)$black ? '<span class="text-danger">Yes</span>' : '<span class=" text-success">No</span>'; ?></td>
												</tr>
												<tr>
													<td><small><i class="ri-sticky-note-line" aria-hidden="true"></i></small> <strong>Note</strong></td>
													<td>:&nbsp;&nbsp;<?= htmlspecialchars($note); ?></td>
												</tr>
											</tbody>
										</table>

									</div>

								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-6 col-md-6">
					<div class="row">
						<div class="col-12 col-md-12">
							<div class="box box-info" style="margin-bottom: 5px;">
								<div class="box-body">
									<div class="row">
										<div class="col-12">
											<h4>Last Visit</h4>
											<hr>
										</div>
									</div>

									<div class="row p-2">
										<div class="col-md-12" style="    max-height: 60vh;overflow-y: auto;overflow-x: hidden;">
											<?php foreach ($visits as $row) :
											?>
												<div class="row mt-1">
													<div class="col-12">
														<div class="border rounded p-2">
															<h6>#<?= date('Y', strtotime($row->treat_date)) ?></h6>
															<table class="w-100">
																<tbody>
																	<tr>
																		<td><strong>Doctor</strong></td>
																		<td><span><?= $row->full_name ?></span></td>
																		<td><strong>Time</strong></td>
																		<td><span><?= $row->treat_date ?></span></td>
																	</tr>
																	<tr>
																		<td><strong>Total</strong></td>
																		<td><span><?= $row->total ?></span></td>
																		<td><strong>Department</strong></td>
																		<td><span><?= $row->module_name ?></span></td>
																	</tr>
																	<tr>
																		<td><strong>Date</strong></td>
																		<td class="text-left"><span><?= date('d/m/Y', strtotime($row->treat_date)) ?></span></td>
																	</tr>
																</tbody>
															</table>
														</div>
													</div>
												</div>
											<?php endforeach; ?>
										</div>
									</div>

								</div>
							</div>
						</div>

						<div class="col-12 col-md-12 no-print">
							<div class="box box-info" style="margin-bottom: 5px;">
								<div class="box-body">
									<div class="row">
										<div class="col-12">
											<h4>Last Measurements</h4>
											<hr>
										</div>
									</div>
									<div class="col-md-10s">
										<ul class="list-group">
											<li class="list-group-item no-border">
												<i class="fa fa-heartbeat mr-3 text-success f-16" aria-hidden="true"></i>Heart Beat : <strong class=""><?= $triage[0]['bp'] ?? '---' ?></strong><sup class="text-muted">b.p.m</sup><br>
											</li>
											<li class="list-group-item no-border">
												<i class="fa fa-thermometer-empty mr-3 text-danger f-16" aria-hidden="true"></i>Temprature :<strong class=""><?= $triage[0]['temperature'] ?? '---' ?></strong> <sup class="text-muted">��C</sup><br>
											</li>
											<li class="list-group-item no-border">
												<i class="fa fa-heart  mr-3 text-danger f-16" aria-hidden="true"></i>Pulse :<strong class=""><?= $triage[0]['pulse'] ?? '---' ?></strong> <sup class="text-muted">mmHg</sup><br>
											</li>
											<li class="list-group-item no-border">
												<i class="fa fa-balance-scale mr-3 text-primary f-16" aria-hidden="true"></i></i>Weight : <strong class=""><?= $triage[0]['weight'] ?? '---' ?></strong> <sup class="text-muted">kg</sup><br>
											</li>
											<li class="list-group-item no-border">
												<i class="fa fa-arrows-v mr-3 f-16" aria-hidden="true"></i> Height : <strong class=""><?= $triage[0]['height'] ?? '---' ?></strong> <sup class="text-muted">cm</sup><br>
											</li>
										</ul>
									</div>

								</div>
							</div>
						</div>
						<div class="col-12 col-md-12">
							<div class="box box-info" style="margin-bottom: 5px;">
								<div class="box-body">
									<div class="row">
										<div class="col-12">
											<h4>Patient Statistic</h4>
											<select name="" class="form-control form-control-sm" id="patient_sumRange">
												<option value="1">Today</option>
												<option value="2">This Week</option>
												<option value="3" >This Month</option>
												<option value="4" selected>This Year</option>
											</select>
											<hr>
										</div>
									</div>
									<div class="row pl-3">
										<div class="col-12 d-flex align-items-baseline">
											<!-- <canvas id="donutChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas> -->
											<!-- <canvas id="donutChart" width="300" height="300"></canvas> -->
											<span>Visits Count:&nbsp;&nbsp;</span>
											<p id="visits" class="statics"></p>
										</div>
										<div class="col-12 d-flex align-items-baseline">
											<span>Total Amount:&nbsp;&nbsp;</span>
											<p id="total" class="statics"></p>
										</div>
										<div class="col-12 d-flex align-items-baseline">
											<span>Paid Amount:&nbsp;&nbsp;</span>
											<p id="paid" class="statics"></p>
										</div>
										<div class="col-12 d-flex align-items-baseline">
											<span>Balance Amount:&nbsp;&nbsp;</span>
											<p id="balance" class="statics"></p>
										</div>
									</div>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="row no-print">
				<div class="col-12">
					<div class="box box-info" style="margin-bottom: 5px;">
						<div class="box-body">
							<div class="row">
								<div class="col-12">
									<div class="d-flex justify-content-between">
										<h4>File & Documents</h4>
										<button class="btn btn-dark btn-sm" id="uploadDocumentBtn" data-toggle="modal" data-target="#uploadPatientDocumentModal">
											<i class="fa fa-cloud-upload" aria-hidden="true"></i> Upload New Documents
										</button>
									</div>
									<hr>
									<div class="row">
										<?php foreach ($documents as $document) : ?>
											<?php
											$uploadPath = './' . UPLOAD_PATH . '' . md5($document->patient_id);
											$filePath = $uploadPath . '/' . $document->document;
											$fileExtension = (pathinfo($filePath, PATHINFO_EXTENSION));
											$preview = null;
											switch ($fileExtension) {
												case 'pdf':
													$preview = '<i class="fa fa-file-pdf-o text-danger mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
													break;

												case 'docx':
												case 'doc':
													$preview = '<i class="fa fa-file-word-o text-primary mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
													break;

												case 'txt':
													$preview = '<i class="fa fa-file-text mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
													break;

												case 'xlsx':
												case 'csv':
													$preview = '<i class="fa fa-file-excel-o text-success mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
													break;

												case 'jpg':
												case 'jpeg':
												case 'png':
												case 'gif':
													$preview = '<i class="fa fa-file-image-o mr-2 text-warning" style="font-size:1.5em;" aria-hidden="true"></i>';
													break;

												default:
													$preview = "File type not supported.";
													break;
											}

											?>
											<div class="col-sm-3 mt-1">
												<div class="card">
													<div class="card-body">
														<h6 class="card-title"><?= $preview; ?><?= $document->name; ?></h6>
														<a href="<?= base_url('index.php/admin/Patients/PatientsController/downloadFile/' . encrypt_and_url_encode($document->patient_id, $this) . '/' . $document->document) ?>" class="btn btn-light btn-sm" target="_blank "><i class="fa fa-cloud-download" aria-hidden="true"></i> Download</a>
													</div>
												</div>
											</div>
										<?php endforeach; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
	</div>


	</div>


	</section>

	</div>

	<!-- ./wrapper -->


	<?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>

</html>

<script>
	$(document).ready(function() {});


	var donutChart = ''

	function drawchart(response) {

		// if (donutChart != '') {
		// 	donutChart.destroy()
		// }
		// if (response != null) {
		// 	$('#donutChart').parent().find('div').html('');
		// } else {
		// 	$('#donutChart').parent().find('div').html('<p id="tretno" style="text-align: center; color: #888; font-size: 16px;position: absolute;right: 40%;top: 40%;">No data available</p>')
		// 	return;
		// }



		var visits = response ? response.visits : 0
		var total = response ? response.total : 0
		var paid = response ? (response.total - response.balance) : 0
		var balance = response ? response.balance : 0

		let visitsCount = new CountUp('visits', 0, Number(visits), 0, 1);
		visitsCount.start();
		let totalCount = new CountUp('total', 0, Number(total), 2, 1);
		totalCount.start();
		let paidCount = new CountUp('paid', 0, Number(paid), 2, 1);
		paidCount.start();
		let balanceCount = new CountUp('balance', 0, Number(balance), 2, 1);
		balanceCount.start();

		// let total_balance = new CountUp('total_balance', 0, Number(totalBalanceAmount), 2, 1);
		// total_balance.start();

		// var donutChartCanvas = $('#donutChart').get(0).getContext('2d');
		// var donutData = {
		// 	labels: ['Visits', 'Treatments', 'Paid', 'balance'],
		// 	datasets: [{
		// 		label: 'Visits',
		// 		data: visits,
		// 		backgroundColor: '#f56954',
		// 	},{
		// 		label: 'Treatments',
		// 		data: total,
		// 		backgroundColor: '#00a65a',
		// 	},{
		// 		label: 'Paid',
		// 		data: paid,
		// 		backgroundColor: '#f39c12',
		// 	},{
		// 		label: 'balance',
		// 		data: balance,
		// 		backgroundColor: '#00c0ef',
		// 	} ]
		// };

		// var donutOptions = {
		// 	maintainAspectRatio: false,
		// 	responsive: true,
		// };
		// donutChart = new Chart(donutChartCanvas, {
		// 	type: 'radar',
		// 	data: donutData,
		// 	options: donutOptions
		// });

	}


	$('#patient_sumRange').on('change', function() {
		let period = $(this).val();
		patientSummary(period)
	})

	function patientSummary(period) {
		var patient_id = '<?= $patient_id ?>';
		$.ajax({
			url: '<?= base_url('index.php/admin/Patients/PatientsController/getPatientSummery') ?>',
			type: 'GET',
			contentType: 'application/json',
			data: {
				period: period,
				patient_id: patient_id
			},
			success: function(response) {
				drawchart(response);
			},
			error: function(error) {}
		});

	}


	patientSummary('4')
</script>

<script src="https://cdn.jsdelivr.net/npm/dompurify@2.3.3/dist/purify.min.js"></script>
<script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script>
	function generatePDF() {
		window.jsPDF = window.jspdf.jsPDF;
		const pdf = new jsPDF('p', 'pt', 'a4');

		const content = document.getElementById('print');
		const removeElements = content.getElementsByTagName('i');

		for (i = 0; i < removeElements.length; i++) {
			//removeElements[i].removeAttribute('class');
			removeElements[i].style.display = 'none';
		}

		pdf.html(content, {
			callback: function(pdf) {
				pdf.save('<?= str_replace(' ', '_', strtolower($patient_name)) . date('Ymdhis'); ?>.pdf');

				for (i = 0; i < removeElements.length; i++) {
					removeElements[i].style.display = 'inline-block';
				}
			}
		});

	}
	document.getElementById('generatePdf').addEventListener('click', generatePDF);
</script>