<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Patient Print</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css"  crossorigin="anonymous">
    <style>
        .container{
            width: 50%;
            margin: auto;
        }
        .td-heading{
            font-size: 17px;
            font-weight:700;
        }
       .td-data{
        font-size: 16px;
        font-weight: 500;
       }
       .image-box{
        width: 40%;
        height: 170px;
        margin: auto;
        padding-top: 10px;
        margin-bottom: 10px;
       }
       .image-box img{
        object-fit:contain;
        width:100%;
        height: 100%;

       }
       .only-print{
        display: none;
       }
       @media print {
        .only-print{
        display: block;
       }
       }
    </style>
</head>
<body>
    <div class="only-print">
    <?php echo print_header($this) ?>
    </div>

    <div class="container">
      

       <h2 style="text-align:center">Patient File	</h2>
        <div class="image-box">
           
            <img src="<?php echo base_url('' . UPLOAD_PATH . 'patients/profile/' . $patient->profile_img);  ?>" alt="">
        </div>
        <table class="table table-bordered" > 
            <tr>
                <td class="td-heading">File No</td>
                <td class="td-data"><?= $patient->patient_id ?></td>
            </tr>
            <tr>
                <td class="td-heading">Patient Name</td>
                <td class="td-data"><?= $patient->patient_name ?></td>
            </tr>
            <tr>
                <td class="td-heading">QID</td>
                <td class="td-data"><?= $patient->qatar_id ?></td>
            </tr>
            <tr>
                <td class="td-heading">DOB</td>
                <td class="td-data"><?= $patient->dob ?></td>
            </tr>
            <tr>
                <td class="td-heading">Nationality</td>
                <td class="td-data"><?= $patient->country_name ?></td>
            </tr>
            <tr>
                <td class="td-heading">Sex</td>
                <td class="td-data"><?= $patient->sex ?></td>
            </tr>
            <tr>
                <td class="td-heading">Mobile No</td>
                <td class="td-data"><?= $patient->mobile ?></td>
            </tr>
            <tr>
                <td class="td-heading">Address</td>
                <td class="td-data"><?= $patient->zone  .'/'. $patient->street .'/'.$patient->building ?></td>
            </tr>
        </table>
    </div>

    <script>
        window.print();
    </script>
</body>
</html>