<div class="row">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h4 class="panel-title">Income Report</h4>
                </div>
                <form  id="profit_report" method="post">
                  <div class="panel-body">
                    <div class="row">
                      <div class="col-md-3">
                        <div class="form-group">
                          <label>Select Supplier</label>
                          <select class="form-control" id="suppliers" name="suppliers">
                            <option value="-1">All</option>
                            <?php if(isset($suppliers) AND $suppliers != NULL){ foreach($suppliers as $val){ ?>
                                <option value="<?php echo $val['supplier_id']; ?>"><?php echo $val['supplier_name']; ?></option>
                            <?php }} ?>
                          </select>
                        </div>
                            </div>
							<div class="col-md-3">
                        <div class="form-group">
                          <label>Select Drug</label>
                          <select class="form-control" id="drugs" name="drugs">
						  <option value="-1">All</option>
                            <?php if(isset($drugs) AND $drugs != NULL){ foreach($drugs as $val){ ?>
                                <option value="<?php echo $val['drug_id']; ?>"><?php echo $val['drug_name']; ?></option>
                            <?php }} ?>
                          </select>
                        </div>
                            </div>
                            <div class="col-md-3">
                        <div class="form-group">
                          <label class="from" for="from">From</label>
                          <label class="date" for="date">Date</label>
                          <input type="date" class="form-control" name="from" id="from">
                        </div>
                        
                        </div>
                        <div class="col-md-3">
                        <div class="form-group">
                          <label for="to">To</label>
                          <input type="date" class="form-control" name="to" id="to">
                        </div>
                            </div>
                      </div>
                    </div>
                   
                    <button type="reset" class="btn  btn-dark hidden-print" id="clear">Clear</button>
                  </div>
                </form>
              </div>
            </div>

</div>
<div class="row mt-5" >
    <div class="col-md-12 mx-auto">
        <table id="p_report" class="table table-light table-bordered table-striped">
                
		
		<tfoot>
    <tr>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th>Total Cost:</th>
		<th>Total Profit:</th>
    </tr>
</tfoot>
        </table>
        </div>
</div>

<script>

function displayContent() {
        var dateFrom = $('#from').val();
        var dateTo = $('#to').val();
        console.log(dateFrom);
        var suppliers = $('#suppliers').val();
        $.ajax({
            url: "<?php $this->load->helper('url'); echo site_url('/admin/Reports/ReportsController/get_p_expiring_report'); ?>",
            type: 'post',
            data: {from:dateFrom, to:dateTo, suppliers:suppliers},
            success: function (result) {
                 $('#content').html(result);
            },
        });
     }
     $(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#p_report').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Profit Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Profit Report`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/get_report_profit_views'); ?>',
				'type': 'POST',
				'data': function(d) {
					d.suppliers = $('#suppliers').val();
					d.from = $('#from').val();
					d.to = $('#to').val();
					d.drugs = $('#drugs').val();
				}
			},
			'columns': [
				 { "data": "sell_date", "title": "Sell Date" },
				 { 
            data: 'supplier_name', 
            title: 'Supplier Name',
            
        },
				{ "data": "drug_name", "title": "Drug Name" },
				{ "data": "credit", "title": "Credit" },
				{ "data": "cash", "title": "Cash" },
				{ "data": "total_cost", "title": "Total Cost" },
				{ "data": "profit", "title": "Profit" }
				
			],
			'footerCallback': function(row, data, start, end, display) {
        var api = this.api();

	
	

				pageTotal = api
                .column(6, { page: 'current'} )
                .data()
                .sum();
          totalCost = api
                .column(5, { page: 'current'} )
                .data()
                .sum();
          totalCash = api
                .column(4, { page: 'current'} )
                .data()
                .sum();
          totalCredit = api
                .column(3, { page: 'current'} )
                .data()
                .sum();

	
				$(api.column(6).footer() ).html(
                "<h5><b>Total Profit</b> :"+ pageTotal + "</h5>");
        $(api.column(5).footer() ).html(
        "<h5><b>Total Cost</b> :"+ totalCost + "</h5>");
        $(api.column(4).footer() ).html(
        "<h5><b>Total Cash</b> :"+ totalCash + "</h5>");
        $(api.column(3).footer() ).html(
        "<h5><b>Total Credit</b> :"+ totalCredit + "</h5>");

    },
					
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			
			footer:true,
			autoWidth: false

		});



		$('#suppliers,#drugs, #from,#to ').on('change', function() {
			dataTable.ajax.reload();
		});
        $('#clear').on('click', function() {
            $('#profit_report').trigger("reset");
			dataTable.ajax.reload();
		});
	});


</script>