<div class="row hidden-print">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h3 class="panel-title">Filter By Date</h3>
                </div>
                <form id="sale_form" method="post">
                  <div class="panel-body">
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Select Cashier</label>
                          <select class="form-control" id="cashier">
                          <option value="-1">All</option>
                            <?php if(isset($cashiers) AND $cashiers != NULL){ foreach($cashiers as $val){ ?>
                                <option value="<?php echo $val['user_id']."-".$val['employee_name']; ?>"><?php echo $val['employee_name']; ?></option>
                            <?php }} ?>
                          </select>
                        </div>
                        </div>
                        <div class="col-md-4">
                             <div class="form-group">
                                <label>Request</label>
                                <select class="form-control" id="request">
                                        <option value="2">All</option>
                                        <option value="1">In-Patient</option>
                                        <option value="0">Out-Patient</option>
                                </select>
                             </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="from" for="from">From</label>
                                <label class="date" for="date">Date</label>
                                <input type="date" class="form-control" name="from" id="from">
                              </div>
                        </div>
                     
                          
                          <div class="col-md-4">
                            <div class="form-group">
                                <label class="date" for="date">Time</label>
                                <input type="time" class="form-control clockpicker" name="stime" id="stime" value="00:00">
                              </div>
                          </div>
                        
                        
                          <div class="col-md-4">
                              <div class="form-group">
                                <label for="to">To Date</label>
                                <input type="date" class="form-control" name="to" id="to">
                              </div>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group">
                                <label class="date" for="date">Time</label>
                                <input type="time" class="form-control clockpicker" name="etime" id="etime" value="23:59">
                              </div>
                          </div>
                        
                          <div class="col-md-4">
                          <!-- <button type="button" class="btn btn-default btn-primary hidden-print" onclick="displayContent();">Show Report</button> -->
                         <button type="reset" class="btn btn-dark  hidden-print" id="clear">Clear</button>
                            </div>  
                  </div>
                            </div>
                </form>
              </div>
            </div>
          </div>

          <div class="row mt-5" >
    <div class="col-md-12 mx-auto" id="content">
        <table id="p_report" class="table table-light table-bordered table-striped">
                        
        </table>
        </div>
</div>


<script>

function displayContent() {
        var dateFrom = $('#from').val();
        var dateTo = $('#to').val();
        console.log(dateFrom);
        var suppliers = $('#suppliers').val();
        $.ajax({
            url: "<?php $this->load->helper('url'); echo site_url('/admin/Reports/ReportsController/get_payment_list'); ?>",
            type: 'post',
            data: {from:dateFrom, to:dateTo, suppliers:suppliers},
            success: function (result) {
                 $('#content').html(result);
            },
        });
     }
     $(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#p_report').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Pharmacy Expire Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Pharmacy Expire Report`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
      'ajax': {
        'url': '<?= site_url('admin/Reports/ReportsController/get_payment_list'); ?>',
        'type': 'POST',
        'data': function(d) {
            d.cashier = $('#cashier').val();
            d.request = $('#request').val();
            d.from = $('#from').val();
            d.to = $('#to').val();
            d.timeFrom = $('#stime').val();
            d.timeTo = $('#etime').val();
        }
    },
    'columns': [
        { 'data': 'order', 'title': 'Order' },
        { 'data': 'sales_person', 'title': 'Sales Person' },
        { 'data': 'total', 'title': 'Total' },
        { 'data': 'discount', 'title': 'Discount' },
        { 'data': 'cash', 'title': 'Cash' },
        { 'data': 'card', 'title': 'Card' },
        { 'data': 'net_total', 'title': 'Net Total' },
    ],
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			'pagingType': 'full_numbers',
			footer:true,
			autoWidth: false

		});



		$('#cashier,#request, #from,#to,#stime,#etime ').on('change', function() {
			dataTable.ajax.reload();
		});
        $('#clear').on('click', function() {
            $('#sale_form').trigger("reset");
			dataTable.ajax.reload();
		});
	});


</script>