<div class="row">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h4 class="panel-title">Supplier Report</h4>
                </div>
                <form  method="post" id="supplier_report">
                  <div class="panel-body">
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Select Supplier</label>
                          <select class="form-control" id="supplier">
                          <option value="-1">All</option>
                            <?php if(isset($suppliers) AND $suppliers != NULL){ foreach($suppliers as $val){ ?>
                                <option value="<?php echo $val['supplier_id']; ?>"><?php echo $val['supplier_name']; ?></option>
                            <?php }} ?>
                          </select>
                        </div>
						</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label>Select Drug</label>
                          <select class="form-control" id="drug">
						  <option value="-1">All</option>
                            <?php if(isset($drugs) AND $drugs != NULL){ foreach($drugs as $val){ ?>
                                <option value="<?php echo $val['drug_id']; ?>"><?php echo $val['drug_name']; ?></option>
                            <?php }} ?>
                          </select>
                        </div>
						</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label>Select Cashier</label>
                          <select class="form-control" id="cashier">
                          <option value="-1">All</option>
                            <?php if(isset($cashiers) AND $cashiers != NULL){ foreach($cashiers as $val){ ?>
                                <option value="<?php echo $val['user_Id'] ?>"><?php echo $val['full_name']; ?></option>
                            <?php }} ?>
                          </select>
                        </div>
                        </div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label class="from" for="from">From</label>
                          <label class="date" for="date">Date</label>
                          <input type="date" class="form-control" name="from" id="from">
                        </div>
							</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label for="to">To</label>
                          <input type="date" class="form-control" name="to" id="to">
                        </div>
						</div>
                     
                    </div>
                    
                    <button type="reset" class="btn btn-dark  hidden-print" id="clear">Clear</button>
                  </div>
                </form>
              </div>
            </div>

</div>
<div class="row mt-5" >
    <div class="col-md-12 mx-auto">
        <table id="p_report" class="table table-light table-bordered table-striped">
                        
        </table>
        </div>
</div>

<script>

     $(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#p_report').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Supplier Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Supplier Report`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/get_report_views'); ?>',
				'type': 'POST',
				'data': function(d) {
					d.suppliers = $('#supplier').val();
					d.drug = $('#drug').val();
					d.cashier = $('#cashier').val();
					d.from = $('#from').val();
					d.to = $('#to').val();
				}
			},
			'columns': [{
					'data': 'sell_bill_id',
					'title': 'Sell Bill No.'
				},
				{
					'data': 'bill_date',
					'title': 'Bill Date.'
				},
				{
					'data': 'sell_date',
					'title': 'Sell Date'
				},
				
				{
					'data': 'supplier_name',
					'title': 'Supplier Name.'
				},
				{
					'data': 'drug_name',
					'title': 'Drug Name'
				},
				{
					'data': 'qty',
					'title': 'Quantity'
				},
				{
					'data': 'sell_prices',
					'title': 'Amount'
				},
                {
					'data': 'type',
					'title': 'Payment Type'
				},
                {
					'data': 'total',
					'title': 'Total'
				},
				
			],
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			'pagingType': 'full_numbers',
			footer:true,
			autoWidth: false

		});



		$('#drug, #from,#to,#supplier,#cashier').on('change', function() {
			dataTable.ajax.reload();
		});
        $('#clear').on('click', function() {
            $('#supplier_report').trigger("reset");
			dataTable.ajax.reload();
		});
	});


</script>