<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Payments List </title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <!--image crop-->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


  <?php require_once(APPPATH . "views/admin/header.php"); ?>
  <style>
    .small-box {
			text-decoration: none;
			color: #444444;
      transition-timing-function: ease-in-out;
      cursor: pointer;
		}

    .small-box:hover {
			text-decoration: none;
			color: #084a6ad9;
		}
    
    .small-box {
      box-shadow: 0 1px 11px 0px rgba(0, 0, 0, 0.1) !important;
    }

    .inner{
      height: 120px;
    }

    .dashboard_icon{
      color: black;
      font-size: 60px;
    }
    
    .phrma_dash_num{
      font-weight: 900;
    }
  </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <strong>Pharmacy</strong>
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <!-- Main content -->
    <form id="submitForm" name="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Patients/PatientsController/search') ?>" method="post">

      <section class="content">
        <!--buttons-->


        <!--//buttons-->

        <!--table-->
        <?php require_once(APPPATH . "views/admin/Pharmacy/Store/itemExpire.php"); ?>
        <?php require_once(APPPATH . "views/admin/Pharmacy/Store/lowQuantity.php"); ?>

        <div class="box box-info">

          <div class="box-body">
            <ul class="nav nav-tabs" id="form_recipt" role="tablist">
            
              <li class="nav-item" id="non_insurance">
                <a class="nav-link font-weight-bold active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">POS</a>
              </li>
              <li class="nav-item" id="non_insurance">
                <a class="nav-link font-weight-bold" id="pos-tab" data-toggle="tab" href="#pos" role="tab" aria-controls="pos" aria-selected="true">Store</a>
              </li>
              <li class="nav-item" id="insurance">
                <a class="nav-link font-weight-bold" id="profile-tab" data-toggle="tab" href="#profile-content" role="tab" aria-controls="profile" aria-selected="false">Suppliers</a>
              </li>
              <li class="nav-item" id="insurance-nav">
                <a class="nav-link font-weight-bold" id="financial-tab" data-toggle="tab" href="#financial-content" role="tab" aria-controls="insurance" aria-selected="false">Financial</a>
              </li>
              <li class="nav-item" id="insurance-nav">
                <a class="nav-link font-weight-bold" id="insurance-tab" data-toggle="tab" href="#reports-content" role="tab" aria-controls="insurance" aria-selected="false">Reports</a>
              </li>
            </ul>


            <div class="tab-content" id="form_recipt_content">
            <?php require_once(APPPATH . "views/admin/Pharmacy/POS/posDashboard.php"); ?>
            <?php require_once(APPPATH . "views/admin/Pharmacy/Store/storeDashboard.php"); ?>
            <?php require_once(APPPATH . "views/admin/Pharmacy/Supplier/supplierDashboard.php"); ?>
            <?php require_once(APPPATH . "views/admin/Pharmacy/Financial/financialDashboard.php"); ?>
            <?php require_once(APPPATH . "views/admin/Pharmacy/Reports/reportDashboard.php"); ?>

              
                
              <div class="tab-pane fade" id="profile-content" role="tabpanel" aria-labelledby="profile-tab">
                <div class="box-body">
                </div>
              </div>

              <div class="tab-pane fade" id="insurance-content" role="tabpanel" aria-labelledby="insurance-tab">
                <div class="box-body">
                </div>
              </div>
            </div>
          </div>
          <!-- /.box-body -->
        </div>

        <!--//table-->
        <input type="hidden" id="selected_id" name="selected_id">
        <input type="hidden" id="formSubmit" name="formSubmit" value="submitForm">
        <input type="hidden" id="form" name="form" value="Payments">


      </section>


    </form>

  </div>

  <!-- ./wrapper -->


  <?php require_once(APPPATH . "views/admin/footer.php"); ?>
	<script src="<?php echo base_url('js/Services/Pharmacy/pos.js') ?>" type="text/javascript"></script>



</body>
<script>
  $(document).on('click', '[data-control=medical_click]', function(e) {

    var selected_id = e.target.id;
    var form = $('#formSubmit').val();
    var url_ = $('#form').val();

    $('#selected_id').val(selected_id);

    var URL = url_ + 'Controller/medical_book/' + selected_id;

    window.location.href = URL;

  });

  
 


</script>
<script>
  $(document).ready(function () {
    $('.loader').hide()
    // Check if there's a saved tab in localStorage
    var savedTab = localStorage.getItem('selectedTab');
    if (savedTab) {
      // Remove active class from all tabs and tab contents
      $('.nav-link').removeClass('active');
      $('.tab-pane').removeClass('active show');

      // Add active class to the saved tab and its corresponding content
      $('#' + savedTab).addClass('active');
      $('#' + savedTab).attr('aria-selected', 'true');
      $('#' + $('#' + savedTab).attr('href').substring(1)).addClass('active show');
    }

    // Add click event listener to each tab
    $('.nav-link').on('click', function () {
      var tabId = $(this).attr('id');
      // Save the selected tab ID to localStorage
      localStorage.setItem('selectedTab', tabId);
    });
  });
</script>

</html>