<?php
//--------------------------------------======================+
// File name   : example_001.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 001 for TCPDF class
//               Default Header and Footer
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//--------------------------------------======================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Default Header and Footer
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('././tcpdf_new/tcpdf.php');

// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    // public function Header() {
    //     // Logo
    //     $image_file = K_PATH_IMAGES.'escpos-php.jpg';
    //     $this->Image($image_file, 5, 0, 60, '', 'JPEG', '', 'C', false, 300, '', false, false, 0, false, false, false);
    //     // Set font
    //     $this->SetY(15);
    //     $this->SetFont('helvetica', '', 8);
    //     // Title
    //     $this->Cell(0, 2, 'Althumama, Doha - Qatar', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    // }

}
$ctr=0;
foreach ($sell_items as $value) {
  $ctr++;
}
$height = 95;
$new_height = $height+($ctr*5);

// create new PDF document
$custom_layout = array('73', $new_height);
// $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $custom_layout, true, 'UTF-8', false);
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $custom_layout, true, 'UTF-8', false);




$pdf->AddPage();


$pdf->SetFont('aealarabiya', '', 8);
date_default_timezone_set('Asia/Kuwait');
$date = date('d/m/Y');
$time = date('h:i:s A');

// Arabic and English content
// $htmlcontent2 = '<span color="#0000ff">This is Arabic "العربية" Example With TCPDF.</span>';
// $pdf->WriteHTML($htmlcontent2, true, 0, true, 0);

$date = date('d/m/Y');
$time = date('h:i:s A');


$tbl = '
<style>
    table .title {
        font-style: italic small-caps bold 12px/30px Georgia, serif;
    }
</style>
<table cellspacing="0" cellpadding="0" border="0">
  <tr>
    <td align="center" class="title" height="30" colspan="3"><b>Bill No. '.$bill_id.'</b></td>
  </tr>
  <tr>
    <td align="left" width="30%">Date</td>
    <td align="center" width="40%">'.$date.'</td>
    <td align="right" width="30%">تاريخ</td>
  </tr>
  <tr>
    <td align="left">Time</td>
    <td align="center">'.$time.'</td>
    <td align="right">زمن</td>
  </tr>

  <tr>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td align="left" colspan="3">
      <table cellspacing="0" cellpadding="0" border="0">
        <tr>
          <td colspan="2">ITEM NAME</td>
          <td>QTY</td>
          <td>PRICE</td>
          <td>TOTAL</td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <td align="left" colspan="3">-------------------------------------------------------------------</td>
  </tr>
  <tr>
    <td align="left" colspan="3">
      <table cellspacing="0" cellpadding="0" border="0">

';
$gross_total = 0;
$discount_total = 0;

foreach ($sell_items as $value) {
  $tbl .= '
  <tr>
    <td align="left" colspan="2">'.$value['drug_name'].'</td>
    <td>'.$value['qty'].'</td>
    <td>'.$value['sell_price'].'</td>
    <td>'.number_format($value['qty']*$value['sell_price'],2).'</td>
  </tr>';
  $gross_total += ($value['qty']*$value['sell_price']);
  $discount_total += $value['discount'];
}

if($payments[0]['type']=="cash"){
  $pay_type = "Cash";
}else if($payments[0]['type']=="card"){
  $pay_type = "Card";
}else if($payments[0]['type']=="check"){
  $pay_type = "Cheque";
}else if($payments[0]['type']=="cash_card"){
  $pay_type = "Cash/Card";
}


if(isset($paymentss[0]['amount'])){ 
  $paid_cash = $paymentss[0]['amount']; 
}
if(isset($paymentss[1]['amount'])){ 
  $paid_card = $paymentss[1]['amount']; 
}

if(isset($paid_cash)){
  $paid = $paid_cash;
}
if(isset($paid_card)){
  $paid = $paid_card;
}
if(isset($paid_cash) && isset($paid_card)){
  $paid = $paid_cash.'/'.$paid_card;
}

$tbl .= '
      </table>
    </td>
  </tr>
  <tr>
    <td align="left" colspan="3">-------------------------------------------------------------------</td>
  </tr>
  <tr>
    <td align="left">Gross Total</td>
    <td align="center">'.number_format($gross_total,2).'</td>
    <td align="right">المجموع الكلي</td>
  </tr>
  <tr>
    <td align="left">Discount</td>
    <td align="center">'.number_format($discount_total,2).'</td>
    <td align="right">خصم</td>
  </tr>
  <tr>
    <td align="left">Net Total</td>
    <td align="center">'.number_format($gross_total-$discount_total,2).'</td>
    <td align="right">المجموع الصافي</td>
  </tr>
  <tr>
    <td align="left">Paid Amount</td>
    <td align="center">'.$paid.'</td>
    <td align="right">المبلغ المدفوع</td>
  </tr>
  <tr>
    <td align="left">Payment Type</td>
    <td align="center">'.$pay_type.'</td>
    <td align="right">طريقة الدفع</td>
  </tr>
  <tr>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td align="center" colspan="3">We are delighted to have you as a patient. May</td>
  </tr>
  <tr>
    <td align="center" colspan="3">we extend our sincere thanks for the opportunity</td>
  </tr>
  <tr>
    <td align="center" colspan="3">to meet your health needs.We look forward</td>
  </tr>
  <tr>
    <td align="center" colspan="3">to a continued relationship with you.</td>
  </tr>
  <tr>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td align="center" colspan="3">THANK YOU VERY MUCH.</td>
  </tr>

</table>
';
$content = str_replace('{{_INVOICE_CONTENT_}}',$tbl,$invoice_template);

$pdf->writeHTML($content, true, false, false, false, '');
// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output('example_018.pdf', 'I');

//--------------------------------------======================+
// END OF FILE
//--------------------------------------======================+
