<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Payments List </title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <!--image crop-->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


  <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/jquery.dataTables.min.css'); ?>" rel="stylesheet">
  <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/buttons.dataTables.min.css'); ?>" rel="stylesheet">
  <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/select.dataTables.min.css'); ?>" rel="stylesheet">
  <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/editor.dataTables.min.css'); ?>" rel="stylesheet">

  <?php require_once(APPPATH . "views/admin/header.php"); ?>
  <style>
    .small-box {
			text-decoration: none;
			color: #444444;
      transition-timing-function: ease-in-out;
      cursor: pointer;
		}

    .small-box:hover {
			text-decoration: none;
			color: #084a6ad9;
		}
    
    .small-box {
      box-shadow: 0 1px 11px 0px rgba(0, 0, 0, 0.1) !important;
    }

    .inner{
      height: 120px;
    }

    .dashboard_icon{
      color:#084a6a;
      font-size: 50px;
    }

    .DTED_Lightbox_Content{
      border: none!important;
    }

    .DTED_Lightbox_Content .DTE .DTE_Header{
      background-color: #084a6a!important;
      color: white;
      height: 58px!important;
    }
    .DTED_Lightbox_Content .DTE .DTE_Footer{
      background-color: none!important;
    }
  </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    
    <section class="content-header">
            <h1><a href="<?php echo base_url('index.php/admin/Pharmacy/PharmacyController') ?>" class="btn btn-sm btn-dark"><i class="fa fa-angle-left"></i> Back</a>
                &nbsp;<strong>Pharmacy </strong><small>- Add/Edit Items</small>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        
        </section>

      <section class="content">
        <!--buttons-->


        <!--//buttons-->


        <div class="box box-info">

          <div class="box-body">
            
          <table id="example" class="display responsive" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>Drug Name</th>
                                    <th>Category</th>
                                    <th>Location</th>
                                    <th>Brand</th>
                                    <th>Barcode</th>
                                    <th>OB</th>
                                    <th>Current Quantity</th>
                                    <th>Sell Price</th>
                                    <th>Min. Avalability</th>
                                    <!-- <th>Action</th> -->
                                    <th>Max Expiration</th>
                                    <th>Status</th>
                                    <th>Drug Code</th>
                                </tr>
                            </thead>
                        </table>

            
          </div>
          <!-- /.box-body -->
        </div>

      </section>


    </form>

  </div>

  <!-- ./wrapper -->


  <?php require_once(APPPATH . "views/admin/footer.php"); ?>
	<script src="<?php echo base_url('js/Services/Pharmacy/pos.js') ?>" type="text/javascript"></script>

    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/jquery.dataTables.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/dataTables.buttons.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/dataTables.select.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/dataTables.editor.min.js'); ?>"></script>


    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/buttons.flash.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/jszip.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/pdfmake.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/vfs_fonts.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/buttons.html5.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/buttons.print.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/dataTables.responsive.js'); ?>"></script>


</body>
<script>
 <?php
        function category_list(){
            $CI =& get_instance();
            $query = $CI->db->query("SELECT category_id as value,category_name as label FROM sh_category");
            $result =  $query->result_array();

            return json_encode($result);
        }

        function location_list(){
            $CI =& get_instance();
            $query = $CI->db->query("SELECT location_id as value,location_name as label FROM sh_locations");
            $result =  $query->result_array();

            return json_encode($result);
        }

        function brand_list(){
            $CI =& get_instance();
            $query = $CI->db->query("SELECT brand_id as value, brand_name as label FROM sh_brand");
            $result =  $query->result_array();

            return json_encode($result);
        }
    ?>

  
    var editor; // use a global for the submit and return data rendering in the examples

    $(document).ready(function() {

        editor = new $.fn.dataTable.Editor( {
            "ajax": "drugs",
            "table": "#example",
            "fields": [ {
                    "label": "Drug Name:",
                    "name": "sh_drugs.drug_name"
                }, {
                    "label": "Category:",
                    "name": "sh_drugs.drugs_category",
                    "type": "select",
                    options: <?php echo category_list(); ?>       
                }, {
                    "label": "Location:",
                    "name": "sh_drugs.drugs_location",
                    "type": "select",
                    options: <?php echo location_list(); ?>
                }, {
                    "label": "Brand:",
                    "name": "sh_drugs.drugs_brand",
                    "type": "select",
                    options: <?php echo brand_list(); ?>
                }, {
                    "label": "Barcode:",
                    "name": "sh_drugs.drugs_code"
                }, {
                //     "label": "Quantity:",
                //     "name": "sh_drugs.quantity"
                // }, {
                    "label": "Sell Price:",
                    "name": "sh_drugs.price"
                }, {
                    "label": "Min. Availability:",
                    "name": "sh_drugs.on_hand"
                }, {
                    "label": "Max Expiration:",
                    "name": "sh_drugs.expiry",
                }, {
                    "label": "Status:",
                    "name": "sh_drugs.deleted",
                    "type": "select",
                    options: [
                                {"value":"0","label":"Activate"},
                                {"value":"1","label":"Inactive"}
                             ]
                }
            ]
        } );

        editor.on('submitSuccess', function(e, json, data) {
            if (json && json.message) {
            successNotification(json.message); // Use the message from the server response
        } else {
            successNotification('Operation successful!');
        }
        $('#example').DataTable().ajax.reload();  // Reload the DataTable to show updated data
    });

    // Event listener for the 'submitError' event
    editor.on('submitError', function(e, xhr, err, thrown, data) {
       errorNotification('Something Went Wrong');
    });

        $('#example').DataTable( {
            lengthMenu: [[10, 50, 75, 100, 150, -1], [10, 50, 75, 100, 150, 'All']],
            dom: "Blfrtip",
            ajax: {
                url: "drugs",
                type: "POST"
            },
            serverSide: true,
            columns: [
                { data: "sh_drugs.drug_name" },
                { data: "sh_category.category_name", editField: "sh_drugs.drugs_category" },
                { data: "sh_locations.location_name", editField: "sh_drugs.drugs_location" },
                { data: "sh_brand.brand_name", editField: "sh_drugs.drugs_brand" },
                { data: "sh_drugs.drugs_code" },
                { data: "sh_drugs.total_quantity" },
                { 
                    data: null, //data is null since we want to access ALL data
                      //for the sake of our calculation below
                    searchable: false,
                    render: function(data,type,row) { 
                        var res='';
                        if (data.sh_drugs.loose_active == 1) {
                            var group = Math.floor(data.sh_drugs.quantity/data.sh_drugs.drug_loose);
                            var group_loose = group * data.sh_drugs.drug_loose ; 
                            var remider = data.sh_drugs.quantity - group_loose;
                            res = group+"/"+remider;
                        }else{
                            res = data.sh_drugs.quantity;
                        }
                        return res;
                         
                        }
                },
                { data: "sh_drugs.price" },
                { data: "sh_drugs.on_hand" },

                // { data: null, 
                //   searchable: false,
                //   orderable: false,
                //     render: function ( data, type, row ) {
                //     return '<button class="print_barcode btn btn-dark" value="'+data.sh_drugs.drugs_code+" ||| "+data.sh_drugs.price+'">Print</button>';
                // } },

                { data: "sh_drugs.expiry" },
                { data: "sh_status.status_name",editField: "sh_drugs.deleted" },
                { data: "sh_drugs.drug_id" }
            ],
            select: true,
            responsive: true,
            buttons: [
                { extend: "create", editor: editor },
                { extend: "edit",   editor: editor },
                <?php if($this->session->userdata('permission') == 1){?>
                { extend: "remove", editor: editor },
                <?php } ?>
                {
                    extend: 'collection',
                    text: 'Export',
                    title: 'Pharmacy Drugs List',
                    buttons: [
                        'copy',
                        'excel',
                        'csv',
                        'pdf',
                        'print'
                    ]
                }
            ]
            // buttons: [
            //     'copy', 'csv', 'excel', 'pdfFlash'
            // ]
        } );

        $('body').on("click",".print_barcode", function(e){
            var temp = (this.value).split(' ||| ');
            var qty = prompt("How many pieces to print?:");
            if (qty != null && qty != "") {
                window.location.replace('<?php //echo URL.'index.php/pharmacy/print_barcode/';?>' + qty + '/' + temp[0]+ '/' +temp[1]);
            }
        });
    } );
    </script>

</script>

</html>