<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>POS</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <!--image crop-->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/jquery.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/buttons.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/select.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/editor.dataTables.min.css'); ?>" rel="stylesheet">

    <?php require_once(APPPATH . "views/admin/header.php"); ?>
    <style>
        .small-box {
            text-decoration: none;
            color: #444444;
            transition-timing-function: ease-in-out;
            cursor: pointer;
        }

        .small-box:hover {
            text-decoration: none;
            color: #084a6ad9;
        }

        .small-box {
            box-shadow: 0 1px 11px 0px rgba(0, 0, 0, 0.1) !important;
        }

        .inner {
            height: 120px;
        }

        .dashboard_icon {
            color: #084a6a;
            font-size: 50px;
        }

        .DTED_Lightbox_Content {
            border: none !important;
        }

        .DTED_Lightbox_Content .DTE .DTE_Header {
            background-color: #084a6a !important;
            color: white;
            height: 58px !important;
        }

        .DTED_Lightbox_Content .DTE .DTE_Footer {
            background-color: none !important;
        }

        .return_choose {
            width: 100%;
            zoom: 2;
        }
    </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->



    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><a href="<?php echo base_url('index.php/admin/Pharmacy/PharmacyController') ?>" class="btn btn-sm btn-dark"><i class="fa fa-angle-left"></i> Back</a>
                &nbsp;<strong>Pharmacy </strong><small>- POS</small>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>

        </section>

        <section class="content">
            <div class="box box-info">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-12">
                            <form id="search" method="post" action="<?php echo  base_url('index.php/admin/Pharmacy/PharmacyController/returnItemProvider'); ?>" class="form-inline"><br>
                                <input class="form-control" type="text" name="search" placeholder="Type Bill Number or Invoice Number" size="40">
                                <button type="submit" class="btn ml-2 btn-sm btn-dark">Search<span class="glyphicon glyphicon-search"></span></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php if ($result) { ?>
               
                <div class="box box-info">
                    <div class="box-header">
                        <h3 class="box-title"><i class="ri-archive-2-fill"></i>&nbsp;Return Purchase Order</h3>
                    </div>
                    <div class="box-body">

                        <div class="row">
                            <div class="col-md-3">
                                <p>Supplier name:</p>
                                <p style="color:blue"><?php echo $supplier; ?></p>
                            </div>
                            <div class="col-md-3">
                                <p>Bill Date:</p>
                                <p><?php echo $date; ?></p>
                            </div>
                            <div class="col-md-3">
                                <p>Status:</p>
                                <p style="color:red;"><?php echo $status; ?></p>
                            </div>
                            <div class="col-md-3">
                                <p>Bill Num.#: </p>
                                <p style="color:blue" id="bill_id"><?php echo $bill_data[0]['bill_id']; ?></p>
                            </div>
                            <div class="col-md-12">

                                <table class="table table-striped table-bordered table-hover" id="dataTables-employee">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>No</th>
                                            <th>Item Name</th>
                                            <th>Expiry Date</th>
                                            <th>Batch No.#</th>
                                            <th>Quantity Remaining</th>
                                            <th>Quantity for Return</th>
                                            <th>Cost per Unit</th>
                                            <th>Total Cost for Return</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tbody">
                                        <?php
                                        $x = 0;
                                        foreach ($items as $value) {
                                            $x++;
                                            echo '<tr>
                        <td><input class="return_choose" type="checkbox" value="' . $value['item_id'] . "-" . $value['bill_items_id'] . '"></td>
                        <td>' . $x . '</td>
                        <td>' . $value['drug_name'] . '</td>
                        <td>' . $value['x_date'] . '</td> 
                        <td>' . $value['batch'] . '</td>
                        <td>' . $value['qty'] . '</td>
                        <td><input class="return_qty form-control" type="text" value="0"></td>
                        <td>' . $value['discount_cost'] . '</td>
                        <td>0</td>
                    </tr>';
                                        }
                                        ?>


                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="2">Total Items:</th>
                                            <td id="items">0</td>
                                            <th class="text-right" colspan="4">Total Amount for Pay:</th>
                                            <td colspan="3" id="total">0</td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <br>
                            <span>Account Status:</span>
                            <span style="color:blue"><?php echo round($account, 2); ?> QAR</span>
                        </div>
                        <div class="col-md-4"><br>
                            <form method="post" action="<?php echo base_url('index.php/admin/Pharmacy/PharmacyController/returnItemProvider'); ?>" id="refund">
                                <label>Payment Type:</label>
                                <select name="type" class="form-control">
                                    <option value="cash">Cash</option>
                                    <option value="credit">Cash</option>
                                    <option value="check">Check</option>
                                    <!-- <option value="account">Account Balance</option> -->
                                </select>
                                <button type="submit" disabled="true" id="pay_back" class="mt-2 btn btn-sm btn-dark"><i class="ri-arrow-go-back-line"></i>Return Items</button>
                            </form>
                        </div>

                    </div>
                    <!-- /.box-body -->
                </div>
            <?php } ?>

            <div class="box box-info">
                <div class="box-header">
                    <h3 class="box-title"><i class="ri-archive-stack-fill"></i>&nbsp;Returned Purchase Order List</h3>
                </div>
                <div class="box-body">
                    <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Date</th>
                                <th>Employee</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            foreach ($purchase_return as $row) {
                            ?>
                                <tr>
                                    <td><?= $row['return_stock_id'] ?></td>
                                    <td><?= $row['return_date'] ?></td>
                                    <td><?= $row['full_name'] ?></td>
                                    <td>
                                        <a class="btn btn-dark btn-sm" target="_blank" id="view" href='<?php $this->load->helper('url'); echo base_url('index.php/admin/Pharmacy/PharmacyController/purchase_return/' . $row['return_stock_id']); ?>'>
                                            View
                            </a>

                                        <a  class="btn btn-danger btn-sm text-light" role="button" onclick="delete_bill(<?php echo $row['return_stock_id'] ?>)"><i class="fa fa-trash"></i></a>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </section>


        </form>

    </div>

    <!-- ./wrapper -->


    <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>
<script>
    function delete_bill(id)
        {
            confirmDelete(function(){
                $.ajax({
                    url : "<?php echo base_url(); ?>index.php/admin/Pharmacy/PharmacyController/delete_purchase_return/" +id,
                    type: "POST",
                    dataType: "JSON",
                    success: function(data)
                    {
                        //if success reload ajax table
                        // $('#modal_form').modal('hide');
                        
                        successNotification('Purchase Statement Deleted');
                        window.location.reload();
                    },
                    error: function (jqXHR, textStatus, errorThrown)
                    {
                        errorNotification('Something Went Wrong');
                    }
                });
            })
            
                // ajax delete data to database
              

            
        }
    $("#search").find('input').autocomplete({
        source: function(request, response) {
            $.ajax({
                url: "search_bill",
                dataType: "json",
                data: {
                    search: request.term
                },
                success: function(data) {
                    response($.map(data, function(item) {
                        return {
                            label: item,
                            value: item
                        }
                    }));
                }
            });
        },
        autoFocus: false,
        minLength: 1
    });
    $("#search").submit(function() {
        var search = $(this).find('input').val(),
            array_search = search.split(" ||| "),
            bill = array_search[0];
        if (bill.match(/\d?/)) {
            $(this).find('input').val(bill);
            return true;
        } else {
            return false;
        }
    });

    function update_total() {
        var net_total = Number(0),
            x = 0;
        $("#tbody tr").each(function(i) {
            var $tds = $(this).find('td'),
                checkbox_td = $tds.eq(0),
                checkbox = checkbox_td.find('input'),
                qty = Number($tds.eq(6).find('input').val()),
                price = Number($tds.eq(7).text()).toFixed(2);
            $tds.eq(8).text((qty * price).toFixed(2));
            if (checkbox.prop('checked')) {
                x++;
            }
            net_total += (qty * price);
        });
        $("#total").text(net_total);
        $("#items").text(x);
        if (net_total !== 0) {
            $("#pay_back").prop("disabled", false);
        } else {
            $("#pay_back").prop("disabled", true);
        }
    }
    $(".return_qty").on("keyup", function() {
        var tds = $(this).closest('td'),
            qty_td = tds.prev('td'),
            batch_td = qty_td.prev('td'),
            date_td = batch_td.prev('td'),
            name_td = date_td.prev('td'),
            item_td = name_td.prev('td'),
            checkbox_td = item_td.prev('td'),
            checkbox = checkbox_td.find('input'),
            qty = Number(qty_td.text()),
            ret = $(this).val();
        if (ret.match(/\d?/) && Number(ret) <= qty && Number(ret) > 0) {
            checkbox.prop('checked', true);
            update_total();
        } else {
            checkbox.prop('checked', false);
            $(this).val('0');
            update_total();
        }
    });
    $("#refund").on("submit", function() {
        var bill_id = $("<input>").attr({
                "type": "hidden",
                "name": "bill"
            }).val($("#bill_id").html()),
            amount = $("<input>").attr({
                "type": "hidden",
                "name": "amount"
            }).val($("#total").text());
        $("#tbody tr").each(function(i) {
            var $tds = $(this).find('td'),
                checkbox = $tds.eq(0).find('input'),
                qty = $tds.eq(6).find('input').val(),
                price = $tds.eq(7).text();
            if (checkbox.prop('checked')) {
                var id = checkbox.val(),
                    id_array = id.split("-"),
                    batch = $tds.eq(4).text(),
                    item_input = $("<input>").attr({
                        "type": "hidden",
                        "name": "items[]"
                    }).val(id_array[0]),
                    batch_input = $("<input>").attr({
                        "type": "hidden",
                        "name": "batch[]"
                    }).val(batch),
                    quantity_input = $("<input>").attr({
                        "type": "hidden",
                        "name": "qty[]"
                    }).val(qty),
                    sell_price = $("<input>").attr({
                        "type": "hidden",
                        "name": "cost[]"
                    }).val(price),
                    r_bill = $("<input>").attr({
                        "type": "hidden",
                        "name": "r_bill[]"
                    }).val(id_array[1]);
                $('#refund').append(item_input);
                $('#refund').append(batch_input);
                $('#refund').append(quantity_input);
                $('#refund').append(sell_price);
                $('#refund').append(r_bill);
            }
        });
        $('#refund').append(bill_id);
        $('#refund').append(amount);
        return true;
    });
</script>

</html>