<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->


	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Appoinments Report</strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>
		<!-- Main content -->
		<section class="content">
			<div class="row">
				<div class="col-md-12">
					<div class="box box-info">
						<div class="box-header with-border">
							<h3 class="box-title font-weight-bold">Available Appoinments</h3>
						</div>

						<div class="box-body">
							<div class="panel-group" id="accordion">

								<div class="d-block mb-3">
									<div class="row" id="filters">
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="appoinment_status">Appoinment Status</label>
												<select name="appoinment_status" id="appoinment_status">
													<option value="0">All</option>
													<?php foreach ($appoinment_status as $index => $status) : ?>
														<option value="<?= $status->status_id; ?>"><?= $status->status_name; ?></option>
													<?php endforeach; ?>
												</select>
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date_from">Date From</label>
												<input type="date" class="form-control" value="<?php echo date('Y-m-d') ?>" name="date_from" id="date_from" placeholder="Date From">
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date_to">Date To</label>
												<input type="date" class="form-control"  value="<?php echo date('Y-m-d') ?>" name="date_to" id="date_to" placeholder="Date To">
											</div>
										</div>
									</div>

								</div>

								<table id="price_list" class="table table-light table-bordered table-striped"></table>

							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div><!-- /.content-wrapper -->
	<!-- ./wrapper -->
	<?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

</html>

<script type="text/javascript">
	$(document).ready(function() {
		// Initialize the DataTable
		var dataTable = $('#price_list').DataTable({
			dom: 'lBfrtip',
			buttons: [{
					extend: 'excel',
					title: `Appoinments Report`
				},
				{
					extend: 'print',
					autoPrint: true,
					title: `Appoinments Report`,
					customize: function(win) {
						$(win.document.body).prepend(`<?php echo print_header($this); ?>`);
						var filterData = '<div class="filter-data d-flex ml-3">';

						$('#filters .form-group').each(function() {
							var label = $(this).find('label').text().trim();
							var value;
							var inputElement = $(this).find('select, input');

							if (inputElement.is('select')) {
								value = inputElement.find('option:selected').text();
							} else if (inputElement.is('input[type="date"]')) {
								value = inputElement.val();
							}


							filterData += '<p class="ml-2 mr-2"><strong>' + label + ':</strong> ' + value + '</p>';
						});

						filterData += '</div>';

						$(win.document.body).find('h1').after(filterData);

						$(win.document.body).find('h1').css({
							'font-size': '20px',
							'text-align': 'center',
							"font-weight": "700"
						});

						$(win.document.body).find('table').css({
							'margin-left': '20px',
							'margin-right': '10px',
							"width": "95%",
							"font-size": "12px",
							'table-layout': 'auto'
						});
						$(win.document.body).find('table th').css({
							"font-size": "12px",
						});
					}

				},

			],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/appoinmentList'); ?>',
				'type': 'GET',
				'data': function(d) {
					d.appoinment_status = $('#appoinment_status').val();
					d.date_from = $('#date_from').val();
					d.date_to = $('#date_to').val();
				}
			},
			'columns': [{
					'data': null,
					'title': '#',
					'orderable': false,
					'searchable': false,
					'render': function(data, type, row, meta) {
						return meta.row + 1;
					}
				}, {
					'data': 'app_patient_id',
					'title': 'File No'
				},
				{
					'data': 'app_patient_name',
					'title': 'Patient'
				},
				{
					'data': 'app_patient_contact',
					'title': 'Phone No'
				},
				{
					'data': null,
					'title': 'Date',
					'render': function(data, type, row, meta) {
						return row.appointment_date;
					}
				},
				{
					'data': null,
					'title': 'Start Time',
					'render': function(data, type, row, meta) {
						return row.appointment_time;
					}
				},
				{
					'data': null,
					'title': 'End Time',
					'render': function(data, type, row, meta) {
						return  row.appointment_etime;
					}
				},
				{
					'data': null,
					'title': 'Duration(h)',
					'render': function(data, type, row, meta) {
						return  row.appointment_duration;
					}
				},
				{
					'data': 'status_name',
					'title': 'Status'
				},
				{
					'data': 'doctor_name',
					'title': 'Doctor'
				},
				{
					'data': 'user_name',
					'title': 'Created By'
				},
			],
			'searching': false,
			'serverSide': true,
			'paging': false
		});

		$('#appoinment_status, #date_from, #date_to').on('keyup change', function() {
			dataTable.ajax.reload();
		});
	});
</script>
<script>
	var settings = {};
	new TomSelect('#appoinment_status', settings);
</script>