<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<?php require_once(APPPATH . "views/admin/header.php"); ?>
	<style>
		.visible-print{
			display: none;
		}
		@media print{
			.visible-print{
				display: block;
			}
		}
	</style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->


	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<div class=" visible-print">
		<?php echo print_header($this); ?>
		</div>
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Dr. Income Report </strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>
		<!-- Main content -->
		<section class="content no-print" style="margin-bottom:0'px !important;">
			<div class="row">
				<div class="col-md-12">
					<div class="box box-info no-print">
						<div class="box-header with-border">
							<h3 class="box-title">Available Doctors</h3>
						</div>

						<div class="box-body">
							<div class="panel-group" id="accordion">

								<div class="d-block mb-3 no-print">
									<div class="row" id="filters">
									
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="doctor">Doctor</label>
												<select name="doctor" id="doctor">
												<?php
													$loged_user =getLoginUser($this);

													if (!check_right('view_all_drincome', $this)) : ?>
														<!-- Show only the logged-in doctor's data -->
														<option value="<?= $loged_user->user_Id; ?>"><?= $loged_user->full_name; ?></option>
														
													<?php else : ?>
													<option value="0">All</option>
													
													<?php foreach ($doctors as $index => $doctor) : ?>
														<option value="<?= $doctor->user_Id; ?>"><?= $doctor->full_name; ?></option>
													<?php endforeach; ?>
													<?php endif; ?>
												</select>
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="payment_type">Payment Type</label>
												<select name="payment_type" id="payment_type">
													<option value="0">All</option>
													<?php foreach ($payment_types as $index => $type) : ?>
														<option value="<?= $type->type_id; ?>"><?= $type->type_name; ?></option>
													<?php endforeach; ?>
												</select>
											</div>
										</div>

										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date_from">Date From</label>
												<input type="date" class="form-control" value="<?php echo date('Y-m-d')  ?>" name="date_from" id="date_from" placeholder="Date From">
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date_to">Date To</label>
												<input type="date" class="form-control"  value="<?php echo date('Y-m-d')  ?>" name="date_to" id="date_to" placeholder="Date To">
											</div>
										</div>
									</div>
                                    <div class="row">
                                        <div class="col-md-12 d-flex justify-content-between">
                                            <?php 
                                            $loged_user =getLoginUser($this);
                                            if (check_right('view_all_drincome', $this)) { ?>
											<div>
											<button type="button" onclick="window.print()" class="btn btn-light btn-sm" ><i class="fa fa-print"></i></button>
										<button id="downloadButton" class="btn btn-light btn-sm"><span id="spinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span><i class="fa fa-download"></i></button>
											</div>
											<?php } ?>
										<div>
										<button class="btn btn-dark btn-sm" id="generateReport">Generate Report</button>
										</div>
                                       
                                        </div>
                                       
                                    </div>
								</div>

								

							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<section class=" p-3">
		<div class="row">
				<div class="col-md-12">
					<div class="box box-info">
					<div id="doctorIncome">
                        <div class="visible-print w-100 text-center"><h5><u>Doctor Income Report</u></h5></div>
                        <br>
                        <div class="visible-print" id="variables"></div>
                        <div  id="doctorResult"></div>
					</div>
					</div>
				</div>
		</div>	
	
		</section>
		
	</div><!-- /.content-wrapper -->
	<!-- ./wrapper -->
	<?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>

</html>
<script>
    var base_url = "<?php echo base_url()  ?>"
    $(document).ready(function() {
        // Handle the click event for the "Generate Report" button
        $("#generateReport").on("click", function(e) {
            e.preventDefault(); // Prevent the default form submission

            // Collect form data
            let doctor = $("#doctor").val();
            let payment_type = $("#payment_type").val();
            let date_from = $("#date_from").val();
            let date_to = $("#date_to").val();

            // Send AJAX request
            $.ajax({
                url: '<?= site_url('admin/Reports/ReportsController/doctorIncomeList'); ?>',  // Replace with the URL of your PHP backend script
                method: 'POST',
                data: {
                    doctor: doctor,
                    payment_type: payment_type,
                    date_from: date_from,
                    date_to: date_to
                },
                success: function(response) {
                    // Display the response data inside #doctorIncome
                    $("#doctorResult").html(response);
                      var filterData = '<div class="filter-data d-flex ml-3">';

					$('#filters .form-group').each(function() {
						var label = $(this).find('label').text().trim();
						var value;
						var inputElement = $(this).find('select, input');

						if (inputElement.is('select')) {
							value = inputElement.find('option:selected').text();
						} else if (inputElement.is('input[type="date"]')) {
							value = inputElement.val();
						}


						filterData += '<p class="ml-2 mr-2"><strong>' + label + ':</strong> ' + value + '</p>';
					});

					filterData += '</div>';
					debugger;
					$('#variables').html(filterData);
                },
                error: function(xhr, status, error) {
                    // Display error if something goes wrong
                    console.error('Error:', error);
                    $("#doctorIncome").html('<p>An error occurred while generating the report.</p>');
                }
            });
        });
    });
	document.getElementById('downloadButton').addEventListener('click', function() {
    // Get the section to download as PDF
	const button = document.getElementById('downloadButton');
    const content = document.getElementById('doctorIncome');
	const spinner = document.getElementById('spinner');
	spinner.classList.remove('d-none');
    button.disabled = true;
	const today = new Date();
const todayDate = today.toISOString().split('T')[0]; // e.g., "2024-11-07"

function getFilename() {
        const dateFrom = $('#date_from').val() || todayDate;
        const dateTo = $('#date_to').val() || todayDate;
        return `doctor-income-report-${dateFrom}-to-${dateTo}.pdf`;
    }

    // Set up options for PDF generation
    const options = {
        margin: 0.5,
        filename: getFilename(),
        image: { type: 'jpeg', quality: 0.98 },
        html2canvas: { scale: 2 },
        jsPDF: { unit: 'in', format: 'a4', orientation: 'portrait' }
    };
    // Generate the PDF
    html2pdf().set(options).from(content).save().then(function(){
		spinner.classList.add('d-none');
        button.disabled = false;
	});
	
});
</script>
<script>
	var settings = {};
	new TomSelect('#doctor', settings);
	new TomSelect('#payment_type', settings);
</script>