<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->


	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Whatsapp Report</strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>
		<!-- Main content -->
		<section class="content">
			<div class="row">
				<div class="col-md-12">
					<div class="box box-info">
						<div class="box-header with-border">
							<h3 class="box-title font-weight-bold">SMS</h3>
						</div>

						<div class="box-body">
							<div class="panel-group" id="accordion">

								<div class="d-block mb-3">

									<div class="row" >
										<div class="col-12 col-md-3">
											<table class="table table-striped table-bordered">
												<tbody>
													<tr>
														<th>Total Sent Messages</th>
														<td><?= $sent_sms->count ?? 0; ?></td>
													</tr>
													<tr>
														<th>Total Failed Messages</th>
														<td><?= $failed_sms->count ?? 0; ?></td>
													</tr>
												</tbody>
											</table>
										</div>
									</div>

									<div class="row">
										<div class="col-12 col-md-3">
											<div class="form-group"  id="filters">
												<label for="status">Status</label>
												<select class="form-control" name="status" id="status">
													<option value="SENT">SENT</option>
													<option value="FAILED">FAILED</option>
												</select>
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date">Date From</label>
												<input type="date" class="form-control" name="date_from" id="date_from" placeholder="Date" value="<?= date('Y-m-d') ?>">
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date">Date To</label>
												<input type="date" class="form-control" name="date_to" id="date_to" placeholder="Date" value="<?= date('Y-m-d') ?>">
											</div>
										</div>
									</div>

								</div>

								<table id="sms_report_table" class="table table-light table-bordered table-striped">
								</table>

							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div><!-- /.content-wrapper -->
	<!-- ./wrapper -->
	<?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

</html>

<script type="text/javascript">
	var dataTable = undefined;

	$(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#sms_report_table').DataTable({
			dom: 'Blfrtip',
			buttons: [{
				extend: 'excel',
				title: `SMS Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `SMS Report`,
				customize: function(win) {
					$(win.document.body).prepend(`<?php echo print_header($this); ?>`);
						var filterData = '<div class="filter-data d-flex ml-3">';

						$('#filters .form-group').each(function() {
							var label = $(this).find('label').text().trim();
							var value;
							var inputElement = $(this).find('select, input');

							if (inputElement.is('select')) {
								value = inputElement.find('option:selected').text();
							} else if (inputElement.is('input[type="date"]')) {
								value = inputElement.val();
							}


							filterData += '<p class="ml-2 mr-2"><strong>' + label + ':</strong> ' + value + '</p>';
						});

						filterData += '</div>';

						$(win.document.body).find('h1').after(filterData);

						$(win.document.body).find('h1').css({
							'font-size': '20px',
							'text-align': 'center',
							"font-weight": "700"
						});

						$(win.document.body).find('table').css({
							'margin-left': '20px',
							'margin-right': '10px',
							"width": "95%",
							"font-size": "12px",
							'table-layout': 'auto'
						});
						$(win.document.body).find('table th').css({
							"font-size": "12px",
						});
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/getWhatsappList'); ?>',
				'type': 'POST',
				'data': function(d) {
					d.status = $('#status').val();
					d.date_from = $('#date_from').val();
					d.date_to = $('#date_to').val();
				}
			},
			'columns': [{
					'data': null,
					'title': '#',
					'render': function(data, type, row, meta) {
						return meta.row + meta.settings._iDisplayStart + 1;
					}
				},
				{
					'data': 'id',
					'title': 'ID'
				},
				{
					'data': 'type',
					'title': 'Type'
				},
				{
					'data': null,
					'title': 'Response',
					'render': function(data, type, row, meta) {
						let formattedResponse;
						try {
							formattedResponse = JSON.stringify(JSON.parse(row.response), null, 2);
						} catch (e) {
							formattedResponse = row.response;
						}
						return `<pre style="
							max-width:1200px;
							white-space: pre-wrap;
							word-wrap: break-word;
							overflow-wrap: break-word;
							font-weight:bold;
							color:#084a6a;
							background-color:white;
							padding:10px;">${formattedResponse}</pre>`;
					}
				},
				{
					'data': 'status',
					'title': 'Status'
				},
				{
					'data': 'created_at',
					'title': 'Created At'
				}
			],
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			'pagingType': 'full_numbers',
			footer: true,
			autoWidth: false
		});

		$('#date_from, #date_to, #status').on('change', function() {
			dataTable.ajax.reload();
		});
	});
</script>