<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Company profile
                    <small>- <?php echo ($company_id_val > 0 ? "Edit" : "Create New" ) ?>  Company profile</small>
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>


            <!-- Main content -->
            <form id="save_form" name ="save_form" role="form" action="<?php echo base_url('index.php/admin/Setting/Company/CompanyController/Save') ?>" method="post" >
                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box margin-bottom-5px box-warning">
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-md-1"></div>
                                        <div class="col-md-9">
                                            <?php if (validation_errors()) { ?>
                                                <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
        <!--                                                      <i class="icon fa fa-warning"></i>-->
                                                    <div>

                                                        <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
                                                    </div>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <div class="col-md-2">
                                            <a href="#" onclick="document.getElementById('save_form').submit(); return false;" class="btn btn-block btn-social <?php echo $this->config->item('save'); ?>">
                                                <i class="fa fa-save"></i> Save company
                                            </a>
                                        </div>
                                    </div>	
                                </div><!-- /.box-body -->
                            </div>
                            <div class="box box-info">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-5">

                                        <div class="box-body">
                                            <!-- text input -->
                                            <div class="form-group <?php echo form_error("company_name") ? "has-error" : "" ?>">
                                                <label>Company name</label>

                                                <input id="company_name" name="company_name" value="<?php echo $company_name_val; ?>" type="text" class="form-control" placeholder="Enter ..."/>

                                                <label><small><?php echo form_error("company_name"); ?></small></label>
                                            </div>
                                            <div class="form-group <?php echo form_error("company_description") ? "has-error" : "" ?>">
                                                <label>Description</label>
                                                <textarea id="company_description" name="company_description" type="text"   class="form-control" rows="3" placeholder="Enter ..."><?php echo $company_description_val; ?></textarea>
                                                <label><small><?php echo form_error("company_description"); ?></small></label>
                                            </div>
                                            <div class="form-group <?php echo form_error("company_address") ? "has-error" : "" ?>">
                                                <label>Address</label>
                                                <textarea id="company_address" name="company_address" type="text"   class="form-control" rows="3" placeholder="Enter ..."><?php echo $company_address_val; ?></textarea>
                                                <label><small><?php echo form_error("company_address"); ?></small></label>
                                            </div>
                                        </div>


                                    </div>
                                    <div class="col-md-5">

                                        <div class="box-body">

                                            <div class="form-group <?php echo form_error("mobile_no") ? "has-error" : "" ?>">
                                                <label>Mobile no</label>

                                                <input id="mobile_no" name="mobile_no" value="<?php echo $mobile_no_val; ?>" type="number" class="form-control" placeholder="Enter ..."/>

                                                <label><small><?php echo form_error("mobile_no"); ?></small></label>
                                            </div>
                                            <div class="form-group <?php echo form_error("phone_no") ? "has-error" : "" ?>">
                                                <label>Phone no</label>

                                                <input id="phone_no" name="phone_no" value="<?php echo $phone_no_val; ?>" type="number" class="form-control" placeholder="Enter ..."/>

                                                <label><small><?php echo form_error("phone_no"); ?></small></label>
                                            </div>
                                            <div class="form-group <?php echo form_error("email") ? "has-error" : "" ?>">
                                                <label>Email</label>

                                                <input id="email" name="email" value="<?php echo $email_val; ?>" type="email" class="form-control" placeholder="Enter ..."/>

                                                <label><small><?php echo form_error("email"); ?></small></label>
                                            </div>
                                            <div class="form-group <?php echo form_error("fax") ? "has-error" : "" ?>">
                                                <label>Fax no</label>

                                                <input id="fax" name="fax" value="<?php echo $fax_val; ?>" type="number" class="form-control" placeholder="Enter ..."/>

                                                <label><small><?php echo form_error("fax"); ?></small></label>
                                            </div>
                                            <div class="form-group <?php echo form_error("web") ? "has-error" : "" ?>">
                                                <label>Web site</label>

                                                <input id="web" name="web" value="<?php echo $web_val; ?>" type="text" class="form-control" placeholder="Enter ..."/>

                                                <label><small><?php echo form_error("web"); ?></small></label>
                                            </div>
                                        </div>


                                    </div>
                                    <input  type="hidden" runat="server"  id="company_id" name="company_id" value=" <?php echo $company_id_val; ?> ">

                                </div>
                            </div><!-- /.box --><!-- /.box-body -->
                            <!-- add image-->
                            <div class="box box-info">
                                <div class="box-header">
                                    <h3 class="box-title">logo</h3>
                                </div><!-- /.box-header -->
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-5">
                                        <div class="box-body">
                                            <div class="form-group">
                                                <label class="file-control">
                                                    <input type="file" id="logoUploader" name="logoUploader" size="60" >
                                                    <div class="dv-logo center">
                                                        <div class="dv-hover center">
                                                            <i class="fa fa-image"></i>
                                                        </div>
                                                        <div class="dv-result-logo">
                                                            <img class="result-logo" id="result" name="result" src="
                                                                 <?php echo $is_new_image == 'true' ? $image_path_val : base_url($image_path_val) ?>">
                                                        </div>
                                                    </div>
                                                </label> 
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-5">

                                         <input type="hidden" name="is_new_image" id="is_new_image" value="<?php echo $is_new_image ?>">
                                        <input hidden="hidden" type="text" runat="server"  id="image_path" name="image_path" value=" <?php echo $image_path_val; ?> " class="txtBx">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div id="crop-image" class="box-body"></div>
                                    </div>
                                </div>
                            </div>
                        </div><!--/.col (right) -->
                    </div>   <!-- /.row -->
                </section><!-- /.content -->
            </form>

        </div><!-- /.content-wrapper -->

        <!-- ./wrapper -->

        <?php require_once(APPPATH . "views/admin/footer.php"); ?>



    </body>
</html>