<div class="tab-pane fade" id="laser_config_tab" role="tabpanel" aria-labelledby="qlm-config-tab">
    <div class="row">
        <div class="col-12">
            <div class="box-body">
                <div class="row">
                    <div class="col-5">
                        <div class="" style="margin-bottom: 5px;border:none">
                            <div class="box-header">
                                <h2 class="box-title"><strong>Laser Resource Details</strong></h2>
                                <div>
                                    <form id="submitForm" name="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Setting/Configurations/ConfigurationsController/laserResourcesSaveUpdate') ?>" method="post">
                                        <div class="box-body">
                                                <div class="row hide" id="resorceIdEdit">
                                                    <div class="col-md-6 col-sm-3 p-2">
                                                        <div class="form-group <?php echo form_error("resource_id") ? "has-error" : "" ?>">
                                                            <label for="resource_id">Resource No.</label>
                                                            <input id="resource_id" readonly name="resource_id" value="<?php echo $resource_id == '' ? '0.00' : $resource_id; ?>" type="text" class="form-control" placeholder="Enter First Name Here..." required />
                                                            <label><small><?php echo form_error("resource_id"); ?></small></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            <div class="row">
                                                <div class="col-md-4 col-sm-3 p-2 order">
                                                    <div class="form-group <?php echo form_error("resource_name") ? "has-error" : "" ?>">
                                                        <label for="patient_id">Resource Name<span class="text-danger">*</span></label>
                                                        <input type="text" placeholder="Enter Resource Name" class="form-control" id="resource_name" value="<?= $resource_name; ?>" name="resource_name" required>
                                                        <label><small><?php echo form_error("resource_name"); ?></small></label>
                                                    </div>
                                                </div>

                                                <div class="col-md-4 col-sm-3 p-2 order">
                                                    <div class="form-group <?php echo form_error("resource_order") ? "has-error" : "" ?>">
                                                        <label for="order">Resource Order<span class="text-danger">*</span></label>
                                                        <input id="resource_order" name="resource_order" value="<?php echo $resource_order == '' ? '0' : $resource_order; ?>" type="text" class="form-control" placeholder="Enter First Name Here..." required />
                                                        <label><small><?php echo form_error("resource_order"); ?></small></label>
                                                    </div>
                                                </div>

                                                <div class="col-md-4 col-sm-3 p-2 resource_color">
                                                    <div class="form-group <?php echo form_error("resource_color") ? "has-error" : "" ?>">
                                                        <label for="resource_color">Resource Color<span class="text-danger">*</span></label>
                                                        <input id="resource_color" style="height:38px" name="resource_color" value="<?php echo $resource_color == '' ? '0' : $resource_color; ?>" type="color" class="form-control" placeholder="Enter First Name Here..." required />
                                                        <label><small><?php echo form_error("resource_color"); ?></small></label>
                                                    </div>
                                                </div>

                                            </div>

                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="d-flex w-100 justify-content-end">
                                                        <button type="submit" class="btn btn-sm btn-light" id="formButton">
                                                            <i class="fa fa-check-circle mr-1" aria-hidden="true"></i>
                                                            Save
                                                        </button>
                                                        <button type="button" class="btn btn-sm btn-light hide" id="formButtonCancel">
                                                            <i class="fa fa-close mr-1" aria-hidden="true"></i>
                                                            Cancal
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- <input type="hidden" name="resource_id" value="<?php echo $resource_id; ?>"> -->
                                        <!-- <input type="hidden" id="patient_id" name="patient_id" value="<?php echo $patient_id; ?>"> -->

                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-7">
                        <div class="" style="margin-bottom: 5px;border:none">
                            <div class="box-header">
                                <h2 class="box-title"><strong>Laser Resources List</strong></h2>
                                <div class="box-body">
                                    <div class="form-group">
                                        <table class="table table-borderedv w-100" id="resources_list"></table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" id="selected_id" name="selected_id">
            <input type="hidden" id="formSubmit" name="formSubmit" value="submitForm">
            <input type="hidden" id="form" name="form" value="Category">
        </div>
    </div>
</div>

<script>
    var dataTableTreatment = $('#resources_list').DataTable({
        'ajax': {
            'url': '<?= site_url('admin/Calender/LaserCalenderController/get_resources_list'); ?>',
            'type': 'GET',
            'data': function(d) {
                d.is_insurance = 0
            }
        },

        'columns': [{
                'data': 'resource_no',
                'title': 'Resource No',
            },
            {
                'data': 'resource_name',
                'title': 'Resource Name'
            },
            {
                'data': 'resource_order',
                'title': 'Resource Order'
            },
            {
                'data': '',
                'title': 'Resource Color',
                'render': function(data, type, row) {
                    return '<label class="badge" style="background-color:' + row.resource_color + '">' + row.resource_color + '</lable>'
                }
            },
            {
                'data': null,
                'title': 'Actions',
                'render': function(data, type, row) {
                    return `
                <button class="btn btn-sm btn-light selectToEdit" title="Edit" onclick="selectResorce(this)"><i class="fa fa-edit"></i></button>
                <a href="#" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/deleteResource') ?>/${row.resource_id}')" class="btn btn-sm btn-light" title="Delete">
                    <i class="fa fa-trash"></i>
                </a>`;
                }
            }
        ],
        'serverSide': false
    });

    function selectResorce(row) {
        let data = $(row).parent().parent().find('td').map(function() {
            return $(this).text();
        }).get();
        $('#resorceIdEdit').removeClass('hide');
        $('#formButtonCancel').removeClass('hide');
        $('#formButton').html('<i class="fa fa-check-circle mr-1" aria-hidden="true"></i>Update')
        $('#resource_id').val(data[0])
        $('#resource_name').val(data[1])
        $('#resource_order').val(data[2])
        $('#resource_color').val(data[3])
    }

    $('#formButtonCancel').on('click', function(e) {
        $('#resorceIdEdit').addClass('hide');
        $('#formButtonCancel').addClass('hide');
        $('#formButton').html('<i class="fa fa-check-circle mr-1" aria-hidden="true"></i>Save')
        $('#resource_id').val('')
        $('#resource_name').val('')
        $('#resource_order').val('')
        $('#resource_color').val('')
    })
</script>