<div class="tab-pane fade" id="pacakges_config_tab" role="tabpanel" aria-labelledby="invoice-config-tab">
    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <h6 class="card-title">Add New Package</h6>
            <label class="radio-inline">
                        <i class="spinner spinner-border spinner-border-sm text-primary" style="display: none;"></i>
                            
                                <input type="checkbox" <?php if($is_package =='1'){echo 'checked';} ?>  name="followup" id="enable_package_module" value="0" class="jq_followup"> Enable  Module
                            </label>     
        </div>
        <div class="card-body">
 
                <form id="pacakgesForm"  method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Package Name <i class="text-danger">*</i></label>
                                <input type="text"  class="form-control" name="name" placeholder="Package Name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Select Department<i class="text-danger">*</i></label>
                              <select name="departments[]" id="departments" multiple >
                                <option value="">-- Select Department --</option>
                              </select>
                            </div>
                        </div>
                        <div id="" class="col-md-12">
                             <!-- Dynamic fields will be appended here -->
                             <div class="row" id="name-session-fields-container">

                             </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Price <i class="text-danger">*</i></label>
                                <input type="number"  name="price" class="form-control" placeholder="Package Price" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                        <label class="radio-inline">
                                <input type="checkbox"  name="limited" id="is_limited"  class="jq_followup"> &nbsp; Limited Validity?
                            </label>     
                        </div>

                        <div id="date-fields" style="display:none;" class="w-100">
                            <div class="col-md-6">
                                <label for="start_date">Days:</label>
                                <input type="number" min="1" id="days" name="days" class="form-control" placeholder="Enter Days">
                            </div>
                           
                        </div>

                        <div class="col-md-12 mt-2 mb-2">
                        <button class="btn btn-ligth btn-sm"><i class="fa fa-save mr-2"></i> Save</button>
                        </div>
                       
                    </div>
                </form>

    <hr>
                <div class="col-md-12 table-responsive mt-5">
            <table class="table-striped" id="packages">
                    <tr>
                        <th>NO</th>
                        <th>Name</th>
                        <th>Discount</th>
                    </tr>
            </table>
            </div>
        </div>
    
    </div>
          
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/js/tom-select.complete.min.js"></script>
<script>
    $(document).ready(function() {
        $('#is_limited').change(function() {
        if ($(this).is(':checked')) {
            $('#date-fields').css('display','flex');
        } else {
            $('#date-fields').css('display','none');
        }
    });
   
});


var initTomSelecs = undefined
var selector= $('#departments');
initTomSelectProcedres(selector);
	function initTomSelectProcedres(selector) {
		initTomSelecs = new TomSelect(selector, {
			valueField: 'id',
			labelField: 'name',
			searchField: 'name',
            plugins: {
		remove_button:{
			title:'Remove this item',
		}
	},
			// Set the "load" property to define the function to fetch data dynamically
			load: function(query, callback) {
				var apiUrl = "<?php echo site_url('admin/CommenController/get_departments')?>";
			

				fetch(apiUrl)
					.then(response => response.json())
					.then(data => {
						callback(data);
					})
					.catch(() => {
						callback();
					});
			},
			render: {
				option: function(item, escape) {
					return '<div>' +
						'<span class="btn btn-sm">' + escape(item.name) + '</span>' +
						'</div>';
				},
				item: function(item, escape) {
					return '<div>' +
						'<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
						'</div>';
				}
			},
            onItemAdd: function(value, item) {
            // Call function to dynamically add fields when a department is selected
            var departmentName = item.querySelector('span').textContent.trim();
            
            addNameSessionFields(value,departmentName);
        },
        onItemRemove: function(value, item) {
            // Extract the department name
            var departmentName = item.querySelector('span').textContent.trim();
            // Call function to remove the corresponding field
            removeNameSessionFields(departmentName);
        }
		});

		// Optional: You can also set a minimum number of characters before triggering the API call
		initTomSelecs.settings.minLength = 2;
	}

    function addNameSessionFields(id,departmentId) {
    // Assuming you have a container to append these fields
    var container = document.getElementById('name-session-fields-container');
    
    // Create a new div for the fields
    var fieldWrapper = document.createElement('div');
    fieldWrapper.className = 'form-group';
    fieldWrapper.className = 'form-group col-md-6';
    fieldWrapper.id = 'field_' + departmentId.replace(/\s+/g, '_');

    // Create a label
    var label = document.createElement('label');
    label.textContent = 'Number of Sessions For Department ' + departmentId;
    
    // Create an input field for "name session"
    var input = document.createElement('input');
    input.type = 'number';
    input.attr = 'required';
    input.name = 'name_session[' + id + ']';
    input.className = 'form-control';

    // Append label and input to the wrapper
    fieldWrapper.appendChild(label);
    fieldWrapper.appendChild(input);
    
    // Append the wrapper to the container
    container.appendChild(fieldWrapper);
}

function removeNameSessionFields(departmentName) {
    var fieldWrapper = document.getElementById('field_' + departmentName.replace(/\s+/g, '_'));
    if (fieldWrapper) {
        fieldWrapper.remove();
    }
}

var dataTable = undefined;
$(document).ready(function() {
    // Initialize the DataTable
    dataTable = $('#packages').DataTable({
        dom: 'lBfrtip',
        buttons: [{
            extend: 'excel',
            title: `Discount Categories`
        }, {
            extend: 'print',
            autoPrint: true,
            title: `Daily Collection Report`,
            exportOptions: {
                columns: ':not(:last-child)'
            },
            customize: function(win) {
                $(win.document.body).prepend(`<?php print_header($this); ?>`);
            }
        }, ],
        'ajax': {
            'url': '<?= site_url('admin/Setting/Configurations/ConfigurationsController/get_packages'); ?>',
            'type': 'GET',
            'data': function(d) {
                d.receptionist = $('#receptionist').val();
                d.fromdate = $('#fromdate').val();
                d.todate = $('#todate').val();
            }
        },
        'columns': [{
                'data': 'id',
                'title': ' No.'
            },
            {
                'data': 'package_name',
                'title': 'Name'
            },
            {
                'data': 'department_names',
                'title': 'Name'
            },
            {
                'data': 'price',
                'title': 'Price'
            },
            {
                'data': '',
                'title': 'Action',
                'render': function(data, type, row) {
                 $html = '<a  data-id="'+row.id+'" class="btn btn-light delete-pacakge"><i class="fa fa-trash"></i></a>'
                return $html;
            }
            },
            
        ],
        'searching': false,
        'serverSide': true,
        'pageLength': 10,
        aLengthMenu: [
            [25, 50, 100, 200, -1],
            [25, 50, 100, 200, "All"]
        ],
        'pagingType': 'full_numbers',
        footer:true,
        autoWidth: false

    });



    $('#receptionist, #fromdate,#todate ').on('change', function() {
        dataTable.ajax.reload();
    });
});

$('#packages').on('click', '.delete-pacakge', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        
        Swal.fire({
			title: "Are you sure?",
			text: "You won't be able to revert this!",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Yes, delete it!"
		}).then((result) => {
			if (result.isConfirmed) {
				$.ajax({
                url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/deletePackage'); ?>',
                type: 'POST',
                data: { id: id },
                success: function(response) {
                    let res = JSON.parse(response);
                    successNotification(res.message);
                    dataTable.ajax.reload();
                },
                error: function(xhr, status, error) {
                    alert('An error occurred while deleting the discount.');
                }
            });
			}
		});

       
    });


    $('#pacakgesForm').on('submit', function(e) {
        e.preventDefault(); // Prevent the default form submission
        
        let formData = new FormData(this);

        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/SavePackage'); ?>',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
                // Handle the success response here
                let res = JSON.parse(response);
              successNotification(res.message);
              dataTable.ajax.reload();
              $('#pacakgesForm')[0].reset();
            },
            error: function(xhr, status, error) {
                // Handle the error response here
                alert('An error occurred while saving the discount settings.');
            }
        });
    });


    $('#enable_package_module').change(function() {
        // Show the spinner
        $(this).siblings('.spinner').show();

        // Get the checkbox status
        var isEnabled = $(this).is(':checked') ? 1 : 0;

        // AJAX request
        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/enableModule'); ?>',  // Replace with your endpoint URL
            type: 'POST',
            data: {
                enabled: isEnabled,
                type:'package'
            },
            success: function(response) {
                // Handle the success response here
                let res = JSON.parse(response);
                successNotification(res.message);
                console.log(res.message);
                
            },
            error: function(xhr, status, error) {
                // Handle the error response here
                errorNotification(error);
                console.error('Update failed:', error);
            },
            complete: function() {
                // Hide the spinner after request completion
                $('#enable_package_module').siblings('.spinner').hide();
            }
        });
    });

</script>

</div>