<div class="panel-group" id="accordion">

                                <div class="row">
                                    <div class="col-md-6">
                                        <form action="<?= base_url('index.php/admin/SmsPortal/SmsPortalController/sendIndividualSms'); ?>"  method="post">
                                            <h4>Send Individuals Messages</h4>
                                            <div class="form-group">
                                                <label for="patient">Patient</label>
                                                <select name="patient[]" id="patient" multiple required>
                                                    <option value="">Choose Patient</option>
                                                </select>
                                                <?= _e($this, 'patient'); ?>
                                            </div>

                                            <div class="form-group">
                                                <label for="message">Message</label>
                                                <textarea name="message" id="message" rows="10" required class="form-control mt-2" placeholder="Type your message here.."></textarea>
                                                <?= _e($this, 'message'); ?>
                                            </div>

                                            <div class="d-flex flex-wrap justify-content-end mt-2">
                                                <button type="submit" class="btn btn-sm btn-light mr-1"><i class="fa fa-paper-plane-o" aria-hidden="true"></i> Send</button>
                                                <button type="reset" class="btn btn-sm btn-light" onclick="init_patients()"><i class="fa fa-refresh" aria-hidden="true"></i> Clear</button>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="col-md-6">
                                        <h4>Send Bulk Messages</h4>
                                        <form action="<?= base_url('index.php/admin/SmsPortal/SmsPortalController/sendBulkSms') ?>" id="bulkMessageForm" method="POST">

                                            <div class="form-group">
                                                <label for="bulk_patients">Patients</label>
                                                <select name="bulk_patients" id="bulk_patients" >
                                                    <option value="all">All Patients</option>
                                                    <option value="vip">VIP Patients</option>
                                                </select>
                                                <?= _e($this, 'bulk_patients[]'); ?>
                                            </div>

                                            <div class="form-group">
                                                <label for="bulk_message">Message</label>
                                                <textarea name="bulk_message" id="bulk_message" rows="10" class="form-control mt-2" placeholder="Type your message here.."></textarea>
                                                <?= _e($this, 'bulk_message'); ?>
                                                <small id="smsCreditsInfo" class="form-text text-muted"></small>
                                            </div>

                                            <div class="d-flex flex-wrap justify-content-end mt-2">
                                                <button type="button" id="confirmBulkSend" class="btn btn-sm btn-light mr-1"><i class="fa fa-paper-plane-o" aria-hidden="true"></i> Send</button>
                                                <button type="reset" class="btn btn-sm btn-light" onclick="init_bulk_patients()"><i class="fa fa-refresh" aria-hidden="true"></i> Clear</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                            <script>

var credits =0;
$('#confirmBulkSend').click(function () {
    // Get the selected patient type (all or VIP)
    var patientType = $('#bulk_patients').val();

    // Make AJAX request to get patient count
    $.ajax({
        url: base_url + 'admin/SmsPortal/SmsPortalController/getPatientCount',  // Replace with your endpoint
        type: 'POST',
        data: { patientType: patientType },
        dataType: 'json',
        success: function(response) {
            // Assuming the server response returns the count in a variable called `count`
            var patientCount = response.count;

            // Update the confirmation message with the actual count
            $('#confirmationMessage').text('You are about to send messages to ' + patientCount + ' ' + (patientType === 'all' ? 'all patients' : 'VIP patients') + '. Are you sure?');
            $('#total_credits').html('Total Credits = '+credits +' x '+patientCount + ' = <strong>'+credits * patientCount + '</strong>');
            // Show the confirmation modal
            $('#confirmSendModal').modal('show');
        },
        error: function() {
            errorNotification("Failed to retrieve patient count.");
        }
    });
});
    // Handle confirm button click inside modal
    $('#confirmSendMessages').click(function () {
        if (!$('#captchaCheckbox').is(':checked')) {
            errorNotification("Please confirm you're not a robot.");
            return;
        }
        $('#bulkMessageForm').submit();  // Submit the form if confirmation is accepted
    });

    $('#bulk_message').on('input', function () {
        var message = $(this).val();
        credits = calculateSmsCredits(message);
        
        // Display the calculated credits below the textarea
        $('#smsCreditsInfo').text('SMS Credits needed: ' + credits);
    });


                                var choose_patient, bulk_patient = null;

function init_patients() {

    if (choose_patient) {
        choose_patient.destroy();
    }

    choose_patient = new TomSelect('#patient', {
        plugins: {
		remove_button:{
			title:'Remove this item',
		}
	},
        load: function(query, callback) {
            $.ajax({
                url: '<?= base_url('index.php/admin/SmsPortal/SmsPortalController/getPatients'); ?>',
                type: 'GET',
                
                dataType: 'json',
                data: {
                    query: query
                },
                success: function(response) {
                    var options = response.map(function(item) {
                        return {
                            value: item.mobile,
                            text: item.patient_name
                        };
                    });
                    callback(options);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching data:', error);
                }
            });
        }
    });
}

function init_bulk_patients() {

    if (bulk_patient) {
        bulk_patient.destroy();
    }

    bulk_patient = new TomSelect('#bulk_patients', {

        load: function(query, callback) {
            $.ajax({
                url: '<?= base_url('index.php/admin/SmsPortal/SmsPortalController/getPatients'); ?>',
                type: 'GET',
                dataType: 'json',
                data: {
                    query: query
                },
                success: function(response) {
                    var options = response.map(function(item) {
                        return {
                            value: item.mobile,
                            text: item.patient_name
                        };
                    });
                    callback(options);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching data:', error);
                }
            });
        }
    });
}

$(function(){
    init_patients();
    init_bulk_patients();
})
                            </script>