<div class="container-fluid mt-5">
    <div class="d-flex justify-content-between mb-3">
    <h5 class=" text-left">Current Running Tasks</h5>
    <a href="<?php echo base_url('admin/Reports/ReportsController/smsReport')  ?>" class="btn btn-light btn-sm">View Detailed Report</a>
    </div>
   
    <?php 
   $tasks = [
    (object) [
        'task_id' => 'T001',
        'created_at' => '2024-11-13 10:30:00',
        'total_sms' => '5000',
        'status' => 'in_progress',
        'progress' => 45,
        'created_by' => 'Acountant'
    ],
 
];

    ?>
    <?php if (!empty($tasks)): ?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="">
                    <tr>
                        <th>Task ID</th>
                        <th>Created Date</th>
                        <th>Total Messages</th>
                        <th>Status</th>

                        <th>Progress</th>
                        <th>Created By</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($tasks as $task): ?>
                        <tr>
                            <td><?php echo $task->task_id; ?></td>
                            <td><?php echo date('Y-m-d', strtotime($task->created_at)); ?></td>
                            <td><?php echo $task->total_sms; ?></td>
                            <td>
                                <?php if ($task->status == 'completed'): ?>
                                    <span class="badge badge-success">Completed</span>
                                <?php elseif ($task->status == 'in_progress'): ?>
                                    <span class="badge badge-warning">In Progress</span>
                                <?php else: ?>
                                    <span class="badge badge-secondary">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="progress" style="height: 20px;">
                                    <div class="progress-bar <?php echo $task->progress == 100 ? 'bg-success' : 'bg-info'; ?>" 
                                         role="progressbar" 
                                         style="width: <?php echo $task->progress; ?>%;" 
                                         aria-valuenow="<?php echo $task->progress; ?>" 
                                         aria-valuemin="0" 
                                         aria-valuemax="100">
                                        <?php echo $task->progress; ?>%
                                    </div>
                                </div>
                            </td>
                            <td><?php echo $task->created_by; ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p class="text-center text-muted">No tasks available to display.</p>
    <?php endif; ?>
</div>
