<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Voucher
                    <small>- <?php echo ($_id > 0 ? "Edit" : "Create New" ) ?> Voucher</small>
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>


            <!-- Main content -->
            <?php echo form_open_multipart('admin/Voucher/VoucherController/SaveVoucher'); ?> 
            <form id="save_form" name ="save_form" role="form" action="<?php echo base_url('index.php/admin/Voucher/VoucherController/SaveVoucher') ?>" method="post" >
                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box margin-bottom-5px box-warning">
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-md-1">
                                            <a href="<?php echo base_url('index.php/admin/Voucher/VoucherController') ?>" class="btn btn-social-icon <?php echo $this->config->item('new_update_back'); ?>" data-toggle="tooltip" data-placement="bottom" title="Back"><i class="fa  fa-long-arrow-left"></i></a>
                                        </div>
                                        <div class="col-md-9">


                                            <?php if (validation_errors()) { ?>
                                                <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">

                                                    <div>
                                                        <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
                                                    </div>
                                                </div>
                                            
											<?php } ?>
                                        </div>
                                        <div class="col-md-2">
                                           <button type="submit" href="#" class="btn btn-block btn-social <?php echo $this->config->item('save'); ?>">
                                                <i class="fa fa-save"></i> Save Voucher
                                            </button>
                                        </div>
                                    </div>	
                                </div><!-- /.box-body -->
                            </div>
                            <div class="box box-info">
                                <div class="row">
                                    <div class="col-md-5">

                                        <div class="box-body">
                                            <div class="form-group <?php echo form_error("code") ? "has-error" : "" ?>">
                                                <label>Voucher code</label>
                                                <input id="code" name="code" type="text"   value="<?php echo $code; ?>" type="text" class="form-control input_numbers" placeholder="Enter ..."/>
                                                <label  ><small><?php echo form_error("code"); ?></small></label>
                                            </div>
                                            <div class="form-group <?php echo form_error("amount") ? "has-error" : "" ?>">
                                                <label>Amount</label>
                                                <input id="amount" name="amount" type="text"   value="<?php echo $amount; ?>" type="text" class="form-control input_numbers" placeholder="Enter ..."/>
                                                <label  ><small><?php echo form_error("amount"); ?></small></label>
                                            </div>
                                            <div class="form-group <?php echo form_error("valid_date") ? "has-error" : "" ?>">
                                                <label>Valid date</label>
												<div id="dt_to_date"  class="input-group date">
													<input class="form-control input_border_radius" id="valid_date" name="valid_date" value="<?php echo $valid_date; ?>" type="text" readonly />
													<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
												</div>
                                                <label><small><?php echo form_error("valid_date"); ?></small></label>
                                            </div>
                                            <div class="form-group <?php echo form_error("expire_date") ? "has-error" : "" ?>">
                                                <label>Expire date</label>
												<div id="dt_to_date"  class="input-group date">
													<input class="form-control input_border_radius" id="expire_date" name="expire_date" value="<?php echo $expire_date; ?>" type="text" readonly />
													<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
												</div>
                                                <label  ><small><?php echo form_error("expire_date"); ?></small></label>
                                            </div>
											
											<div class="form-group <?php echo form_error("note") ? "has-error" : "" ?>">
											   <label>Note</label>
											   <textarea id="note" name="note" class="form-control" rows="6" placeholder="Enter ..."><?php echo $note ?></textarea>

											   <label><small><?php echo form_error("note"); ?></small></label>
										   </div>
											<div class="form-group <?php echo form_error("status") ? "has-error" : "" ?>">
												  <label>Status</label>
												  <select id="status" name="status" class="form-control selectpicker"  placeholder="Enter ..." data-live-search="true"/>

													<option  value="New" <?php echo $status == 'New' ? 'selected' : '' ?>  >New</option>
													<option  value="Cancell" <?php echo $status == 'Cancell' ? 'selected' : '' ?>  >Cancell</option>

												  </select>
												  <label><small><?php echo form_error("status"); ?></small></label>
											</div>
                                        </div>


                                    </div>
                                    <div class="col-md-7">
										<div class="row">
											<div class="col-md-12">
												<div class="box-body">
													<div class="form-group <?php echo form_error("voucher_image") ? "has-error" : "" ?>" style="width: 250px; margin-top: 20px;">
														<label class="file-control">
															<input type="file" data-control="image_uploader" size="60" >
															<div class="dv-logo">
																<div class="center" style="position: absolute;top: 0;left: 0;height: 100%;width: 100%;">
																	<div class="dv-hover center" style="margin: 0px;">
																		<i class="fa fa-image"></i>
																	</div>
																</div>

																<div class="dv-result-logo" style="width: 250px;">

																	<img class="result-logo" id="result" name="result" src="
																		 <?php echo $is_new_image == '1' ? $voucher_image : base_url($voucher_image) ?>">
																</div>
															</div>
														</label> 
														
														<br>
														<label  ><small><?php echo form_error("voucher_image"); ?></small></label>
														
													</div>
												</div>
											</div>
											<div class="col-md-12">
												<div id="crop-image" class="box-body"></div>
											   <input hidden="hidden" id="voucher_image" name="voucher_image" value="<?php echo $voucher_image; ?>">
											   <input hidden="hidden" id="is_new_image" name="is_new_image" value="<?php echo $is_new_image; ?>">
											</div>
										</div>
									</div>
                                </div>
                            </div>
                           <!-- add image-->
                            
                        </div>
                    </div>

                </section>
				
				<input  type="hidden" runat="server"  id="_id" name="_id" value=" <?php echo $_id; ?> ">
				
            </form>

        </div>


        <!-- ./wrapper -->

        <?php require_once(APPPATH . "views/admin/footer.php"); ?>

		<script type="text/javascript">
			
            $(document).ready(function () {

				$("#valid_date").datepicker({
					autoclose: true,
					todayHighlight: true,
					format: 'yyyy-mm-dd'
				}).datepicker('update', '<?php echo $valid_date; ?>');

				$("#expire_date").datepicker({
					autoclose: true,
					todayHighlight: true,
					format: 'yyyy-mm-dd'
				}).datepicker('update', '<?php echo $expire_date; ?>');
				
            /*image crop */
				function logoreadURL_Local(input) {

					if (input.files && input.files[0]) {

						var reader = new FileReader();

						reader.onload = function (e) {

							var selectedImage = e.target.result;

							$('#result').attr('src', selectedImage);

							$('#voucher_image').val(selectedImage);
							$('#is_new_image').val('1');


						}
						reader.readAsDataURL(input.files[0]);
					}
				}

				$(document).on('change', '[data-control=image_uploader]', function(e){
			
					logoreadURL_Local(this);

				});
				
			});

        </script>

    </body>
</html>