<?php

class DashboardController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->load->model('admin/Dashboard/DashboardModel');
    }

    public function index()
    {

        if ($this->session->userdata('user_Id') != '') {

            $data['active_menu'] = 1;
            $data['active_submenu'] = 0;

            // $patientsSummary = $this->DashboardModel->patient_count_and_last_patient_id();
            // $employeeSummary = $this->DashboardModel->get_employee_counts();
            // $smsSummary = $this->DashboardModel->get_available_sms_count();
            // $appoinmentSummary = $this->DashboardModel->get_available_appoinments_for_today();

            // $data = [
            //     'last_patient_id' => (int)$patientsSummary->last_patient_id,
            //     'totla_patients' => (int)$patientsSummary->totla_patients,
            //     'total_doctors' => (int)$employeeSummary->total_doctors,
            //     'total_nurses' => (int)$employeeSummary->total_nurses,
            //     'avialable_sms_count' => (int)$smsSummary, // Need to implement this function in DashboardModel,
            //     'available_appoinments' => (int)$appoinmentSummary->avialable_confirmed_appoinment,
            // ];

            // Treatments vs appoinments chart
            // Total sales [ today / this month / this year ]
            // Total appoinmens [ today / this month / this year ]
            // Price list with drop down [ qlm / insurance / default ]
            
            $data['insurance_types'] = $this->DashboardModel->getInsuranceTypes();
            $data['companies'] = $this->DashboardModel->getCompanies();

            if(check_right('dashboard_enable',$this)){
                 $this->load->view('admin/Dashboard/Dashboard', $data);
            }else{
                redirect('admin/Calender/CalenderController', 'refresh');
            }
               
            
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }
    
    public function get_sms_balance(){
        $sms = file_get_contents('https://javacomtech.com/pm/index.php/sms_gateway/get_balance?sender_api_key=l0Dild2X6GM5N7xe6o3BGQ5o9');
                    // echo $sms;
                    if($sms){
                      return round($sms);
                    //   setcookie('sms_credit', round($sms));
                    }else{
                     return 0;
                    }
    }

    public function getDashboarddData()
    {
        $patientsSummary = $this->DashboardModel->patient_count_and_last_patient_id();
        $employeeSummary = $this->DashboardModel->get_employee_counts();
        $smsSummary = $this->get_sms_balance();
        $appoinmentSummary = $this->DashboardModel->get_appoinment_counts();

        $result = [
            'last_patient_id' => (int)$patientsSummary->last_patient_id,
            'totla_patients' => (int)$patientsSummary->totla_patients,
            'total_doctors' => (int)$employeeSummary->total_doctors,
            'total_nurses' => (int)$employeeSummary->total_nurses,
            'avialable_sms_count' => (int)$smsSummary,
            'available_appoinments' => (int)$appoinmentSummary->avialable_confirmed_appoinment,
            'appoinments_vs_treatments' => [
                'appoinments' => array_values((array)$this->DashboardModel->get_this_year_appoinments()),
                'treatments' => array_values((array)$this->DashboardModel->get_this_year_treatments())
            ],
            'receptionist_received' => [
                'today' => $this->DashboardModel->receptionistReceived('today'),
                'week' => $this->DashboardModel->receptionistReceived('week'),
                'month' => $this->DashboardModel->receptionistReceived('month'),
                'year' =>  $this->DashboardModel->receptionistReceived('year')
            ],
            'doctor_income' => $this->DashboardModel->doctorIncome(),
            'totalSales' => [
                'today' => $this->DashboardModel->get_sales_counts('today'),
                'week' => $this->DashboardModel->get_sales_counts('week'),
                'month' => $this->DashboardModel->get_sales_counts('month'),
                'year' => $this->DashboardModel->get_sales_counts('year')
            ],
            'totalBalance' => [
                'today' => $this->DashboardModel->get_balance_counts('today'),
                'week' => $this->DashboardModel->get_balance_counts('week'),
                'month' => $this->DashboardModel->get_balance_counts('month'),
                'year' => $this->DashboardModel->get_balance_counts('year')
            ],
            'treatments' => $this->DashboardModel->get_top_treatments(3),
            'patients' => $this->DashboardModel->get_top_patients(3),
            'doctors' => $this->DashboardModel->get_top_doctors(3)
        ];

        return $this->output
            ->set_status_header(200)
            ->set_content_type('application/json')
            ->set_output(json_encode($result));
    }

    public function getAppoinments()
    {

        $json_data = file_get_contents('php://input');
        $data = json_decode($json_data);

        $response = $this->DashboardModel->get_appoinment_counts($data->type);

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function insurancePriceList()
    {
        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $insurance = $this->input->get('insurance');

        $records = $this->DashboardModel->getInsurancePriceList($search, $insurance, $length, $start);
        $total_records = $this->DashboardModel->get_total_records($search, $insurance); // Get total records
        

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function CompanyPriceList()
    {
        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $insurance = $this->input->get('insurance');
        $company = $this->input->get('company');

        $records = $this->DashboardModel->getInsurancePriceList($search, $insurance, $length, $start);
        $total_records = $this->DashboardModel->get_total_records($search, $insurance); // Get total records
        $company = $this->DashboardModel->retrieve_data_unique_row('tbl_companies', 'company_id', $company); // Get total records
        foreach ($records as $key => $value) {
            $discount_amount = ($company->discount * $value->lqdc_gross) / 100;
            $value->lqdc_gross = number_format($value->lqdc_gross - $discount_amount);
            $records[$key] = $value;
        }

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function getTreatPatients(){
        $period = $this->input->get('period');

        $response = array(
         'treatment' => $this->DashboardModel->get_top_treatments($period),
         'patients' => $this->DashboardModel->get_top_patients($period)
        );

        return $this->output
        ->set_status_header(200)
        ->set_content_type('application/json')
        ->set_output(json_encode($response));
    }

    public function getDoctorPatients(){
        $period = $this->input->get('period');

        $response = array(
         'doctors' => $this->DashboardModel->get_top_doctors($period)
        );

        return $this->output
        ->set_status_header(200)
        ->set_content_type('application/json')
        ->set_output(json_encode($response));
    }

}
