<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class EmployeesController extends MY_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('admin/Employees/EmployeesModel');
        $this->load->model('admin/UserGroup/UserGroupModel');
        $this->load->model('admin/Users/UserModel');
        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Calender/CalenderModel');
        $this->load->library('upload');
        $this->load->helper(array('form', 'url'));

        // load form_validation library
        $this->load->library('form_validation');
    }

    public function index() {
        if ($this->session->userdata('user_Id') != '') {
            $this->check_permission($this->session->userdata('user_Id'),'employees');

            $loginId = $this->session->userdata('user_Id');
            $data['profile'] = $this->UserModel->profile($loginId);
            $data['active_menu'] = 2;
            $data['active_submenu'] = 3;

            $data['user_right'] = $this->CommonModel->logged_user_right($loginId); 
            $data['profile'] = $this->CommonModel->profile($loginId);
            //$data['user'] = $this->UserModel->get_user();
            $data['doctors'] = $this->EmployeesModel->get_list(1);
            $data['nurses'] = $this->EmployeesModel->get_list(2);
            $data['cordinator'] = $this->EmployeesModel->get_list(8);

			$data['add_user'] = $this->CommonModel->check_user_other_rights($loginId,'employees');

            $this->load->view('admin/Employees/EmployeesList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function CreateNew() {
        if ($this->session->userdata('user_Id') != '') {

            $loginId = $this->session->userdata('user_Id');

            $data['active_menu'] = 2;
            $data['active_submenu'] = 3;
            $data['error'] = '';

            //Locals =========================================================================
			
			
			$data['edit_user'] = $this->CommonModel->check_user_other_rights($loginId,'edit_user');
			$data['add_user'] = $this->CommonModel->check_user_other_rights($loginId,'add_user');
			
            $data['user_id_val'] = 0;
            $data['user_name_val'] = '';
            $data['full_name_val'] = '';
            $data['email_val'] = '';
            $data['phone_no_val'] = '';
            $data['description_val'] = '';
			$data['district_id'] = '0';
			
			
			//image
			$data['image_path_val'] = '';


            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            $data['user'] = $this->UserModel->get_user();
            $data['user_group_id'] = $this->UserModel->user_group_id();
            $data['district_list'] = $this->CommonModel->District();

            $this->load->view('admin/Users/User', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    //Save data function
    public function SaveEmployee() {
        if ($this->session->userdata('user_Id') != '') {

            $loginId = $this->session->userdata('user_Id');
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            $data['user_group_id'] = $this->UserModel->user_group_id();
			$data['district_list'] = $this->CommonModel->District();
            $data['user'] = $this->UserModel->get_user();

			
			$data['designation_list'] = $this->CommonModel->get_list('tbl_designations');
            $data['tbl_doctor_types'] = $this->CommonModel->get_list('tbl_doctor_types');
            $data['tbl_department'] = $this->CommonModel->get_list('tbl_modules');
            

			$data['edit_employee'] = $this->CommonModel->check_user_other_rights($loginId,'edit_user');
            
            // $this->form_validation->set_rules('employee_code', 'Doctor Code', 'required|callback_code_exists_check');
            // $this->form_validation->set_rules('doctor_type', 'Doctor Type', 'required|callback_doctortype_check');

            $data['error'] = '';
            $data['active_menu'] = 2;
            $data['active_submenu'] = 3;

            //Locals =========================================================================
			

            $employee_type = $this->input->post('employee_type');
            $data['employee_id'] = trim($this->input->post('employee_id'));
            $data['user_id_val'] = trim($this->input->post('user_Id'));
            $data['user_name_val'] = trim($this->input->post('UserName'));
            $data['employee_code'] = trim($this->input->post('employee_code'));
            $data['doctor_stamp'] = trim($this->input->post('doctor_stamp'));
            $data['doctor_color'] = trim($this->input->post('doctor_color'));
            $data['full_name_val'] = trim($this->input->post('FullName'));
            $data['doctor_type'] = trim($this->input->post('doctor_type'));
            $data['department'] = trim($this->input->post('department'));
            $doctor_license = trim($this->input->post('doctor_license'));
		
           

            $data_save = array(
                'employee_code' => $this->input->post('employee_code'),
                'doctor_type' => $this->input->post('doctor_type'),
                'user_id' => $this->input->post('user_Id'),
                'doctor_color' => $this->input->post('doctor_color'),
                'doctor_stamp' => $this->input->post('doctor_stamp'),
                'employee_type' => $this->input->post('employee_type'),
                'department' => $this->input->post('department')
            );

            $data_group = array(
                'user_right_name' => $data['full_name_val'],
                'user_right_code' => $data['user_id_val'],
                'menu_order' => 1,
                'sub_menu_id' => 0,
                'right_type' => 'other_right',
                'main_menu_code' => 'calender',
                'main_menu_name' => 'Calender',
                'module' => 'doctor'
            );


            if ($data['employee_id'] > 0) {
               
		        $this->session->set_flashdata('success', 'Doctor Details Updated!');
                $this->EmployeesModel->update_data('tbl_employees','employee_id',$data['employee_id'], $data_save);
            } else {
                
		        $this->session->set_flashdata('success', 'Doctor Details Saved!');
                $this->EmployeesModel->save($data_save); 
                $this->UserGroupModel->saveUserRight($data_group);
                
            }

            $this->load->view('admin/Employees/Employee', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function SaveEmployeeNurse() {
        if ($this->session->userdata('user_Id') != '') {

            $loginId = $this->session->userdata('user_Id');
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            $data['user_group_id'] = $this->UserModel->user_group_id();
			$data['district_list'] = $this->CommonModel->District();
            $data['user'] = $this->UserModel->get_user();

			$data['designation_list'] = $this->CommonModel->get_list('tbl_designations');
            $data['tbl_doctor_types'] = $this->CommonModel->get_list('tbl_doctor_types');
            
			$data['edit_employee'] = $this->CommonModel->check_user_other_rights($loginId,'edit_user');
            
            $this->form_validation->set_rules('employee_code', 'Doctor Code', 'required|callback_code_exists_check');

            $data['error'] = '';
            $data['active_menu'] = 2;
            $data['active_submenu'] = 3;

            //Locals =========================================================================
			
            $employee_type = $this->input->post('employee_type');
            $data['employee_id'] = trim($this->input->post('employee_id'));
            $data['user_id_val'] = trim($this->input->post('user_Id'));
            $data['user_name_val'] = trim($this->input->post('UserName'));
            $data['employee_code'] = trim($this->input->post('employee_code'));
            $data['full_name_val'] = trim($this->input->post('FullName'));
            $doctor_license = trim($this->input->post('doctor_license'));
		
            if ($this->form_validation->run() == FALSE) {
                $this->load->view('admin/Employees/EmployeeNurse', $data);
                return;
            }
			

            $data_save = array(
                'employee_code' => $this->input->post('employee_code'),
                'user_id' => $this->input->post('user_Id'),
                'employee_type' => $this->input->post('employee_type')
            );


            if ($data['employee_id'] > 0) {
		        $this->session->set_flashdata('success', 'Nurse Details updated!');
                $this->EmployeesModel->update_data('tbl_employees','employee_id',$data['employee_id'], $data_save);
            } else {
		        $this->session->set_flashdata('success', 'Nurse Details Saved!');
                $this->EmployeesModel->save($data_save);
            }

            $this->load->view('admin/Employees/EmployeeNurse', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }



    public function Load($UserID) {
        if ($this->session->userdata('user_Id') != '') {
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 2;
            $data['active_submenu'] = 3;
			
			$data['edit_employee'] = $this->CommonModel->check_user_other_rights($loginId,'edit_user');

            $group_data = $this->EmployeesModel->get_employee_details($UserID);

            foreach ($group_data AS $row) {
                $data['employee_id'] = $row->employee_id;
                $data['user_id_val'] = $row->user_Id;
                $data['user_name_val'] = $row->user_name;                
                $data['doctor_stamp'] = $row->doctor_stamp;               
                $data['full_name_val'] = $row->full_name;
                $data['doctor_license'] = $row->doctor_license;
                $data['doctor_color'] = $row->doctor_color;
                $data['doctor_type'] = $row->doctor_type;
                $data['employee_code'] = $row->employee_code;
                $data['department'] = $row->department;
            }
			
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            // $data['user_group_right'] = $this->UserGroupModel->user_right();

            $data['user_group_id'] = $this->UserModel->user_group_id();
			$data['district_list'] = $this->CommonModel->District();
			$data['designation_list'] = $this->CommonModel->get_list('tbl_designations');
            $data['tbl_doctor_types'] = $this->CommonModel->get_list('tbl_doctor_types');
            $data['tbl_department'] = $this->CommonModel->get_list('tbl_modules','is_module',1);

            $this->load->view('admin/Employees/Employee', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function sync_hrmate(){
        $users = json_decode(file_get_contents('http://hmate.is-by.us:2020/hrmate/erp/employees/get_employee_list'));
        foreach ($users as $user) {
            $exist = $this->CommonModel->get_list_where('tbl_users','hrmate_id',$user->user_id);
            if(empty($exist)){
                $password = uniqid();
                $cost = 10;
                $salt = strtr(base64_encode(random_bytes(16)), '+', '.');
                $salt = sprintf("$2a$%02d$", $cost) . $salt;
                $hash = crypt($password, $salt);

                $data_save = array(
                'user_name' => strtolower($user->first_name),
                'full_name' => ucfirst(strtolower($user->first_name)).' '.ucfirst(strtolower($user->last_name)),
                'email' => $user->email,
                'phone_no' => $user->contact_number,
                'user_description' => '',
                'password' => $hash,
                'create_user_Id' => '77',
				'image' => $this->profile_img(),
                'user_group_Id' => 1,
                'create_datetime' => date('Y-m-d H:i:s'),
                'hrmate_id' =>$user->user_id,
                'is_inactive' => 1
                );
                $this->UserModel->saveUser($data_save);
            }
        }

    }

    public function profile_img(){

        $userImage = 'data:image/png;base64,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';

        return $userImage;
    }
    
    
    public function code_exists_check() {
        if (self::code_exists(trim($this->input->post('employee_code')), trim($this->input->post('user_Id')),
        trim($this->input->post('employee_type')))) {
            $this->form_validation->set_message('code_exists_check', 'Doctor Code Alerady Exists!');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function code_exists($employee_code,$user_Id,$employee_type){
        $this->db->where('employee_code', $employee_code);
        $this->db->where('employee_type', $employee_type);
        $this->db->where_not_in('user_id', $user_Id);
        $query = $this->db->get('tbl_employees');
        if ($query->num_rows() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function doctortype_check() {
        if ($this->input->post('doctor_type') === '0') {
            $this->form_validation->set_message('doctortype_check', 'Please Select a Doctor Type.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function LoadNurse($UserID){
        if ($this->session->userdata('user_Id') != '') {
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 2;
            $data['active_submenu'] = 3;
			
			$data['edit_employee'] = $this->CommonModel->check_user_other_rights($loginId,'edit_user');

            $group_data = $this->EmployeesModel->get_employee_details($UserID);

            foreach ($group_data AS $row) {
                $data['employee_id'] = $row->employee_id;
                $data['user_id_val'] = $row->user_Id;
                $data['user_name_val'] = $row->user_name;                
                $data['doctor_stamp'] = $row->doctor_stamp;               
                $data['full_name_val'] = $row->full_name;
                $data['doctor_license'] = $row->doctor_license;
                $data['doctor_color'] = $row->doctor_color;
                $data['doctor_type'] = $row->doctor_type;
                $data['employee_code'] = $row->employee_code;
                
            }
			
			
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);

            $data['user_group_id'] = $this->UserModel->user_group_id();
			$data['district_list'] = $this->CommonModel->District();
			$data['designation_list'] = $this->CommonModel->get_list('tbl_designations');
            $data['tbl_doctor_types'] = $this->CommonModel->get_list('tbl_doctor_types');
            

            $this->load->view('admin/Employees/EmployeeNurse', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function LoadCordinator($UserID){
        if ($this->session->userdata('user_Id') != '') {
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 2;
            $data['active_submenu'] = 3;
			
			$data['edit_employee'] = $this->CommonModel->check_user_other_rights($loginId,'edit_user');

            $group_data = $this->EmployeesModel->get_employee_details($UserID);

            foreach ($group_data AS $row) {
                $data['employee_id'] = $row->employee_id;
                $data['user_id_val'] = $row->user_Id;
                $data['user_name_val'] = $row->user_name;                
                $data['doctor_stamp'] = $row->doctor_stamp;               
                $data['full_name_val'] = $row->full_name;
                $data['doctor_license'] = $row->doctor_license;
                $data['doctor_color'] = $row->doctor_color;
                $data['doctor_type'] = $row->doctor_type;
                $data['employee_code'] = $row->employee_code;
                $data['department'] = $row->department;
            }
			
			
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);

            $data['user_group_id'] = $this->UserModel->user_group_id();
			$data['district_list'] = $this->CommonModel->District();
			$data['designation_list'] = $this->CommonModel->get_list('tbl_designations');
          
            $data['tbl_department'] = $this->CommonModel->get_list('tbl_modules','is_module',1);
            

            $this->load->view('admin/Employees/EmployeeCordinator', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }


    public function SaveEmployeeCoordinator() {
        if ($this->session->userdata('user_Id') != '') {

            $loginId = $this->session->userdata('user_Id');
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            $data['user_group_id'] = $this->UserModel->user_group_id();
			$data['district_list'] = $this->CommonModel->District();
            $data['user'] = $this->UserModel->get_user();

			$data['designation_list'] = $this->CommonModel->get_list('tbl_designations');
            $data['tbl_doctor_types'] = $this->CommonModel->get_list('tbl_doctor_types');
            
			$data['edit_employee'] = $this->CommonModel->check_user_other_rights($loginId,'edit_user');
            
            $this->form_validation->set_rules('employee_code', 'Doctor Code', 'required|callback_code_exists_check');

            $data['error'] = '';
            $data['active_menu'] = 2;
            $data['active_submenu'] = 3;

            //Locals =========================================================================
			
            $employee_type = $this->input->post('employee_type');
            $data['employee_id'] = trim($this->input->post('employee_id'));
            $data['user_id_val'] = trim($this->input->post('user_Id'));
            $data['user_name_val'] = trim($this->input->post('UserName'));
            $data['employee_code'] = trim($this->input->post('employee_code'));
            $data['full_name_val'] = trim($this->input->post('FullName'));
            $doctor_license = trim($this->input->post('doctor_license'));
            $data['department'] = trim($this->input->post('department'));
		
            if ($this->form_validation->run() == FALSE) {
                $this->load->view('admin/Employees/EmployeeCordinator', $data);
                return;
            }
			

            $data_save = array(
                'employee_code' => $this->input->post('employee_code'),
                'user_id' => $this->input->post('user_Id'),
                'employee_type' => $this->input->post('employee_type'),
                'department' => $this->input->post('department')
            );


            if ($data['employee_id'] > 0) {
		        $this->session->set_flashdata('success', 'Coordinator Details updated!');
                $this->EmployeesModel->update_data('tbl_employees','employee_id',$data['employee_id'], $data_save);
            } else {
		        $this->session->set_flashdata('success', 'Coordinator Details Saved!');
                $this->EmployeesModel->save($data_save);
            }

            $this->load->view('admin/Employees/EmployeeCordinator', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }


}
