<?php

class OBGYNController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');

        $this->load->library('upload');
    }

    public function index()
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PatientsModel->get_dataList();

        $this->load->view('admin/Patients/PatientsList', $data);
    }

    public function canvan_images($imagepath, $pid, $folder_name, $plastic_up_image)
    {

        if (!is_dir('./'.UPLOAD_PATH)) {
            mkdir('./'.UPLOAD_PATH);
        }

        if (!is_dir('/'.UPLOAD_PATH.'plastic/')) {
            mkdir('./'.UPLOAD_PATH.'plastic/');
        }

        if (!is_dir("./".UPLOAD_PATH."plastic/{$folder_name}")) {
            mkdir("./".UPLOAD_PATH."plastic/{$folder_name}");
        }
        $exist_image = ''.UPLOAD_PATH.'plastic/' . $folder_name . $plastic_up_image;

        $imagepath = substr($imagepath, strpos($imagepath, ",") + 1);
        $imagepath = base64_decode($imagepath);
        $path = ''.UPLOAD_PATH.'plastic/' . $folder_name;
        // print_r($imagepath);die;
        $image_name = $pid . '_' . uniqid() . ".png";
        $file_path = $path . $image_name;
        file_put_contents($file_path, $imagepath, FILE_USE_INCLUDE_PATH);
        return $image_name;
    }


    public function save()
    {

        $patient_id = $this->input->post('patient_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

        $result['active_menu'] = 15;
        $result['active_submenu'] = 1;

        
        $treatment_date_gyne = $this->input->post('treatment_date_gyne');
        $diagnosis_id = $this->input->post('gyne_diagnosis_id');
        $diagnosis_name = $this->input->post('gyne_diagnosis_name');
        $treatment_name = $this->input->post('gyne_treatment_name');
        $treatment_id = $this->input->post('gyne_treatment_id');
        $fees = $this->input->post('fees_gyne');

        $assigned_package = $this->input->post('assigned_package');
        $followup = $this->input->post('followup');

        $discount = $this->input->post('discount');
        $discount_per = $this->input->post('discount_per');
        $orig_price = $this->input->post('orig_price');

        $treatment_date = $this->input->post('treatment_date');
        $treatment_time = $this->input->post('treatment_time');

        if (is_array($fees)) {
            $total = array_sum($fees);
        }

        if (is_array($fees)) {
            $orig_price_total = array_sum($fees);
        }

        if (is_array($discount)) {
            $total_discount = array_sum($discount);
        }


        $this->db->trans_start();
        try {
            if($followup == 0){
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date_gyne,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 6
            );
        }else{
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date_gyne,
                'treat_time' => $treatment_time,
                'total' => 0,
                'discount' => 0,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 6
            );
        }

            $treatement_payment_id = $this->PatientsModel->insert_data('tbl_treatment_payment', $treatment_payment_data);


            $newdata = array(
                'patient_id' => $decryptedId,
                'treatment_payment_id' => $treatement_payment_id,
                'present_complaints' => $this->input->post('present_complaints'),
                'menstrual' => $this->input->post('menstrual'),
                'menarche' => $this->input->post('menarche'),
                'painss' => $this->input->post('painss'),
                'loss' => $this->input->post('loss'),
                'inter_menstrual' => $this->input->post('inter_menstrual'),
                'obstetric' => $this->input->post('obstetric'),
                'infertility' => $this->input->post('infertility'),
                'nofchilds' => $this->input->post('nofchilds'),
                'mother' => $this->input->post('mother'),
                'children' => $this->input->post('children'),
                'miscarriages' => $this->input->post('miscarriages'),
                'urinary_symptoms' => $this->input->post('urinary_symptoms'),
                'alimentary_symtoms' => $this->input->post('alimentary_symtoms'),
                'pain' => $this->input->post('pain'),
                'others_symtoms' => $this->input->post('others_symtoms'),
                'urgency' => $this->input->post('urgency'),
                'incontinence_stress' => $this->input->post('incontinence_stress'),
                'other_stres' => $this->input->post('Other_stres'),
                'contraception_methods' => $this->input->post('contraception_methods'),
                'marital_history' => $this->input->post('marital_history'),
                'pre_medi' => $this->input->post('pre_medi'),
                'drug_taken' => $this->input->post('drug_taken'),
                'complaints' => $this->input->post('complaints'),
                'allergies' => $this->input->post('allergies'),
                'asthma' => $this->input->post('asthma'),
                'hay_fever' => $this->input->post('hay_fever'),
                'drugs' => $this->input->post('drugs'),
                'skin' => $this->input->post('skin'),
                'general_pe' => $this->input->post('general_pe'),
                'bp_pe' => $this->input->post('bp_pe'),
                'height_pe' => $this->input->post('height_pe'),
                'weight_pe' => $this->input->post('weight_pe'),
                'breast_pe' => $this->input->post('breast_pe'),
                'investigation' => $this->input->post('investigation'),
                'pelvis' => $this->input->post('pelvis'),
                'vulva' => $this->input->post('vulva'),
                'introitus' => $this->input->post('introitus'),
                'vagina' => $this->input->post('vagina'),
                'cervix' => $this->input->post('cervix'),
                'uterus' => $this->input->post('uterus'),
                'apendage_r' => $this->input->post('apendage_r'),
                'apendage_l' => $this->input->post('apendage_l'),
                // 'smeartaken' => $this->input->post('smeartaken'),
                // 'swabtaken' => $this->input->post('swabtaken'),
                // 'colivisible' => $this->input->post('colivisible'),
                'provisional_diagnosis' => $this->input->post('provisional_diagnosis'),
                'made_by' => $this->input->post('made_by'),
                'management' => $this->input->post('management'),
                'treatment_in_clinic' => $this->input->post('treatment_in_clinic'),
                'investigation_pe' => $this->input->post('investigation_pe'),
                'lmp' => $this->input->post('lmp')
            );

            $gyne_data_id = $this->PatientsModel->insert_data('tbl_treat_gynae_rec', $newdata);

            for ($i = 0; $i < count($treatment_id); $i++) {

                $newdata = array(
                    'procedure_id' => $treatment_id[$i],
                    'episode_type' => 1,
                    'diagnostise_id' => $diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id,
                    'aditional_diagnostise_name' => $diagnosis_name[$i],
                    'orig_price' => $fees[$i]
                );
                

                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }

            if($followup == 2){
              $this->PatientsModel->updateSessions($decryptedId,$assigned_package,6);
               
               
            }
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
            $this->session->set_flashdata('success', 'OB-GYN Treatment saved successfully.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            $this->session->set_flashdata('Error', 'OB-GYN Treatment not saved.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
            exit;
        }

        $this->db->trans_complete();
    }

    public function update()
    {

        $patient_id = $this->input->post('patient_id');
        $treatement_payment_id = $this->input->post('treatement_payment_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

        $result['active_menu'] = 15;
        $result['active_submenu'] = 1;

        
        $treatment_date_gyne = $this->input->post('treatment_date_gyne');
        $diagnosis_id = $this->input->post('gyne_diagnosis_id');
        $diagnosis_name = $this->input->post('gyne_diagnosis_name');
        $treatment_name = $this->input->post('gyne_treatment_name');
        $treatment_id = $this->input->post('gyne_treatment_id');
        $fees = $this->input->post('fees_gyne');

        $discount = $this->input->post('discount');
        $discount_per = $this->input->post('discount_per');
        $orig_price = $this->input->post('orig_price');

        $treatment_date = $this->input->post('treatment_date');
        $treatment_time = $this->input->post('treatment_time');

        $treatment_date = $this->input->post('treatment_date');
        $treatment_time = $this->input->post('treatment_time');
        if (is_array($fees)) {
            $total = array_sum($fees);
        }

        if (is_array($fees)) {
            $orig_price_total = array_sum($fees);
        }

        if (is_array($discount)) {
            $total_discount = array_sum($discount);
        }

        $this->db->trans_start();
        try {
            $treatment_payment_data = array(
                'treat_date' => $treatment_date_gyne,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => 0,
                'department_id' => 6
            );


            $gynae_data = array(
                'present_complaints' => $this->input->post('present_complaints'),
                'menstrual' => $this->input->post('menstrual'),
                'menarche' => $this->input->post('menarche'),
                'painss' => $this->input->post('painss'),
                'loss' => $this->input->post('loss'),
                'inter_menstrual' => $this->input->post('inter_menstrual'),
                'obstetric' => $this->input->post('obstetric'),
                'infertility' => $this->input->post('infertility'),
                'nofchilds' => $this->input->post('nofchilds'),
                'mother' => $this->input->post('mother'),
                'children' => $this->input->post('children'),
                'miscarriages' => $this->input->post('miscarriages'),
                'urinary_symptoms' => $this->input->post('urinary_symptoms'),
                'alimentary_symtoms' => $this->input->post('alimentary_symtoms'),
                'pain' => $this->input->post('pain'),
                'others_symtoms' => $this->input->post('others_symtoms'),
                'urgency' => $this->input->post('urgency'),
                'incontinence_stress' => $this->input->post('incontinence_stress'),
                'other_stres' => $this->input->post('Other_stres'),
                'contraception_methods' => $this->input->post('contraception_methods'),
                'marital_history' => $this->input->post('marital_history'),
                'pre_medi' => $this->input->post('pre_medi'),
                'drug_taken' => $this->input->post('drug_taken'),
                'complaints' => $this->input->post('complaints'),
                'allergies' => $this->input->post('allergies'),
                'asthma' => $this->input->post('asthma'),
                'hay_fever' => $this->input->post('hay_fever'),
                'drugs' => $this->input->post('drugs'),
                'skin' => $this->input->post('skin'),
                'general_pe' => $this->input->post('general_pe'),
                'bp_pe' => $this->input->post('bp_pe'),
                'height_pe' => $this->input->post('height_pe'),
                'weight_pe' => $this->input->post('weight_pe'),
                'breast_pe' => $this->input->post('breast_pe'),
                'investigation' => $this->input->post('investigation'),
                'pelvis' => $this->input->post('pelvis'),
                'vulva' => $this->input->post('vulva'),
                'introitus' => $this->input->post('introitus'),
                'vagina' => $this->input->post('vagina'),
                'cervix' => $this->input->post('cervix'),
                'uterus' => $this->input->post('uterus'),
                'apendage_r' => $this->input->post('apendage_r'),
                'apendage_l' => $this->input->post('apendage_l'),
                'provisional_diagnosis' => $this->input->post('provisional_diagnosis'),
                'made_by' => $this->input->post('made_by'),
                'management' => $this->input->post('management'),
                'treatment_in_clinic' => $this->input->post('treatment_in_clinic'),
                'investigation_pe' => $this->input->post('investigation_pe'),
                'lmp' => $this->input->post('lmp')
            );


            $this->PatientsModel->update_data_where('tbl_treatment_payment', 'treatement_payment_id', $treatement_payment_id, $treatment_payment_data);
            $this->PatientsModel->update_data_where('tbl_treat_gynae_rec', 'treatment_payment_id', $treatement_payment_id, $gynae_data);
            $this->PatientsModel->delete_data_where('tbl_episode_payment', 'treatement_payment_id', $treatement_payment_id);

            for ($i = 0; $i < count($treatment_id); $i++) {

                $newdata = array(
                    'procedure_id' => $treatment_id[$i],
                    'episode_type' => 1,
                    // 'diagnostise_id' => $diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id,
                    'aditional_diagnostise_name' => $diagnosis_name[$i],
                    'orig_price' => $fees[$i]
                );

                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
            $this->session->set_flashdata('success', 'OB-GYN Treatment Updated Successfully.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            exit;
        }

        $this->db->trans_complete();
    }

    public function edit($treatement_payment_id)
    {
        $decryptedId = decrypt_and_url_decode($treatement_payment_id, $this);
        $data['invoice'] = $this->PatientsModel->retrieve_data_unique_row('tbl_treatment_payment', 'treatement_payment_id', $decryptedId);
        $data['episodes'] = $this->PatientsModel->get_treatment_episodes($decryptedId);
        $gynae = $this->PatientsModel->retrieve_data_unique_row('tbl_treat_gynae_rec', 'treatment_payment_id', $decryptedId);
        foreach ($gynae as $key => $value) {
            $data[$key] = $value;
        }
        $data['patient_id'] = $data['invoice']->patient_id;
        $data['treatment_payment_id'] = $decryptedId;

        // print_r($data);die;

        $this->load->view('admin/Modules/GynaeRecord/gynaeRecordEdit', $data);
    }
}
