<?php

class QlmController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        date_default_timezone_set('Asia/Kuwait');

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Qlm/QlmModel');

        $this->load->library('upload');
    }

    public function qlmPriceList()
    {

        $insurnaceId = decrypt_and_url_decode($this->input->post('insurnaceId'), $this);
        $treatmentCategory = decrypt_and_url_decode($this->input->post('treatmentCategory'), $this);

        // $this->output
        //     ->set_content_type('application/json')
        //     ->set_output(json_encode($this->QlmModel->qlmPriceList($insurnaceId, $treatmentCategory)));
        $result = $this->QlmModel->qlmPriceList($insurnaceId, $treatmentCategory);
        $HTML = "<option value='-1'>Please Select Procedure</option>";
        foreach ($result as $row) {
            $HTML .= "<option value='$row->treatment_id | $row->treatment_name | $row->lqdc_gross'>$row->treatment_id | $row->treatment_name | $row->lqdc_gross</option>";
        }
        echo $HTML;
    }

    public function getDiagnosis()
    {
        $term = $this->input->get('term');
        $data = $this->QlmModel->getDiagnosis($term);
        echo json_encode($data);
    }

    public function addPlaneofcare()
    {

            // $this->output
            //     ->set_content_type('application/json')
            //     ->set_output(json_encode($this->input->post()))
            //     ->_display();
            // exit;

        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);
        $curr_time = date("H:i");
        $split_time = explode(':', $curr_time);

        $plan_teeth = $this->input->post('plan_teeth');
        $plan_clinical_finding = $this->input->post('plan_clinical_finding');
        $plan_procedure = $this->input->post('plan_procedure');
        $plan_doctor = $this->input->post('plan_doctor');
        $patient_id = $this->input->post('patient_id');
        $full_teeth = $this->input->post('full_teeth');
        $discount = $this->input->post('discount');
        $discount_per = $this->input->post('discount_per');
        $teeth_price = $this->input->post('teeth_price');
        $patient_qid = $this->input->post('patient_qid');
        $member_id = $this->input->post('member_id');
        $p_category = $this->input->post('p_category');
        $p_category = (int)$p_category;
        $plan_diag = $this->input->post('plan_diag');
        $dia_id = $this->input->post('dia_id');
        $chief_complain = $this->input->post('illness_details');
        $medical_history = $this->input->post('medical_history');
        $line_of_management = $this->input->post('line_of_management');
        $illness = $this->input->post('illness');
        $priority = $this->input->post('priority');
        $plan_diag_full = $this->input->post('plan_diag_full');
        $pregnant = $this->input->post('pregnant');
        $lmp_date = $this->input->post('lmp_date');
        $insurance_id = $this->input->post('insurance_id');
        $justification = $this->input->post('justification');
        $patient_diagnostise = '';
        $preapproval = [];

        if (!empty($dia)) {
            $patient_diagnostise = implode(',', $dia_id);
        }

        $files = !empty($_FILES['xray']) ? $_FILES['xray'] : '';

        //$data['private_category'] = $this->doctor_retrive->retrieve_data('p_treatment_category');

        $last_exam = $this->QlmModel->getLastExam(decrypt_and_url_decode($patient_id, $this));

        $data['full_tooth'] = $last_exam ? $last_exam->full_tooth : "";
        $data['patient_id'] = $patient_id;

        $this->form_validation->set_rules('patient_id', 'Patient', 'required');

        if ($this->form_validation->run() == FALSE) {
            set_old($this);
            errors_to_flashdata($this);
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id);
        }

        $get_doctor_id = $this->QlmModel->getDoctorData($this->session->userdata('user_Id'));
        $doctor_id = $get_doctor_id->user_id;
        if($doctor_id == ""){
            $doctor_id = "3";
        }
        $doctor_id = "203";
        $inpt = $this->input->post();
        $inpt['doctor_id'] = $get_doctor_id->doctor_license;

        if ($p_category == 12) {
            $newdata = [
                'enter_date' => $curr_date,
                'patient_id' => $patient_id,
                'doctor_id' => $doctor_id,
                'xray'  => '',
                'p_category' => $p_category,
                'chief_complain' => $chief_complain,
                'medical_history' => $medical_history,
                'line_of_management' => $line_of_management,
                'illness' => $illness,
                'priority' => $priority,
                'insurance_id' => $insurance_id,
                'justification' => $justification
            ];

            $planofcare_main_id = $this->QlmModel->insert_data('tbl_planofcare_main', $newdata);

            $newdata = [
                'planofcare_main_id' => $planofcare_main_id,
                'diagnosis_id' => $patient_diagnostise,
                'doctor_id' => $doctor_id
            ];

            $this->QlmModel->insert_data('tbl_planofcare', $newdata);

            $newdata = [
                'patient_id' => $patient_id,
                'doctor_id' => $doctor_id,
                'enter_date' => $curr_date,
                'diagnostise_id' => $patient_diagnostise,
                'status' => 1
            ];

            $this->QlmModel->insert_data('tbl_prescription_main', $newdata);

            foreach ($inpt['drug_id'] as $k => $drug) {
                $newdata = [
                    'patient_id' => $patient_id,
                    'drug_id' => $inpt['drug_id'][$k],
                    'drug_qty' => $inpt['drugs_qty'][$k],
                    'drug_note' => $inpt['drug_notes'][$k],
                    'after_before' => '',
                    'prescription_id' => $planofcare_main_id,
                    'log_id' => '',
                    'prescription_main_id' => $planofcare_main_id,
                    'drug_name' => $inpt['drug_name'][$k],
                    'bill_items_id' => 0
                ];

                $this->QlmModel->insert_data('tbl_prescription', $newdata);
            }
        } else {
            $newfilename = $patient_id . '~' . $curr_date . '~' . $split_time[0] . $split_time[1];
            $config['upload_path'] = './'.UPLOAD_PATH.'xray/';
            $config['allowed_types'] = 'jpg|png';
            $config['overwrite']    = 'TRUE';
            $config['max_size']    = '3072';
            $config['max_width']  = '0';
            $config['max_height']  = '0';
            $config['file_name']  = $newfilename;

            $this->load->library('upload', $config);

            if (!$this->upload->do_upload('xray')) {

                $newdata = [
                    'enter_date' => $curr_date,
                    'patient_id' => $patient_id,
                    'doctor_id' => $doctor_id,
                    'xray'  => '',
                    'qlm_status' => !empty($preapproval->messageType) ? $preapproval->messageType : '',
                    'qlm_message' => !empty($preapproval->message) ? $preapproval->message : '',
                    'pa_reference_no' => !empty($preapproval->PAreferenceNo) ? $preapproval->PAreferenceNo : '',
                    'visit_no' => !empty($eligibility->visitNo) ? $eligibility->visitNo : '',
                    'p_category' => $p_category,
                    'chief_complain' => $chief_complain,
                    'medical_history' => $medical_history,
                    'line_of_management' => $line_of_management,
                    'illness' => $illness,
                    'priority' => $priority
                ];

                $planofcare_main_id = $this->QlmModel->insert_data('tbl_planofcare_main', $newdata);

                for ($i = 0; $i < count($plan_procedure); $i++) {

                    $newdata = [
                        'planofcare_main_id' => $planofcare_main_id,
                        'teeth_number' => $plan_teeth[$i],
                        'full_tooth' => $full_teeth[$i],
                        'procedure_id' => $plan_procedure[$i],
                        'teeth_price' => $teeth_price[$i],
                        'discount_qr' => $discount[$i],
                        'discount_per' => $discount_per[$i],
                        'doctor_id' => $doctor_id,
                        //'diagnosis_id' => $dia_id[$i]
                        'diagnosis_id' => $plan_diag_full[$i]
                    ];

                    $this->QlmModel->insert_data('tbl_planofcare', $newdata);
                }
            } else {
                // echo 'x<hr>';
                // print_r($this->input->post());
                // die();
                $img_data = ['upload_data' => $this->upload->data()];

                $newdata = [
                    'enter_date' => $curr_date,
                    'patient_id' => $patient_id,
                    'doctor_id' => $doctor_id,
                    'xray'  => $img_data['upload_data']['file_name'],
                    'p_category' => $p_category,
                    'chief_complain' => $chief_complain,
                    'medical_history' => $medical_history,
                    'line_of_management' => $line_of_management,
                    'illness' => $illness,
                    'priority' => $priority
                ];

                $planofcare_main_id = $this->QlmModel->insert_data('tbl_planofcare_main', $newdata);

                for ($i = 0; $i < count($plan_teeth); $i++) {
                    $newdata = [
                        'planofcare_main_id' => $planofcare_main_id,
                        'teeth_number' => $plan_teeth[$i],
                        'full_tooth' => $full_teeth[$i],
                        'procedure_id' => $plan_procedure[$i],
                        'teeth_price' => $teeth_price[$i],
                        'discount_qr' => $discount[$i],
                        'discount_per' => $discount_per[$i],
                        'doctor_id' => $doc,
                        'diagnosis_id' => $plan_diag_full[$i]
                    ];

                    $this->QlmModel->insert_data('tbl_planofcare', $newdata);
                }
            }
        }

        if ($insurance_id == 8) {
            $qlm = new Qlm();
            $preapproval = $qlm->pre_approval($inpt, $planofcare_main_id);
            $preapproval = json_decode($preapproval);

            $newdata = [
                'qlm_status' => !empty($preapproval->messageType) ? $preapproval->messageType : '',
                'qlm_message' => !empty($preapproval->message) ? $preapproval->message : '',
                'pa_reference_no' => !empty($preapproval->PAreferenceNo) ? $preapproval->PAreferenceNo : '',
                'visit_no' => !empty($eligibility->visitNo) ? $eligibility->visitNo : '',
                'insurance_id' => 8
            ];

            $this->QlmModel->update_data_where('tbl_planofcare_main', 'tbl_planofcare_main_id', $planofcare_main_id, $newdata);
        }

        $data['alert_msg'] = '';
        $data['error'] = '';
        $data['success'] = 'Treatment Plans have added successfully';
        //$data['doctor_list'] = $this->doctor_retrive->get_doctors();
        $this->session->set_flashdata('success', 'Treatment Saved.');
        redirect('admin/Patients/PatientsController/medical_book/' . $patient_id);
    }


   
 
	
}
