<?php

class SurgicalController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');

        $this->load->library('upload');
    }

    public function index()
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PatientsModel->get_dataList();

        $this->load->view('admin/Patients/PatientsList', $data);
    }


    public function save()
    {
        // print_r($_POST);die;

        $patient_id = $this->input->post('patient_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

        $result['active_menu'] = 15;
        $result['active_submenu'] = 1;

        $diagnosis_id = $this->input->post('general_diagnosis_id');
        $diagnosis_name = $this->input->post('general_diagnosis_name');
        $treatment_id = $this->input->post('general_treatment_id');
        $fees = $this->input->post('orig_price_surgical');

        $discount = $this->input->post('discount_surgical');
        $discount_per = $this->input->post('discount_per_surgical');
        $note_con = $this->input->post('note_con');
        $note = $this->input->post('note');

        $user_id = $this->session->userdata('user_Id');

        $treatment_date = $this->input->post('operation_date');
        $treatment_time = $this->input->post('operation_time');
        $bp_1 = $this->input->post('bp_1');
        $drug_id_surg = $this->input->post('drug_id_surg');
        $assigned_package = $this->input->post('assigned_package');
        $followup = $this->input->post('followup');

        if (is_array($fees)) {
            $total = array_sum($fees);
        }

        if (is_array($fees)) {
            $orig_price_total = array_sum($fees);
        }

        if (is_array($discount)) {
            $total_discount = array_sum($discount);
        }

        $required_titles = [
            'operation_note', 'operation_date', 'operation_time',
            'operation_status', 'room', 'duration', 'stay', 'admission_time', 'anesthisia_type', 'start_time', 'end_time', 'operation', 'asistant', 'discharge_date', 'discharge_time'
        ];

        $surgery_details = json_encode(array_intersect_key($_POST, array_flip($required_titles)));

        $vitals = [];
        foreach ($bp_1 as $key => $value) {
            array_push(
                $vitals,
            array(
                'time'=> $_POST['time'][$key],
                'diagnosis_vitals_surg'=>  $_POST['diagnosis_vitals_surg'][$key],
                'notes'=>  $_POST['notes'][$key],
                'bmi'=>  $_POST['bmi'][$key],
                'saturation'=>  $_POST['saturation'][$key],
                'weight'=>  $_POST['weight'][$key],
                'height'=>  $_POST['height'][$key],
                'rr'=>  $_POST['rr'][$key],
                'grbs'=>  $_POST['grbs'][$key],
                'tempf'=>  $_POST['tempf'][$key],
                'tempc'=>  $_POST['tempc'][$key],
                'pulse'=>  $_POST['pulse'][$key],
                'bp_2'=>  $_POST['bp_2'][$key],
                'bp_1'=>  $_POST['bp_1'][$key]
            ));

            
        }

        $validation_rules = array(
            array(
                'field' => 'tretments',
                'label' => 'Treatment',
                'rules' => 'required'
            ),
            array(
                'field' => 'vitals',
                'label' => 'Patient Vitals',
                'rules' => 'required'
            )
        );

        $this->form_validation->set_rules($validation_rules);

        if ($this->form_validation->run() == FALSE) {
        	$error_message ="";
        	foreach ($validation_rules as $rule) {
        		$field = $rule['field'];
        		$error_message .= form_error($field)."<br>";
        	}
        	$this->session->set_flashdata('error', $error_message);
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
            return;
        }
        

        $prescription = [];
        foreach ($drug_id_surg as $key => $value) {
            array_push(
                $prescription,
            array(
                'drug_id_surg'=> $_POST['drug_id_surg'][$key],
                'bill_items_id_surg'=>  $_POST['bill_items_id_surg'][$key],
                'drugs_qty_surg'=>  $_POST['drugs_qty_surg'][$key],
                'meals_surg'=>  $_POST['meals_surg'][$key],
                'drug_notes_surg'=>  $_POST['drug_notes_surg'][$key],
                'drug_name_surg'=>  $_POST['drug_name_surg'][$key]
            ));
        }

       

       

        $this->db->trans_start();
        try {
            if($followup == 0){
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 8
            );
        }
        else{
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date,
                'treat_time' => $treatment_time,
                'total' => 0,
                'discount' => 0,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 8 
            );
        }

            $treatement_payment_id = $this->PatientsModel->insert_data('tbl_treatment_payment', $treatment_payment_data);

            $surgery_data = array(
                'surgery_details'  => $surgery_details,
                'surgery_vitals' => json_encode($vitals),
                'patient_id' => $decryptedId,
                'prescription' => json_encode($prescription),
                'treatment_payment_id' => $treatement_payment_id,
                'note_con' => $note_con,
                'note' => $note
            );

            $this->PatientsModel->insert_data('tbl_surgery', $surgery_data);

            for ($i = 0; $i < count($treatment_id); $i++) {

                $newdata = array(
                    'procedure_id' => $treatment_id[$i],
                    'episode_type' => 1,
                    'diagnostise_id' => $diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id,
                    'aditional_diagnostise_name' => $diagnosis_name[$i],
                    'orig_price' => $fees[$i]
                );

                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }


            $files = $_FILES;
            $file_exist = $_FILES['attach_surgical']['size'];
            $db_attachment = array();
            if (array_filter($file_exist)) {

                $this->load->library('upload');

                $cpt = count($_FILES['attach_surgical']['name']);
                $config = array();
                $config['upload_path'] = './'.UPLOAD_PATH.'surgery/';
                $config['allowed_types'] = '*';
                $config['max_size']      = '*';
                $config['overwrite']     = TRUE;

                $last_id = $this->CommonModel->get_last_attachment($decryptedId, '11');
                if (isset($last_id) and $last_id != NULL) {
                    $ctr_array = explode("-", $last_id->attachment);
                    $j = $ctr_array[1] + 1;
                } else {
                    $j = 1;
                }


                for ($i = 0; $i < $cpt; $i++) {
                    $_FILES['attach_surgical']['name'] = $files['attach_surgical']['name'][$i];
                    $_FILES['attach_surgical']['type'] = $files['attach_surgical']['type'][$i];
                    $_FILES['attach_surgical']['tmp_name'] = $files['attach_surgical']['tmp_name'][$i];
                    $_FILES['attach_surgical']['error'] = $files['attach_surgical']['error'][$i];
                    $_FILES['attach_surgical']['size'] = $files['attach_surgical']['size'][$i];

                    $ext = strtolower(pathinfo($_FILES['attach_surgical']['name'], PATHINFO_EXTENSION));
                    $newfilename = $decryptedId . '-' . $j . '.' . $ext;

                    $config['file_name'] = $newfilename;

                    $this->upload->initialize($config);

                    if (!$this->upload->do_upload('attach_surgical')) {

                        echo $this->upload->display_errors();
                    } else {
                        array_push($db_attachment, $newfilename);
                    }
                    $j++;
                }

                if (!empty($db_attachment)) {
                    $count_attachment = count($db_attachment);

                    for ($i = 0; $i < $count_attachment; $i++) {
                        $newdata = array(
                            'document' => $db_attachment[$i],
                            'date' => $treatment_date,
                            'user_id' => $user_id,
                            'category' => 8,
                            'patient_id' => $decryptedId,
                            'treat_id' => $treatement_payment_id
                        );

                        $this->PatientsModel->insert_data('tbl_patient_attachments', $newdata);
                    }
                }
            }
            if($followup == 2){
                $this->PatientsModel->updateSessions($decryptedId,$assigned_package,8);
                 
                 
              }

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
            $this->session->set_flashdata('success', 'Surgery Details saved successfully.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            $this->session->set_flashdata('Error', 'Surgery Details not saved.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
            exit;
        }

        $this->db->trans_complete();
    }

    public function update()
    {

        // print_r($_POST);die;
        $patient_id = $this->input->post('patient_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

        $result['active_menu'] = 15;
        $result['active_submenu'] = 1;

        $diagnosis_id = $this->input->post('general_diagnosis_id');
        $diagnosis_name = $this->input->post('general_diagnosis_name');
        $treatment_id = $this->input->post('general_treatment_id');
        $fees = $this->input->post('orig_price_surgical');

        $discount = $this->input->post('discount_surgical');
        $discount_per = $this->input->post('discount_per_surgical');
        $note_con = $this->input->post('note_con');
        $note = $this->input->post('note');

        $user_id = $this->session->userdata('user_Id');

        $treatment_date = $this->input->post('operation_date');
        $treatment_time = $this->input->post('operation_time');
        $bp_1 = $this->input->post('bp_1');
        $drug_id_surg = $this->input->post('drug_id_surg');
        $treatment_payment_id = $this->input->post('treatement_payment_id');

        if (is_array($fees)) {
            $total = array_sum($fees);
        }

        if (is_array($fees)) {
            $orig_price_total = array_sum($fees);
        }

        if (is_array($discount)) {
            $total_discount = array_sum($discount);
        }

        $required_titles = [
            'operation_note', 'operation_date', 'operation_time',
            'operation_status', 'room', 'duration', 'stay', 'admission_time', 'anesthisia_type', 'start_time', 'end_time', 'operation', 'asistant', 'discharge_date', 'discharge_time'
        ];

        $surgery_details = json_encode(array_intersect_key($_POST, array_flip($required_titles)));

        $vitals = [];
        foreach ($bp_1 as $key => $value) {
            array_push(
                $vitals,
            array(
                'time'=> $_POST['time'][$key],
                'diagnosis_vitals_surg'=>  $_POST['diagnosis_vitals_surg'][$key],
                'notes'=>  $_POST['notes'][$key],
                'bmi'=>  $_POST['bmi'][$key],
                'saturation'=>  $_POST['saturation'][$key],
                'weight'=>  $_POST['weight'][$key],
                'height'=>  $_POST['height'][$key],
                'rr'=>  $_POST['rr'][$key],
                'grbs'=>  $_POST['grbs'][$key],
                'tempf'=>  $_POST['tempf'][$key],
                'tempc'=>  $_POST['tempc'][$key],
                'pulse'=>  $_POST['pulse'][$key],
                'bp_2'=>  $_POST['bp_2'][$key],
                'bp_1'=>  $_POST['bp_1'][$key]
            ));
        }
        

        $prescription = [];
        foreach ($drug_id_surg as $key => $value) {
            array_push(
                $prescription,
            array(
                'drug_id_surg'=> $_POST['drug_id_surg'][$key],
                'bill_items_id_surg'=>  $_POST['bill_items_id_surg'][$key],
                'drugs_qty_surg'=>  $_POST['drugs_qty_surg'][$key],
                'meals_surg'=>  $_POST['meals_surg'][$key],
                'drug_notes_surg'=>  $_POST['drug_notes_surg'][$key],
                'drug_name_surg'=>  $_POST['drug_name_surg'][$key]
            ));
        }

        $validation_rules = array(
            array(
                'field' => 'general_treatment_id',
                'label' => 'Treatment',
                'rules' => 'required'
            ),
            array(
                'field' => 'diagnosis_vitals_surg',
                'label' => 'Patient Vitals',
                'rules' => 'required'
            )
        );

        $this->form_validation->set_rules($validation_rules);


        // if ($this->form_validation->run() == FALSE) {
        // 	$error_message ="";
        // 	foreach ($validation_rules as $rule) {
        // 		$field = $rule['field'];
        // 		$error_message .= "*".form_error($field)."<br>";
        // 	}
        // 	$this->session->set_flashdata('error', $error_message);
        //     redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
        //     return;
        // }

        $this->db->trans_start();
        try {
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount
            );

            $this->PatientsModel->update_data_where('tbl_treatment_payment','treatement_payment_id', $treatment_payment_id, $treatment_payment_data);

            $surgery_data = array(
                'surgery_details'  => $surgery_details,
                'surgery_vitals' => json_encode($vitals),
                'patient_id' => $decryptedId,
                'prescription' => json_encode($prescription),
                'note_con' => $note_con,
                'note' => $note
            );

            $this->PatientsModel->update_data_where('tbl_surgery','treatment_payment_id', $treatment_payment_id, $surgery_data);
            $this->PatientsModel->delete_data_where('tbl_episode_payment', 'treatement_payment_id', $treatment_payment_id);

            for ($i = 0; $i < count($treatment_id); $i++) {

                $newdata = array(
                    'procedure_id' => $treatment_id[$i],
                    'episode_type' => 1,
                    'diagnostise_id' => $diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatment_payment_id,
                    'aditional_diagnostise_name' => $diagnosis_name[$i],
                    'orig_price' => $fees[$i]
                );

                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }


            $files = $_FILES;
            $file_exist = $_FILES['attach_surgical']['size'];
            $db_attachment = array();
            if (array_filter($file_exist)) {

                $this->load->library('upload');

                $cpt = count($_FILES['attach_surgical']['name']);
                $config = array();
                $config['upload_path'] = './'.UPLOAD_PATH.'surgery/';
                $config['allowed_types'] = '*';
                $config['max_size']      = '*';
                $config['overwrite']     = TRUE;

                $last_id = $this->CommonModel->get_last_attachment($decryptedId, '11');
                if (isset($last_id) and $last_id != NULL) {
                    $ctr_array = explode("-", $last_id->attachment);
                    $j = $ctr_array[1] + 1;
                } else {
                    $j = 1;
                }


                for ($i = 0; $i < $cpt; $i++) {
                    $_FILES['attach_surgical']['name'] = $files['attach_surgical']['name'][$i];
                    $_FILES['attach_surgical']['type'] = $files['attach_surgical']['type'][$i];
                    $_FILES['attach_surgical']['tmp_name'] = $files['attach_surgical']['tmp_name'][$i];
                    $_FILES['attach_surgical']['error'] = $files['attach_surgical']['error'][$i];
                    $_FILES['attach_surgical']['size'] = $files['attach_surgical']['size'][$i];

                    $ext = strtolower(pathinfo($_FILES['attach_surgical']['name'], PATHINFO_EXTENSION));
                    $newfilename = $decryptedId . '-' . $j . '.' . $ext;

                    $config['file_name'] = $newfilename;

                    $this->upload->initialize($config);

                    if (!$this->upload->do_upload('attach_surgical')) {

                        echo $this->upload->display_errors();
                    } else {
                        array_push($db_attachment, $newfilename);
                    }
                    $j++;
                }

                if (!empty($db_attachment)) {
                    $count_attachment = count($db_attachment);

                    for ($i = 0; $i < $count_attachment; $i++) {
                        $newdata = array(
                            'document' => $db_attachment[$i],
                            'date' => $treatment_date,
                            'user_id' => $user_id,
                            'category' => 8,
                            'patient_id' => $decryptedId,
                            'treat_id' => $treatment_payment_id
                        );

                        $this->PatientsModel->insert_data('tbl_patient_attachments', $newdata);
                    }
                }
            }

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
            $this->session->set_flashdata('success', 'Surgery Details Update successfully.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            $this->session->set_flashdata('Error', 'Surgery Details not Updated.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
            exit;
        }

        $this->db->trans_complete();
    }

    public function edit($treatement_payment_id)
    {
        $decryptedId = decrypt_and_url_decode($treatement_payment_id, $this);
        $data['invoice'] = $this->PatientsModel->retrieve_data_unique_row('tbl_treatment_payment', 'treatement_payment_id', $decryptedId);
        $data['rooms'] = $this->PatientsModel->retrieve_data_unique('tbl_rooms', 'status', '0');
        $data['nurses'] = $this->PatientsModel->get_nurses();
        $data['episodes'] = $this->PatientsModel->get_treatment_episodes($decryptedId);
        $data['surgical'] = $this->PatientsModel->retrieve_data_unique_row('tbl_surgery', 'treatment_payment_id', $decryptedId);
        $data['attachment'] = $this->CommonModel->get_attachment($data['surgical']->patient_id, 8, $decryptedId);
        $data['patient_id'] = $data['invoice']->patient_id;
        $data['treatment_payment_id'] = $decryptedId;
        $data['surgery_details'] = json_decode($data['surgical']->surgery_details);

        $this->load->view('admin/Modules/Surgical/SurgicalEdit', $data);
    }

    
    public function delete_surgical_attachment($document_id)
    {

        $decrypted_documenet_id = decrypt_and_url_decode($document_id, $this);

        $document = $this->db->select('*')
            ->from('tbl_patient_attachments')
            ->where('id', $decrypted_documenet_id)
            ->get()
            ->row();

        $treatment_id = $document->treat_id;

            if(file_exists(''.UPLOAD_PATH.'surgery/'.$document->document)) {
                
                try {
                    unlink($document->document);
                    $this->db->where('id', $document->id)->delete('tbl_patient_attachments');
                    $this->session->set_flashdata('success', 'Attachment deleted successfully.');
                } catch (Exception $e) {
                    $this->session->set_flashdata('error', 'Failed to delete attachment.');
                }

            }else{
                $this->session->set_flashdata('error', 'Attachment not found.');
            }

            redirect('admin/Modules/Surgical/SurgicalController/edit/' . encrypt_and_url_encode($treatment_id, $this));
    }
}
