<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class ReportsController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        error_reporting(E_ERROR | E_PARSE);
        $this->load->helper('url');
        $this->load->model('admin/Reports/ReportsModel','report_retrive');
        $this->load->model('admin/CommonModel');
    }

    /**
     * Daily Collection Reports start
     */
    public function dailyCollectionReport()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 23;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['sales_persons'] = $this->report_retrive->get_sales_persons();
        $data['doctors'] = $this->report_retrive->all_doctors();

        $this->load->view('admin/Reports/DailyCollectionReport', $data);
    }

    public function dailyCollectionList()
    {

        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');

        $search = $this->input->get('search')['value'];

        $receptionist = $this->input->get('receptionist');
         $doctor = $this->input->get('doctor');
        $date = $this->input->get('date');
        $date_to = $this->input->get('date_to');

        $records = $this->report_retrive->get_daily_collection_list($receptionist, $date,$date_to, $length, $start, $doctor);
      
        //$total_records = $this->report_retrive->get_total_daily_collections($receptionist, $date);
        $discount = 0;
        $cash = 0;
        $card = 0;
        $total = 0;
        $insurance_amount = 0;
        $company_discount_qar=0;
			$category_discount_qar=0;
			$coupon_discount = 0;
			$points_discount = 0;
           $cashier_discount=0;
           $total_discount = 0;
           $dr_discount=0;
           $net_total=0;
           $gross=0;
        foreach ($records as $key => $value) {
            $discount += $value->discount;
            $cash += $value->total_paid;
            $card += $value->card;
            $total += $value->total;
            $insurance_amount += $value->insurance_amount;
            $cashier_discount += $value->cdiscount;
            $gross += $value->gross;
            $company_discount_qar += $value->company_discount;
                    $category_discount_qar += $value->category_discount;
                    $coupon_discount += $value->coupon_discount;
                    $points_discount += $value->points_discount;
                    $dr_discount += $value->discount;
                   
                    
                    // Assign the total discount for the current row
                    // $records[$key]->total_discount = $value->all_discount;
                    $records[$key]->net_total = $value->gross -$value->all_discount;
                
                    // Accumulate the total discount across all rows
                    $total_discount += $value->all_discount;
        }
       
        $net_total= $gross - $total_discount;
        $refund_records = $this->report_retrive->get_refund_list($receptionist, $date, $length, $start);
        // print_r($refund_records);die;
        foreach ($refund_records as $key => $value) {
            $discount += $value->discount;
            $cash += $value->cash;
            $card += $value->card;
            $total += (0) - $value->amount;
            $insurance_amount += $value->insurance_amount;
        }

        foreach($refund_records as $key => $value){
            array_push(
                $records,
                array(
                    'patient_payment_id' => '<b style="text-align:right;color:#f95656">Refund</b>',
                    'treatment_payment_id' => null,
                    'patient_id' => $value->patient_id,
                    'pay_date' => $value->pay_date,
                    'pay_time' => null,
                    'total_paid' => (0)-$value->amount ?? 0,
                    'pay_type' => null,
                    'user_id' => null,
                    'cashier' => $value->cashier ?? '--',
                    'all_discount' => '--',
                    'bank_name' => null,
                    'cheque_date' => null,
                    'cheque_number' => null,
                    'gross' => null,
                    'net_total' =>null,
                    'branch' => null,
                    'co_payment' => null,
                    'discount_per' => null,
                    'is_insurance' => null,
                    'card' => null,
                    'total_refund' => (0)-$value->amount ?? 0,
                    'co_payment_per' => null,
                    'excess' => null,
                    'insurance_amount' => 0,
                    'createddate' => null,
                    'recipt_no' => null,
                    'patient_name' => $value->patient_name,
                    'type_name' => $value->type_name,
                    'treatment_no' => $value->treatment_no,
                    'module_name' => null,
                    'full_name' => $value->full_name,
                    'insurance_name' => $value->insurance_name,
                    'procedure_ids' => $value->procedure_ids,
                )
            );

        }
        $total_cash= $cash- $value->amount;
        if(check_right('view_daily_total',$this)) {
        array_push(
            $records,
            array(
                'patient_payment_id' => '<b style="text-align:right">Total Net Amount</b>',
                'treatment_payment_id' => null,
                'patient_id' => null,
                'pay_date' => null,
                'pay_time' => null,
                'total_paid' => '<b>' . $total_cash . '</b>',
                'pay_type' => null,
                'user_id' => null,
                'cashier' => null,
                'all_discount' => '<b>' . $total_discount . '</b>',
                'bank_name' => null,
                'cheque_date' => null,
                'cheque_number' => null,
                'branch' => null,
                'co_payment' => null,
                'discount_per' => null,
                'is_insurance' => null,
                'card' => '<b>' . number_format($card, 2) . '</b>',
                'total' =>'<b>' .  number_format($total, 2) . '</b>',
                'net_total' =>'<b>' .  number_format($net_total, 2) . '</b>',
                'gross' =>'<b>' .  number_format($gross, 2) . '</b>',
                'total_refund' => (0)-$value->amount,
                'co_payment_per' => null,
                'excess' => null,
                'insurance_amount' => '<b>' . $insurance_amount . '</b>',
                'createddate' => null,
                'recipt_no' => null,
                'patient_name' => null,
                'type_name' => null,
                'treatment_no' => '<b>' . number_format($net_total , 2) . '</b>',
                'module_name' => null,
                'full_name' => null,
                'insurance_name' => null,
                'procedure_ids' => null,
            )
        );
        }else{
             array_push(
            $records,
            array(
                'patient_payment_id' => null,
                'treatment_payment_id' => null,
                'patient_id' => null,
                'pay_date' => null,
                'pay_time' => null,
                'total_paid' => null,
                'pay_type' => null,
                'user_id' => null,
                'cashier' => null,
                'all_discount' => null,
                'bank_name' => null,
                'cheque_date' => null,
                'cheque_number' => null,
                'branch' => null,
                'co_payment' => null,
                'discount_per' => null,
                'is_insurance' => null,
                'card' => null,
                'total' =>null,
                'net_total' =>null,
                'gross' =>null,
                'total_refund' => null,
                'co_payment_per' => null,
                'excess' => null,
                'insurance_amount' => null,
                'createddate' => null,
                'recipt_no' => null,
                'patient_name' => null,
                'type_name' => null,
                'treatment_no' => null,
                'module_name' => null,
                'full_name' => null,
                'insurance_name' => null,
                'procedure_ids' => null,)
            );
        }

        // print_r($this->db->last_query());die;
        $total_records = count($records);

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    /**
     * Refund Reports start
     */
    public function RefundReport()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 23;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['sales_persons'] = $this->report_retrive->get_sales_persons();

        $this->load->view('admin/Reports/RefundReport', $data);
    }



    /**
     * Daily Collection Reports end
     */

    /**
     * Doctor Reports start
     */
    public function doctorReport()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 23;
        $data['active_submenu'] = 2;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['doctors'] = $this->report_retrive->all_doctors();
        $data['payment_types'] = $this->report_retrive->payment_types();

        $this->load->view('admin/Reports/DoctorReports', $data);
    }

    public function doctorList()
    {

        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');

        $search = $this->input->get('search')['value'];

        $doctor = $this->input->get('doctor');
        $payment_type = $this->input->get('payment_type');
        $date_from = $this->input->get('date_from');
        $date_to = $this->input->get('date_to');

        $records = $this->report_retrive->get_doctor_list($doctor, $payment_type, $date_from, $date_to, $length, $start);
        //$total_records = $this->report_retrive->get_total_doctors();
        $total_records = count($records);

        $invoice_amount = 0;
        $paid_amount = 0;
        $company_discount_qar=0;
			$category_discount_qar=0;
			$coupon_discount = 0;
			$points_discount = 0;
           $cashier_discount=0;
           $total_discount = 0;
           $dr_discount=0;
           $net_total=0;
       
        // $insurance_amount = 0;
        foreach ($records as $key => $value) {
            $invoice_amount += $value->total;
            $paid_amount += $value->amount;
            $cashier_discount += $value->cdiscount;

            $company_discount_qar += $value->company_discount;
                    $category_discount_qar += $value->category_discount;
                    $coupon_discount += $value->coupon_discount;
                    $points_discount += $value->points_discount;
                    $dr_discount += $value->discount;
                    $total_discount_row = round(
                        $value->cdiscount + 
                        $value->company_discount + 
                        $value->category_discount + 
                        $value->coupon_discount + 
                        $value->points_discount+
                        $value->discount
                    );
                    
                    // Assign the total discount for the current row
                    $records[$key]->total_discount = $total_discount_row;
                    $records[$key]->net_total = $value->total -$total_discount_row;
                
                    // Accumulate the total discount across all rows
                    $total_discount += $total_discount_row;
                  
        }
        $total_discount = round($cashier_discount +$dr_discount + $company_discount_qar + $category_discount_qar + $coupon_discount +$points_discount);
        $net_total= $invoice_amount - $total_discount;
        array_push(
            $records ,array(
                'treatement_payment_id' => '<b style="text-align:right">Total Fees</b>',
                'patient_id' => '<b>'.number_format($net_total,2).'</b>',
                'patient_name' => null,
                'full_name' => null,
                'treat_date' => null,
                'type_name' => null,
                'total_discount'=>"<b>".$total_discount."<b>",
                'net_total'=>"<b>".$net_total."<b>",
            
                'total' => '<b>'.number_format($invoice_amount,2).'</b>',
                'amount' => '<b>'.number_format($paid_amount,2).'</b>'
            )
            );

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    /**
     * Doctor Reports end
     */

    /**
     * Appoinment Reports start
     */
    public function appoinmentsReport()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 23;
        $data['active_submenu'] = 3;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['appoinment_status'] = $this->report_retrive->get_all_booking_status();

        $this->load->view('admin/Reports/AppoinmentReport', $data);
    }

    public function appoinmentList()
    {

        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');

        $search = $this->input->get('search')['value'];

        $appoinment_status = $this->input->get('appoinment_status');
        $date_from = $this->input->get('date_from');
        $date_to = $this->input->get('date_to');

        $records = $this->report_retrive->get_appoinment_list($appoinment_status, $date_from, $date_to, $length, $start);
        $recordsco = $this->report_retrive->get_appoinment_list_count($appoinment_status, $date_from, $date_to);
        //$total_records = $this->report_retrive->get_total_appoinments();
        $total_records = count($recordsco);

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function insuranceCollectionReport()
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 23;
        $data['active_submenu'] = 5;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['insurance_types'] = $this->report_retrive->all_insurance_types();
        $data['payment_types'] = $this->report_retrive->payment_types();

        $this->load->view('admin/Reports/InsuranceReports', $data);
    }

    public function insuranceList()
    {

        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');

        $search = $this->input->get('search')['value'];

        $insurace_type = $this->input->get('insurance_type');
        $date_from = $this->input->get('date_from');
        $date_to = $this->input->get('date_to');

        $records = $this->report_retrive->get_insurance_list($insurace_type, null, $date_from, $date_to, $length, $start);
        $total_records = count($records);

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function SalesReport()
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 23;
        $data['active_submenu'] = 6;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['insurance_types'] = $this->report_retrive->all_insurance_types();
        $data['payment_types'] = $this->report_retrive->payment_types();

        $this->load->view('admin/Reports/SalesReport', $data);
    }

    public function SalesList()
    {

        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');

        $search = $this->input->get('search')['value'];

        $date_from = $this->input->get('date_from');
        $date_to = $this->input->get('date_to');
        $payment = $this->input->get('payment_type');
        $payment_type = $this->report_retrive->retrieve_data_unique_row('tbl_payment_types', 'type_id', $payment);

        // print_r( $payment_result);die;
        $record_cleam = array();
        $records = $this->report_retrive->get_sales_list(0, $payment, $date_from, $date_to, $length, $start);
        // print_r( $this->db->last_query());die;
        $discount = 0;
        $invoice_amount = 0;
        $paid_amount = 0;
        $company_discount_qar=0;
			$category_discount_qar=0;
			$coupon_discount = 0;
			$points_discount = 0;
           $cashier_discount=0;
           $total_discount = 0;
           $dr_discount=0;
           $net_total=0;
       
        // $insurance_amount = 0;
        foreach ($records as $key => $value) {
            $discount += $value->discount;
            $invoice_amount += $value->invoice_amount;
            $paid_amount += $value->paid_amount;
            $cashier_discount += $value->cdiscount;

            $company_discount_qar += $value->company_discount;
                    $category_discount_qar += $value->category_discount;
                    $coupon_discount += $value->coupon_discount;
                    $points_discount += $value->points_discount;
                    $dr_discount += $value->discount;
                   
                   
                    $records[$key]->net_total = $value->invoice_amount -$value->all_discount;
                
                    // Accumulate the total discount across all rows
                    $total_discount += $value->all_discount;
                  
        }
        // $total_discount = round($cashier_discount +$dr_discount + $company_discount_qar + $category_discount_qar + $coupon_discount +$points_discount);
        $net_total= $invoice_amount - $total_discount;

        array_push(
            $records ,array(
                'treatement_payment_id' => '<b style="text-align:right">Total Sales</b>',
                'patient_payment_id' => '<b>'.number_format($invoice_amount,2).'</b>',
                'patient_id' => null,
                'patient_name' => null,
                'pay_type' => -2,
                'procedure_ids' => null,
                'excess' => null,

                'invoice_amount' => '<b>'.number_format($invoice_amount,2).'</b>',
                 'all_discount'=>"<b>".$total_discount."<b>",
                'net_total'=>"<b>".$net_total."<b>",
                'paid_amount' => '<b>'.number_format($paid_amount,2).'</b>',
                'treat_date' => null,
                "patient_payment_ids" => '<b>'.number_format($invoice_amount,2).'</b>'
            )
            );

        $total_records = count($records);

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function treatmentWiseReport()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 23;
        $data['active_submenu'] = 7;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['insurance_types'] = $this->report_retrive->all_insurance_types();
        $data['payment_types'] = $this->report_retrive->retrieve_data_unique_fields('tbl_payment_types', '*', 'is_show', 1);
        $data['departments'] = $this->report_retrive->get_departments();

        $this->load->view('admin/Reports/TreatmentWiseReport', $data);
    }

    public function getInsurancePrices()
    {

        $this->form_validation->set_rules('insurance_id', 'Insurance ID', 'required|integer');

        if ($this->form_validation->run() === false) {
            $response = array(
                'success' => false,
                'message' => validation_errors()
            );
        } else {
            $insurance_id = $this->input->post('insurance_id');
            $department_id = $this->input->post('department_id');
            $insurance_price_list = $this->report_retrive->get_insurance_price_list($insurance_id, $department_id);

            //print_r($this->db->last_query());exit;
            $response = array(
                'success' => true,
                'data' => $insurance_price_list
            );
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    public function getTreatmentWiseReport()
    {
        $draw = $this->input->get('draw');
        $lenght = $this->input->get('length');
        $start = $this->input->get('start');
        $order_column = $this->input->get('columns')[$this->input->get('order')[0]['column']]['data'];
        $order = $this->input->get('order')[0]['dir'];
        $department_id = $this->input->get('department_id');
        
        $insurance_id = $this->input->get('insurance_id');
        $procedure =  $this->input->get('procedure');
        $payment_type =  $this->input->get('payment_type');

        $date_from =  $this->input->get('date_from');
        $date_to =  $this->input->get('date_to');

        // if (empty($date_from) || empty($date_to) || empty($insurance_id)) {
        //     $response = [
        //         "draw" => intval($draw),
        //         "recordsTotal" => 0,
        //         "recordsFiltered" => 0,
        //         'data' => []
        //     ];
        //     $this->output->set_content_type('application/json')->set_output(json_encode($response));
        //     return;
        // }

        $total_records = (int)$this->report_retrive->count_total_treatment_wise_records($insurance_id, $procedure, $payment_type, $date_from, $date_to, $department_id);
        $result = $this->report_retrive->get_treatment_wise_report($insurance_id, $procedure, $payment_type, $date_from, $date_to, $lenght, $start, $order_column, $order, $department_id);

        $filtered_records = count($result);

        $response = [
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $filtered_records,
            "data" => $result
        ];

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function feedbackReport(){
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 23;
        $data['active_submenu'] = 6;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['insurance_types'] = $this->report_retrive->all_insurance_types();
        $data['payment_types'] = $this->report_retrive->payment_types();

        $this->load->view('admin/Reports/FeedbackReport', $data);
    }

    public function feedbackList() {

        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');

        $search = $this->input->get('search')['value'];

        $date_from = $this->input->get('date_from');
        $date_to = $this->input->get('date_to');
        $patient_id = $this->input->get('patient_id');
        
        $records = $this->report_retrive->get_feedback_list($date_from, $date_to, $patient_id,'');
        $total_records = count($records);
        foreach ($records as $key => $value) {
                $value['appointment'] = $this->rating_name($value['appointment']);
                $value['reception'] = $this->rating_name($value['reception']);
                $value['waiting'] = $this->rating_name($value['waiting']);
                $value['nurse'] = $this->rating_name($value['nurse']);
                $value['laser'] = $this->rating_name($value['laser']);
                $value['session'] = $this->rating_name($value['session']);
                $value['treatment'] = $this->rating_name($value['treatment']);
                $value['previous'] =  $this->rating_name($value['previous']);  
                $value['curr_time'] = date('g:i:s A', strtotime($value['curr_time']));
                $records[$key] = $value;
        }

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function refundList()
    {

        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $fromdate = $this->input->get('fromdate');
        $todate = $this->input->get('todate');

        $search = $this->input->get('search')['value'];

        $receptionist = $this->input->get('receptionist');
        $date = $this->input->get('date');

        $refund_records = $this->report_retrive->get_refund_list_report($receptionist, $date, $length, $fromdate,$todate);
        $total = 0;
        $insurance_amount = 0;
        foreach ($refund_records as $key => $value) {
            $total += $value->amount;
            $insurance_amount += $value->insurance_amount;
        }

        // print_r($this->db->last_query());die;

        array_push(
            $refund_records,
            array(
                'recipt_no' => '<b style="text-align:right">Total Refunded</b>',
                'treatment_payment_id' => null,
                'patient_id' => null,
                'pay_date' => '<b>' . number_format($total , 2) . '</b>',
                'pay_time' => null,
                'cash' => null,
                "treat_date" => null,
                'pay_type' => null,
                'user_id' => null,
                'cashier' => null,
                'discount' => null,
                'bank_name' => null,
                'cheque_date' => null,
                'cheque_number' => null,
                'branch' => null,
                'co_payment' => null,
                'discount_per' => null,
                'is_insurance' => null,
                'card' => null,
                'total' => '<b>' . number_format($total , 2) . '</b>',
                'co_payment_per' => null,
                'excess' => null,
                'insurance_amount' => '<b>' . $insurance_amount . '</b>',
                'createddate' => null,
                'patient_name' => null,
                'type_name' => null,
                'treatment_no' => null,
                'module_name' => null,
                'full_name' => null,
                'insurance_name' => null,
                'procedure_ids' => null,
            )
        );

        // print_r($this->db->last_query());die;
        $total_records = count($refund_records);

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $refund_records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }
    
    public function smsReport()
    {
        $data['sent_sms'] = $this->report_retrive->getTotalNotification('SMS', 'SENT');
        $data['failed_sms'] = $this->report_retrive->getTotalNotification('SMS', 'FAILED');
        $this->load->view('admin/Reports/SmsReport', $data);
    }
    public function whatsapp_logs()
    {
        $data['sent_sms'] = $this->report_retrive->getTotalNotification('WHATSAPP', 'SENT');
        $data['failed_sms'] = $this->report_retrive->getTotalNotification('WHATSAPP', 'FAILED');
        $this->load->view('admin/Reports/whatsappReport', $data);
    }

    public function getSmsList()
    {
        $date_from = $this->input->post('date_from');
        $date_to = $this->input->post('date_to');
        $status = $this->input->post('status');
        $draw = $this->input->post('draw');
        $length = $this->input->post('length');
        $start = $this->input->post('start');
        $type = 'SMS';

        $smsData = $this->report_retrive->getNotificationList($date_from, $date_to, $status, $type, $length, $start);

        $total_records = count($smsData);
        $response = [
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $smsData
        ];

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }
    public function getWhatsappList()
    {
        $date_from = $this->input->post('date_from');
        $date_to = $this->input->post('date_to');
        $status = $this->input->post('status');
        $draw = $this->input->post('draw');
        $length = $this->input->post('length');
        $start = $this->input->post('start');
        $type = 'whatsapp';

        $smsData = $this->report_retrive->getNotificationList($date_from, $date_to, $status, $type, $length, $start);

        $total_records = count($smsData);
        $response = [
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $smsData
        ];

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function get_p_expiring_report(){
  


			$from = $this->input->post('from');
			$to = $this->input->post('to');
			$opt = $this->input->post('suppliers');
            $drug = $this->input->post('drug');

			$cash_total = 0;
        	$credit_total = 0;
        	$grand_total = 0;
        	$ctr = 0;
        	$PDF = '';
           
			$result = $this->report_retrive->get_p_expiring_report($from,$to,$opt,$drug);
            if (!isset($result) || $result == null) {
                $result = [];
            }
            $response = array(
               
                "data" => $result
            );
       
                $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
        
            
		
	}

    public function get_drugs_list()
	{
	

			$from = $this->input->post('from');
			$to = $this->input->post('to');
			$drug = $this->input->post('drug');
			// $drug_array = explode("-",$drug);
         
			$result = $this->report_retrive->get_items_list($drug,$from,$to);

           
            if (!isset($result) || $result == null) {
                $result = [];
            }
            $total_records = count($result);
            $response = [
               
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
                "data" => $result
            ];

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
        
       
			
			
		 
	}
    public function get_transaction_list()
	{


			$from = $this->input->post('from');
			$to = $this->input->post('to');
			$request = $this->input->post('request');

			$total = 0;

			$result = $this->report_retrive->get_transaction_list($request,$from,$to);

            if (!isset($result) || $result == null) {
                $result = [];
            }
            $response = array(
               
                "data" => $result
            );

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
        }

        public function get_report_views()
	{
	
			$from = $this->input->post('from');
			$to = $this->input->post('to');
			$supplier = $this->input->post('suppliers');
            $drug = $this->input->post('drug');
            $cashier = $this->input->post('cashier');

			$qty = 0;
			$total = 0;

			$result = $this->report_retrive->get_view_reports($supplier,$from,$to,$drug,$cashier);

            if (!isset($result) || $result == null) {
                $result = [];
            }
                $total_records =count($result);
            $response = [
              
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
                "data" => $result
            
            ];

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    
        }

        public function get_drugs_sale()
	{
	

			$from = $this->input->post('from');
			$to = $this->input->post('to');
			$drug = $this->input->post('drug');
			// $drug_array = explode("-",$drug);

			$qty = 0;
			$total = 0;

			$result = $this->report_retrive->get_drugs_sale($drug,$from,$to);

             if (!isset($result) || $result == null) {
                $result = [];
            }
            
            $total_records =count($result);
            $response = array(
                "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
                "data" => $result
            );

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));

        }



        public function get_payment_list()
        {
            $from = $this->input->post('from');
            $to = $this->input->post('to');
            $cashier = $this->input->post('cashier');
            $request = $this->input->post('request');
            $timeFrom = $this->input->post('timeFrom');
            $timeTo = $this->input->post('timeTo');
        
            $cashier_array = explode("-", $cashier);
        
            $total = 0;
            $cash = 0;
            $credit = 0;
            $discount = 0;
        
            $cashiers = $this->report_retrive->get_payment_list($cashier_array[0], $request, $from, $to, $timeFrom, $timeTo);
        
            $result = [];
        
            if ($cashiers) {
                foreach ($cashiers as $val) {
                    $disc = $this->report_retrive->retrieve_data_unique("sh_sell_bill_items", "sell_bill_id", $val['sell_bill_id']);
                    $discounts = 0;
                    foreach ($disc as $value) {
                        $discounts += $value['discount'];
                        $discount += $value['discount'];
                    }
        
                    $total += $val['amount'] + $discounts;
        
                    $row = [
                        'order' => $val['sell_bill_id'],
                        'sales_person' => $val['full_name'],
                        'total' => $val['amount'],
                        'discount' => number_format($discounts, 2),
                        'cash' => 0,
                        'card' => 0,
                        'net_total' => number_format($val['amount'] + $discounts, 2),
                    ];
        
                    if ($val['type'] == "cash") {
                        $row['cash'] = $val['amount'];
                        $cash += $val['amount'];
                    } else if ($val['type'] == "cash_card") {
                        $result_cash = $this->report_retrive->get_cash_card($val['sell_bill_id'], "cash");
                        $row['cash'] = $result_cash->amount;
                        $cash += $result_cash->amount;
                    }
        
                    if ($val['type'] == "card") {
                        $row['card'] = $val['amount'];
                        $credit += $val['amount'];
                    } else if ($val['type'] == "cash_card") {
                        $result_card = $this->report_retrive->get_cash_card($val['sell_bill_id'], "card");
                        $row['card'] = $result_card->amount;
                        $credit += $result_card->amount;
                    }
        
                    $result[] = $row;
                }
        
                $refund = $this->report_retrive->refund_pharma_cashier($from, $to);
                $total_refund = 0;
                if ($refund) {
                    foreach ($refund as $value) {
                        $total_refund += $value['sell_price'] * $value['qty'];
                    }
                }
        
                $refund_result = $this->report_retrive->refund_pharma_cashier_wise($from, $to, $cashier_array[0], $request);
                if ($refund_result) {
                    foreach ($refund_result as $value) {
                        $result[] = [
                            'order' => 'Refund No - ' . $value['return_sale_id'],
                            'sales_person' => 'drug code - ' . $value['item_id'],
                            'total' => '',
                            'discount' => '',
                            'cash' => '-' . number_format($value['qty'] * $value['sell_price'], 2),
                            'card' => '',
                            'net_total' => '',
                        ];
                    }
                }
        
                $Grand_total = $cash + $credit - $total_refund;
        
                $result[] = [
                    'order' => 'REFUND:' . number_format($total_refund, 2),
                    'sales_person' => '',
                    'total' => '',
                    'discount' => '',
                    'cash' => '',
                    'card' => '',
                    'net_total' => 'Grand Total: ' . number_format($Grand_total, 2),
                ];
            }
        
            $total_records = count($result);
        
            $response = array(
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
                "data" => $result
            );
        
            $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($response));
        }
        
        public function get_p_refund_report()
	{
		

			$from = $this->input->post('from');
			$to = $this->input->post('to');
			$timeFrom = $this->input->post('timeFrom');
			$timeTo = $this->input->post('timeTo');

			$qty = 0;
        	$total = 0;
        	$grand_total = 0;
        	$ctr = 0;

			$result = $this->report_retrive->get_p_refund_report($from,$to,$timeFrom,$timeTo);
            if (!isset($result) || $result == null) {
                $result = [];
            }else{
                foreach($result as &$val){

                    $qty += $val['qty'];
                    $loos_price=0;
                    $loose_active = $this->report_retrive->get_row_data('sh_drugs', 'drug_id', $val['drug_id']);
                                  if ($loose_active->loose_active !=0) {
                                        $loos_price = $val['price']/$loose_active->drug_loose;
                                      $price = number_format($val['qty']*$loos_price,2);
                                      
                                  }else{
                                      $price =	number_format($val['qty']*$val['price'],2);
                                      $loos_price = $val['price'];
                                  }
                                $total += $val['qty']*$loos_price;
                                $val['loos_price']= $loos_price;
                                $val['price']= $price;
                }
            }

           
            $total_records =count($result);
            $response = array(
                "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
                "data" => $result
            );

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
     
     
     
    }

    public function get_purchase_refund_report()
	{
		

			$from = $this->input->post('from');
			$to = $this->input->post('to');
			$timeFrom = $this->input->post('timeFrom');
			$timeTo = $this->input->post('timeTo');

			$qty = 0;
        	$total = 0;
        	$grand_total = 0;
        	$ctr = 0;

			$result = $this->report_retrive->get_purchase_refund_report($from,$to);
            if (!isset($result) || $result == null) {
                $result = [];
            }else{
                foreach($result as &$val){

                    $qty += $val['qty'];
                    $loos_price=0;
                    $loose_active = $this->report_retrive->get_row_data('sh_drugs', 'drug_id', $val['drug_id']);
                                  if ($loose_active->loose_active !=0) {
                                        $loos_price = $val['price']/$loose_active->drug_loose;
                                      $price = number_format($val['qty']*$loos_price,2);
                                      
                                  }else{
                                      $price =	number_format($val['qty']*$val['price'],2);
                                      $loos_price = $val['price'];
                                  }
                                $total += $val['qty']*$loos_price;
                                $val['loos_price']= $loos_price;
                                $val['price']= $price;
                }
            }

           
            $total_records =count($result);
            $response = array(
                "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
                "data" => $result
            );

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
     
     
     
    }


        public function get_report_profit_views()
	{
		

			$from = $this->input->post('from');
			$to = $this->input->post('to');
			$supplier = $this->input->post('suppliers');
			$drug = $this->input->post('drugs');

			$qty = 0;
			$total = 0;
			$total_cash = 0;
			$total_card = 0;
			$total_cost = 0;
			$total_profit = 0;

			$results = $this->report_retrive->get_view_profit_reports($supplier,$drug,$from,$to);
            $total_records =count($results);

            foreach ($results as &$val) {
                $val['cash'] = 0;
                $val['credit'] = 0;
                
                $price = $val['qty'] * $val['sell_prices'];
        
                if ($val['type'] == "card") {
                    $val['credit'] = $price;
                } else if ($val['type'] == "cash") {
                    $val['cash'] = $price;
                }
        
                $val['total_cost'] = $val['qty'] * $val['cost'];
                $val['profit'] = $price - ($val['qty'] * $val['cost']);
            }
        
            
            // Prepare response data
            $response = [
                "qty" => array_sum(array_column($results, 'qty')),
                "total" => array_sum(array_column($results, 'qty')) * array_sum(array_column($results, 'sell_prices')),
                "total_cash" => array_sum(array_column($results, 'cash')),
                "total_card" => array_sum(array_column($results, 'card')),
                "total_cost" => array_sum(array_column($results, 'total_cost')),
                "total_profit" => array_sum(array_column($results, 'profit')),
                "data" => $results, // Include the fetched data in the response
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
            ];
          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));

        }

    public function p_sales_report()
	{
		
		
			
			$to = $this->input->post('to');	
			$from = $this->input->post('from');
			$radioDatetype = $this->input->post('date_type');
			$option = $this->input->post('payment_report');
			$branch_id = '-1';//$this->input->post('branch_id');
			$data['to'] = $to;
			$data['from'] = $from;
			$data['option'] = $option;
			$data['date_type'] = $radioDatetype;
			$data['branch_id'] = $branch_id;
			if($radioDatetype == 1) {
			$this -> form_validation -> set_rules('from', 'From Date', 'required');
			$this -> form_validation -> set_rules('to', 'To Date', 'required');
			}
			else{
				$this -> form_validation -> set_rules('from', 'Date', 'required');
			}
			if ($this -> form_validation -> run() == FALSE) {
				$data['title'] = 'Report::: Hospital Management System';
				$data['page_header'] = 'Sales Report';
				$data['sales_report'] = FALSE;
				$data['sales_total'] = FALSE;
				$data['alert_msg'] = '';
				$this -> load -> view('report_sales', $data);
			} else {
				$data['sales_report'] = $this->report_retrive->sales_report_new($radioDatetype, $from, $to, $option, $branch_id);
				$data['sales_sum_report'] = $this->report_retrive->sales_sum_report($radioDatetype, $from, $to, $option, $branch_id);
				$data['sales_treat_total'] = $this->report_retrive->sales_treat_total($radioDatetype, $from, $to, $option, $branch_id);
				$data['sales_patient_amt_total'] = $this->report_retrive->sales_patient_amt_total($radioDatetype, $from, $to, $option, $branch_id);
				$data['open_balance_info'] = $this->report_retrive->open_balance_info($radioDatetype, $from, $to, $option, $branch_id);
				
				$data['sales_total'] = $this->report_retrive->sales_sum($radioDatetype, $from, $to, $option, $branch_id);
				$data['refund_info'] = $this->report_retrive->refund_info($radioDatetype, $from, $to, $option, $branch_id);
				$data['refund_full_info'] = $this->report_retrive->refund_full_info($radioDatetype, $from, $to, $option, $branch_id);		
				// $this->load->view('report_sales', $data);
				$this->load->view('report_sales_print', $data);
				
			}
		
	}
    
    public function logsReport()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 23;
        $data['active_submenu'] = 3;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['appoinment_status'] = $this->report_retrive->get_all_booking_status();
        $data['sales_persons'] = $this->report_retrive->retrieve_data('tbl_users');
        $this->load->view('admin/Reports/LogsReport', $data);
    }
    public function logsList()
    {
        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $user_id = $this->input->get('user_id');
        $type = $this->input->get('type');
        $action = $this->input->get('action');
        $order_column = $this->input->get('columns')[$this->input->get('order')[0]['column']]['data'];
        $order = $this->input->get('order')[0]['dir'];
        $search = $this->input->get('search')['value'];
        $appoinment_status = $this->input->get('appoinment_status');
        $date_from = $this->input->get('date_from');
        $date_to = $this->input->get('date_to');
        $records = $this->report_retrive->get_logs_list($appoinment_status, $date_from, $date_to, $length, $start, $type, $action, $user_id, $order_column, $order);
        //$total_records = $this->report_retrive->get_total_appoinments();
        $total_records = count($records);
        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function view_log($id){
   
        $record = $this->report_retrive->get_log($id);
      
        $this->load->view('admin/Reports/ViewLogsReport', $record);
    }

public function doctorIncomeReport()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 23;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['doctors'] = $this->report_retrive->all_doctors();
        $data['payment_types'] = $this->report_retrive->payment_types();

        $this->load->view('admin/Reports/DoctorIncomeReport', $data);
    }
    
    
    public function doctorIncomeList(){
        $doctor = $this->input->post('doctor');
        $payment_type = $this->input->post('payment_type');
        $date_from = $this->input->post('date_from');
        $date_to = $this->input->post('date_to');

        $report_data = $this->report_retrive->get_doctorIncome($doctor, $payment_type, $date_from, $date_to);
   $receptionist= $this->report_retrive->receptionistSale($doctor, $payment_type, $date_from, $date_to);
  
    
        return $this->generate_income($report_data,$receptionist);
       
    }

    function generate_income($report_data,$receptionist){
        // Generate HTML for the report
$output = "<table class='table'>";
$output .= "<thead><tr><th>Doctor</th><th>Total Amount</th></tr></thead><tbody>";
$grand_total = 0; // Initialize grand total

// Check if there are any doctor totals to display
if (!empty($report_data['doctor_totals'])) {
    foreach ($report_data['doctor_totals'] as $doctor_total) {
        $output .= "<tr>";
        $output .= "<td>{$doctor_total->full_name}</td>";
        $output .= "<td>{$doctor_total->total_cash}</td>";
        $output .= "</tr>";
        $grand_total += $doctor_total->total_cash;
    }
} else {
    $output .= "<tr><td colspan='2'>No doctor payment records found for the selected criteria.</td></tr>";
}

$output .= "</tbody>";


$output .= "<tfoot class=''>
<tr class='bg-light'><th><h6 class='font-bolder ' style='font-weight:900'>Cash Collected By</h6></th><th><h3></h3></th></tr>";
if (!empty($receptionist)) {
    foreach ($receptionist as $re) {
        if($re->type_name == 'Cash'){
            $output .= "<tr>";
            $output .= "<td>{$re->full_name}</td>";
            $output .= "<td> {$re->total_cash} </td>";
            $output .= "</tr>";
        }
      
    }
}
// Display grand total
$output .= "<tfoot class=''>
<tr class='bg-light'><th><h6 class='font-bolder '  style='font-weight:900'>Total</h6></th><th><h6  style='font-weight:900'>{$grand_total}.00</h6></th></tr>";
if (!empty($report_data['payment_method_totals'])) {
    foreach ($report_data['payment_method_totals'] as $payment_total) {
        $output .= "<tr>";
        $output .= "<td>{$payment_total->type_name}</td>";
        $output .= "<td>{$payment_total->total_cash}</td>";
        $output .= "</tr>";
    }
}

echo $output;
    }

}