<?php

class CompanyController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/Setting/Company/CompanyModel');
        $this->load->model('admin/Announcement/AnnouncementModel');


        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
    }

    public function index()
    {

        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);

            //Locals =========================================================================
            $data['List'] = $this->CompanyModel->get_list();

            $this->load->view('admin/Setting/Company/CompanyList', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function CreateNew()
    {
        if ($this->session->userdata('user_Id') != '') {
            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);

            //Locals =========================================================================
            $data['company_id_val'] = 0;
            $data['company_name_val'] = '';
            $data['company_description_val'] = '';
            $data['company_address_val'] = '';
            $data['mobile_no_val'] = '';
            $data['phone_no_val'] = '';
            $data['fax_val'] = '';
            $data['email_val'] = '';
            $data['web_val'] = '';

            //image
            $data['image_path_val'] = '';

            $this->load->view('admin/Setting/Company/Company', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function name_exists_check()
    {
        $this->db->where('company_name', trim($this->input->post('company_name')));
        $this->db->where_not_in('company_id', $this->input->post('company_id'));
        $query = $this->db->get('tbl_company');

        if ($query->num_rows() > 0) {
            $this->form_validation->set_message('name_exists_check', 'Name Already Added.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function Save()
    {
        if ($this->session->userdata('user_Id') != '') {
            //Commen =========================================================================
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);

            //Validation ====================================================================
            $this->form_validation->set_rules('company_name', 'Company Name', 'required|min_length[4]|callback_name_exists_check');
            $this->form_validation->set_rules('company_description', 'Description', 'required|max_length[450]');
            $this->form_validation->set_rules('company_address', 'Address', 'required|max_length[450]');
            $this->form_validation->set_rules('mobile_no', 'Mobile number', 'required|max_length[8]|min_length[8]');
            $this->form_validation->set_rules('phone_no', 'Phone number', 'required|max_length[8]|min_length[8]');
            $this->form_validation->set_rules('fax', 'Fax number', 'max_length[8]|min_length[8]');
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
            $this->form_validation->set_rules('web', 'Web', 'valid_url');

            //Locals =========================================================================
            $company_id = trim($this->input->post('company_id'));
            $data['company_id_val'] = trim($this->input->post('company_id'));
            $data['company_name_val'] = trim($this->input->post('company_name'));
            $data['company_description_val'] = trim($this->input->post('company_description'));
            $data['company_address_val'] = trim($this->input->post('company_address'));
            $data['mobile_no_val'] = trim($this->input->post('mobile_no'));
            $data['phone_no_val'] = trim($this->input->post('phone_no'));
            $data['fax_val'] = trim($this->input->post('fax'));
            $data['email_val'] = trim($this->input->post('email'));
            $data['web_val'] = trim($this->input->post('web'));
            $data['is_new_image'] = trim($this->input->post('is_new_image'));
            $is_new_image  = trim($this->input->post('is_new_image'));

            //image
            $data['image_path_val'] = trim($this->input->post('image_path'));
            $logo = trim($this->input->post('image_path'));


            if ($this->form_validation->run() == FALSE) {
                $this->load->view('admin/Setting/Company/Company', $data);
                return;
            }

            //Save =========================================================================
            $data_save = array(
                'company_name' => $this->input->post('company_name'),
                'description' => $this->input->post('company_description'),
                'address' => $this->input->post('company_address'),
                'mobile_no' => $this->input->post('mobile_no'),
                'phone_no' => $this->input->post('phone_no'),
                'fax' => $this->input->post('fax'),
                'email' => $this->input->post('email'),
                'web' => $this->input->post('web'),
                'logo' => $logo,
                'create_user_Id' => $loginId,
                'create_datetime' => date('Y-m-d H:i:s')
            );

            if ($company_id > 0) {
                $this->CompanyModel->update($company_id, $data_save, $is_new_image);
            } else {
                $company_id = $this->CompanyModel->save($data_save, $is_new_image);
            }

            //load screen defaults ============================================================= 
            $data['List'] = $this->CompanyModel->get_list();
            redirect('admin/Setting/Company/CompanyController/Load');
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function Load()
    {
        if ($this->session->userdata('user_Id') != '') {
            //Commen =========================================================================
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            $data['sms_portal'] = $this->db->select('*')->from('tbl_config_services')->where('service_name', 'SMS Service')->get()->row();
            $data['skipcash_portal'] = $this->db->select('*')->from('tbl_config_services')->where('service_name', 'skipcash_service')->get()->row();
            $data['whatsapp_portal'] = $this->db->select('*')->from('tbl_config_services')->where('service_name', 'whatsapp_service')->get()->row();
            $data['user_groups'] = $this->db->select('*')->from('tbl_user_groups')->get()->result();

            //Load ===========================================================================
            $load_data = $this->CompanyModel->get_by_id();

            $data['is_new_image'] = 'false';

            //load screen defaults ============================================================ 
            foreach ($load_data as $row) {
                $data['company_id_val'] = $row['company_id'];
                $data['company_name_val'] = $row['company_name'];
                $data['company_description_val'] = $row['description'];
                $data['company_address_val'] = $row['address'];
                $data['mobile_no_val'] = $row['mobile_no'];
                $data['phone_no_val'] = $row['phone_no'];
                $data['fax_val'] = $row['fax'];
                $data['email_val'] = $row['email'];
                $data['web_val'] = $row['web'];
                $data['image_path_val'] = $row['logo'];
            }

            $this->load->view('admin/Setting/Company/Company', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function save_sms_configurations()
    {

        $postData = json_encode($this->input->post());

        $query = $this->db->select('*')
            ->from('tbl_config_services')
            ->where('service_name', 'SMS Service')
            ->get();

        //echo $query->num_rows();exit;

        if ($query->num_rows() > 0) {
            $this->db->update('tbl_config_services', ['service_configuration' => $postData], array('service_name' => 'SMS Service'));
        } else {
            $this->db->insert('tbl_config_services', $postData);
        }

        $this->session->set_flashdata('success', 'SMS Configurations Updated Successfully.');
        redirect('admin/Setting/Company/CompanyController/Load');
    }

    
    public function save_skipcash_configurations()
    {

        $postData = json_encode($this->input->post());

        $data= array(
            'service_name'=>'skipcash_service',
            'service_configuration'=>$postData,
        );

        $query = $this->db->select('*')
            ->from('tbl_config_services')
            ->where('service_name', 'skipcash_service')
            ->get();

        //echo $query->num_rows();exit;

        if ($query->num_rows() > 0) {
            $this->db->update('tbl_config_services', ['service_configuration' => $postData], array('service_name' => 'skipcash_service'));
        } else {
            $this->db->insert('tbl_config_services', $data);
        }

        $this->session->set_flashdata('success', 'Payment Configurations Updated Successfully.');
        redirect('admin/Setting/Company/CompanyController/Load');
    }

    public function save_whatsapp_configurations()
    {

        $postData = json_encode($this->input->post());

        $data= array(
            'service_name'=>'whatsapp_service',
            'service_configuration'=>$postData,
        );

        $query = $this->db->select('*')
            ->from('tbl_config_services')
            ->where('service_name', 'whatsapp_service')
            ->get();

        //echo $query->num_rows();exit;

        if ($query->num_rows() > 0) {
            $this->db->update('tbl_config_services', ['service_configuration' => $postData], array('service_name' => 'whatsapp_service'));
        } else {
            $this->db->insert('tbl_config_services', $data);
        }

        $this->session->set_flashdata('success', 'Whatsapp Configurations Updated Successfully.');
        redirect('admin/Setting/Company/CompanyController/Load');
    }

    public function save_announcement()
    {

        $this->form_validation->set_rules('user_group', 'User Group', 'required');
        $this->form_validation->set_rules('announcement', 'Announcement Message', 'required');
        $this->form_validation->set_rules('expire_at', 'Expiration Time', 'required');
        $this->form_validation->set_rules('start_at', 'Start Time', 'required');

        if ($this->form_validation->run() == FALSE) {
            set_old($this);
            errors_to_flashdata($this);
            redirect('admin/Setting/Company/CompanyController/Load');
        }

        $announcement_id = $this->input->post('announcement_id');
        $post_data = $this->input->post();
        unset($post_data['announcement_id']);

        if(!empty($announcement_id)) {
            // Update
            $announcement_id_decrypted = decrypt_and_url_decode($announcement_id, $this);
            $announcement = $this->AnnouncementModel->retrieve_data_unique_row('tbl_announcements', 'id', $announcement_id_decrypted);

            if(!empty($announcement)) {
                try {
                    $this->db->where('id', $announcement_id_decrypted);
                    $this->db->update('tbl_announcements', $post_data);
                } catch (Exception $e) {
                    $this->session->set_flashdata('errors', 'Failed to update announcement!');
                }
                $this->session->set_flashdata('success', 'Announcement updated!');
            }else{
                $this->session->set_flashdata('errors', 'Failed to update announcement!');
            }

        }else{
            // Insert
            try {
                $this->AnnouncementModel->createOrUpdateAnnouncement($post_data);
                $this->session->set_flashdata('success', 'New announcement created!');
            } catch (Exception $e) {
                $this->session->set_flashdata('errors', 'Failed to update announcement!');
            }
        }

        redirect('admin/Setting/Company/CompanyController/Load');
    }

    public function LoadAnnouncements()
    {
        $announcements = $this->AnnouncementModel->LoadAnnouncements();

        foreach ($announcements as $key => $announcement) {
            $announcements[$key]['e_id'] = encrypt_and_url_encode($announcement['id'], $this);
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($announcements));
    }

    public function deleteAnnouncement($announcement_id)
    {
        $id = decrypt_and_url_decode($announcement_id, $this);
        $this->AnnouncementModel->delete_data_where('tbl_announcements', 'id', $id);
        $this->session->set_flashdata('success', 'Announcement deleted!');
        redirect('admin/Setting/Company/CompanyController/Load');
    }


    public function send_otp() {
        $loginId = $this->session->userdata('user_Id');
        $otp = rand(1540, 9999); // Generate a 4-digit OTP
        $user= getLoginUser($this);

        $query = $this->db->select('*')
            ->from('otp')
            ->where('mobile_number', $user->phone_no)
            ->get();

            $postData= array(
                'otp'=>$otp,
                'mobile_number'=>$user->phone_no,
                'user_id'=>$loginId,
                'created_at' => date('Y-m-d H:i:s'),
               
            );

        if ($query->num_rows() > 0) {
            $this->db->where('user_id', $loginId);
            $this->db->update('otp', $postData);
           
        } else {
            $this->db->insert('otp', $postData);
        }
      
    
        echo json_encode(['success' => true]);
    }

    public function validate_otp() {
        $input_otp = $this->input->post('otp');
        $user_id = $this->session->userdata('user_Id'); // Assuming you're using session to track the user
    
        // Retrieve the OTP stored in the database
        $this->db->where('user_id', $user_id);
        $query = $this->db->get('otp');
        
        if ($query->num_rows() > 0) {
            $otp_record = $query->row();
    
            // Check if the OTP is valid
            if ($otp_record->otp == $input_otp) {
                // Check if OTP is within the valid time frame (5 minutes)
                $created_at = strtotime($otp_record->created_at);
                $current_time = time();
                $time_difference = $current_time - $created_at;
    
                if ($time_difference <= 300) { // 300 seconds = 5 minutes
                    // OTP is valid and within time limit
                    echo json_encode(['valid' => true]);
                } else {
                    // OTP is expired
                    echo json_encode(['valid' => false, 'message' => 'OTP has expired. Please request a new one.']);
                }
            } else {
                // Invalid OTP
                echo json_encode(['valid' => false, 'message' => 'Invalid OTP. Please try again.']);
            }
        } else {
            // No OTP record found for the user
            echo json_encode(['valid' => false, 'message' => 'No OTP found. Please request a new one.']);
        }
    }

}
