<?php
use Twilio\Rest\Client;
class PaymentController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->check_permission($this->session->userdata('user_Id'), 'configurations');
        $this->load->library('TwilioWhatsApp');
        $this->load->model('admin/Setting/Company/CompanyModel');
    }


    public function index(){
        $amount = $this->input->post('amount') ;
        $type = $this->input->post('type') ;
        $package_id = $this->input->post('package_id') ?? 'renew';
        $messages_count = $this->input->post('messages_count') ;
        $monthsCount = $this->input->post('month_count') ;
        $myuuid = $this->guidv4();

      
        
        if($messages_count){
            $extra_info = array(
                'type'=>$type,
                'package_id'=>$package_id,
                'message_count'=>$messages_count,
            );
        }else{
            $extra_info = array(
                'type'=>$type,
                'package_id'=>$package_id,
                'months_count'=>$monthsCount,
            );
        }
       

        $extra_info = json_encode($extra_info);
      
        $saveData= array('transaction_id'=>$myuuid,'type'=>$type,'status'=>'Pending','amount'=>$amount,'extra_info'=>$extra_info);

       
        

        $company = $this->CompanyModel->retrieve_data_unique_row('tbl_company');


            $secretkey = SKIPCASH_SECRET;
            $data = [];
            $data['Uid'] = $myuuid;
            $data['KeyId'] = SKIPCASH_KEYID;
            $data['Amount'] = $amount;
            $data['FirstName'] = $company->company_name;
            $data['LastName'] = "GUlzar";
            $data['Phone'] = '+974'.$company->mobile_no;
            $data['Email'] = $company->email;
            $data['TransactionId'] = $myuuid; 
            $data['returnUrl'] = base_url('admin/SkipCash/PaymentController/paymentInvoice'); 
            
            $data_string = json_encode($data);
            $resultheader = "Uid=" . $data['Uid'] . ',KeyId=' . $data['KeyId'] . ',Amount=' . $data['Amount'] . ',FirstName=' . $data['FirstName'] . ',LastName=' . $data['LastName'] . ',Phone=' . $data['Phone'] . ',Email=' . $data['Email']. ',TransactionId=' . $data['TransactionId'];
        
            $this->initPayment($resultheader,$secretkey,$data_string,$saveData);
           
    }


    public function send_payment_link(){
        $amount = $this->input->post('amount') ;
       
        $payment_id = $this->input->post('payment_id') ?? '';
        $patient_id = $this->input->post('patient_id') ;
    
        $myuuid = $this->guidv4();

        $patient = $this->CompanyModel->retrieve_data_unique_row('tbl_patients','patient_id',$patient_id);
        $skipcash_details= $this->db->select('*')->from('tbl_config_services')->where('service_name', 'skipcash_service')->get()->row();
        $config_skipcash= json_decode($skipcash_details->service_configuration);
        
            $secretkey = $config_skipcash->secret_key;
            $data = [];
            $data['Uid'] = $myuuid;
            $data['KeyId'] = $config_skipcash->key_id;
            $data['Amount'] = $amount;
            $data['FirstName'] = $patient->patient_name;
            $data['LastName'] = "GUlzar";
            $data['Phone'] = '+974'.$patient->mobile;
            $data['Email'] = $patient->email;
            $data['TransactionId'] = $myuuid; 
            $data['Custom2'] = $payment_id; 
             $data['Custom3'] = $patient_id; 

            $data['webhookUrl'] = base_url('admin/SkipCash/WebhookController/callback'); 
             $data['returnUrl'] = ''; 
            $data_string = json_encode($data);

          $url='';
          if($config_skipcash->status== 0){
            $url= SKIPCASH_SANDBOX_URL;
          }else if($config_skipcash->status==1){
            $url= SKIPCASH_PRODUCTION_URL;
          }
            $resultheader = "Uid=" . $data['Uid'] . ',KeyId=' . $data['KeyId'] . ',Amount=' . $data['Amount'] . ',FirstName=' . $data['FirstName'] . ',LastName=' . $data['LastName'] . ',Phone=' . $data['Phone'] . ',Email=' . $data['Email']. ',TransactionId=' . $data['TransactionId'];
            $link = $this->get_payment_link($resultheader,$secretkey,$data_string,$url);
          
            if($link){
            // $this->send_whatsapp($link,$amount);
            echo json_encode(['status'=>true,'message'=>'Payment Link Sent Successfully']);
           }else{
            echo json_encode(['status'=>false,'message'=>'Error Generating Link']);
           }
      


    }


    public function send_whatsapp_test($link='https://google.com', $amount='5000') {
       //reminder template with buttons
        $content_sid = "HXb63665bd422dd53c4df3c9b350c99565";
        $to = "+97477393781"; // Recipient number
             $template_data = array(
                        "1" => "169-", // Ensure these match the variables in your template
                        "2" => "3",
                        "3" => "169-",
                        "4" => '4',
                        "5"=>'Usman',
                        "6"=>'4 PM',
                        "7"=>'Dr Omar',
                    
             );
        $response = $this->twiliowhatsapp->send_template_message($to, $content_sid, $template_data);
    }

    public function get_payment_link($resultheader,$secretkey,$data_string,$url){
        $s = hash_hmac('sha256', $resultheader, $secretkey, true);
        $authorisationheader = base64_encode($s);
        $curl = curl_init();


        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_2_0,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $data_string,
            CURLOPT_HTTPHEADER => array(
                'Content-Type:application/json', 'Authorization:' . $authorisationheader
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response, true);

      

        $result = $response['resultObj'];
        $payUrl = $result['payUrl'];
        
        // print_r($response);
        
        return $payUrl;

        // header('Content-Type: application/json; charset=utf-8');

        // //Redirect customer to the payment page
        // header("Location:".$payUrl);

        // // return $result;

        // exit();
    }

    public function send_t(){
        $to = '+97477393781'; // Recipient's WhatsApp number
    $message = 'Your appointment is coming up on July 21 at 3PM';

    // Call the send_message method from the TwilioWhatsApp library
    $response = $this->twiliowhatsapp->send_message($to, $message);

    // Handle response
    print_r($response);


    }
    public function initPayment($resultheader,$secretkey,$data_string,$saveData){
        $s = hash_hmac('sha256', $resultheader, $secretkey, true);
        $authorisationheader = base64_encode($s);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => SKIPCASH_SANDBOX_URL,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_2_0,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $data_string,
            CURLOPT_HTTPHEADER => array(
                'Content-Type:application/json', 'Authorization:' . $authorisationheader
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response, true);

        $save = $this->CompanyModel->saveTransaction($saveData);

        $result = $response['resultObj'];
        $payUrl = $result['payUrl'];
        
        
      

        header('Content-Type: application/json; charset=utf-8');

        //Redirect customer to the payment page
        header("Location:".$payUrl);

        // return $result;

        exit();
    }

    public function callback(){

        // Send a response back to SkipCash to acknowledge receipt
       return true;
    }
    function guidv4($data = null)
    {
        // Generate 16 bytes (128 bits) of random data or use the data passed into the function.
        $data = $data ?? random_bytes(16);
        assert(strlen($data) == 16);
        // Set version to 0100
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
        // Set bits 6-7 to 10
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80);
        // Output the 36 character UUID.
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    }


    public function  paymentInvoice(){
        $id =  $_GET['id'];
        $transaction_id = $_GET['transId'];
        $transaction_status = $_GET['status'];
        

        $curl = curl_init();
        $clientId = SKIPCASH_CLIENTID;

        curl_setopt_array($curl, array(
            CURLOPT_URL => SKIPCASH_SANDBOX_URL .'/'. $id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                'Content-Type:application/json', 'Accept: application/json', 'Authorization: ' . $clientId
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response, true);
        // var_dump($response['resultObj']);
        $data= $response['resultObj'];

        $transaction = $this->CompanyModel->retrieve_data_unique_row('skipcash_transactions','transaction_id',$transaction_id);
        $details = json_decode($transaction->extra_info, true);
        $data['messageCount']= $details['message_count'];
        $data['monthCount']= $details['months_count'] ?? '';
        if($transaction_status=='Paid'){


        if($transaction->status == 'Completed'){

        }else{
            $update_data = array('status' => 'Completed','skip_cash_id'=>$id); // Replace 'new_status_value' with the actual status value
            $this->CompanyModel->update_data('skipcash_transactions', 'transaction_id', $transaction_id, $update_data);

            
           
            
           
            if($transaction->type=='whatsapp_package'){
              
            $msgs_available = $this->CompanyModel->retrieve_data_unique_row('user_message_details');
            $whatsapp_available =  $msgs_available->available_whatsapp;
            $total_count = (int)$whatsapp_available + (int)$details['message_count'];
            $update_count = array('available_whatsapp' => $total_count); // Replace 'new_status_value' with the actual status value
            $this->CompanyModel->update_data('user_message_details','type','1', $update_count);
            $data['message']="Whatsapp Messages Added To your Account";
            } else if($transaction->type=='sms_package'){
                $data['message']="Your SMS Will be Added in your account with in one working day";
            }else{

                $subscription = $this->CompanyModel->retrieve_data_unique_row('company_subscription');
                $expired_at = $subscription->expired_at;
                $date = new DateTime($expired_at);
                $months= (int)$details['months_count'];

                $date->modify('+'.$months.' months');
                $new_expired_at = $date->format('Y-m-d H:i:s');

                $update_data = array('expired_at' => $new_expired_at,'renew_at'=>date('Y-m-d H:i:s'));

             $this->CompanyModel->update_data('company_subscription','id',$subscription->id, $update_data);

                $data['renew']=1;
                $data['message']="Subscription Renewed Successfully";
            }
        }
        return $this->load->view('admin/SkipCash/Receipt',$data);
    }
    }

    public function Transactions(){

        return $this->load->view('admin/SkipCash/UserTransactions');
    }
}