<?php

require_once APPPATH . 'controllers/admin/Jobs/Job/SmsNotification.php';

class SmsPortalController extends MY_Controller
{
    private $job = null;

    function __construct()
    {
        parent::__construct();
        $this->job = new Job($this);

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->model('admin/SmsPortal/SmsPortalModel');

        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
    }


    public function index()
    {
        $this->load->view('admin/SmsPortal/portal');
    }

    public function getPatients()
    {
        $query = $this->input->get('query');
        
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($this->SmsPortalModel->load_patients($query)));
    }

    public function sendIndividualSms()
    {
        $this->form_validation->set_rules('patient', 'Patient', 'required');
        $this->form_validation->set_rules('message', 'Message', 'required');

        if ($this->form_validation->run() == FALSE) {
            set_old($this);
            errors_to_flashdata($this);
            redirect('admin/SmsPortal/SmsPortalController/index');
        }

        //echo json_encode($this->input->post());exit;
        $patient_mobile_number = $this->input->post('patient');
        $message = $this->input->post('message');

        $sms = new SmsNotification($this,null, null, $patient_mobile_number, $message);
        $this->job->new($queue = 'DEFAULT', $payload = $sms , $attempts = 2, $available_at = null);

        $this->session->set_flashdata('success', 'SMS Scheduled!');
        redirect('admin/SmsPortal/SmsPortalController/index');
    }

    public function validate_bulk_patients($bulk_patients) {
        if (empty($bulk_patients)) {
            $this->form_validation->set_message('validate_bulk_patients', 'Please select at least one patient.');
            return false;
        }
        return true;
    }

    public function sendBulkSms()
    {

        $this->form_validation->set_rules('bulk_patients[]', 'Patients', 'callback_validate_bulk_patients');
        $this->form_validation->set_rules('bulk_message', 'Message', 'required');

        if ($this->form_validation->run() == FALSE) {
            set_old($this);
            errors_to_flashdata($this);
            redirect('admin/SmsPortal/SmsPortalController/index');
        }

        $patient_mobile_numbers = $this->input->post('bulk_patients[]');
        //var_dump($patient_mobile_numbers);exit;
        $message = $this->input->post('bulk_message');
     
        $sms = new SmsNotification($this,null, null, $patient_mobile_numbers, $message);
        $this->job->new($queue = 'DEFAULT', $payload = $sms , $attempts = 2, $available_at = null);
                
        $this->session->set_flashdata('success', 'Bulk SMS Scheduled!');
        redirect('admin/SmsPortal/SmsPortalController/index');
    }

}
